/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.osgi.framework.Bundle;

public class AddMarkerAction
extends TextEditorAction {
    private static final int MAX_LABEL_LENGTH = 80;
    private String fMarkerType;
    private boolean fAskForLabel;
    private ResourceBundle fBundle;
    private String fPrefix;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AddMarkerAction(ResourceBundle bundle, String prefix, ITextEditor textEditor, String markerType, boolean askForLabel) {
        super(bundle, prefix, textEditor);
        this.fBundle = bundle;
        this.fPrefix = prefix;
        this.fMarkerType = markerType;
        this.fAskForLabel = askForLabel;
    }

    protected ResourceBundle getResourceBundle() {
        return this.fBundle;
    }

    protected String getResourceKeyPrefix() {
        return this.fPrefix;
    }

    public void run() {
        IResource resource = this.getResource();
        if (resource == null) {
            return;
        }
        Map attributes = this.getInitialAttributes();
        if (this.fAskForLabel && !this.askForLabel(attributes)) {
            return;
        }
        String name = this.getToolTipText();
        name = name == null ? TextEditorMessages.AddMarkerAction_addMarker : name;
        final Shell shell = this.getTextEditor().getSite().getShell();
        IAdaptable context = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Shell");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter == clazz) {
                    return shell;
                }
                return null;
            }
        };
        CreateMarkersOperation operation = new CreateMarkersOperation(this.fMarkerType, attributes, resource, name);
        IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
        try {
            operationHistory.execute((IUndoableOperation)operation, null, context);
        }
        catch (ExecutionException x) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
            ILog log = Platform.getLog((Bundle)bundle);
            String msg = AddMarkerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "error.dialog.message"), (String)(String.valueOf(this.fPrefix) + "error.dialog.message"));
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, msg, (Throwable)x));
        }
    }

    public void update() {
        this.setEnabled(this.getResource() != null);
    }

    protected boolean askForLabel(Map attributes) {
        String proposal;
        Object o = attributes.get("message");
        String string = proposal = o instanceof String ? (String)o : "";
        if (proposal == null) {
            proposal = "";
        }
        String title = AddMarkerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "dialog.title"), (String)(String.valueOf(this.fPrefix) + "dialog.title"));
        String message = AddMarkerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "dialog.message"), (String)(String.valueOf(this.fPrefix) + "dialog.message"));
        IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                return newText == null || newText.trim().length() == 0 ? " " : null;
            }
        };
        InputDialog dialog = new InputDialog(this.getTextEditor().getSite().getShell(), title, message, proposal, inputValidator);
        String label = null;
        if (dialog.open() != 1) {
            label = dialog.getValue();
        }
        if (label == null) {
            return false;
        }
        if ((label = label.trim()).length() == 0) {
            return false;
        }
        attributes.put("message", label);
        return true;
    }

    protected Map getInitialAttributes() {
        HashMap attributes = new HashMap(11);
        ITextSelection selection = (ITextSelection)this.getTextEditor().getSelectionProvider().getSelection();
        if (!selection.isEmpty()) {
            int start = selection.getOffset();
            int length = selection.getLength();
            if (length < 0) {
                length = -length;
                start -= length;
            }
            MarkerUtilities.setCharStart(attributes, start);
            MarkerUtilities.setCharEnd(attributes, start + length);
            int line = selection.getStartLine();
            MarkerUtilities.setLineNumber(attributes, line == -1 ? -1 : line + 1);
            IDocument document = this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
            MarkerUtilities.setMessage(attributes, this.getLabelProposal(document, start, length));
        }
        return attributes;
    }

    protected String getLabelProposal(IDocument document, int offset, int length) {
        char ch;
        int limit;
        int left;
        block10: {
            if (length > 0) {
                int i = 0;
                boolean skip = true;
                while (i < length) {
                    boolean isWhitespace = Character.isWhitespace(document.getChar(offset + i));
                    if (!skip && isWhitespace) break;
                    if (skip && !isWhitespace) {
                        skip = false;
                    }
                    ++i;
                }
                String label = document.get(offset, i);
                return label.trim();
            }
            left = offset;
            int line = document.getLineOfOffset(offset);
            limit = document.getLineOffset(line);
            while (left > limit) {
                ch = document.getChar(left);
                if (Character.isWhitespace(ch)) break;
                --left;
            }
            limit += document.getLineLength(line);
            while (left <= limit) {
                ch = document.getChar(left);
                if (!Character.isWhitespace(ch)) break;
                ++left;
            }
            if (left <= limit) break block10;
            return null;
        }
        try {
            limit = Math.min(limit, left + 80);
            int right = offset + length > limit ? limit : offset + length;
            while (right < limit) {
                ch = document.getChar(right);
                if (Character.isWhitespace(ch)) break;
                ++right;
            }
            if (left != right) {
                String label = document.get(left, right - left);
                return label.trim();
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    protected IResource getResource() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            IEditorInput input = editor.getEditorInput();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)input.getAdapter((Class)clazz);
        }
        return null;
    }
}

