/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Vector;

public class Straight {
    public Vector position;
    public Vector direction;

    public Straight(Vector position, Vector direction) {
        if (direction.isNull()) {
            throw new IllegalArgumentException("direction has to be unequal to (0,0)");
        }
        this.position = position;
        this.direction = direction;
    }

    public Straight(PrecisionPoint point1, PrecisionPoint point2) {
        this(new Vector(point1), new Vector(point1, point2));
    }

    public boolean intersects(Straight other) {
        return this.direction.getDotProduct(other.direction.getOrthogonalComplement()) != 0.0;
    }

    public boolean intersectsWithinSegment(Vector segmentStart, Vector segmentEnd, Straight other) {
        if (!this.contains(segmentStart) || !this.contains(segmentEnd)) {
            throw new IllegalArgumentException("segment points have to be contained");
        }
        Vector segmentDirection = segmentEnd.getSubtracted(segmentStart);
        if (segmentDirection.isNull()) {
            return other.contains(segmentStart);
        }
        if (this.intersects(other)) {
            Vector intersection = this.getIntersection(other);
            return this.containsWithinSegment(segmentStart, segmentEnd, intersection);
        }
        return false;
    }

    public Vector getIntersection(Straight other) {
        if (!this.intersects(other)) {
            return null;
        }
        Vector s1 = this.direction.getMultiplied(other.position.getDotProduct(other.direction.getOrthogonalComplement()));
        Vector s2 = other.direction.getMultiplied(this.position.getDotProduct(this.direction.getOrthogonalComplement()));
        return s1.getSubtracted(s2).getDivided(this.direction.getDotProduct(other.direction.getOrthogonalComplement()));
    }

    public double getAngle(Straight other) {
        return this.direction.getAngle(other.direction);
    }

    public Vector getProjection(Vector vector) {
        return this.getIntersection(new Straight(vector, this.direction.getOrthogonalComplement()));
    }

    public double getDistance(Vector vector) {
        return this.getProjection(vector).getSubtracted(vector).getLength();
    }

    public boolean contains(Vector vector) {
        return this.getDistance(vector) == 0.0;
    }

    public boolean containsWithinSegment(Vector segmentStart, Vector segmentEnd, Vector vector) {
        if (!this.contains(segmentStart) || !this.contains(segmentEnd)) {
            throw new IllegalArgumentException("segment points have to be contained");
        }
        Vector segmentDirection = segmentEnd.getSubtracted(segmentStart);
        if (segmentDirection.isNull()) {
            return segmentStart.equals(vector);
        }
        if (new Straight(segmentStart, segmentDirection).contains(vector)) {
            double s;
            double d = s = segmentDirection.isVertical() ? (vector.y - segmentDirection.y) / segmentDirection.y : (vector.x - segmentStart.x) / segmentDirection.x;
            if (0.0 <= s && s <= 1.0) {
                return true;
            }
        }
        return false;
    }

    public boolean isParallelTo(Straight other) {
        return this.direction.isParallelTo(other.direction);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Straight)) {
            return false;
        }
        Straight otherStraight = (Straight)other;
        return this.contains(otherStraight.position) && this.isParallelTo(otherStraight);
    }

    public int hashCode() {
        return this.position.hashCode() + this.direction.hashCode();
    }

    public String toString() {
        return String.valueOf(this.position.toString()) + " + s * " + this.direction.toString();
    }
}

