/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.action;

import java.util.List;
import jp.sourceforge.tmdmaker.dialog.VirtualSupersetCreateDialog;
import jp.sourceforge.tmdmaker.editpart.AbstractTMDEditPart;
import jp.sourceforge.tmdmaker.editpart.DiagramEditPart;
import jp.sourceforge.tmdmaker.editpart.VirtualSupersetEditPart;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.Entity2VirtualSupersetTypeRelationship;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType;
import jp.sourceforge.tmdmaker.model.command.ConnectionCreateCommand;
import jp.sourceforge.tmdmaker.model.command.ConnectionDeleteCommand;
import jp.sourceforge.tmdmaker.model.command.ModelDeleteCommand;
import jp.sourceforge.tmdmaker.model.command.ModelEditCommand;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

public class VirtualSupersetCreateAction
extends SelectionAction {
    public static final String ID = "_VS";

    public VirtualSupersetCreateAction(IWorkbenchPart part) {
        super(part);
        this.setText("\u307f\u306a\u3057Superset\u7de8\u96c6");
        this.setId(ID);
    }

    public void run() {
        Point pos = this.getControlCursorLocation();
        Diagram diagram = null;
        VirtualSuperset original = null;
        VirtualSupersetType aggregator = null;
        Object m = this.getPart().getModel();
        if (m instanceof Diagram) {
            diagram = (Diagram)m;
        } else if (m instanceof VirtualSuperset) {
            original = (VirtualSuperset)m;
            aggregator = original.getVirtualSupersetType();
            diagram = original.getDiagram();
        }
        VirtualSupersetCreateDialog dialog = new VirtualSupersetCreateDialog(this.getPart().getViewer().getControl().getShell(), diagram, original);
        if (dialog.open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            VirtualSuperset edited = dialog.getEditedValue();
            if (original == null) {
                List<AbstractEntityModel> selection = dialog.getSelection();
                if (selection.size() == 0) {
                    return;
                }
                Rectangle constraint = new Rectangle(pos.x, pos.y, -1, -1);
                edited.setConstraint(constraint);
                aggregator = dialog.getEditedAggregator();
                edited.setReusedIdentifieres(aggregator.getReusedIdentifieres());
                ccommand.add((Command)new VirtualSupersetCreateCommand(diagram, edited));
                aggregator.setConstraint(constraint.getTranslated(0, 50));
                ccommand.add((Command)new VirtualSupersetTypeCreateCommand(diagram, aggregator));
                ccommand.add((Command)new ConnectionCreateCommand(new RelatedRelationship(aggregator, edited), aggregator, edited));
                for (AbstractEntityModel model : selection) {
                    ccommand.add((Command)new ConnectionCreateCommand(new Entity2VirtualSupersetTypeRelationship(model, (ConnectableElement)aggregator), model, aggregator));
                }
            } else {
                ccommand.add((Command)new ModelEditCommand(original, edited));
                List<AbstractEntityModel> notSelection = dialog.getNotSelection();
                List<AbstractEntityModel> selection = dialog.getSelection();
                List<AbstractEntityModel> selectedList = original.getVirtualSubsetList();
                for (AbstractConnectionModel con : original.getVirtualSubsetRelationshipList()) {
                    ConnectableElement source = con.getSource();
                    if (!notSelection.contains(source)) continue;
                    ccommand.add((Command)new ConnectionDeleteCommand(con));
                }
                if (selection.size() == 0) {
                    ccommand.add((Command)new VirtualSupersetTypeDeleteCommand(diagram, aggregator));
                    ccommand.add((Command)new ModelDeleteCommand(diagram, original));
                } else {
                    ccommand.add((Command)new VirtualSupersetTypeChangeCommand(original.getVirtualSupersetType(), dialog.getEditedAggregator().isApplyAttribute()));
                    for (AbstractEntityModel s : selection) {
                        if (selectedList.contains(s)) continue;
                        ccommand.add((Command)new ConnectionCreateCommand(new Entity2VirtualSupersetTypeRelationship(s, (ConnectableElement)aggregator), s, aggregator));
                    }
                }
            }
            this.execute((Command)ccommand);
        }
    }

    private Point getControlCursorLocation() {
        Control control = this.getPart().getViewer().getControl();
        Point pos = control.getDisplay().getCursorLocation();
        System.out.println(pos);
        pos = control.toControl(pos);
        System.out.println(pos);
        pos.x -= 200;
        pos.y -= 100;
        return pos;
    }

    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() == 1) {
            Object selection = this.getSelectedObjects().get(0);
            return selection instanceof DiagramEditPart || selection instanceof VirtualSupersetEditPart;
        }
        return false;
    }

    protected AbstractTMDEditPart getPart() {
        return (AbstractTMDEditPart)this.getSelectedObjects().get(0);
    }

    private static class VirtualSupersetCreateCommand
    extends Command {
        private Diagram diagram;
        private VirtualSuperset model;

        public VirtualSupersetCreateCommand(Diagram diagram, VirtualSuperset model) {
            this.diagram = diagram;
            this.model = model;
        }

        public void execute() {
            this.diagram.addChild(this.model);
        }

        public void undo() {
            this.diagram.removeChild(this.model);
        }
    }

    private static class VirtualSupersetTypeChangeCommand
    extends Command {
        private VirtualSupersetType model;
        private boolean oldApplyAttribute;
        private boolean newApplyAttribute;

        public VirtualSupersetTypeChangeCommand(VirtualSupersetType model, boolean newApplyAttribute) {
            this.model = model;
            this.newApplyAttribute = newApplyAttribute;
            this.oldApplyAttribute = model.isApplyAttribute();
        }

        public void execute() {
            this.model.setApplyAttribute(this.newApplyAttribute);
        }

        public void undo() {
            this.model.setApplyAttribute(this.oldApplyAttribute);
        }
    }

    private static class VirtualSupersetTypeCreateCommand
    extends Command {
        private Diagram diagram;
        private VirtualSupersetType aggregator;

        public VirtualSupersetTypeCreateCommand(Diagram diagram, VirtualSupersetType aggregator) {
            this.diagram = diagram;
            this.aggregator = aggregator;
        }

        public void execute() {
            this.diagram.addChild(this.aggregator);
        }

        public void undo() {
            this.diagram.removeChild(this.aggregator);
        }
    }

    private static class VirtualSupersetTypeDeleteCommand
    extends Command {
        private Diagram diagram;
        private VirtualSupersetType model;

        public VirtualSupersetTypeDeleteCommand(Diagram diagram, VirtualSupersetType model) {
            this.diagram = diagram;
            this.model = model;
        }

        public void execute() {
            this.diagram.removeChild(this.model);
        }

        public void undo() {
            this.diagram.addChild(this.model);
        }
    }
}

