/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.generate;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.generate.DatabaseNotSelectRuntimeException;
import jp.sourceforge.tmdmaker.generate.Generator;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.DataTypeDeclaration;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.KeyModel;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.StandardSQLDataType;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformFactory;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.NonUniqueIndex;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.UniqueIndex;

public class DdlUtilsDDLGenerator
implements Generator {
    public void execute(String rootDir, List<AbstractEntityModel> models) {
        assert (models.size() != 0);
        Diagram diagram = models.get(0).getDiagram();
        String databaseName = diagram.getDatabaseName();
        if (databaseName == null || databaseName.length() == 0) {
            throw new DatabaseNotSelectRuntimeException();
        }
        Database database = this.convert(diagram, models);
        Platform platform = PlatformFactory.createNewPlatformInstance((String)databaseName);
        String sql = platform.getCreateModelSql(database, true, true);
        System.out.println(sql);
        File file = new File(rootDir, "ddl.sql");
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(file);
                out.write(sql.getBytes("UTF-8"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getGeneratorName() {
        return "DDL\u3092\u51fa\u529b";
    }

    public String getGroupName() {
        return "DDL";
    }

    public boolean isImplementModelOnly() {
        return true;
    }

    private Database convert(Diagram diagram, List<AbstractEntityModel> models) {
        Database database = new Database();
        database.setName(diagram.getName());
        for (AbstractEntityModel model : models) {
            this.addModel(database, (ModelElement)model);
        }
        return database;
    }

    private void addModel(Database database, ModelElement model) {
        AbstractEntityModel entity;
        if (model instanceof AbstractEntityModel && !(entity = (AbstractEntityModel)model).isNotImplement()) {
            database.addTable(this.convert(entity));
        }
    }

    private Table convert(AbstractEntityModel entity) {
        Table table = new Table();
        table.setName(entity.getImplementName());
        List attributes = ImplementRule.findAllImplementAttributes((AbstractEntityModel)entity);
        HashMap<IAttribute, Column> attributeColumnMap = new HashMap<IAttribute, Column>();
        for (IAttribute a : attributes) {
            Column column = this.convert(a);
            table.addColumn(column);
            attributeColumnMap.put(a, column);
        }
        for (KeyModel idx : entity.getKeyModels()) {
            table.addIndex(this.convert(idx, attributeColumnMap));
        }
        return table;
    }

    private Index convert(KeyModel key, Map<IAttribute, Column> attributeColumnMap) {
        Object index = null;
        index = key.isUnique() ? new UniqueIndex() : new NonUniqueIndex();
        index.setName(key.getName());
        for (IAttribute attr : key.getAttributes()) {
            Column column = attributeColumnMap.get(attr);
            if (column != null) {
                IndexColumn indexColumn = new IndexColumn(column);
                index.addColumn(indexColumn);
                continue;
            }
            System.err.println("column not found." + attr.getName());
        }
        return index;
    }

    private Column convert(IAttribute attribute) {
        Column column = new Column();
        column.setName(attribute.getImplementName());
        DataTypeDeclaration dtd = attribute.getDataTypeDeclaration();
        if (dtd != null) {
            StandardSQLDataType dataType = dtd.getLogicalType();
            column.setTypeCode(dataType.getSqlType());
            if (dataType.isSupportSize() && dtd.getSize() != null) {
                column.setSize(dtd.getSize().toString());
            }
            if (dataType.isSupportScale() && dtd.getScale() != null) {
                column.setScale(dtd.getScale().intValue());
            }
        }
        column.setRequired(!attribute.isNullable());
        return column;
    }
}

