/*
 * Decompiled with CFR 0.152.
 */
package tmdmaker.serializer.converter.sample;

import java.util.List;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.Entity2SubsetTypeRelationship;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.model.Version;
import jp.sourceforge.tmdmaker.persistence.converter.SerializerHandler;

public class SerializerConverterSample
implements SerializerHandler {
    public String handleBeforeDeserialize(String in) {
        return in;
    }

    public Diagram handleAfterDeserialize(Diagram in) {
        Version version = new Version(in.getVersion());
        if (version.getMajorVersion() == 0 && version.getMinorVersion() == 2 && version.getServiceNo() <= 2) {
            System.out.println("need to convert model.");
            for (ModelElement o : in.getChildren()) {
                if (!(o instanceof AbstractEntityModel)) continue;
                AbstractEntityModel model = (AbstractEntityModel)o;
                this.convert(model);
            }
        } else {
            System.out.println("no need to convert.");
        }
        return in;
    }

    private void convert(AbstractEntityModel model) {
        this.convertRelatedRelationships(model.getModelSourceConnections());
        this.convertRelatedRelationships(model.getModelTargetConnections());
    }

    private void convertRelatedRelationships(List<AbstractConnectionModel> connections) {
        for (AbstractConnectionModel c : connections) {
            if (c instanceof RelatedRelationship) {
                System.out.println("convertRelatedRelationships():" + c.toString());
                this.convertLocationIfNeeds(c);
            }
            if (!(c instanceof Entity2SubsetTypeRelationship)) continue;
            System.out.println("convertRelatedRelationships():" + c.toString());
            this.convertLocationIfNeeds(c);
        }
    }

    private void convertLocationIfNeeds(AbstractConnectionModel connection) {
        if (connection.getSourceXp() == 0 && connection.getSourceYp() == 0 || connection.getTargetXp() == 0 && connection.getTargetYp() == 0) {
            connection.setSourceLocationp(-1, -1);
            connection.setTargetLocationp(-1, -1);
        }
    }

    public Diagram handleBeforeSerialize(Diagram diagram) {
        return null;
    }

    public String handleAfterSerialize(String in) {
        return null;
    }
}

