/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.persistence;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import jp.sourceforge.tmdmaker.extension.PluginExtensionPointFactory;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.persistence.SerializationException;
import jp.sourceforge.tmdmaker.persistence.Serializer;
import jp.sourceforge.tmdmaker.persistence.converter.SerializerHandler;

public class XStreamSerializer
implements Serializer {
    PluginExtensionPointFactory<SerializerHandler> factory = new PluginExtensionPointFactory("tmdmaker.serializer.converter");

    public InputStream serialize(Diagram obj) {
        try {
            return this.serializeAsStream(obj, obj.getClass().getClassLoader());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new SerializationException((Throwable)e);
        }
    }

    private InputStream serializeAsStream(Object obj, ClassLoader loader) throws UnsupportedEncodingException {
        String xml = this.serializeAsString(obj, loader);
        return new ByteArrayInputStream(xml.getBytes("UTF-8"));
    }

    private String serializeAsString(Object obj, ClassLoader loader) {
        XStream xstream = new XStream();
        xstream.setClassLoader(loader);
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xstream.toXML(obj);
    }

    public Diagram deserialize(InputStream in) {
        try {
            String xml = this.loadStream(in, "UTF-8");
            System.out.println(this.getVersionFromXml(xml));
            String converted = this.fireBeforeDeserialize(xml);
            Diagram diagram = (Diagram)this.deserialize(new ByteArrayInputStream(converted.getBytes("UTF-8")), this.getClass().getClassLoader());
            this.fireAfterDeserialize(diagram);
            return diagram;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new SerializationException((Throwable)e);
        }
    }

    private String fireBeforeDeserialize(String xml) {
        String converted = xml;
        for (SerializerHandler c : this.factory.getInstances()) {
            converted = c.handleBeforeDeserialize(converted);
        }
        return converted;
    }

    private void fireAfterDeserialize(Diagram diagram) {
        for (SerializerHandler c : this.factory.getInstances()) {
            c.handleAfterDeserialize(diagram);
        }
    }

    private String getVersionFromXml(String xml) {
        if (xml == null || xml.length() == 0) {
            return "";
        }
        if (xml.indexOf("<version>") == -1) {
            return "";
        }
        return xml.substring(xml.indexOf("<version>") + "<version>".length(), xml.indexOf("</version>"));
    }

    private Object deserialize(InputStream in, ClassLoader loader) throws UnsupportedEncodingException {
        XStream xstream = new XStream();
        xstream.setClassLoader(loader);
        return xstream.fromXML((Reader)new InputStreamReader(in, "UTF-8"));
    }

    private String loadStream(InputStream in, String encoding) {
        try {
            byte[] buf = new byte[in.available()];
            in.read(buf);
            String string = new String(buf, encoding);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SerializationException((Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

