/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpart.XYChopboxAnchor;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.ModelElement;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRelationshipEditPart
extends AbstractConnectionEditPart
implements NodeEditPart,
PropertyChangeListener {
    protected static Logger logger = LoggerFactory.getLogger(AbstractEntityEditPart.class);
    private ConnectionAnchor anchor;

    private ConnectionAnchor getConnectionAnchor() {
        if (this.anchor == null) {
            this.anchor = new PolylineConnectionAnchor((PolylineConnection)this.getFigure());
        }
        return this.anchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_property_constraint")) {
            logger.debug("Connection AbstractEntityModel.P_CONSTRAINT");
            this.refreshVisuals();
        } else if (evt.getPropertyName().equals("p_source_connection")) {
            logger.debug("Connection AbstractEntityModel.P_SOURCE_CONNECTION");
            this.refreshSourceConnections();
        } else if (evt.getPropertyName().equals("p_target_connection")) {
            logger.debug("Connection AbstractEntityModel.P_TARGET_CONNECTION");
            this.refreshTargetConnections();
        }
    }

    public void activate() {
        super.activate();
        ((ModelElement)this.getModel()).addPropertyChangeListener(this);
    }

    public void deactivate() {
        super.deactivate();
        ((ModelElement)this.getModel()).removePropertyChangeListener(this);
    }

    protected List<AbstractConnectionModel> getModelSourceConnections() {
        return ((ConnectableElement)this.getModel()).getModelSourceConnections();
    }

    protected List<AbstractConnectionModel> getModelTargetConnections() {
        return ((ConnectableElement)this.getModel()).getModelTargetConnections();
    }

    protected void calculateAnchorLocation() {
        ConnectionAnchor targetAnchor;
        AbstractConnectionModel relationship = (AbstractConnectionModel)this.getModel();
        ConnectionAnchor sourceAnchor = this.getConnectionFigure().getSourceAnchor();
        if (sourceAnchor instanceof XYChopboxAnchor) {
            ((XYChopboxAnchor)sourceAnchor).setLocation(relationship.getSourceXp(), relationship.getSourceYp());
        }
        if ((targetAnchor = this.getConnectionFigure().getTargetAnchor()) instanceof XYChopboxAnchor) {
            ((XYChopboxAnchor)targetAnchor).setLocation(relationship.getTargetXp(), relationship.getTargetYp());
        }
    }

    protected static class PolylineConnectionAnchor
    extends AbstractConnectionAnchor {
        private PolylineConnection owner;

        public PolylineConnectionAnchor(PolylineConnection owner) {
            this.owner = owner;
        }

        public Point getLocation(Point reference) {
            Point midpoint = this.owner.getPoints().getMidpoint();
            this.owner.translateToAbsolute((Translatable)midpoint);
            return midpoint;
        }

        public IFigure getOwner() {
            return this.owner;
        }

        public Point getReferencePoint() {
            if (this.owner == null) {
                return null;
            }
            return this.getLocation(null);
        }
    }
}

