/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.figure;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;

public class SubsetTypeFigure
extends Figure {
    public SubsetTypeFigure() {
        this(true);
    }

    public SubsetTypeFigure(boolean sameType) {
        this.setBorder((Border)new SubsetBorder(sameType));
        this.setOpaque(false);
    }

    public void setSameType(boolean sameType) {
        if (sameType) {
            this.setSize(30, 5);
        } else {
            this.setSize(30, 10);
        }
        ((SubsetBorder)this.getBorder()).setSameType(sameType);
    }

    private static class SubsetBorder
    extends AbstractBorder {
        private int width = 1;
        private boolean sameType;

        public SubsetBorder(boolean sameType) {
            this.sameType = sameType;
        }

        public int getWidth() {
            return this.width;
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(this.getWidth());
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            if (this.sameType) {
                this.paintSubsetSameType(figure, graphics, insets);
            } else {
                this.paintSubsetDifferenceType(figure, graphics, insets);
            }
        }

        private void paintSubsetSameType(IFigure figure, Graphics graphics, Insets insets) {
            tempRect.setBounds(SubsetBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
            if (this.getWidth() % 2 != 0) {
                --SubsetBorder.tempRect.width;
                --SubsetBorder.tempRect.height;
            }
            tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
            graphics.setLineWidth(this.getWidth());
            graphics.drawLine(tempRect.getTopLeft(), tempRect.getTopRight());
            graphics.drawLine(tempRect.getBottomLeft(), tempRect.getBottomRight());
            graphics.drawLine(SubsetBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getTop(), tempRect.getCenter());
        }

        private void paintSubsetDifferenceType(IFigure figure, Graphics graphics, Insets insets) {
            tempRect.setBounds(SubsetBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
            graphics.drawLine(tempRect.getTopLeft(), tempRect.getBottomRight());
            graphics.drawLine(tempRect.getBottomLeft(), tempRect.getTopRight());
        }

        public void setSameType(boolean sameType) {
            this.sameType = sameType;
        }
    }
}

