/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.MultivalueAndAggregator;
import jp.sourceforge.tmdmaker.model.MultivalueAndSuperset;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.model.TransfarReuseKeysToTargetRelationship;
import jp.sourceforge.tmdmaker.model.rule.MultivalueRule;

public class Header2DetailRelationship
extends TransfarReuseKeysToTargetRelationship {
    private MultivalueAndSuperset superset;
    private Detail detail;
    private MultivalueAndAggregator aggregator;
    private RelatedRelationship superset2aggregator;
    private RelatedRelationship header2aggregator;
    private RelatedRelationship detail2aggregator;
    private String oldHeaderName;
    private String newHeaderName;

    public Header2DetailRelationship(AbstractEntityModel header) {
        this.setSource(header);
        this.detail = MultivalueRule.createDetail(header);
        this.setTarget(this.detail);
        this.superset = MultivalueRule.createMultivalueAndSuperset(header);
        this.superset.setDetail(this.detail);
        this.aggregator = new MultivalueAndAggregator();
        this.aggregator.setConstraint(header.getConstraint().getTranslated(75, -30));
        this.superset2aggregator = new RelatedRelationship(this.superset, this.aggregator);
        this.header2aggregator = new RelatedRelationship(header, this.aggregator);
        this.detail2aggregator = new RelatedRelationship(this.detail, this.aggregator);
        this.oldHeaderName = header.getName();
        this.newHeaderName = MultivalueRule.createHeaderName(header);
    }

    @Override
    public void connect() {
        super.connect();
        this.getSource().getDiagram().addChild(this.superset);
        this.getSource().getDiagram().addChild(this.aggregator);
        this.superset2aggregator.connect();
        this.header2aggregator.connect();
        this.detail2aggregator.connect();
        this.getSource().setName(this.newHeaderName);
    }

    @Override
    public void disconnect() {
        this.getSource().setName(this.oldHeaderName);
        this.detail2aggregator.disconnect();
        this.header2aggregator.disconnect();
        this.superset2aggregator.disconnect();
        this.getSource().getDiagram().removeChild(this.aggregator);
        this.getSource().getDiagram().removeChild(this.superset);
        super.disconnect();
    }

    @Override
    public void attachTarget() {
        this.getSource().getDiagram().addChild(this.detail);
        super.attachTarget();
    }

    @Override
    public void detachTarget() {
        super.detachTarget();
        this.getSource().getDiagram().removeChild(this.detail);
    }

    @Override
    public void identifierChanged() {
        super.identifierChanged();
        this.superset.fireIdentifierChanged(this);
    }

    @Override
    public boolean isDeletable() {
        return this.getTarget().isDeletable();
    }
}

