/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.importer.impl;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Attribute;
import jp.sourceforge.tmdmaker.model.Constraint;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.Laputa;
import jp.sourceforge.tmdmaker.model.importer.FileImporter;
import jp.sourceforge.tmdmaker.model.rule.EntityRecognitionRule;
import jp.sourceforge.tmdmaker.model.rule.EntityTypeRule;

public class EntityFileImporter
implements FileImporter {
    public String getImporterName() {
        return "\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u3092\u30a4\u30f3\u30dd\u30fc\u30c8";
    }

    public List<AbstractEntityModel> importEntities(String filePath) throws FileNotFoundException, IOException {
        String[] nextLine;
        CSVReader reader = new CSVReader((Reader)new BufferedReader(new FileReader(filePath)));
        Laputa l = null;
        HashMap<String, AbstractEntityModel> s = new HashMap<String, AbstractEntityModel>();
        while ((nextLine = reader.readNext()) != null) {
            String entityName = nextLine[0];
            String attributeName = "";
            if (nextLine.length >= 2) {
                attributeName = nextLine[1];
            }
            if (l == null) {
                System.out.println("l is null.");
                l = this.createLaputa(s, entityName);
            }
            if (!entityName.equals(l.getName())) {
                System.out.println("entityName not equals");
                l = (AbstractEntityModel)s.get(entityName);
                if (l == null) {
                    l = this.createLaputa(s, entityName);
                }
            } else {
                System.out.println("entityName equals");
                l = (AbstractEntityModel)s.get(entityName);
            }
            l.addAttribute(new Attribute(attributeName));
        }
        reader.close();
        ArrayList<AbstractEntityModel> list = new ArrayList<AbstractEntityModel>();
        for (Map.Entry entry : s.entrySet()) {
            list.add(this.convertEntityIfPossible((AbstractEntityModel)entry.getValue()));
        }
        return list;
    }

    private AbstractEntityModel convertEntityIfPossible(AbstractEntityModel model) {
        String entityName = model.getName();
        ArrayList<IAttribute> identifierCandidates = new ArrayList<IAttribute>();
        for (IAttribute a : model.getAttributes()) {
            String generateName = EntityRecognitionRule.getInstance().generateEntityNameFromIdentifier(a.getName());
            if (!entityName.equals(generateName)) continue;
            identifierCandidates.add(a);
        }
        if (identifierCandidates.size() > 0) {
            Entity entity = new Entity();
            model.copyTo((AbstractEntityModel)entity);
            IAttribute attribute = (IAttribute)identifierCandidates.get(0);
            entity.setIdentifier(new Identifier(attribute.getName()));
            entity.removeAttribute((Attribute)attribute);
            entity.setNotImplement(false);
            if (EntityTypeRule.hasEventAttribute((AbstractEntityModel)entity)) {
                entity.setEntityType(EntityType.EVENT);
            } else {
                entity.setEntityType(EntityType.RESOURCE);
            }
            return entity;
        }
        return model;
    }

    private Laputa createLaputa(Map<String, AbstractEntityModel> s, String entityName) {
        Laputa l = EntityRecognitionRule.getInstance().createLaputa(entityName);
        l.setConstraint(new Constraint());
        s.put(l.getName(), (AbstractEntityModel)l);
        return l;
    }
}

