/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.rcp;

import jp.sourceforge.tmdmaker.rcp.ApplicationActionBarAdvisor;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.WorkbenchWindow;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setInitialSize(new Point(640, 480));
        configurer.setShowCoolBar(true);
        configurer.setShowMenuBar(true);
        configurer.setShowStatusLine(false);
        configurer.setTitle("TMD-Maker for RCP");
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        Shell shell = configurer.getWindow().getShell();
        if (configurer.getInitialSize().equals((Object)shell.getSize())) {
            shell.setMaximized(true);
            shell.setMinimumSize(640, 480);
        }
    }

    public void openIntro() {
        super.openIntro();
        this.trimWindow();
    }

    private void trimWindow() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window instanceof WorkbenchWindow) {
            MWindow model = ((WorkbenchWindow)window).getModel();
            EModelService modelService = (EModelService)model.getContext().get(EModelService.class);
            this.hideQuickAccess(modelService, model);
        }
    }

    private void hideQuickAccess(EModelService modelService, MWindow model) {
        MToolControl searchField = (MToolControl)modelService.find("SearchField", (MUIElement)model);
        if (searchField != null) {
            searchField.setToBeRendered(false);
            MTrimBar trimBar = modelService.getTrim((MTrimmedWindow)model, SideValue.TOP);
            trimBar.getChildren().remove(searchField);
        }
    }
}

