/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.action;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.TMDEditor;
import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.dialog.GeneratorDialog;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpart.LaputaEditPart;
import jp.sourceforge.tmdmaker.editpart.MultivalueAndAggregatorEditPart;
import jp.sourceforge.tmdmaker.editpart.SubsetTypeEditPart;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.generate.Generator;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;

public class GenerateAction
extends SelectionAction {
    private Generator generator;
    private GraphicalViewer viewer;

    public GenerateAction(TMDEditor editor, GraphicalViewer viewer, Generator generator) {
        super((IWorkbenchPart)editor);
        this.generator = generator;
        this.viewer = viewer;
        this.setId(generator.getClass().getName());
        this.setText(generator.getGeneratorName());
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        Diagram diagram = (Diagram)this.viewer.getContents().getModel();
        List<AbstractEntityModel> selectedModels = this.getSelectedModelList();
        GeneratorDialog dialog = new GeneratorDialog(this.getWorkbenchPart().getSite().getShell(), this.getSavePath(), this.generator.getGeneratorName(), selectedModels, this.getNotSelectedModelList(diagram, selectedModels));
        if (dialog.open() == 0) {
            try {
                String savePath = dialog.getSavePath();
                this.generator.execute(savePath, dialog.getSelectedModels());
                TMDPlugin.showMessageDialog(String.valueOf(this.generator.getGeneratorName()) + " \u5b8c\u4e86");
                TMDPlugin.refreshGenerateResources(savePath);
            }
            catch (Throwable t) {
                TMDPlugin.showErrorDialog(t);
            }
        }
    }

    private String getSavePath() {
        IFile file = TMDPlugin.getEditFile(this.getWorkbenchPart());
        return file.getLocation().removeLastSegments(1).toOSString();
    }

    private List<AbstractEntityModel> getSelectedModelList() {
        ArrayList<AbstractEntityModel> list = new ArrayList<AbstractEntityModel>();
        for (Object selection : this.getSelectedObjects()) {
            if (!(selection instanceof AbstractEntityEditPart) || selection instanceof SubsetTypeEditPart || selection instanceof MultivalueAndAggregatorEditPart || selection instanceof LaputaEditPart) continue;
            AbstractEntityModel model = (AbstractEntityModel)((AbstractEntityEditPart)selection).getModel();
            if (this.generator.isImplementModelOnly()) {
                if (model.isNotImplement()) continue;
                list.add(model);
                continue;
            }
            list.add(model);
        }
        return list;
    }

    private List<AbstractEntityModel> getNotSelectedModelList(Diagram diagram, List<AbstractEntityModel> selectedModels) {
        ArrayList<AbstractEntityModel> list = new ArrayList<AbstractEntityModel>();
        List target = diagram.findEntityModel();
        list.removeAll(selectedModels);
        if (this.generator.isImplementModelOnly()) {
            for (AbstractEntityModel m : target) {
                if (m.isNotImplement()) continue;
                list.add(m);
            }
        } else {
            list.addAll(target);
        }
        list.removeAll(selectedModels);
        return list;
    }
}

