/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.action;

import java.util.List;
import jp.sourceforge.tmdmaker.action.AbstractMultipleSelectionAction;
import jp.sourceforge.tmdmaker.dialog.VirtualSupersetCreateDialog;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpart.DiagramEditPart;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.Constraint;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.Entity2VirtualSupersetTypeRelationship;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType;
import jp.sourceforge.tmdmaker.ui.command.ConnectionCreateCommand;
import jp.sourceforge.tmdmaker.ui.command.ConnectionDeleteCommand;
import jp.sourceforge.tmdmaker.ui.command.ModelDeleteCommand;
import jp.sourceforge.tmdmaker.ui.command.ModelEditCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

public class VirtualSupersetCreateAction
extends AbstractMultipleSelectionAction {
    public static final String ID = "_VS";

    public VirtualSupersetCreateAction(IWorkbenchPart part) {
        super(part);
        this.setText("\u307f\u306a\u3057Superset\u7de8\u96c6");
        this.setId(ID);
    }

    public void run() {
        Point pos = this.getControlCursorLocation();
        List<AbstractEntityModel> selectedModels = this.getSelectedModelList();
        Diagram diagram = null;
        VirtualSuperset original = null;
        VirtualSupersetType aggregator = null;
        if (selectedModels.size() == 0) {
            diagram = this.getDiagram();
        } else {
            diagram = selectedModels.get(0).getDiagram();
            original = this.getVirtualSuperset();
            if (original != null) {
                selectedModels.remove(original);
                aggregator = original.getVirtualSupersetType();
            }
        }
        VirtualSupersetCreateDialog dialog = new VirtualSupersetCreateDialog(this.getControl().getShell(), diagram, original, selectedModels);
        if (dialog.open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            VirtualSuperset edited = dialog.getEditedValue();
            if (original == null) {
                List<AbstractEntityModel> selection = dialog.getSelection();
                if (selection.size() == 0) {
                    return;
                }
                Constraint constraint = new Constraint(pos.x, pos.y, -1, -1);
                edited.setConstraint(constraint);
                aggregator = dialog.getEditedAggregator();
                edited.setReusedIdentifieres(aggregator.getReusedIdentifieres());
                ccommand.add((Command)new VirtualSupersetCreateCommand(diagram, edited));
                aggregator.setConstraint(constraint.getTranslated(0, 50));
                ccommand.add((Command)new VirtualSupersetTypeCreateCommand(diagram, aggregator));
                ccommand.add((Command)new ConnectionCreateCommand((AbstractConnectionModel)new RelatedRelationship((ConnectableElement)aggregator, (ConnectableElement)edited), (ConnectableElement)aggregator, (ConnectableElement)edited));
                for (AbstractEntityModel model : selection) {
                    ccommand.add((Command)new ConnectionCreateCommand((AbstractConnectionModel)new Entity2VirtualSupersetTypeRelationship(model, (ConnectableElement)aggregator), (ConnectableElement)model, (ConnectableElement)aggregator));
                }
            } else {
                ccommand.add((Command)new ModelEditCommand((AbstractEntityModel)original, (AbstractEntityModel)edited));
                List<AbstractEntityModel> notSelection = dialog.getNotSelection();
                List<AbstractEntityModel> selection = dialog.getSelection();
                List selectedList = original.getVirtualSubsetList();
                for (AbstractConnectionModel con : original.getVirtualSubsetRelationshipList()) {
                    ConnectableElement source = con.getSource();
                    if (!notSelection.contains(source)) continue;
                    ccommand.add((Command)new ConnectionDeleteCommand(con));
                }
                if (selection.size() == 0) {
                    ccommand.add((Command)new VirtualSupersetTypeDeleteCommand(diagram, aggregator));
                    ccommand.add((Command)new ModelDeleteCommand(diagram, (AbstractEntityModel)original));
                } else {
                    ccommand.add((Command)new VirtualSupersetTypeChangeCommand(original.getVirtualSupersetType(), dialog.getEditedAggregator().isApplyAttribute()));
                    for (AbstractEntityModel s : selection) {
                        if (selectedList.contains(s)) continue;
                        ccommand.add((Command)new ConnectionCreateCommand((AbstractConnectionModel)new Entity2VirtualSupersetTypeRelationship(s, (ConnectableElement)aggregator), (ConnectableElement)s, (ConnectableElement)aggregator));
                    }
                }
            }
            this.execute((Command)ccommand);
        }
    }

    private Control getControl() {
        return ((AbstractEditPart)this.getSelectedObjects().get(0)).getViewer().getControl();
    }

    private Point getControlCursorLocation() {
        Control control = this.getControl();
        Point pos = control.getDisplay().getCursorLocation();
        System.out.println(pos);
        pos = control.toControl(pos);
        System.out.println(pos);
        pos.x -= 200;
        pos.y -= 100;
        return pos;
    }

    private Diagram getDiagram() {
        for (Object o : this.getSelectedObjects()) {
            if (o instanceof DiagramEditPart) {
                return (Diagram)((DiagramEditPart)o).getModel();
            }
            if (!(o instanceof AbstractEntityEditPart)) continue;
            return (Diagram)((AbstractEntityEditPart)o).getParent().getModel();
        }
        return null;
    }

    private VirtualSuperset getVirtualSuperset() {
        List<AbstractEntityModel> list = this.getSelectedModelList();
        for (AbstractEntityModel o : list) {
            if (!(o instanceof VirtualSuperset)) continue;
            return (VirtualSuperset)o;
        }
        for (AbstractEntityModel o : list) {
            VirtualSupersetType type = o.findVirtualSupersetType();
            if (type == null) continue;
            return (VirtualSuperset)((AbstractConnectionModel)type.getModelSourceConnections().get(0)).getTarget();
        }
        return null;
    }

    @Override
    protected boolean calculateEnabled() {
        if (this.getSelectedModelList().size() >= 1) {
            return true;
        }
        return this.getDiagram() != null;
    }

    private static class VirtualSupersetCreateCommand
    extends Command {
        private Diagram diagram;
        private VirtualSuperset model;

        public VirtualSupersetCreateCommand(Diagram diagram, VirtualSuperset model) {
            this.diagram = diagram;
            this.model = model;
        }

        public void execute() {
            this.diagram.addChild((AbstractEntityModel)this.model);
        }

        public void undo() {
            this.diagram.removeChild((AbstractEntityModel)this.model);
        }
    }

    private static class VirtualSupersetTypeChangeCommand
    extends Command {
        private VirtualSupersetType model;
        private boolean oldApplyAttribute;
        private boolean newApplyAttribute;

        public VirtualSupersetTypeChangeCommand(VirtualSupersetType model, boolean newApplyAttribute) {
            this.model = model;
            this.newApplyAttribute = newApplyAttribute;
            this.oldApplyAttribute = model.isApplyAttribute();
        }

        public void execute() {
            this.model.setApplyAttribute(this.newApplyAttribute);
        }

        public void undo() {
            this.model.setApplyAttribute(this.oldApplyAttribute);
        }
    }

    private static class VirtualSupersetTypeCreateCommand
    extends Command {
        private Diagram diagram;
        private VirtualSupersetType aggregator;

        public VirtualSupersetTypeCreateCommand(Diagram diagram, VirtualSupersetType aggregator) {
            this.diagram = diagram;
            this.aggregator = aggregator;
        }

        public void execute() {
            this.diagram.addChild((ConnectableElement)this.aggregator);
        }

        public void undo() {
            this.diagram.removeChild((ConnectableElement)this.aggregator);
        }
    }

    private static class VirtualSupersetTypeDeleteCommand
    extends Command {
        private Diagram diagram;
        private VirtualSupersetType model;

        public VirtualSupersetTypeDeleteCommand(Diagram diagram, VirtualSupersetType model) {
            this.diagram = diagram;
            this.model = model;
        }

        public void execute() {
            this.diagram.removeChild((ConnectableElement)this.model);
        }

        public void undo() {
            this.diagram.addChild((ConnectableElement)this.model);
        }
    }
}

