/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.dialog.DetailEditDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.TMDModelGraphicalNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.ui.command.ModelEditCommand;
import jp.sourceforge.tmdmaker.ui.command.TableDeleteCommand;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class DetailEditPart
extends AbstractEntityEditPart {
    @Override
    protected void onDoubleClicked() {
        logger.debug(this.getClass() + "#onDoubleClicked()");
        Detail table = (Detail)this.getModel();
        DetailEditDialog dialog = new DetailEditDialog(this.getViewer().getControl().getShell(), table);
        if (dialog.open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            List<EditAttribute> editAttributeList = dialog.getEditAttributeList();
            this.addAttributeEditCommands(ccommand, (AbstractEntityModel)table, editAttributeList);
            ModelEditCommand command = new ModelEditCommand((AbstractEntityModel)table, (AbstractEntityModel)dialog.getEditedValue());
            ccommand.add((Command)command);
            this.getViewer().getEditDomain().getCommandStack().execute((Command)ccommand);
        }
    }

    @Override
    protected void updateFigure(IFigure figure) {
        EntityFigure entityFigure = (EntityFigure)figure;
        Detail entity = (Detail)this.getModel();
        entityFigure.setNotImplement(entity.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(entity.getName());
        IdentifierRef original = (IdentifierRef)entity.getOriginalReusedIdentifier().getUniqueIdentifieres().get(0);
        entityFigure.setIdentifier(original.getName());
        entityFigure.setIdentifier(entity.getDetailIdentifier().getName());
        for (Map.Entry rk : entity.getReusedIdentifieres().entrySet()) {
            for (IdentifierRef i : ((ReusedIdentifier)rk.getValue()).getUniqueIdentifieres()) {
                if (i.isSame(original)) continue;
                entityFigure.addRelationship(i.getName());
            }
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DetailComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TMDModelGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }

    private static class DetailComponentEditPolicy
    extends ComponentEditPolicy {
        private DetailComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            Detail model = (Detail)this.getHost().getModel();
            return new TableDeleteCommand((AbstractEntityModel)model, (AbstractConnectionModel)model.getModelTargetConnections().get(0));
        }
    }
}

