/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.dialog.LaputaEditDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityComponentEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.Laputa;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.ui.command.ModelEditCommand;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class LaputaEditPart
extends AbstractEntityEditPart {
    @Override
    protected void updateFigure(IFigure figure) {
        EntityFigure entityFigure = (EntityFigure)figure;
        Laputa entity = (Laputa)this.getModel();
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(entity.getName());
        entityFigure.setIdentifier(entity.getIdentifier().getName());
        for (Map.Entry rk : entity.getReusedIdentifieres().entrySet()) {
            for (Identifier i : ((ReusedIdentifier)rk.getValue()).getUniqueIdentifieres()) {
                entityFigure.addRelationship(i.getName());
            }
        }
        this.setupColor((IFigure)entityFigure, ModelAppearance.LAPUTA_COLOR);
    }

    @Override
    protected void onDoubleClicked() {
        logger.debug(this.getClass() + "#onDoubleClicked()");
        Laputa model = (Laputa)this.getModel();
        LaputaEditDialog dialog = new LaputaEditDialog(this.getViewer().getControl().getShell(), model);
        if (dialog.open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            List<EditAttribute> editAttributeList = dialog.getEditAttributeList();
            this.addAttributeEditCommands(ccommand, (AbstractEntityModel)model, editAttributeList);
            ModelEditCommand command = new ModelEditCommand((AbstractEntityModel)model, (AbstractEntityModel)dialog.getEditedValueEntity());
            ccommand.add((Command)command);
            this.getViewer().getEditDomain().getCommandStack().execute((Command)ccommand);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EntityComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }
}

