/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.preferences.appearance;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AppearancePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Composite colorFields;
    private BooleanFieldEditor editor;
    private List<ColorFieldEditor> colorFieldEditors = new ArrayList<ColorFieldEditor>();
    private List<ColorFieldEditor> fontFieldEditors = new ArrayList<ColorFieldEditor>();

    public AppearancePreferencePage() {
        super(1);
        this.setPreferenceStore(TMDPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        this.setColorFieldsEnabled(this.getPreferenceStore().getBoolean("entityColorEnablePreference"));
    }

    protected void createFieldEditors() {
        ModelAppearance a;
        Composite parent = this.getFieldEditorParent();
        Group colorGroup = new Group(parent, 0);
        colorGroup.setText("\u8272\u8a2d\u5b9a");
        colorGroup.setLayout((Layout)new GridLayout(1, true));
        GridData colorGd = new GridData(768);
        colorGd.horizontalSpan = 2;
        colorGroup.setLayoutData((Object)colorGd);
        this.editor = new BooleanFieldEditor("entityColorEnablePreference", "\u30e2\u30c7\u30eb\u306e\u8272\u8a2d\u5b9a\u3092\u6709\u52b9\u306b\u3059\u308b :", (Composite)colorGroup){

            protected void valueChanged(boolean oldValue, boolean newValue) {
                AppearancePreferencePage.this.setColorFieldsEnabled(newValue);
                super.valueChanged(oldValue, newValue);
            }
        };
        this.addField((FieldEditor)this.editor);
        this.colorFields = new Composite((Composite)colorGroup, 0);
        new Label(this.colorFields, 0);
        Label l = new Label(this.colorFields, 0);
        l.setText("\u80cc\u666f\u8272");
        ModelAppearance[] modelAppearanceArray = ModelAppearance.values();
        int n = modelAppearanceArray.length;
        int n2 = 0;
        while (n2 < n) {
            a = modelAppearanceArray[n2];
            this.colorFieldEditors.add(new ColorFieldEditor(a.getBackgroundColorPropertyName(), a.getLabel(), this.colorFields));
            ++n2;
        }
        for (ColorFieldEditor e : this.colorFieldEditors) {
            this.addField((FieldEditor)e);
        }
        new Label(this.colorFields, 0);
        l = new Label(this.colorFields, 0);
        l.setText("\u7f6b\u7dda\u30fb\u30d5\u30a9\u30f3\u30c8");
        modelAppearanceArray = ModelAppearance.values();
        n = modelAppearanceArray.length;
        int n3 = 0;
        while (n3 < n) {
            a = modelAppearanceArray[n3];
            this.fontFieldEditors.add(new ColorFieldEditor(a.getFontColorPropertyName(), a.getLabel(), this.colorFields));
            ++n3;
        }
        for (ColorFieldEditor e : this.fontFieldEditors) {
            this.addField((FieldEditor)e);
        }
    }

    private void setColorFieldsEnabled(boolean enabled) {
        for (ColorFieldEditor e : this.colorFieldEditors) {
            e.setEnabled(enabled, this.colorFields);
        }
        for (ColorFieldEditor e : this.fontFieldEditors) {
            e.setEnabled(enabled, this.colorFields);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.setColorFieldsEnabled(this.editor.getBooleanValue());
    }
}

