/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.util.List;
import jp.sourceforge.tmdmaker.dialog.ModelEditDialog;
import jp.sourceforge.tmdmaker.dialog.VirtualEntityEditDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityModelEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.ReconnectableNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.VirtualEntity;
import jp.sourceforge.tmdmaker.model.VirtualEntityType;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import jp.sourceforge.tmdmaker.ui.command.ImplementDerivationModelsDeleteCommand;
import jp.sourceforge.tmdmaker.ui.command.TableDeleteCommand;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class VirtualEntityEditPart
extends AbstractEntityModelEditPart<VirtualEntity> {
    public VirtualEntityEditPart(VirtualEntity entity) {
        this.setModel(entity);
    }

    @Override
    protected CompoundCommand createEditCommand(List<EditAttribute> editAttributeList, AbstractEntityModel editedValue) {
        CompoundCommand ccommand = super.createEditCommand(editAttributeList, editedValue);
        Command deleteCommand = this.getDeleteCommand(editedValue);
        if (deleteCommand != null) {
            ccommand.add(deleteCommand);
        }
        return ccommand;
    }

    @Override
    protected ModelEditDialog<VirtualEntity> getDialog() {
        return new VirtualEntityEditDialog(this.getControllShell(), (VirtualEntity)this.getModel());
    }

    @Override
    protected void updateFigure(IFigure figure) {
        EntityFigure entityFigure = (EntityFigure)figure;
        VirtualEntity entity = (VirtualEntity)this.getModel();
        entityFigure.setNotImplement(entity.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(entity.getName());
        entityFigure.setEntityType(EntityType.VE.getLabel());
        entityFigure.addRelationship(this.extractRelationship(entity));
        entityFigure.setColor(this.getForegroundColor(), this.getBackgroundColor());
    }

    @Override
    protected ModelAppearance getAppearance() {
        ModelAppearance appearance = null;
        appearance = ((VirtualEntity)this.getModel()).getVirtualEntityType().equals((Object)VirtualEntityType.RESOURCE) ? ModelAppearance.RESOURCE_VIRTUAL_ENTITY : (((VirtualEntity)this.getModel()).getVirtualEntityType().equals((Object)VirtualEntityType.EVENT) ? ModelAppearance.EVENT_SUBSET : ModelAppearance.VIRTUAL_ENTITY);
        return appearance;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new VirtualEntityComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ReconnectableNodeEditPolicy());
    }

    private static class VirtualEntityComponentEditPolicy
    extends ComponentEditPolicy {
        private VirtualEntityComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            VirtualEntity model = (VirtualEntity)this.getHost().getModel();
            CompoundCommand ccommand = new CompoundCommand();
            if (model.isNotImplement()) {
                AbstractEntityModel original = ImplementRule.findOriginalImplementModel((AbstractEntityModel)model);
                ccommand.add((Command)new ImplementDerivationModelsDeleteCommand((AbstractEntityModel)model, original));
            }
            ccommand.add((Command)new TableDeleteCommand((AbstractEntityModel)model, (AbstractConnectionModel)model.getModelTargetConnections().get(0)));
            return ccommand;
        }
    }
}

