/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.command;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Constraint;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;
import org.eclipse.gef.commands.Command;

public class VirtualSubsetDisconnectCommand
extends Command {
    private Diagram diagram;
    private VirtualSuperset superset;
    private AbstractEntityModel model;
    private Constraint oldTypeConstraint;

    public VirtualSubsetDisconnectCommand(VirtualSuperset superset, AbstractEntityModel model) {
        this.diagram = superset.getDiagram();
        this.superset = superset;
        this.oldTypeConstraint = superset.getVirtualSupersetType().getConstraint();
        this.model = model;
    }

    public void execute() {
        this.superset.disconnectSubset(this.model);
        if (!this.superset.hasSubset()) {
            this.diagram.removeChild((AbstractEntityModel)this.superset);
        }
    }

    public void undo() {
        if (!this.superset.hasSubset()) {
            this.diagram.addChild((AbstractEntityModel)this.superset);
        }
        this.superset.connectSubset(this.model);
        this.superset.getVirtualSupersetType().setConstraint(this.oldTypeConstraint);
    }
}

