/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.Attribute;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.Constraint;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.Entity2SubsetTypeRelationship;
import jp.sourceforge.tmdmaker.model.Entity2VirtualSupersetTypeRelationship;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.Event2EventRelationship;
import jp.sourceforge.tmdmaker.model.Header2DetailRelationship;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.IdentifierChangeListener;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.KeyModels;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.SubsetType2SubsetRelationship;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType;
import jp.sourceforge.tmdmaker.model.rule.SubsetRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityModel
extends ConnectableElement {
    private static Logger logger = LoggerFactory.getLogger(AbstractEntityModel.class);
    private Diagram diagram;
    public static final String PROPERTY_ATTRIBUTE_REORDER = "p_attribute_reorder";
    public static final String PROPERTY_ATTRIBUTE = "p_attribute";
    public static final String PROPERTY_REUSED = "p_reused";
    public static final String PROPERTY_ATTRIBUTES = "p_attributes";
    public static final String PROPERTY_NOT_IMPLEMENT = "p_notImplement";
    public static final String PROPERTY_IDENTIFIER = "_property_identifier";
    protected Map<AbstractEntityModel, ReusedIdentifier> reusedIdentifiers = new LinkedHashMap<AbstractEntityModel, ReusedIdentifier>();
    protected List<IAttribute> attributes = new ArrayList<IAttribute>();
    protected EntityType entityType = EntityType.RESOURCE;
    protected boolean notImplement = false;
    protected String implementName = "";
    protected List<AbstractEntityModel> implementDerivationModels = new ArrayList<AbstractEntityModel>();
    protected KeyModels keyModels = new KeyModels();

    public AbstractEntityModel() {
        this.setConstraint(new Constraint());
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    public Map<AbstractEntityModel, ReusedIdentifier> getReusedIdentifiers() {
        return Collections.unmodifiableMap(this.reusedIdentifiers);
    }

    public void setReusedIdentifiers(Map<AbstractEntityModel, ReusedIdentifier> reusedIdentifiers) {
        this.reusedIdentifiers = reusedIdentifiers;
    }

    public void addReusedIdentifier(AbstractEntityModel source) {
        this.addReusedIdentifier(source, source.createReusedIdentifier());
    }

    protected void addReusedIdentifier(AbstractEntityModel source, ReusedIdentifier reused) {
        ReusedIdentifier added = this.reusedIdentifiers.put(source, reused);
        this.firePropertyChange(PROPERTY_REUSED, null, added);
    }

    public ReusedIdentifier removeReusedIdentifier(AbstractEntityModel source) {
        ReusedIdentifier removed = this.reusedIdentifiers.remove(source);
        this.firePropertyChange(PROPERTY_REUSED, removed, null);
        return removed;
    }

    public abstract ReusedIdentifier createReusedIdentifier();

    public List<IAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<IAttribute> attributes) {
        List<IAttribute> oldValue = this.attributes;
        this.attributes = attributes;
        this.firePropertyChange(PROPERTY_ATTRIBUTE_REORDER, oldValue, attributes);
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public void addAttribute(int index, Attribute attribute) {
        this.attributes.add(index, attribute);
        this.firePropertyChange(PROPERTY_ATTRIBUTE, null, attribute);
    }

    public void removeAttribute(Attribute attribute) {
        if (this.attributes.remove(attribute)) {
            this.firePropertyChange(PROPERTY_ATTRIBUTE, attribute, null);
        }
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public SubsetType findSubsetType() {
        List<AbstractConnectionModel> results = this.findRelationship(this.getModelSourceConnections(), Entity2SubsetTypeRelationship.class);
        if (results.size() != 0) {
            return (SubsetType)((Entity2SubsetTypeRelationship)results.get(0)).getTarget();
        }
        return null;
    }

    public VirtualSupersetType findVirtualSupersetType() {
        List<AbstractConnectionModel> results = this.findRelationshipFromSourceConnections(Entity2VirtualSupersetTypeRelationship.class);
        if (results.size() != 0) {
            return (VirtualSupersetType)((Entity2VirtualSupersetTypeRelationship)results.get(0)).getTarget();
        }
        results = this.findRelationshipFromTargetConnections(Entity2VirtualSupersetTypeRelationship.class);
        if (results.size() != 0) {
            return (VirtualSupersetType)((Entity2VirtualSupersetTypeRelationship)results.get(0)).getTarget();
        }
        return null;
    }

    protected List<AbstractConnectionModel> findRelationship(List<AbstractConnectionModel> connections, Class<?> clazz) {
        ArrayList<AbstractConnectionModel> results = new ArrayList<AbstractConnectionModel>();
        for (AbstractConnectionModel connection : connections) {
            if (!clazz.equals(connection.getClass())) continue;
            results.add(connection);
        }
        return results;
    }

    public List<AbstractConnectionModel> findRelationshipFromSourceConnections(Class<?> clazz) {
        return this.findRelationship(this.getModelSourceConnections(), clazz);
    }

    public List<AbstractConnectionModel> findRelationshipFromTargetConnections(Class<?> clazz) {
        return this.findRelationship(this.getModelTargetConnections(), clazz);
    }

    public void fireIdentifierChanged(AbstractConnectionModel callConnection) {
        this.firePropertyChange(PROPERTY_REUSED, null, null);
        if (this.getEntityType().equals((Object)EntityType.RESOURCE)) {
            this.notifyIdentifierChangedToConnections(this.getModelSourceConnections(), callConnection);
            this.notifyIdentifierChangedToConnections(this.getModelTargetConnections(), callConnection);
        } else {
            this.notifyIdentifierChangedToConnections(this.getModelSourceConnections(), callConnection);
            List<AbstractConnectionModel> targetcons = this.findRelationshipFromTargetConnections(Event2EventRelationship.class);
            this.notifyIdentifierChangedToConnections(targetcons, callConnection);
        }
    }

    private void notifyIdentifierChangedToConnections(List<AbstractConnectionModel> connections, AbstractConnectionModel callConnection) {
        for (AbstractConnectionModel con : connections) {
            if (!(con instanceof IdentifierChangeListener) || con == callConnection) continue;
            ((IdentifierChangeListener)((Object)con)).identifierChanged();
            logger.debug(String.valueOf(this.getName()) + "\u304b\u3089" + con.getClass().toString() + "\u306b\u901a\u77e5\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public boolean isNotImplement() {
        return this.notImplement;
    }

    public void setNotImplement(boolean notImplement) {
        this.notImplement = notImplement;
    }

    public abstract boolean isEntityTypeEditable();

    public abstract boolean isDeletable();

    public String getImplementName() {
        return this.implementName;
    }

    public void setImplementName(String implementName) {
        this.implementName = implementName;
    }

    public void copyTo(AbstractEntityModel to) {
        to.setEntityType(this.getEntityType());
        to.setNotImplement(this.isNotImplement());
        to.setImplementName(this.getImplementName());
        to.setAttributes(this.getAttributes());
        to.setImplementDerivationModels(this.getImplementDerivationModels());
        to.setKeyModels(this.getKeyModels());
        to.setName(this.getName());
    }

    public void copyWithAttributesTo(AbstractEntityModel to) {
        this.copyTo(to);
        to.setAttributes(this.getCopyAttributes());
    }

    private List<IAttribute> getCopyAttributes() {
        ArrayList<IAttribute> copies = new ArrayList<IAttribute>(this.getAttributes().size());
        for (IAttribute a : this.getAttributes()) {
            Attribute copy = new Attribute();
            copy.copyFrom(a);
            copies.add(copy);
        }
        return copies;
    }

    public AbstractEntityModel getCopyWithAttributes() {
        AbstractEntityModel model = this.getCopy();
        model.setAttributes(this.getCopyAttributes());
        return model;
    }

    public List<AbstractEntityModel> getImplementDerivationModels() {
        if (this.implementDerivationModels == null) {
            return new ArrayList<AbstractEntityModel>();
        }
        return new ArrayList<AbstractEntityModel>(this.implementDerivationModels);
    }

    public void setImplementDerivationModels(List<AbstractEntityModel> implementDerivationModels) {
        this.implementDerivationModels = implementDerivationModels;
    }

    public abstract AbstractEntityModel getCopy();

    public KeyModels getKeyModels() {
        if (this.keyModels == null) {
            this.keyModels = new KeyModels();
        }
        return this.keyModels;
    }

    public void setKeyModels(KeyModels keyModels) {
        this.keyModels = keyModels;
    }

    public int calcurateMaxIdentifierRefSize() {
        int rx = 0;
        for (Map.Entry<AbstractEntityModel, ReusedIdentifier> e : this.getReusedIdentifiers().entrySet()) {
            ReusedIdentifier ri = e.getValue();
            for (IdentifierRef i : ri.getUniqueIdentifiers()) {
                rx = Math.max(i.getName().length() + 3, rx);
            }
        }
        return rx;
    }

    public int calcurateMaxAttributeNameSize() {
        int ax = 0;
        for (IAttribute a : this.getAttributes()) {
            ax = Math.max(a.getName().length(), ax);
        }
        return ax;
    }

    public boolean isHeaderDetail() {
        Header2DetailRelationship r = this.getHeader2DetailRelationship();
        return r != null;
    }

    public Header2DetailRelationship getHeader2DetailRelationship() {
        for (AbstractConnectionModel c : this.getModelSourceConnections()) {
            if (!(c instanceof Header2DetailRelationship)) continue;
            return (Header2DetailRelationship)c;
        }
        return null;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public SubsetEntity addSubset(String subsetName) {
        SubsetType subsetType = this.findSubsetType();
        if (subsetType == null) {
            subsetType = new SubsetType();
            subsetType.setSubsetType(SubsetType.SubsetTypeValue.SAME);
            subsetType.setExceptNull(false);
            this.getDiagram().addChild(subsetType);
            Entity2SubsetTypeRelationship r1 = new Entity2SubsetTypeRelationship(this, subsetType);
            r1.connect();
        }
        SubsetEntity subset = SubsetRule.createSubsetEntity(this, subsetName);
        SubsetType2SubsetRelationship r2 = new SubsetType2SubsetRelationship(subsetType, subset);
        r2.connect();
        this.getDiagram().addChild(subset);
        return subset;
    }

    public boolean removeSubset(SubsetEntity subset) {
        if (!subset.isDeletable()) {
            return false;
        }
        SubsetType subsetType = this.findSubsetType();
        if (subsetType == null) {
            return false;
        }
        if (subsetType.removeSubsetEntity(subset)) {
            this.removeSubsetTypeIfEmpty(subsetType);
            return true;
        }
        return false;
    }

    private void removeSubsetTypeIfEmpty(SubsetType subsetType) {
        if (!subsetType.hasSubsetEntity()) {
            Entity2SubsetTypeRelationship r = (Entity2SubsetTypeRelationship)subsetType.getModelTargetConnections().get(0);
            r.disconnect();
            this.getDiagram().removeChild(subsetType);
        }
    }

    @Override
    public boolean canCreateSubset() {
        return true;
    }

    @Override
    public boolean canCreateMultivalueOr() {
        return true;
    }

    @Override
    public boolean canCreateVirtualEntity() {
        return true;
    }
}

