/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.ProductProperties;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.FeatureSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.WelcomeEditorInput;

@Deprecated
public class QuickStartAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private static final String EDITOR_ID = "org.eclipse.ui.internal.ide.dialogs.WelcomeEditor";
    private IWorkbenchWindow workbenchWindow;

    public QuickStartAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public QuickStartAction(IWorkbenchWindow window) {
        super(IDEWorkbenchMessages.QuickStart_text);
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setToolTipText(IDEWorkbenchMessages.QuickStart_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.quick_start_action_context");
        this.setActionDefinitionId("org.eclipse.ui.help.quickStartAction");
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        try {
            AboutInfo feature = this.promptForFeature();
            if (feature != null) {
                this.openWelcomePage(feature);
            }
        }
        catch (WorkbenchException e) {
            ErrorDialog.openError((Shell)this.workbenchWindow.getShell(), (String)IDEWorkbenchMessages.QuickStartAction_errorDialogTitle, (String)IDEWorkbenchMessages.QuickStartAction_infoReadError, (IStatus)e.getStatus());
        }
    }

    private AboutInfo promptForFeature() throws WorkbenchException {
        ArrayList<AboutInfo> welcomeFeatures = new ArrayList<AboutInfo>();
        URL productUrl = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            productUrl = ProductProperties.getWelcomePageUrl((IProduct)product);
            welcomeFeatures.add(new AboutInfo(product));
        }
        AboutInfo[] features = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
        int i = 0;
        while (i < features.length) {
            URL url = features[i].getWelcomePageURL();
            if (!(url == null || productUrl != null && url.toString().equals(productUrl.toString()))) {
                welcomeFeatures.add(features[i]);
            }
            ++i;
        }
        Shell shell = this.workbenchWindow.getShell();
        if (welcomeFeatures.size() == 0) {
            MessageDialog.openInformation((Shell)shell, (String)IDEWorkbenchMessages.QuickStartMessageDialog_title, (String)IDEWorkbenchMessages.QuickStartMessageDialog_message);
            return null;
        }
        features = new AboutInfo[welcomeFeatures.size()];
        welcomeFeatures.toArray(features);
        FeatureSelectionDialog d = new FeatureSelectionDialog(shell, features, product == null ? null : product.getId(), IDEWorkbenchMessages.WelcomePageSelectionDialog_title, IDEWorkbenchMessages.WelcomePageSelectionDialog_message, "org.eclipse.ui.ide.welcome_page_selection_dialog");
        if (d.open() != 0 || d.getResult().length != 1) {
            return null;
        }
        return (AboutInfo)d.getResult()[0];
    }

    public boolean openWelcomePage(String featureId) throws WorkbenchException {
        AboutInfo feature = this.findFeature(featureId);
        if (feature == null || feature.getWelcomePageURL() == null) {
            return false;
        }
        return this.openWelcomePage(feature);
    }

    private AboutInfo findFeature(String featureId) throws WorkbenchException {
        AboutInfo[] features = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
        int i = 0;
        while (i < features.length) {
            AboutInfo info = features[i];
            if (info.getFeatureId().equals(featureId)) {
                return info;
            }
            ++i;
        }
        return null;
    }

    private boolean openWelcomePage(AboutInfo feature) {
        IWorkbenchPage page = null;
        String perspectiveId = feature.getWelcomePerspectiveId();
        if (perspectiveId == null && ((page = this.workbenchWindow.getActivePage()) == null || page.getPerspective() == null)) {
            perspectiveId = PlatformUI.getWorkbench().getPerspectiveRegistry().getDefaultPerspective();
        }
        if (perspectiveId != null) {
            try {
                page = PlatformUI.getWorkbench().showPerspective(perspectiveId, this.workbenchWindow);
            }
            catch (WorkbenchException e) {
                IDEWorkbenchPlugin.log("Error opening perspective: " + perspectiveId, e.getStatus());
                return false;
            }
        }
        if (page == null) {
            return false;
        }
        page.setEditorAreaVisible(true);
        WelcomeEditorInput input = new WelcomeEditorInput(feature);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.activate((IWorkbenchPart)editor);
            return true;
        }
        try {
            page.openEditor((IEditorInput)input, EDITOR_ID);
        }
        catch (PartInitException e) {
            IDEWorkbenchPlugin.log("Error opening welcome editor for feature: " + feature.getFeatureId(), e);
            Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.QuickStartAction_openEditorException, (Throwable)e);
            ErrorDialog.openError((Shell)this.workbenchWindow.getShell(), (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogTitle, (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogMessage, (IStatus)status);
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow = null;
    }
}

