/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.dom;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTCursorHelper;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTFontHelper;
import org.eclipse.e4.ui.css.swt.properties.GradientBackgroundListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ControlElement
extends WidgetElement {
    private static final String WEBSITE_CLASS = "org.eclipse.swt.browser.WebSite";
    protected boolean hasFocus = false;
    protected boolean hasMouseHover = false;
    private FocusListener focusListener = new FocusAdapter(){

        public void focusGained(FocusEvent e) {
            ControlElement.this.hasFocus = true;
            ControlElement.this.doApplyStyles();
        }

        public void focusLost(FocusEvent e) {
            ControlElement.this.hasFocus = false;
            ControlElement.this.doApplyStyles();
        }
    };
    private MouseTrackListener mouseHoverListener = new MouseTrackAdapter(){

        public void mouseEnter(MouseEvent e) {
            ControlElement.this.hasMouseHover = true;
            ControlElement.this.doApplyStyles();
        }

        public void mouseExit(MouseEvent e) {
            ControlElement.this.hasMouseHover = false;
            ControlElement.this.doApplyStyles();
        }
    };

    public ControlElement(Control control, CSSEngine engine) {
        super((Widget)control, engine);
    }

    public void initialize() {
        super.initialize();
        if (!this.dynamicEnabled) {
            return;
        }
        Control control = this.getControl();
        control.addFocusListener(this.focusListener);
        control.addMouseTrackListener(this.mouseHoverListener);
    }

    public void dispose() {
        super.dispose();
        if (!this.dynamicEnabled) {
            return;
        }
        Control control = this.getControl();
        if (!control.isDisposed()) {
            control.removeFocusListener(this.focusListener);
            control.removeMouseTrackListener(this.mouseHoverListener);
        }
    }

    public boolean isPseudoInstanceOf(String s) {
        if ("focus".equalsIgnoreCase(s)) {
            return this.hasFocus;
        }
        if ("hover".equalsIgnoreCase(s)) {
            return this.hasMouseHover;
        }
        if ("enabled".equalsIgnoreCase(s)) {
            return this.getControl().getEnabled();
        }
        if ("disabled".equalsIgnoreCase(s)) {
            return !this.getControl().getEnabled();
        }
        if ("visible".equalsIgnoreCase(s)) {
            return this.getControl().getVisible();
        }
        return super.isPseudoInstanceOf(s);
    }

    @Override
    public Node getParentNode() {
        Control control = this.getControl();
        Composite parent = control.getParent();
        if (parent != null) {
            Element element = this.getElement(parent);
            return element;
        }
        return null;
    }

    protected Control getControl() {
        return (Control)this.getNativeWidget();
    }

    @Override
    public void reset() {
        Control control = this.getControl();
        CSSSWTFontHelper.restoreDefaultFont(control);
        CSSSWTCursorHelper.restoreDefaultCursor(control);
        GradientBackgroundListener.remove(control);
        if (control.getBackgroundImage() != null) {
            control.setBackgroundImage(null);
        }
        if (WEBSITE_CLASS.equals(control.getClass().getName())) {
            control.setBackground(control.getDisplay().getSystemColor(25));
            control.setForeground(control.getDisplay().getSystemColor(36));
        } else {
            control.setBackground(null);
            control.setForeground(null);
        }
        super.reset();
    }
}

