/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.AbstractRelationship;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.rule.EntityTypeRule;

public class TransfarReuseKeysToTargetRelationship
extends AbstractRelationship {
    private ReusedIdentifier targetReusedIdentifier;

    public TransfarReuseKeysToTargetRelationship() {
    }

    public TransfarReuseKeysToTargetRelationship(AbstractEntityModel source, AbstractEntityModel target) {
        AbstractEntityModel from = null;
        AbstractEntityModel to = null;
        if (EntityTypeRule.isResource(source)) {
            from = source;
            to = target;
        } else {
            from = target;
            to = source;
        }
        this.setSource(from);
        this.setTarget(to);
    }

    @Override
    public void attachTarget() {
        super.attachTarget();
        if (this.targetReusedIdentifier == null) {
            this.getTarget().addReusedIdentifier(this.getSource());
        } else {
            this.getTarget().addReusedIdentifier(this.getSource(), this.targetReusedIdentifier);
            this.targetReusedIdentifier = null;
        }
    }

    @Override
    public void detachTarget() {
        this.targetReusedIdentifier = this.getTarget().removeReusedIdentifier(this.getSource());
        super.detachTarget();
    }

    @Override
    public boolean isDeletable() {
        return true;
    }

    @Override
    public void identifierChanged() {
        this.getTarget().fireIdentifierChanged(this);
    }
}

