/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.dialogs.models;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.parts.ModelName;
import jp.sourceforge.tmdmaker.model.rule.EntityRecognitionRule;
import jp.sourceforge.tmdmaker.ui.dialogs.models.EditAttribute;

public class EntityCreation {
    private EditAttribute identifier = new EditAttribute();
    private ModelName entityName = new ModelName();
    private EntityType entityType = EntityType.RESOURCE;
    private boolean entityNameAutoGeneration = true;

    public boolean isEntityNameAutoGeneration() {
        return this.entityNameAutoGeneration;
    }

    public void setEntityNameAutoGeneration(boolean entityNameAutoGeneration) {
        this.entityNameAutoGeneration = entityNameAutoGeneration;
        if (this.isEntityNameAutoGeneration()) {
            this.generateEntityNameFromIdentifier();
        }
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public void setIdentifierName(String identifierName) {
        this.identifier.setName(identifierName);
        if (this.isEntityNameAutoGeneration()) {
            this.generateEntityNameFromIdentifier();
        }
    }

    private void generateEntityNameFromIdentifier() {
        this.entityName = new Identifier(this.identifier.getName()).createEntityName();
    }

    public EditAttribute getIdentifier() {
        return this.identifier;
    }

    public ModelName getEntityName() {
        return this.entityName;
    }

    public void setEntityName(ModelName entityName) {
        this.entityName = entityName;
    }

    private boolean isLaputa() {
        return this.entityType.equals((Object)EntityType.LAPUTA);
    }

    private boolean isValidEntity() {
        return !this.entityName.isEmpty() && this.identifier.isValid();
    }

    public boolean isValid() {
        return this.isLaputa() || this.isValidEntity();
    }

    public AbstractEntityModel getCreateModel() {
        EntityRecognitionRule rule = EntityRecognitionRule.getInstance();
        String name = this.entityName.getValue();
        Identifier identifier = this.identifier.toIdentifier();
        if (this.isLaputa()) {
            return rule.createLaputa(name, identifier);
        }
        return rule.createEntity(name, identifier, this.entityType);
    }
}

