/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.SurrogateKey;
import jp.sourceforge.tmdmaker.model.SurrogateKeyRef;

public class ReusedIdentifier
implements Serializable {
    private List<IdentifierRef> identifiers = new ArrayList<IdentifierRef>();
    private List<SurrogateKeyRef> surrogateKeys = new ArrayList<SurrogateKeyRef>();

    public ReusedIdentifier() {
    }

    public ReusedIdentifier(Identifier identifier, SurrogateKey surrogateKey) {
        this.addIdentifier(identifier);
        this.surrogateKeys.add(new SurrogateKeyRef(surrogateKey));
    }

    public ReusedIdentifier(SurrogateKey surrogateKey) {
        this.surrogateKeys.add(new SurrogateKeyRef(surrogateKey));
    }

    public ReusedIdentifier(SurrogateKey surrogateKey1, SurrogateKey surrogateKey2) {
        this.surrogateKeys.add(new SurrogateKeyRef(surrogateKey1));
        this.surrogateKeys.add(new SurrogateKeyRef(surrogateKey2));
    }

    public List<IdentifierRef> getIdentifiers() {
        return Collections.unmodifiableList(this.identifiers);
    }

    public List<IdentifierRef> getUniqueIdentifiers() {
        ArrayList<IdentifierRef> list = new ArrayList<IdentifierRef>(this.identifiers.size());
        for (IdentifierRef i : this.identifiers) {
            if (i.isDuplicate().booleanValue()) continue;
            list.add(i);
        }
        return Collections.unmodifiableList(list);
    }

    public List<SurrogateKeyRef> getSurrogateKeys() {
        return Collections.unmodifiableList(this.surrogateKeys);
    }

    public void addAll(List<IdentifierRef> identifiers) {
        for (IdentifierRef i : identifiers) {
            this.identifiers.add(new IdentifierRef(i));
        }
    }

    public void addIdentifier(Identifier identifier) {
        IdentifierRef identifierRef = new IdentifierRef(identifier);
        this.identifiers.add(identifierRef);
    }

    public void dispose() {
        this.identifiers.clear();
    }

    public boolean isSurrogateKeyEnabled() {
        if (this.surrogateKeys != null && this.surrogateKeys.size() > 0) {
            SurrogateKeyRef surrogateKey = this.surrogateKeys.get(0);
            return surrogateKey != null && surrogateKey.isEnabled();
        }
        return false;
    }
}

