/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.relationship;

import java.beans.PropertyChangeEvent;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.AbstractRelationship;
import jp.sourceforge.tmdmaker.ui.dialogs.RelationshipEditDialog;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.figure.relationship.RelationshipFigure;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.ConnectionDeleteCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.RelationshipEditCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.relationship.AbstractRelationshipEditPart;
import jp.sourceforge.tmdmaker.ui.editor.gef3.editpolicies.RelationshipEditPolicy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class RelationshipEditPart
extends AbstractRelationshipEditPart {
    public RelationshipEditPart(AbstractRelationship relationship) {
        this.setModel(relationship);
    }

    protected IFigure createFigure() {
        RelationshipFigure connection = new RelationshipFigure();
        this.updateFigure(connection);
        return connection;
    }

    protected void updateFigure(RelationshipFigure connection) {
        AbstractRelationship model = (AbstractRelationship)this.getModel();
        connection.update(model);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.calculateAnchorLocation();
        this.updateFigure((RelationshipFigure)this.getFigure());
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new RelationshipEditPolicy(){

            @Override
            protected Command getDeleteCommand(GroupRequest request) {
                ConnectionDeleteCommand cmd = new ConnectionDeleteCommand((AbstractConnectionModel)RelationshipEditPart.this.getModel());
                return cmd;
            }
        });
    }

    protected void onDoubleClicked() {
        AbstractRelationship model = (AbstractRelationship)this.getModel();
        AbstractEntityModel source = model.getSource();
        AbstractEntityModel target = model.getTarget();
        RelationshipEditDialog dialog = new RelationshipEditDialog(this.getViewer().getControl().getShell(), source.getName(), target.getName(), model.getSourceCardinality(), model.getTargetCardinality(), model.isSourceNoInstance(), model.isTargetNoInstance());
        if (dialog.open() == 0) {
            RelationshipEditCommand command = new RelationshipEditCommand();
            command.setModel(model);
            command.setSourceCardinality(dialog.getSourceCardinality());
            command.setSourceNoInstance(dialog.isSourceNoInstance());
            command.setTargetCardinality(dialog.getTargetCardinality());
            command.setTargetNoInstance(dialog.isTargetNoInstance());
            GraphicalViewer viewer = (GraphicalViewer)this.getViewer();
            viewer.getEditDomain().getCommandStack().execute((Command)command);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_property_source_cardinality")) {
            this.refreshVisuals();
        } else if (evt.getPropertyName().equals("_property_target_cardinality")) {
            this.refreshVisuals();
        } else if (evt.getPropertyName().equals("_property_connection")) {
            this.refreshVisuals();
        } else {
            super.propertyChange(evt);
        }
    }

    public void performRequest(Request req) {
        this.logger.debug(String.valueOf(this.getClass().toString()) + req.getType());
        if (req.getType().equals("open")) {
            this.onDoubleClicked();
        } else {
            super.performRequest(req);
        }
    }
}

