/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model.rule;

import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.Laputa;
import jp.sourceforge.tmdmaker.model.rule.EntityTypeRule;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;

public class EntityRecognitionRule {
    private static EntityRecognitionRule rule;
    public static final String[] DEFAULT_IDENTIFIER_SUFFIXES;
    public static final String[] DEFAULT_REPORT_SUFFIXES;
    private static final String SEPARATOR = ",";
    private String[] identifierSuffixes = DEFAULT_IDENTIFIER_SUFFIXES;
    private String[] reportSuffixes = DEFAULT_REPORT_SUFFIXES;

    static {
        DEFAULT_IDENTIFIER_SUFFIXES = new String[]{"ID", "\uff29\uff24", "id", "\uff49\uff44", "\u30b3\u30fc\u30c9", "CD", "cd", "\u756a\u53f7", "No", "NO", "no", "NUM", "Num", "num"};
        DEFAULT_REPORT_SUFFIXES = new String[]{"\u4f1d\u7968", "\u5831\u544a\u66f8", "\u66f8", "\u30ec\u30dd\u30fc\u30c8"};
    }

    public static EntityRecognitionRule getInstance() {
        if (rule == null) {
            rule = new EntityRecognitionRule();
        }
        return rule;
    }

    public String generateEntityNameFromIdentifier(String identifierName) {
        String entityName = this.removeIdentifierSuffixFromIdentifierName(identifierName);
        return this.removeReportNameSuffixFromEntityName(entityName);
    }

    private String removeIdentifierSuffixFromIdentifierName(String identifierName) {
        String[] stringArray = this.identifierSuffixes;
        int n = this.identifierSuffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            if (identifierName.endsWith(suffix)) {
                return identifierName.substring(0, identifierName.lastIndexOf(suffix));
            }
            ++n2;
        }
        return identifierName;
    }

    private String removeReportNameSuffixFromEntityName(String entityName) {
        String[] stringArray = this.reportSuffixes;
        int n = this.reportSuffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String reportSuffix = stringArray[n2];
            if (entityName.endsWith(reportSuffix)) {
                return entityName.substring(0, entityName.lastIndexOf(reportSuffix));
            }
            ++n2;
        }
        return entityName;
    }

    public Entity createEntity(String entityName, Identifier identifier, EntityType entityType) {
        Entity entity = new Entity();
        entity.setName(entityName);
        entity.setEntityType(entityType);
        entity.setIdentifier(identifier);
        EntityTypeRule.addDefaultAttribute(entity);
        ImplementRule.setModelDefaultValue(entity);
        ImplementRule.setIdentifierDefaultValue(entity.getIdentifier());
        return entity;
    }

    public Laputa createLaputa(String entityName, Identifier identifier) {
        Laputa laputa = new Laputa();
        if (entityName != null && entityName.length() > 0) {
            laputa.setName(entityName);
        } else {
            laputa.setName("\u30e9\u30d4\u30e5\u30bf");
        }
        if (identifier != null) {
            laputa.setIdentifier(identifier);
        } else {
            laputa.setIdentifier(new Identifier(entityName));
        }
        laputa.setEntityType(EntityType.LAPUTA);
        return laputa;
    }

    public Laputa createLaputa(String entityName) {
        return this.createLaputa(entityName, null);
    }

    public Laputa createLaputa() {
        return this.createLaputa(null, null);
    }

    public void setIdentifierSuffixes(String[] suffixes) {
        this.identifierSuffixes = suffixes;
    }

    public void setReportSuffixes(String[] reportSuffixes) {
        this.reportSuffixes = reportSuffixes;
    }

    public String getIdentifierSuffixesString() {
        StringBuffer buf = new StringBuffer();
        String[] stringArray = this.identifierSuffixes;
        int n = this.identifierSuffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (buf.length() > 0) {
                buf.append(SEPARATOR);
            }
            buf.append(str);
            ++n2;
        }
        return buf.toString();
    }

    public void setIdentifierSuffixesString(String suffixes) {
        this.setIdentifierSuffixes(suffixes.split(SEPARATOR));
    }

    public String getReportSuffixesString() {
        StringBuffer buf = new StringBuffer();
        String[] stringArray = this.reportSuffixes;
        int n = this.reportSuffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (buf.length() > 0) {
                buf.append(SEPARATOR);
            }
            buf.append(str);
            ++n2;
        }
        return buf.toString();
    }

    public void setReportSuffixesString(String suffixes) {
        this.setReportSuffixes(suffixes.split(SEPARATOR));
    }
}

