/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.editor.gef3.commands;

import java.util.List;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.parts.ModelName;
import jp.sourceforge.tmdmaker.model.subset.SubsetBuilder;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.adjuster.SubsetAdjuster;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.adjuster.SubsetTypeAdjuster;
import org.eclipse.gef.commands.Command;

public class SubsetAddCommand
extends Command {
    private AbstractEntityModel parent;
    private List<ModelName> addSubsetNameList;
    private List<SubsetEntity> addedList;
    private SubsetBuilder builder;

    public SubsetAddCommand(AbstractEntityModel parent, List<ModelName> addSubsetNameList) {
        this.parent = parent;
        this.addSubsetNameList = addSubsetNameList;
    }

    public void execute() {
        this.builder = this.parent.subsets().builder();
        for (ModelName name : this.addSubsetNameList) {
            this.builder.add(name);
        }
        this.builder.build();
        SubsetType subsetType = this.parent.subsets().subsetType();
        if (subsetType.isInitialPosition()) {
            new SubsetTypeAdjuster(this.parent, subsetType).adjust();
        }
        this.addedList = this.builder.getAddedSubsetList();
        new SubsetAdjuster(this.parent, this.addedList).adjust();
    }

    public void undo() {
        this.builder.rollbackAdd();
    }

    public void redo() {
        this.builder.build();
    }
}

