/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.editor.gef3.commands;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.Laputa;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.parts.ModelName;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.ConstraintConverter;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.Clipboard;

public class PasteModelCommand
extends Command {
    Diagram diagram;
    List<AbstractEntityModel> copyList = new ArrayList<AbstractEntityModel>();

    public boolean canExecute() {
        Object obj = Clipboard.getDefault().getContents();
        if (!(obj instanceof List)) {
            return false;
        }
        List list = (List)obj;
        this.copyList.clear();
        for (AbstractEntityModel m : list) {
            if (this.diagram == null) {
                this.diagram = m.getDiagram();
            }
            this.add(m);
        }
        return this.copyList != null && !this.copyList.isEmpty();
    }

    private void add(AbstractEntityModel model) {
        if (model instanceof Entity) {
            this.copyList.add(this.createCopy(model));
        } else {
            this.copyList.add(this.copyToLaputa(model));
        }
    }

    private AbstractEntityModel createCopy(AbstractEntityModel model) {
        AbstractEntityModel copy = model.getCopyWithAttributes();
        ConstraintConverter.copyConstraint((ModelElement)copy, (ModelElement)model);
        return copy;
    }

    private AbstractEntityModel copyToLaputa(AbstractEntityModel model) {
        Laputa laputa = Laputa.of((ModelName)new ModelName(model.getName()));
        model.copyWithAttributesTo((AbstractEntityModel)laputa);
        ConstraintConverter.copyConstraint((ModelElement)laputa, (ModelElement)model);
        return laputa;
    }

    public void execute() {
        for (AbstractEntityModel m : this.copyList) {
            this.diagram.addChild(m);
        }
    }

    public void undo() {
        for (AbstractEntityModel m : this.copyList) {
            this.diagram.removeChild(m);
        }
    }
}

