/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.sphinx.relationshiplist;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.sphinx.relationshiplist.RelationshipMapping;
import jp.sourceforge.tmdmaker.sphinx.utilities.SphinxUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class RelationshipListRstGenerator {
    public static IOException generateRelationshipList(List<AbstractEntityModel> models, File outputdir) {
        IOException _xblockexpression = null;
        outputdir.mkdirs();
        LinkedHashMap<AbstractEntityModel, List<RelationshipMapping>> relationshipMappingMap = RelationshipListRstGenerator.createData(models);
        HashMap<AbstractEntityModel, ArrayList<String>> table = new HashMap<AbstractEntityModel, ArrayList<String>>();
        Set<Map.Entry<AbstractEntityModel, List<RelationshipMapping>>> _entrySet = relationshipMappingMap.entrySet();
        for (Map.Entry<AbstractEntityModel, List<RelationshipMapping>> mapping : _entrySet) {
            ArrayList<String> row = new ArrayList<String>();
            boolean isWrite = true;
            List<RelationshipMapping> _value = mapping.getValue();
            for (RelationshipMapping rm : _value) {
                row.add(RelationshipListRstGenerator.cellValue(isWrite, rm.isRelationship()));
                AbstractEntityModel _target = rm.getTarget();
                AbstractEntityModel _key = mapping.getKey();
                boolean _equals = Objects.equal((Object)_target, (Object)_key);
                if (!_equals) continue;
                isWrite = false;
            }
            table.put(mapping.getKey(), row);
        }
        CharSequence _relationshipList = RelationshipListRstGenerator.relationshipList(table);
        File _file = new File(outputdir, "relationship_list.rst");
        _xblockexpression = SphinxUtils.writeTo(_relationshipList, _file);
        return _xblockexpression;
    }

    private static String cellValue(boolean isWrite, boolean relationship) {
        String _xifexpression = null;
        if (isWrite) {
            String _xifexpression_1 = null;
            _xifexpression_1 = relationship ? "\u25cb" : "\u00d7";
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = "\\-";
        }
        return _xifexpression;
    }

    private static LinkedHashMap<AbstractEntityModel, List<RelationshipMapping>> createData(final List<AbstractEntityModel> models) {
        LinkedHashMap _xblockexpression = null;
        LinkedHashMap relationshipMappingMap = new LinkedHashMap();
        Functions.Function2<LinkedHashMap<AbstractEntityModel, List<RelationshipMapping>>, AbstractEntityModel, LinkedHashMap<AbstractEntityModel, List<RelationshipMapping>>> _function = new Functions.Function2<LinkedHashMap<AbstractEntityModel, List<RelationshipMapping>>, AbstractEntityModel, LinkedHashMap<AbstractEntityModel, List<RelationshipMapping>>>(){

            public LinkedHashMap<AbstractEntityModel, List<RelationshipMapping>> apply(LinkedHashMap<AbstractEntityModel, List<RelationshipMapping>> rm, final AbstractEntityModel source) {
                LinkedHashMap<AbstractEntityModel, List<RelationshipMapping>> _xblockexpression = null;
                Functions.Function1<AbstractEntityModel, RelationshipMapping> _function = new Functions.Function1<AbstractEntityModel, RelationshipMapping>(){

                    public RelationshipMapping apply(AbstractEntityModel target) {
                        return new RelationshipMapping(source, target);
                    }
                };
                rm.put(source, ListExtensions.map((List)models, (Functions.Function1)_function));
                _xblockexpression = rm;
                return _xblockexpression;
            }
        };
        _xblockexpression = (LinkedHashMap)IterableExtensions.fold(models, relationshipMappingMap, (Functions.Function2)_function);
        return _xblockexpression;
    }

    private static CharSequence relationshipList(Map<AbstractEntityModel, ArrayList<String>> table) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\u30ea\u30ec\u30fc\u30b7\u30e7\u30f3\u30b7\u30c3\u30d7\u306e\u691c\u8a3c\u8868");
        _builder.newLine();
        _builder.append("===========================");
        _builder.newLine();
        _builder.newLine();
        _builder.append(".. list-table::");
        _builder.newLine();
        _builder.append("   ");
        _builder.append(":header-rows: 1");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("* - ");
        _builder.newLine();
        Set<AbstractEntityModel> _keySet = table.keySet();
        for (AbstractEntityModel abstractEntityModel : _keySet) {
            _builder.append("     ");
            _builder.append("- ");
            String _name = abstractEntityModel.getName();
            _builder.append(_name, "     ");
            _builder.newLineIfNotEmpty();
        }
        Set<Map.Entry<AbstractEntityModel, ArrayList<String>>> _entrySet = table.entrySet();
        for (Map.Entry entry : _entrySet) {
            _builder.append("   ");
            _builder.append("* - ");
            String _name_1 = ((AbstractEntityModel)entry.getKey()).getName();
            _builder.append(_name_1, "   ");
            _builder.newLineIfNotEmpty();
            ArrayList _value = (ArrayList)entry.getValue();
            for (String rm : _value) {
                _builder.append("   ");
                _builder.append("  ");
                _builder.append("- ");
                _builder.append(rm, "     ");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }
}

