/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.parts.ModelName;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import jp.sourceforge.tmdmaker.ui.dialogs.components.SubsetSettingPanel;
import jp.sourceforge.tmdmaker.ui.dialogs.models.EditSubsetEntity;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.ImplementDerivationModelsDeleteCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.SubsetAddCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.SubsetDeleteCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.SubsetNameChangeCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.SubsetTypeChangeCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SubsetCreateDialog
extends Dialog {
    private SubsetSettingPanel panel;
    private SubsetType.SubsetTypeValue subsetType;
    private boolean exceptNull;
    private List<IAttribute> attributes;
    private List<EditSubsetEntity> subsetEntities = new ArrayList<EditSubsetEntity>();
    private IAttribute selectedAttribute;
    private SubsetType.SubsetTypeValue editedSubsetType;
    private IAttribute editedPartitionAttribute;
    private List<EditSubsetEntity> editedSubsetEntities;
    private List<EditSubsetEntity> deletedSubsetEntities;
    private boolean editedExceptNull;
    private AbstractEntityModel model;
    private CompoundCommand ccommand;

    public SubsetCreateDialog(Shell parentShell, AbstractEntityModel model) {
        super(parentShell);
        if (model.subsets().hasSubset()) {
            SubsetType currentSubsetType = model.subsets().subsetType();
            this.subsetType = currentSubsetType.getSubsetType();
            this.exceptNull = currentSubsetType.isExceptNull();
            this.selectedAttribute = currentSubsetType.getPartitionAttribute();
            for (SubsetEntity se : currentSubsetType.getSubsetList()) {
                this.subsetEntities.add(new EditSubsetEntity(se));
            }
        } else {
            this.subsetType = SubsetType.SubsetTypeValue.SAME;
            this.exceptNull = false;
        }
        this.attributes = model.getAttributes();
        this.model = model;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.EditSubset);
        Composite composite = new Composite(parent, 0);
        this.panel = new SubsetSettingPanel(composite, 0);
        this.panel.initializeValue(this.subsetType.equals((Object)SubsetType.SubsetTypeValue.SAME), this.exceptNull, this.attributes, this.subsetEntities, this.selectedAttribute);
        composite.pack();
        return composite;
    }

    protected void okPressed() {
        this.editedSubsetType = this.createEditedSubsetType();
        this.editedExceptNull = this.panel.isExceptNull();
        int partitionSelectionIndex = this.panel.getSelectedPartitionAttributeIndex();
        if (partitionSelectionIndex != -1) {
            this.editedPartitionAttribute = this.attributes.get(partitionSelectionIndex);
        }
        this.editedSubsetEntities = this.panel.getSubsetEntityList();
        this.deletedSubsetEntities = this.panel.getDeletedSubsetEntityList();
        this.ccommand = new CompoundCommand();
        this.addSubsetAddCommand();
        this.addSubsetTypeChangeCommand();
        this.addSubsetEntityRenameCommand();
        this.addSubsetDeleteCommand();
        super.okPressed();
    }

    public CompoundCommand getCcommand() {
        return this.ccommand;
    }

    private void addSubsetAddCommand() {
        this.ccommand.add((Command)new SubsetAddCommand(this.model, this.getAddSubsetEntityNames()));
    }

    private List<ModelName> getAddSubsetEntityNames() {
        ArrayList<ModelName> subsetNames = new ArrayList<ModelName>();
        for (EditSubsetEntity s : this.editedSubsetEntities) {
            if (!s.isAdded()) continue;
            subsetNames.add(new ModelName(s.getName()));
        }
        return subsetNames;
    }

    private void addSubsetTypeChangeCommand() {
        this.ccommand.add((Command)new SubsetTypeChangeCommand(this.model, this.editedSubsetType, this.editedPartitionAttribute, this.editedExceptNull));
    }

    private SubsetType.SubsetTypeValue createEditedSubsetType() {
        if (this.panel.isSameTypeSelected()) {
            return SubsetType.SubsetTypeValue.SAME;
        }
        return SubsetType.SubsetTypeValue.DIFFERENT;
    }

    private void addSubsetEntityRenameCommand() {
        for (EditSubsetEntity s : this.editedSubsetEntities) {
            if (!s.isNameChanged()) continue;
            this.ccommand.add((Command)new SubsetNameChangeCommand(s.getOriginal(), s.getName()));
        }
    }

    private void addSubsetDeleteCommand() {
        ArrayList<EditSubsetEntity> deletedList = new ArrayList<EditSubsetEntity>();
        for (EditSubsetEntity e : this.deletedSubsetEntities) {
            if (e.getOriginal() == null) continue;
            deletedList.add(e);
        }
        AbstractEntityModel original = null;
        for (EditSubsetEntity e : deletedList) {
            SubsetEntity subset = e.getOriginal();
            if (original == null) {
                original = ImplementRule.findOriginalImplementModel((AbstractEntityModel)subset);
            }
            if (subset == null) continue;
            SubsetDeleteCommand command = new SubsetDeleteCommand(subset);
            this.ccommand.add((Command)command);
            if (!subset.isNotImplement()) continue;
            this.ccommand.add((Command)new ImplementDerivationModelsDeleteCommand((AbstractEntityModel)subset, original));
        }
    }
}

