/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.importer.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.csv.Messages;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Attribute;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.Laputa;
import jp.sourceforge.tmdmaker.model.importer.FileImporter;
import jp.sourceforge.tmdmaker.model.parts.ModelName;

public class EntityFileImporter
implements FileImporter {
    private static final String[] EXTENSION = new String[]{"csv"};

    public String getImporterName() {
        return Messages.getString("EntityFileImporter.ImporterName");
    }

    public List<AbstractEntityModel> importEntities(String filePath) throws FileNotFoundException, IOException {
        String[] nextLine;
        CSVReader reader = new CSVReader((Reader)new BufferedReader(new FileReader(filePath)));
        Laputa l = null;
        LinkedHashMap<String, AbstractEntityModel> s = new LinkedHashMap<String, AbstractEntityModel>();
        while ((nextLine = reader.readNext()) != null) {
            String entityName = nextLine[0];
            String attributeName = "";
            if (nextLine.length >= 2) {
                attributeName = nextLine[1];
            }
            if (l == null) {
                l = this.createLaputa(s, entityName);
            }
            if (!entityName.equals(l.getName())) {
                l = (AbstractEntityModel)s.get(entityName);
                if (l == null) {
                    l = this.createLaputa(s, entityName);
                }
            } else {
                l = (AbstractEntityModel)s.get(entityName);
            }
            l.addAttribute(new Attribute(attributeName));
        }
        reader.close();
        ArrayList<AbstractEntityModel> list = new ArrayList<AbstractEntityModel>();
        for (Map.Entry entry : s.entrySet()) {
            list.add(this.convertEntityIfPossible((AbstractEntityModel)entry.getValue()));
        }
        return list;
    }

    private AbstractEntityModel convertEntityIfPossible(AbstractEntityModel model) {
        String entityName = model.getName();
        ArrayList<IAttribute> identifierCandidates = new ArrayList<IAttribute>();
        for (IAttribute a : model.getAttributes()) {
            String generateName = new Identifier(a.getName()).createEntityName().getValue();
            if (!entityName.equals(generateName)) continue;
            identifierCandidates.add(a);
        }
        if (!identifierCandidates.isEmpty()) {
            IAttribute attribute = (IAttribute)identifierCandidates.get(0);
            Entity entity = null;
            Identifier identifier = new Identifier(attribute.getName());
            ModelName name = new ModelName(model.getName());
            entity = this.isEvent(model) ? Entity.ofEvent((ModelName)name, (Identifier)identifier) : Entity.ofResource((ModelName)name, (Identifier)identifier);
            EntityType type = entity.getEntityType();
            model.copyTo((AbstractEntityModel)entity);
            entity.setEntityType(type);
            entity.removeAttribute((Attribute)attribute);
            entity.setNotImplement(false);
            return entity;
        }
        return model;
    }

    private boolean isEvent(AbstractEntityModel model) {
        String eventAttributeName = Entity.getDefaultEventAttributeName((String)model.getName());
        for (IAttribute a : model.getAttributes()) {
            if (!eventAttributeName.equals(a.getName())) continue;
            return true;
        }
        return false;
    }

    private Laputa createLaputa(Map<String, AbstractEntityModel> s, String entityName) {
        Laputa l = Laputa.of((ModelName)new ModelName(entityName));
        s.put(l.getName(), (AbstractEntityModel)l);
        return l;
    }

    public String[] getAvailableExtensions() {
        return EXTENSION;
    }
}

