/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor;

import java.util.List;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.ActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.SubsetType;
import org.tmdmaker.extension.GeneratorFactory;
import org.tmdmaker.extension.PluginExtensionPointFactory;
import org.tmdmaker.model.generate.Generator;
import org.tmdmaker.model.importer.FileImporter;
import org.tmdmaker.ui.Messages;

public class TMDContextMenuProvider
extends ContextMenuProvider {
    private ActionRegistry actionRegistry;
    private static Logger logger = LoggerFactory.getLogger(TMDContextMenuProvider.class);

    public ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public void setActionRegistry(ActionRegistry actionRegistry) {
        this.actionRegistry = actionRegistry;
    }

    public TMDContextMenuProvider(EditPartViewer viewer, ActionRegistry registry) {
        super(viewer);
        this.setActionRegistry(registry);
    }

    public void buildContextMenu(IMenuManager menu) {
        ActionRegistry registry = this.getActionRegistry();
        EditPartViewer viewer = this.getViewer();
        List list = viewer.getSelectedEditParts();
        if (list != null) {
            this.printDebugLog(list);
            if (list.size() > 1) {
                this.addMenuWhenManyModelSelected(menu, registry);
            } else if (list.size() == 1) {
                if (((EditPart)list.get(0)).getModel() instanceof AbstractEntityModel) {
                    this.addMenuWhenSingleEntityModelSelected(menu, registry);
                } else if (((EditPart)list.get(0)).getModel() instanceof SubsetType) {
                    menu.add(registry.getAction((Object)"_SUBSETTYPE"));
                } else {
                    menu.add(registry.getAction((Object)"_OPEN"));
                    menu.add(registry.getAction((Object)ActionFactory.DELETE.getId()));
                }
            } else {
                menu.add(registry.getAction((Object)"DatabaseSelectAction"));
                menu.add(registry.getAction((Object)"_VS"));
                menu.add((IContributionItem)new Separator("generate"));
                menu.add(registry.getAction((Object)"DiagramImageGenerateAction"));
                this.addGeneratorMenus(menu, registry);
                menu.add((IContributionItem)new Separator("importer"));
                PluginExtensionPointFactory fileImportFactory = new PluginExtensionPointFactory("tmdmaker.importers");
                for (FileImporter importer : fileImportFactory.getInstances()) {
                    menu.add(registry.getAction((Object)importer.getClass().getName()));
                }
            }
        }
    }

    private void addMenuWhenManyModelSelected(IMenuManager menu, ActionRegistry registry) {
        menu.add(registry.getAction((Object)"_VS"));
        menu.add((IContributionItem)new Separator("generate"));
        menu.add(registry.getAction((Object)"DiagramImageGenerateAction"));
        this.addGeneratorMenus(menu, registry);
    }

    private void addGeneratorMenus(IMenuManager menu, ActionRegistry registry) {
        for (Generator generator : GeneratorFactory.getGenerators()) {
            menu.add(registry.getAction((Object)generator.getClass().getName()));
        }
    }

    private void addMenuWhenSingleEntityModelSelected(IMenuManager menu, ActionRegistry registry) {
        menu.add(registry.getAction((Object)"_OPEN"));
        menu.add(registry.getAction((Object)ActionFactory.DELETE.getId()));
        menu.add(registry.getAction((Object)"_SUBSET"));
        MenuManager multivalueMenu = new MenuManager(Messages.Multivalue);
        multivalueMenu.add(registry.getAction((Object)"_MO"));
        multivalueMenu.add(registry.getAction((Object)"_MA"));
        multivalueMenu.add(registry.getAction((Object)"_MVA_SE_HIDE"));
        multivalueMenu.add(registry.getAction((Object)"_MVA_SE_SHOW"));
        menu.add((IContributionItem)multivalueMenu);
        MenuManager tmdashMenu = new MenuManager(Messages.VirtualConcept);
        tmdashMenu.add(registry.getAction((Object)"_VE"));
        tmdashMenu.add(registry.getAction((Object)"_VS"));
        menu.add((IContributionItem)tmdashMenu);
        menu.add((IContributionItem)new Separator("implement"));
        menu.add(registry.getAction((Object)"ImplementInfoEditAction"));
        menu.add(registry.getAction((Object)"CommonAtributeSettingAction"));
        menu.add((IContributionItem)new Separator("generate"));
        this.addGeneratorMenus(menu, registry);
    }

    private void printDebugLog(List<EditPart> list) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        for (EditPart e : list) {
            logger.debug("editpart:{}", (Object)e.getModel().getClass().getName());
        }
    }
}

