/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.gef3.editpolicies;

import java.util.List;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.swt.widgets.Shell;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Attribute;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.ui.dialogs.ModelEditDialog;
import org.tmdmaker.ui.dialogs.model.EditAttribute;
import org.tmdmaker.ui.editor.gef3.commands.AttributeEditCommand;
import org.tmdmaker.ui.editor.gef3.commands.ModelEditCommand;

public abstract class AbstractEntityModelEditPolicy<T extends AbstractEntityModel>
extends ComponentEditPolicy {
    public Command getCommand(Request request) {
        if ("open".equals(request.getType())) {
            ModelEditDialog<T> dialog = this.getDialog();
            if (dialog.open() != 0) {
                return null;
            }
            Command command = this.createEditCommand(dialog.getEditAttributeList(), (AbstractEntityModel)dialog.getEditedValue());
            return command;
        }
        return super.getCommand(request);
    }

    protected Command createEditCommand(List<EditAttribute> editAttributeList, AbstractEntityModel editedValue) {
        CompoundCommand ccommand = new CompoundCommand();
        this.addAttributeEditCommands(ccommand, this.getModel(), editAttributeList);
        ModelEditCommand command = new ModelEditCommand((AbstractEntityModel)this.getModel(), editedValue);
        ccommand.add((Command)command);
        return ccommand.unwrap();
    }

    protected void addAttributeEditCommands(CompoundCommand ccommand, T entity, List<EditAttribute> editAttributeList) {
        for (EditAttribute ea : editAttributeList) {
            IAttribute original = ea.getOriginalAttribute();
            if (!ea.isEdited() || ea.isAdded()) continue;
            Attribute editedValueAttribute = new Attribute();
            ea.copyTo((IAttribute)editedValueAttribute);
            AttributeEditCommand editCommand = new AttributeEditCommand(original, (IAttribute)editedValueAttribute, (AbstractEntityModel)entity);
            ccommand.add((Command)editCommand);
        }
    }

    protected T getModel() {
        return (T)((AbstractEntityModel)this.getHost().getModel());
    }

    protected abstract ModelEditDialog<T> getDialog();

    protected Shell getControllShell() {
        return this.getHost().getViewer().getControl().getShell();
    }

    protected Diagram getDiagram() {
        return (Diagram)this.getHost().getParent().getModel();
    }
}

