/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.views.properties.gef3;

import java.util.ArrayList;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.tmdmaker.core.model.DataTypeDeclaration;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.core.model.StandardSQLDataType;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.views.properties.gef3.AbstractPropertySource;
import org.tmdmaker.ui.views.properties.gef3.commands.PropertyChangeCommand;

public class IAttributePropertySource
extends AbstractPropertySource {
    protected static final String SCALE = "scale";
    protected static final String SIZE = "size";
    protected static final String DATA_TYPE_DECLARATION = "dataTypeDeclaration";
    protected static final String IMPLEMENT_NAME = "implementName";
    protected static final String NAME = "name";
    protected IAttribute attribute;

    public IAttributePropertySource(CommandStack commandStack, IAttribute attribute) {
        super(commandStack);
        this.attribute = attribute;
    }

    public Object getEditableValue() {
        return this.attribute;
    }

    private static String[] getDataTypeDeclarationLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("");
        StandardSQLDataType[] standardSQLDataTypeArray = StandardSQLDataType.values();
        int n = standardSQLDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardSQLDataType dt = standardSQLDataTypeArray[n2];
            labels.add(dt.getName());
            ++n2;
        }
        return labels.toArray(new String[labels.size()]);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<Object> propertyDescriptordList = new ArrayList<Object>();
        DataTypeDeclaration dtd = this.attribute.getDataTypeDeclaration();
        StandardSQLDataType dt = null;
        if (dtd != null) {
            dt = dtd.getLogicalType();
        }
        propertyDescriptordList.add(new TextPropertyDescriptor((Object)NAME, Messages.ModelName));
        propertyDescriptordList.add(new TextPropertyDescriptor((Object)IMPLEMENT_NAME, Messages.ImplementationName));
        ComboBoxPropertyDescriptor cbpd = new ComboBoxPropertyDescriptor((Object)DATA_TYPE_DECLARATION, Messages.DataType, IAttributePropertySource.getDataTypeDeclarationLabels());
        propertyDescriptordList.add(cbpd);
        if (dt != null && dt.isSupportSize()) {
            propertyDescriptordList.add(new TextPropertyDescriptor((Object)SIZE, Messages.Size));
        }
        if (dt != null && dt.isSupportScale()) {
            propertyDescriptordList.add(new TextPropertyDescriptor((Object)SCALE, Messages.Scale));
        }
        return propertyDescriptordList.toArray(new IPropertyDescriptor[propertyDescriptordList.size()]);
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(NAME)) {
            return this.canonicalize(this.attribute.getName());
        }
        if (id.equals(IMPLEMENT_NAME)) {
            return this.canonicalize(this.attribute.getImplementName());
        }
        DataTypeDeclaration dt = this.attribute.getDataTypeDeclaration();
        if (id.equals(DATA_TYPE_DECLARATION)) {
            if (dt == null) {
                return 0;
            }
            return StandardSQLDataType.getStandardSQLDataType((String)dt.getLogicalType().getName()).ordinal();
        }
        if (id.equals(SIZE)) {
            if (dt == null) {
                return "";
            }
            return dt.getSize() != null ? String.valueOf(dt.getSize()) : "";
        }
        if (id.equals(SCALE)) {
            if (dt == null) {
                return "";
            }
            return dt.getScale() != null ? String.valueOf(dt.getScale()) : "";
        }
        return null;
    }

    @Override
    protected Command createSetPropertyCommand(Object id, Object value) {
        DataTypeDeclaration oldDt;
        Object oldValue = null;
        Object newValue = value;
        String propertyName = (String)id;
        oldValue = this.getPropertyValue(this.attribute, propertyName);
        if (id.equals(DATA_TYPE_DECLARATION)) {
            propertyName = DATA_TYPE_DECLARATION;
            oldDt = this.attribute.getDataTypeDeclaration();
            StandardSQLDataType sdt = StandardSQLDataType.values()[(Integer)newValue];
            newValue = oldDt.newLogicalType(sdt);
        }
        if (id.equals(SIZE)) {
            propertyName = DATA_TYPE_DECLARATION;
            oldDt = this.attribute.getDataTypeDeclaration();
            oldValue = oldDt;
            newValue = oldDt.newSize(Integer.valueOf((String)newValue));
        }
        if (id.equals(SCALE)) {
            propertyName = DATA_TYPE_DECLARATION;
            oldDt = this.attribute.getDataTypeDeclaration();
            oldValue = oldDt;
            newValue = oldDt.newScale(Integer.valueOf((String)newValue));
        }
        return new PropertyChangeCommand(this.attribute, propertyName, oldValue, newValue);
    }
}

