/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.serializer.handler.patch;

import java.util.List;
import org.tmdmaker.core.model.AbstractConnectionModel;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.core.model.Entity2SubsetTypeRelationship;
import org.tmdmaker.core.model.RelatedRelationship;
import org.tmdmaker.serializer.handler.patch.AbstractSerializerHandler;
import org.tmdmaker.serializer.handler.patch.AnchorConstraintMigrator;

public class Patch023SerializerHandler
extends AbstractSerializerHandler {
    @Override
    public Diagram handleAfterDeserialize(Diagram in) {
        this.logger.info("handleAfterDeserialize");
        if (this.versionUnderEqual(in, 0, 2, 2)) {
            this.logger.info("apply patch 0.2.3");
            for (AbstractEntityModel model : in.query().listEntityModel()) {
                this.convert(model);
            }
        }
        return in;
    }

    private void convert(AbstractEntityModel model) {
        this.convertRelatedRelationships(model.getModelSourceConnections());
        this.convertRelatedRelationships(model.getModelTargetConnections());
    }

    private void convertRelatedRelationships(List<AbstractConnectionModel> connections) {
        AnchorConstraintMigrator converter = new AnchorConstraintMigrator();
        for (AbstractConnectionModel c : connections) {
            if (c instanceof RelatedRelationship) {
                this.logger.debug("convertRelatedRelationships():{}", (Object)c);
                converter.convertNullLocationPoint(c);
            }
            if (!(c instanceof Entity2SubsetTypeRelationship)) continue;
            this.logger.debug("convertEntity2SubsetTypeRelationships():{}", (Object)c);
            converter.convertNullLocationPoint(c);
        }
    }
}

