/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.actions.gef3;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IWorkbenchPart;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.core.model.SurrogateKey;
import org.tmdmaker.core.model.rule.ImplementRule;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.actions.gef3.AbstractEntitySelectionAction;
import org.tmdmaker.ui.dialogs.ImplementInfoEditDialog;
import org.tmdmaker.ui.dialogs.model.EditImplementAttribute;
import org.tmdmaker.ui.dialogs.model.EditSurrogateKey;
import org.tmdmaker.ui.editor.gef3.commands.AttributeEditCommand;
import org.tmdmaker.ui.editor.gef3.commands.ModelEditCommand;

public class ImplementInfoEditAction
extends AbstractEntitySelectionAction {
    public static final String ID = "ImplementInfoEditAction";

    public ImplementInfoEditAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.EditImplementInformation);
        this.setId(ID);
    }

    public void run() {
        ImplementInfoEditDialog dialog = new ImplementInfoEditDialog(this.getPart().getViewer().getControl().getShell(), this.getModel());
        if (dialog.open() == 0) {
            IAttribute original;
            CompoundCommand ccommand = new CompoundCommand();
            ccommand.add((Command)new ModelEditCommand(this.getModel(), dialog.getEditedValueEntity()));
            for (EditImplementAttribute ea : dialog.getEditedValueAttributes()) {
                original = ea.getOriginalAttribute();
                IAttribute newAttribute = original.getCopy();
                ea.copyTo(newAttribute);
                ccommand.add((Command)new AttributeEditCommand(original, newAttribute, ea.getContainerModel()));
            }
            SurrogateKey newSurrogateKey = new SurrogateKey();
            EditSurrogateKey edited = dialog.getEditedSurrogateKey();
            edited.copyTo((IAttribute)newSurrogateKey);
            ImplementRule.setSurrogateKeyDefaultValue((SurrogateKey)newSurrogateKey);
            original = (SurrogateKey)edited.getOriginalAttribute();
            ccommand.add((Command)new AttributeEditCommand(original, (IAttribute)newSurrogateKey, edited.getContainerModel()));
            this.execute((Command)ccommand);
        }
    }
}

