/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.gef3.editpolicies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmdmaker.core.model.AbstractConnectionModel;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.constraint.AnchorConstraint;
import org.tmdmaker.ui.editor.draw2d.anchors.XYChopboxAnchorHelper;
import org.tmdmaker.ui.editor.gef3.commands.SourceConnectionReconnectCommand;
import org.tmdmaker.ui.editor.gef3.commands.TargetConnectionReconnectCommand;
import org.tmdmaker.ui.editor.gef3.editparts.node.AbstractModelEditPart;
import org.tmdmaker.ui.editor.gef3.editpolicies.TMDModelGraphicalNodeEditPolicy;

public class ReconnectableNodeEditPolicy
extends GraphicalNodeEditPolicy {
    protected static Logger logger = LoggerFactory.getLogger(TMDModelGraphicalNodeEditPolicy.class);

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        AbstractConnectionModel connection = (AbstractConnectionModel)request.getConnectionEditPart().getModel();
        if (connection.getSource() == connection.getTarget()) {
            logger.debug("source == target");
            return null;
        }
        AbstractEntityModel newSource = (AbstractEntityModel)request.getTarget().getModel();
        if (!connection.getSource().equals(newSource)) {
            logger.debug("source not equals newSource");
            return null;
        }
        Point location = new Point(request.getLocation());
        AbstractModelEditPart sourceEditPart = (AbstractModelEditPart)request.getConnectionEditPart().getSource();
        IFigure sourceFigure = sourceEditPart.getFigure();
        sourceFigure.translateToRelative((Translatable)location);
        AnchorConstraint newAnchorConstraint = new XYChopboxAnchorHelper(sourceFigure.getBounds()).calculateAnchorConstraint(location);
        return new SourceConnectionReconnectCommand(connection, newAnchorConstraint);
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        AbstractConnectionModel connection = (AbstractConnectionModel)request.getConnectionEditPart().getModel();
        if (connection.getSource() == connection.getTarget()) {
            logger.debug("source == target");
            return null;
        }
        AbstractEntityModel newTarget = (AbstractEntityModel)request.getTarget().getModel();
        if (!connection.getTarget().equals(newTarget)) {
            logger.debug("target not equals newTarget");
            return null;
        }
        Point location = new Point(request.getLocation());
        AbstractModelEditPart targetEditPart = (AbstractModelEditPart)request.getConnectionEditPart().getTarget();
        IFigure targetFigure = targetEditPart.getFigure();
        targetFigure.translateToRelative((Translatable)location);
        AnchorConstraint newAnchorConstraint = new XYChopboxAnchorHelper(targetFigure.getBounds()).calculateAnchorConstraint(location);
        return new TargetConnectionReconnectCommand(connection, newAnchorConstraint);
    }

    protected AbstractEntityModel getAbstractEntityModel() {
        return (AbstractEntityModel)this.getHost().getModel();
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        return null;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        return null;
    }
}

