/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.views.properties.gef3;

import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPropertySource
implements IPropertySource {
    private CommandStack commandStack;
    protected Logger logger;

    public AbstractPropertySource(CommandStack commandStack) {
        this.commandStack = commandStack;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public void resetPropertyValue(Object paramObject) {
    }

    public void setPropertyValue(Object id, Object value) {
        Command command = this.createSetPropertyCommand(id, value);
        if (command != null) {
            this.getCommandStack().execute(command);
        }
    }

    protected abstract Command createSetPropertyCommand(Object var1, Object var2);

    public boolean isPropertySet(Object id) {
        IPropertyDescriptor[] iPropertyDescriptorArray = this.getPropertyDescriptors();
        int n = iPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
            if (descriptor.equals(id)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected String canonicalize(String property) {
        return property != null ? property : "";
    }

    protected CommandStack getCommandStack() {
        return this.commandStack;
    }

    protected Object getPropertyValue(Object model, String propertyName) {
        try {
            return BeanUtils.getProperty((Object)model, (String)propertyName);
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
            return "";
        }
    }
}

