/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.views.properties.gef3;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.tmdmaker.core.model.KeyModel;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.views.properties.gef3.AbstractPropertySource;
import org.tmdmaker.ui.views.properties.gef3.commands.PropertyChangeCommand;

public class KeyModelPropertySource
extends AbstractPropertySource {
    private static final String UNIQUE = "unique";
    private static final String MASTER_KEY = "masterKey";
    private static final String NAME = "name";
    private static final String[] BOOLEAN_LABELS = new String[]{Messages.Yes, Messages.No};
    private static final int BOOLEAN_YES_INDEX = 0;
    private static final int BOOLEAN_NO_INDEX = 1;
    private KeyModel keymodel;

    public KeyModelPropertySource(CommandStack commandStack, KeyModel keymodel) {
        super(commandStack);
        this.keymodel = keymodel;
    }

    public Object getEditableValue() {
        return this.keymodel;
    }

    protected IPropertyDescriptor[] buildPropertyDescriptors() {
        Object masterKeyPropertyDescriptor = null;
        masterKeyPropertyDescriptor = this.keymodel.isUnique() ? new ComboBoxPropertyDescriptor((Object)MASTER_KEY, Messages.MasterKey, BOOLEAN_LABELS) : new PropertyDescriptor((Object)MASTER_KEY, Messages.MasterKey);
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)NAME, Messages.ModelName), new ComboBoxPropertyDescriptor((Object)UNIQUE, Messages.UniqueConstraint, BOOLEAN_LABELS), masterKeyPropertyDescriptor};
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.buildPropertyDescriptors();
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(NAME)) {
            return this.canonicalize(this.keymodel.getName());
        }
        if (id.equals(UNIQUE)) {
            return this.keymodel.isUnique() ? 0 : 1;
        }
        if (id.equals(MASTER_KEY)) {
            if (this.keymodel.isUnique()) {
                return this.keymodel.isMasterKey() ? 0 : 1;
            }
            return this.keymodel.isMasterKey() ? Messages.Yes : Messages.No;
        }
        return null;
    }

    @Override
    protected Command createSetPropertyCommand(Object id, Object value) {
        String propertyName = id.toString();
        Object oldValue = this.getPropertyValue(this.keymodel, propertyName);
        if (propertyName.equals(UNIQUE)) {
            value = (Integer)value == 0;
        }
        if (propertyName.equals(MASTER_KEY) && this.keymodel.isUnique()) {
            value = (Integer)value == 0;
        }
        return new PropertyChangeCommand(this.keymodel, propertyName, oldValue, value);
    }
}

