/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.core.model.IdentifierRef;
import org.tmdmaker.core.model.TransfarReuseKeysToTargetRelationship;
import org.tmdmaker.core.model.VirtualEntity;
import org.tmdmaker.core.model.VirtualEntityType;

public class Entity2VirtualEntityRelationship
extends TransfarReuseKeysToTargetRelationship {
    private static Logger logger = LoggerFactory.getLogger(Entity2VirtualEntityRelationship.class);
    private VirtualEntity ve;

    public Entity2VirtualEntityRelationship(AbstractEntityModel source, String virtualEntityName, VirtualEntityType type) {
        this.setSource(source);
        this.ve = VirtualEntity.build(source, virtualEntityName, type);
        this.ve.setVirtualEntityType(type);
        this.setTarget(this.ve);
    }

    @Override
    public void connect() {
        Diagram diagram = this.getSource().getDiagram();
        if (diagram != null) {
            diagram.addChild(this.getTarget());
        }
        super.connect();
    }

    @Override
    public void disconnect() {
        super.disconnect();
        Diagram diagram = this.getSource().getDiagram();
        if (diagram != null) {
            diagram.removeChild(this.getTarget());
        }
    }

    @Override
    public boolean isDeletable() {
        return this.getTarget().isDeletable();
    }

    @Override
    public void identifierChanged() {
        logger.debug("VE\u306e\u751f\u6210\u5143\u306e\u500b\u4f53\u8b58\u5225\u5b50\u304c\u5909\u66f4\u306b\u306a\u3063\u305f\u305f\u3081\u518d\u8a2d\u5b9a\u3002");
        this.ve.setOriginalReusedIdentifier(this.getSource().createReusedIdentifier());
        for (IdentifierRef r : this.getSource().createReusedIdentifier().getIdentifiers()) {
            logger.debug(r.getName());
        }
    }

    public VirtualEntity getVirtualEntity() {
        return (VirtualEntity)this.getTarget();
    }
}

