/**
 * Title: UniCodePage
 * Copyright:   Copyright (c) 2001, 2002, 2003
 * Company:
 * @author  Kenneth J. Pouncey
 *          rewritten by LDC, WVL, Luc
 * @version 0.4
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j.encoding;

class UniCodeU60 {
	protected static final char[] cvtbl_u_60 = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbe7e, //0x0
		' ', ' ', 0xbe7f, ' ', ' ', 0xbe80, ' ', ' ', 
		' ', ' ', ' ', 0xbe81, 0xbe82, ' ', ' ', 0xbe83, //0x10
		0xbe84, ' ', 0xbe85, ' ', ' ', ' ', ' ', 0xbe86, 
		' ', ' ', ' ', ' ', 0xbe87, ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', 0xbe88, ' ', ' ', 
		' ', ' ', ' ', 0xbe89, ' ', 0xbe8a, ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xbe8b, ' ', ' ', ' ', ' ', ' ', ' ', 0xbe8c, //0x40
		0xbe8d, 0xbe8e, ' ', ' ', 0xbe8f, ' ', ' ', ' ', 
		' ', 0xbe90, ' ', ' ', 0xbe91, ' ', 0xbe92, 0xbe93, //0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xbe94, ' ', ' ', ' ', ' ', ' ', 0xbe95, //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xbe96, ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', 0xbe97, 0xbe98, 
		' ', ' ', 0xbe99, ' ', ' ', ' ', 0xbe9a, ' ', //0x80
		0xbe9b, ' ', ' ', ' ', ' ', ' ', 0xbe9c, ' ', 
		' ', 0xbe9d, ' ', 0xbe9e, ' ', 0xbe9f, ' ', ' ', //0x90
		0xbea0, ' ', ' ', ' ', ' ', 0xbea1, 0xbea2, ' ', 
		' ', ' ', 0xbea3, ' ', 0xbea4, 0xbea5, ' ', ' ', //0xa0
		0xbea6, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xbea7, 0xbea8, ' ', ' ', ' ', ' ', ' ', 0xbea9, //0xb0
		' ', ' ', ' ', 0xbeaa, ' ', ' ', 0xbeab, ' ', 
		' ', ' ', 0xbeac, ' ', 0xbead, ' ', ' ', ' ', //0xc0
		0xbeae, 0xbeaf, 0xbeb0, 0xbeb1, ' ', ' ', 0xbeb2, 0xbeb3, 
		' ', ' ', ' ', ' ', 0xbeb4, ' ', ' ', ' ', //0xd0
		' ', 0xbeb5, ' ', 0xbeb6, ' ', 0xbeb7, ' ', ' ', 
		' ', ' ', 0xbeb8, ' ', ' ', 0xbeb9, ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xbeba, ' ', ' ', //0xf0
		0xbebb, ' ', ' ', ' ', 0xbebc, 0xbebd, ' ', ' '
	};
	protected static final char[] cvtbl_u_61 = {
		' ', ' ', 0xbebe, ' ', ' ', ' ', ' ', 0xbebf, //0x0
		' ', ' ', 0xbec0, ' ', 0xbec1, ' ', ' ', ' ', 
		0xbec2, ' ', 0xbec3, 0xbec4, 0xbec5, ' ', 0xbec6, 0xbec7, //0x10
		' ', 0xbec8, ' ', ' ', 0xbec9, ' ', 0xbeca, ' ', 
		' ', ' ', 0xbecb, ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', 0xbecc, 0xbecd, ' ', ' ', ' ', ' ', 
		' ', 0xbece, ' ', ' ', ' ', 0xbecf, 0xbed0, ' ', //0x30
		' ', 0xbed1, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xbed2, ' ', ' ', ' ', 0xbed3, 0xbed4, ' ', //0x40
		' ', 0xbed5, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', 0xbed6, ' ', 
		0xbed7, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', 0xbed8, ' ', ' ', ' ', 
		' ', ' ', 0xbed9, ' ', ' ', ' ', ' ', ' ', //0x70
		0xbeda, ' ', ' ', 0xbedb, 0xbedc, ' ', ' ', 0xbedd, 
		0xbede, 0xbedf, ' ', 0xbee0, 0xbee1, ' ', ' ', ' ', //0x80
		' ', ' ', ' ', 0xbee2, ' ', 0xbee3, ' ', ' ', 
		' ', ' ', 0xbee4, 0xbee5, ' ', ' ', ' ', 0xbee6, //0x90
		' ', ' ', ' ', ' ', 0xbee7, 0xbee8, ' ', 0xbee9, 
		0xbeea, ' ', ' ', ' ', ' ', 0xbeeb, ' ', ' ', //0xa0
		0xbeec, ' ', 0xbeed, ' ', ' ', 0xbeee, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		0xbeef, 0xbef0, ' ', ' ', 0xbef1, ' ', ' ', ' ', 
		0xbef2, 0xbef3, 0xbef4, ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', 0xbef5, 0xbef6, 
		' ', ' ', ' ', ' ', ' ', 0xbef7, ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', 0xbef8, 0xbef9, 0xbefa, 0xbefb, 
		' ', 0xbefc, 0xbefd, ' ', ' ', 0xbefe, ' ', 0xbf41, //0xe0
		' ', 0xbf42, ' ', ' ', 0xbf43, 0xbf44, ' ', 0xbf45, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_62 = {
		' ', 0xbf46, ' ', 0xbf47, 0xbf48, ' ', ' ', 0xbf49, //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xbf4a, ' ', ' ', //0x10
		' ', ' ', ' ', ' ', 0xbf4b, ' ', ' ', ' ', 
		0xbf4c, ' ', 0xbf4d, 0xbf4e, ' ', ' ', ' ', 0xbf4f, //0x20
		' ', 0xbf50, ' ', 0xbf51, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x30
		' ', 0xbf52, ' ', ' ', ' ', 0xbf53, ' ', ' ', 
		' ', ' ', 0xbf54, 0xbf55, 0xbf56, ' ', 0xbf57, ' ', //0x40
		' ', ' ', ' ', ' ', 0xbf58, ' ', ' ', ' ', 
		0xbf59, 0xbf5a, 0xbf5b, ' ', 0xbf5c, ' ', 0xbf5d, ' ', //0x50
		' ', ' ', 0xbf5e, ' ', 0xbf5f, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xbf60, ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', 0xbf61, ' ', 0xbf62, 
		' ', ' ', ' ', 0xbf63, ' ', ' ', ' ', ' ', //0x70
		' ', ' ', 0xbf64, ' ', ' ', 0xbf65, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', 0xbf66, 0xbf67, 0xbf68, 
		0xbf69, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		0xbf6a, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xbf6b, ' ', ' ', 0xbf6c, 0xbf6d, //0xb0
		' ', ' ', 0xbf6e, ' ', ' ', ' ', 0xbf6f, 0xbf70, 
		' ', ' ', ' ', ' ', 0xbf71, ' ', ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', 0xbf72, ' ', 
		' ', ' ', ' ', ' ', ' ', 0xbf73, 0xbf74, ' ', //0xd0
		' ', ' ', 0xbf75, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', 0xbf76, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xbf77, ' ', 0xbf78, ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', 0xbf79, 0xbf7a, ' ', ' '
	};
	protected static final char[] cvtbl_u_63 = {
		' ', ' ', ' ', 0xbf7b, 0xbf7c, ' ', ' ', ' ', //0x0
		' ', ' ', 0xbf7d, 0xbf7e, ' ', 0xbf7f, ' ', ' ', 
		0xbf80, ' ', ' ', 0xbf81, ' ', ' ', 0xbf82, ' ', //0x10
		0xbf83, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', 0xbf84, 0xbf85, ' ', ' ', 0xbf86, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xbf87, 0xbf88, ' ', //0x30
		' ', 0xbf89, ' ', ' ', 0xbf8a, ' ', ' ', ' ', 
		' ', 0xbf8b, 0xbf8c, 0xbf8d, 0xbf8e, ' ', 0xbf8f, ' ', //0x40
		' ', ' ', 0xbf90, 0xbf91, ' ', ' ', 0xbf92, ' ', 
		' ', ' ', 0xbf93, 0xbf94, 0xbf95, ' ', ' ', ' ', //0x50
		0xbf96, ' ', ' ', 0xbf97, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xbf98, 0xbf99, ' ', //0x60
		' ', ' ', ' ', ' ', 0xbf9a, 0xbf9b, ' ', ' ', 
		' ', 0xbf9c, ' ', ' ', 0xbf9d, 0xbf9e, ' ', ' ', //0x70
		0xbf9f, ' ', ' ', ' ', 0xbfa0, 0xbfa1, ' ', 0xbfa2, 
		' ', ' ', 0xbfa3, ' ', 0xbfa4, ' ', ' ', 0xbfa5, //0x80
		' ', ' ', 0xbfa6, ' ', ' ', ' ', ' ', ' ', 
		0xbfa7, ' ', ' ', ' ', 0xbfa8, 0xbfa9, ' ', ' ', //0x90
		' ', 0xbfaa, 0xbfab, ' ', ' ', ' ', 0xbfac, ' ', 
		' ', ' ', ' ', ' ', 0xbfad, ' ', 0xbfae, ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', 0xbfaf, 0xbfb0, 0xbfb1, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', 0xbfb2, ' ', ' ', 
		' ', 0xbfb3, ' ', ' ', ' ', 0xbfb4, ' ', ' ', //0xc0
		0xbfb5, ' ', ' ', ' ', ' ', ' ', 0xbfb6, ' ', 
		' ', 0xbfb7, ' ', 0xbfb8, 0xbfb9, 0xbfba, ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', 0xbfbb, ' ', ' ', ' ', 
		0xbfbc, ' ', ' ', ' ', ' ', 0xbfbd, ' ', ' ', //0xe0
		' ', ' ', 0xbfbe, ' ', 0xbfbf, ' ', ' ', ' ', 
		' ', ' ', 0xbfc0, 0xbfc1, ' ', ' ', ' ', ' ', //0xf0
		0xbfc2, 0xbfc3, ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_64 = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x0
		' ', 0xbfc4, 0xbfc5, ' ', ' ', ' ', ' ', ' ', 
		0xbfc6, ' ', 0xbfc7, ' ', 0xbfc8, ' ', ' ', ' ', //0x10
		0xbfc9, ' ', ' ', ' ', ' ', ' ', 0xbfca, ' ', 
		0xbfcb, ' ', 0xbfcc, ' ', 0xbfcd, 0xbfce, ' ', ' ', //0x20
		' ', 0xbfcf, 0xbfd0, ' ', ' ', ' ', ' ', 0xbfd1, 
		0xbfd2, ' ', ' ', ' ', ' ', 0xbfd3, ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', 0xbfd4, ' ', 0xbfd5, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', ' ', 0xbfd6, ' ', ' ', ' ', 0xbfd7, 
		' ', 0xbfd8, 0xbfd9, 0xbfda, 0xbfdb, ' ', ' ', ' ', //0x50
		' ', ' ', 0xbfdc, 0xbfdd, 0xbfde, 0xbfdf, ' ', 0xbfe0, 
		' ', 0xbfe1, ' ', 0xbfe2, ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', 0xbfe3, ' ', ' ', 
		' ', ' ', ' ', 0xbfe4, 0xbfe5, ' ', ' ', ' ', //0x70
		' ', ' ', ' ', 0xbfe6, ' ', 0xbfe7, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xbfe8, ' ', 0xbfe9, //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbfea, 
		0xbfeb, 0xbfec, ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		0xbfed, 0xbfee, ' ', 0xbfef, ' ', ' ', ' ', 0xbff0, 
		' ', 0xbff1, ' ', 0xbff2, ' ', ' ', 0xbff3, ' ', //0xa0
		0xbff4, ' ', ' ', ' ', 0xbff5, ' ', ' ', ' ', 
		' ', ' ', ' ', 0xbff6, ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', 0xbff7, 0xbff8, 0xbff9, 
		' ', ' ', ' ', ' ', 0xbffa, ' ', ' ', ' ', //0xc0
		' ', 0xbffb, 0xbffc, 0xbffd, 0xbffe, ' ', ' ', ' ', 
		0xc041, 0xc042, ' ', ' ', ' ', 0xc043, ' ', 0xc044, //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc045, 0xc046, ' ', ' ', //0xe0
		' ', 0xc047, 0xc048, ' ', ' ', 0xc049, ' ', ' ', 
		0xc04a, ' ', ' ', ' ', ' ', 0xc04b, ' ', 0xc04c, //0xf0
		' ', ' ', ' ', 0xc04d, ' ', ' ', ' ', 0xc04e
	};
	protected static final char[] cvtbl_u_65 = {
		' ', 0xc04f, ' ', ' ', 0xc050, ' ', ' ', ' ', //0x0
		0xc051, 0xc052, 0xc053, ' ', ' ', ' ', ' ', 0xc054, 
		' ', ' ', ' ', 0xc055, 0xc056, ' ', 0xc057, ' ', //0x10
		' ', 0xc058, ' ', 0xc059, ' ', ' ', 0xc05a, 0xc05b, 
		' ', ' ', 0xc05c, ' ', ' ', ' ', 0xc05d, ' ', //0x20
		' ', 0xc05e, ' ', ' ', ' ', ' ', 0xc05f, ' ', 
		' ', 0xc060, ' ', ' ', ' ', ' ', ' ', ' ', //0x30
		' ', ' ', 0xc061, ' ', 0xc062, 0xc063, ' ', ' ', 
		' ', ' ', ' ', 0xc064, ' ', ' ', ' ', 0xc065, //0x40
		' ', 0xc066, ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc067, ' ', 0xc068, ' ', 0xc069, ' ', ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc06a, 
		0xc06b, ' ', ' ', ' ', ' ', ' ', ' ', 0xc06c, //0x60
		' ', ' ', ' ', 0xc06d, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', 0xc06e, ' ', ' ', 0xc06f, ' ', ' ', 
		' ', 0xc070, ' ', ' ', ' ', 0xc071, ' ', ' ', //0x80
		' ', ' ', 0xc072, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xc073, ' ', ' ', 0xc074, ' ', ' ', //0x90
		0xc075, ' ', ' ', ' ', ' ', 0xc076, ' ', ' ', 
		0xc077, ' ', ' ', 0xc078, ' ', ' ', 0xc079, ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', 0xc07a, ' ', 
		' ', ' ', 0xc07b, 0xc07c, 0xc07d, ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc07e, 
		' ', ' ', 0xc07f, ' ', ' ', ' ', ' ', ' ', //0xc0
		0xc080, 0xc081, ' ', ' ', ' ', ' ', 0xc082, ' ', 
		0xc083, ' ', ' ', ' ', 0xc084, ' ', 0xc085, ' ', //0xd0
		0xc086, ' ', ' ', ' ', ' ', ' ', ' ', 0xc087, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc088, ' ', 0xc089, ' ', 0xc08a, 0xc08b, ' ', ' ', //0xf0
		' ', 0xc08c, ' ', ' ', ' ', ' ', 0xc08d, 0xc08e
	};
	protected static final char[] cvtbl_u_66 = {
		' ', ' ', ' ', ' ', 0xc08f, ' ', ' ', ' ', //0x0
		0xc090, ' ', ' ', ' ', ' ', 0xc091, ' ', ' ', 
		' ', 0xc092, 0xc093, ' ', ' ', ' ', 0xc094, ' ', //0x10
		' ', ' ', ' ', ' ', ' ', 0xc095, ' ', ' ', 
		' ', 0xc096, 0xc097, 0xc098, ' ', ' ', 0xc099, ' ', //0x20
		' ', 0xc09a, 0xc09b, 0xc09c, 0xc09d, ' ', ' ', ' ', 
		0xc09e, ' ', ' ', 0xc09f, ' ', ' ', ' ', 0xc0a0, //0x30
		' ', 0xc0a1, ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc0a2, ' ', ' ', ' ', ' ', 0xc0a3, 0xc0a4, ' ', //0x40
		' ', ' ', 0xc0a5, ' ', 0xc0a6, ' ', 0xc0a7, ' ', 
		' ', 0xc0a8, ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		0xc0a9, ' ', ' ', 0xc0aa, 0xc0ab, ' ', ' ', ' ', 
		0xc0ac, 0xc0ad, ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		' ', ' ', 0xc0ae, 0xc0af, 0xc0b0, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc0b1, ' ', 0xc0b2, //0x70
		0xc0b3, 0xc0b4, ' ', 0xc0b5, 0xc0b6, ' ', 0xc0b7, 0xc0b8, 
		0xc0b9, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', 0xc0ba, 0xc0bb, 0xc0bc, ' ', ' ', 
		0xc0bd, ' ', 0xc0be, ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', 0xc0bf, 0xc0c0, 0xc0c1, ' ', ' ', 0xc0c2, 
		' ', ' ', ' ', ' ', 0xc0c3, ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', 0xc0c4, ' ', ' ', 
		' ', 0xc0c5, ' ', ' ', ' ', 0xc0c6, ' ', ' ', //0xb0
		' ', ' ', ' ', 0xc0c7, ' ', ' ', ' ', ' ', 
		0xc0c8, ' ', 0xc0c9, 0xc0ca, ' ', ' ', ' ', ' ', //0xc0
		0xc0cb, ' ', ' ', ' ', 0xc0cc, ' ', 0xc0cd, 0xc0ce, 
		' ', ' ', ' ', ' ', 0xc0cf, ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', 0xc0d0, ' ', ' ', ' ', 0xc0d1, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		0xc0d2, ' ', ' ', 0xc0d3, 0xc0d4, ' ', 0xc0d5, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_67 = {
		' ', ' ', ' ', ' ', ' ', 0xc0d6, ' ', 0xc0d7, //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xc0d8, ' ', ' ', ' ', ' ', //0x10
		' ', 0xc0d9, ' ', ' ', 0xc0da, ' ', ' ', ' ', 
		0xc0db, ' ', 0xc0dc, ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xc0dd, ' ', ' ', ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', 0xc0de, ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc0df, ' ', 0xc0e0, //0x40
		0xc0e1, ' ', ' ', ' ', 0xc0e2, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc0e3, 0xc0e4, ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', 0xc0e5, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', 0xc0e6, ' ', 0xc0e7, ' ', 
		' ', ' ', ' ', ' ', 0xc0e8, ' ', 0xc0e9, ' ', //0x70
		' ', ' ', ' ', 0xc0ea, ' ', ' ', ' ', ' ', 
		' ', 0xc0eb, ' ', ' ', 0xc0ec, ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', 0xc0ed, 0xc0ee, 
		' ', 0xc0ef, ' ', 0xc0f0, ' ', ' ', 0xc0f1, ' ', //0x90
		0xc0f2, 0xc0f3, ' ', 0xc0f4, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc0f5, 0xc0f6, 0xc0f7, ' ', ' ', 0xc0f8, ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', 0xc0f9, 0xc0fa, ' ', ' ', 
		' ', ' ', 0xc0fb, 0xc0fc, ' ', 0xc0fd, ' ', ' ', //0xc0
		0xc0fe, 0xc141, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xc142, ' ', ' ', ' ', ' ', 0xc143, //0xd0
		' ', 0xc144, ' ', ' ', 0xc145, ' ', ' ', ' ', 
		' ', 0xc146, ' ', ' ', ' ', ' ', 0xc147, ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc148, ' ', 0xc149, ' ', ' ', ' ', 0xc14a, 0xc14b, //0xf0
		' ', 0xc14c, ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_68 = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc14d, ' ', ' ', ' ', //0x10
		' ', 0xc14e, ' ', ' ', ' ', 0xc14f, ' ', 0xc150, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc151, //0x20
		0xc152, ' ', ' ', ' ', 0xc153, 0xc154, ' ', 0xc155, 
		0xc156, 0xc157, ' ', 0xc158, ' ', ' ', ' ', ' ', //0x30
		' ', ' ', ' ', 0xc159, ' ', ' ', ' ', 0xc15a, 
		' ', ' ', ' ', ' ', ' ', 0xc15b, ' ', ' ', //0x40
		' ', ' ', 0xc15c, ' ', 0xc15d, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc15e, ' ', 0xc15f, //0x50
		0xc160, ' ', ' ', 0xc161, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', 0xc162, ' ', ' ', 0xc163, 0xc164, 
		0xc165, 0xc166, 0xc167, ' ', ' ', 0xc168, ' ', ' ', //0x70
		' ', 0xc169, 0xc16a, 0xc16b, 0xc16c, ' ', ' ', ' ', 
		' ', ' ', 0xc16d, ' ', 0xc16e, ' ', 0xc16f, ' ', //0x80
		0xc170, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc171, ' ', //0x90
		0xc172, ' ', 0xc173, ' ', 0xc174, ' ', ' ', ' ', 
		' ', 0xc175, ' ', 0xc176, ' ', 0xc177, ' ', ' ', //0xa0
		' ', 0xc178, 0xc179, ' ', ' ', ' ', 0xc17a, ' ', 
		' ', ' ', 0xc17b, ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', 0xc17c, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc17d, ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', 0xc17e, ' ', ' ', ' ', 
		0xc17f, 0xc180, ' ', 0xc181, ' ', ' ', 0xc182, ' ', //0xd0
		' ', 0xc183, ' ', ' ', 0xc184, 0xc185, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc186, ' ', ' ', //0xe0
		0xc187, ' ', 0xc188, 0xc189, 0xc18a, 0xc18b, ' ', ' ', 
		0xc18c, 0xc18d, ' ', ' ', ' ', 0xc18e, 0xc18f, ' ', //0xf0
		' ', ' ', ' ', 0xc190, 0xc191, 0xc192, ' ', ' '
	};
	protected static final char[] cvtbl_u_69 = {
		' ', ' ', ' ', ' ', ' ', ' ', 0xc193, ' ', //0x0
		' ', 0xc194, 0xc195, ' ', ' ', ' ', ' ', ' ', 
		0xc196, 0xc197, ' ', 0xc198, ' ', ' ', 0xc199, 0xc19a, //0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc19b, ' ', 0xc19c, ' ', 0xc19d, ' ', ' ', //0x30
		0xc19e, ' ', ' ', 0xc19f, ' ', ' ', ' ', ' ', 
		' ', ' ', 0xc1a0, ' ', ' ', 0xc1a1, ' ', ' ', //0x40
		' ', 0xc1a2, ' ', ' ', ' ', ' ', 0xc1a3, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc1a4, //0x50
		' ', ' ', ' ', 0xc1a5, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xc1a6, 0xc1a7, 0xc1a8, 0xc1a9, ' ', //0x60
		' ', 0xc1aa, ' ', ' ', 0xc1ab, ' ', ' ', ' ', 
		0xc1ac, 0xc1ad, 0xc1ae, ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', 0xc1af, 0xc1b0, ' ', ' ', ' ', 0xc1b1, 
		0xc1b2, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', 0xc1b3, ' ', ' ', 
		' ', ' ', 0xc1b4, ' ', ' ', ' ', 0xc1b5, ' ', //0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc1b6, ' ', ' ', ' ', 0xc1b7, 0xc1b8, ' ', //0xa0
		0xc1b9, ' ', ' ', 0xc1ba, ' ', 0xc1bb, ' ', 0xc1bc, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc1bd, //0xb0
		0xc1be, ' ', 0xc1bf, ' ', 0xc1c0, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc1c1, ' ', ' ', //0xc0
		0xc1c2, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc1c3, ' ', ' ', ' ', ' ', 0xc1c4, 0xc1c5, //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc1c6, ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', 0xc1c7, 0xc1c8, 
		' ', 0xc1c9, ' ', 0xc1ca, ' ', 0xc1cb, ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', 0xc1cc, ' '
	};
	protected static final char[] cvtbl_u_6a = {
		0xc1cd, 0xc1ce, ' ', 0xc1cf, ' ', ' ', ' ', ' ', //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc1d0, 
		' ', 0xc1d1, ' ', ' ', ' ', 0xc1d2, ' ', ' ', //0x10
		' ', ' ', 0xc1d3, ' ', ' ', 0xc1d4, ' ', ' ', 
		0xc1d5, ' ', ' ', ' ', 0xc1d6, ' ', ' ', ' ', //0x20
		0xc1d7, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xc1d8, ' ', 0xc1d9, ' ', ' ', 0xc1da, //0x30
		' ', ' ', ' ', 0xc1db, ' ', ' ', 0xc1dc, 0xc1dd, 
		' ', ' ', ' ', ' ', ' ', 0xc1de, ' ', ' ', //0x40
		' ', 0xc1df, 0xc1e0, ' ', ' ', ' ', 0xc1e1, ' ', 
		0xc1e2, 0xc1e3, 0xc1e4, ' ', ' ', 0xc1e5, 0xc1e6, ' ', //0x50
		' ', ' ', ' ', 0xc1e7, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc1e8, ' ', ' ', 0xc1e9, //0x60
		' ', ' ', 0xc1ea, ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc1eb, ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc1ec, ' ', 0xc1ed, ' ', ' ', 0xc1ee, 0xc1ef, //0x80
		' ', 0xc1f0, ' ', 0xc1f1, ' ', ' ', ' ', ' ', 
		' ', 0xc1f2, ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', ' ', 0xc1f3, ' ', 0xc1f4, 0xc1f5, 0xc1f6, 
		' ', ' ', ' ', ' ', ' ', 0xc1f7, ' ', ' ', //0xa0
		' ', ' ', ' ', 0xc1f8, ' ', ' ', ' ', 0xc1f9, 
		0xc1fa, 0xc1fb, ' ', ' ', 0xc1fc, ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', 0xc1fd, 0xc1fe, 0xc241, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc242, ' ', //0xc0
		0xc243, 0xc244, ' ', ' ', 0xc245, ' ', ' ', ' ', 
		0xc246, ' ', ' ', ' ', 0xc247, 0xc248, 0xc249, ' ', //0xd0
		' ', ' ', ' ', ' ', 0xc24a, 0xc24b, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc24c, //0xe0
		' ', ' ', ' ', ' ', 0xc24d, ' ', ' ', ' ', 
		0xc24e, 0xc24f, 0xc250, ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', 0xc251, 0xc252, ' ', ' '
	};
	protected static final char[] cvtbl_u_6b = {
		' ', ' ', 0xc253, 0xc254, ' ', ' ', 0xc255, 0xc256, //0x0
		' ', 0xc257, ' ', ' ', ' ', ' ', ' ', 0xc258, 
		0xc259, 0xc25a, ' ', ' ', ' ', ' ', ' ', 0xc25b, //0x10
		' ', ' ', ' ', 0xc25c, ' ', ' ', 0xc25d, ' ', 
		' ', ' ', ' ', ' ', 0xc25e, ' ', ' ', ' ', //0x20
		0xc25f, ' ', ' ', 0xc260, 0xc261, ' ', ' ', 0xc262, 
		' ', ' ', ' ', ' ', ' ', 0xc263, 0xc264, ' ', //0x30
		' ', ' ', ' ', 0xc265, ' ', ' ', ' ', 0xc266, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc267, ' ', //0x40
		' ', ' ', 0xc268, ' ', ' ', 0xc269, ' ', ' ', 
		' ', ' ', 0xc26a, ' ', ' ', ' ', 0xc26b, ' ', //0x50
		0xc26c, ' ', ' ', ' ', ' ', 0xc26d, ' ', ' ', 
		0xc26e, ' ', ' ', ' ', ' ', ' ', ' ', 0xc26f, //0x60
		' ', ' ', ' ', 0xc270, ' ', ' ', 0xc271, ' ', 
		0xc272, ' ', ' ', ' ', ' ', 0xc273, ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', 0xc274, 0xc275, ' ', 
		' ', ' ', 0xc276, ' ', ' ', 0xc277, ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc278, //0x90
		' ', ' ', ' ', 0xc279, ' ', ' ', ' ', 0xc27a, 
		0xc27b, ' ', 0xc27c, 0xc27d, ' ', ' ', ' ', ' ', //0xa0
		0xc27e, 0xc27f, ' ', ' ', 0xc280, 0xc281, 0xc282, ' ', 
		0xc283, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		0xc284, 0xc285, ' ', ' ', ' ', 0xc286, 0xc287, ' ', 
		' ', ' ', ' ', 0xc288, 0xc289, ' ', ' ', ' ', //0xc0
		' ', 0xc28a, ' ', ' ', 0xc28b, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', 0xc28c, ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc28d, ' ', 0xc28e, ' ', ' ', 0xc28f, 0xc290, //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', 0xc291, ' ', 
		' ', 0xc292, ' ', ' ', ' ', ' ', ' ', 0xc293, //0xf0
		' ', 0xc294, ' ', ' ', ' ', ' ', ' ', 0xc295
	};
	protected static final char[] cvtbl_u_6c = {
		' ', ' ', 0xc296, ' ', 0xc297, 0xc298, ' ', ' ', //0x0
		' ', 0xc299, ' ', ' ', ' ', 0xc29a, 0xc29b, ' ', 
		0xc29c, ' ', 0xc29d, ' ', ' ', ' ', ' ', ' ', //0x10
		' ', 0xc29e, ' ', ' ', ' ', ' ', ' ', 0xc29f, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc2a0, 0xc2a1, //0x20
		0xc2a2, ' ', ' ', ' ', 0xc2a3, ' ', 0xc2a4, ' ', 
		' ', ' ', ' ', 0xc2a5, ' ', 0xc2a6, 0xc2a7, ' ', //0x30
		' ', ' ', 0xc2a8, 0xc2a9, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', 0xc2aa, 0xc2ab, ' ', 0xc2ac, ' ', 0xc2ad, 
		' ', ' ', 0xc2ae, ' ', 0xc2af, ' ', ' ', ' ', //0x50
		' ', 0xc2b0, ' ', 0xc2b1, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc2b2, //0x60
		' ', ' ', ' ', 0xc2b3, ' ', 0xc2b4, ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc2b5, ' ', 0xc2b6, ' ', //0x70
		0xc2b7, 0xc2b8, ' ', 0xc2b9, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc2ba, ' ', 0xc2bb, //0x80
		' ', 0xc2bc, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc2bd, 0xc2be, ' ', 0xc2bf, //0x90
		0xc2c0, ' ', ' ', ' ', 0xc2c1, ' ', ' ', 0xc2c2, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc2c3, ' ', 0xc2c4, ' ', 0xc2c5, ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xc2c6, ' ', ' ', ' ', 0xc2c7, ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', 0xc2c8, ' ', 0xc2c9, 
		0xc2ca, 0xc2cb, 0xc2cc, ' ', 0xc2cd, ' ', 0xc2ce, ' ', //0xd0
		' ', ' ', ' ', ' ', 0xc2cf, ' ', ' ', ' ', 
		0xc2d0, ' ', ' ', ' ', ' ', ' ', ' ', 0xc2d1, //0xe0
		' ', 0xc2d2, ' ', 0xc2d3, 0xc2d4, ' ', 0xc2d5, ' ', 
		' ', ' ', 0xc2d6, ' ', 0xc2d7, ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_6d = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc2d8, //0x0
		' ', ' ', 0xc2d9, ' ', ' ', ' ', 0xc2da, 0xc2db, 
		' ', 0xc2dc, ' ', 0xc2dd, ' ', ' ', ' ', ' ', //0x10
		' ', ' ', 0xc2de, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc2df, 0xc2e0, //0x20
		0xc2e1, ' ', ' ', ' ', ' ', ' ', 0xc2e2, 0xc2e3, 
		' ', 0xc2e4, ' ', ' ', ' ', ' ', ' ', ' ', //0x30
		' ', 0xc2e5, ' ', ' ', 0xc2e6, ' ', ' ', 0xc2e7, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc2e8, //0x50
		' ', ' ', ' ', ' ', ' ', ' ', 0xc2e9, 0xc2ea, 
		' ', 0xc2eb, ' ', ' ', ' ', 0xc2ec, ' ', 0xc2ed, //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc2ee, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', 0xc2ef, ' ', ' ', ' ', 
		' ', ' ', 0xc2f0, ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc2f1, 0xc2f2, ' ', 0xc2f3, ' ', ' ', 0xc2f4, //0x90
		0xc2f5, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', 0xc2f6, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc2f7, ' ', ' ', 0xc2f8, //0xb0
		' ', 0xc2f9, ' ', ' ', ' ', 0xc2fa, ' ', 0xc2fb, 
		' ', ' ', ' ', ' ', 0xc2fc, ' ', ' ', ' ', //0xc0
		0xc2fd, ' ', 0xc2fe, ' ', ' ', ' ', 0xc341, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc342, ' ', //0xd0
		' ', ' ', ' ', 0xc343, ' ', 0xc344, ' ', 0xc345, 
		0xc346, ' ', 0xc347, ' ', ' ', 0xc348, ' ', ' ', //0xe0
		' ', 0xc349, ' ', ' ', ' ', ' ', ' ', 0xc34a, 
		0xc34b, ' ', ' ', ' ', 0xc34c, ' ', 0xc34d, ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_6e = {
		0xc34e, ' ', ' ', ' ', 0xc34f, ' ', ' ', ' ', //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', ' ', ' ', ' ', ' ', 0xc350, ' ', 
		' ', ' ', 0xc351, ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xc352, ' ', ' ', ' ', 0xc353, ' ', //0x30
		' ', ' ', ' ', 0xc354, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc355, 0xc356, ' ', ' ', //0x40
		0xc357, 0xc358, ' ', 0xc359, ' ', ' ', ' ', 0xc35a, 
		' ', 0xc35b, 0xc35c, 0xc35d, 0xc35e, ' ', ' ', 0xc35f, //0x50
		' ', ' ', ' ', ' ', ' ', 0xc360, 0xc361, ' ', 
		' ', ' ', 0xc362, 0xc363, ' ', ' ', ' ', ' ', //0x60
		0xc364, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xc365, ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', 0xc366, ' ', 0xc367, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', 0xc368, ' ', ' ', 
		' ', ' ', ' ', 0xc369, ' ', ' ', ' ', ' ', //0x90
		' ', 0xc36a, ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc36b, ' ', ' ', ' ', ' ', ' ', ' ', 0xc36c, //0xa0
		' ', ' ', ' ', ' ', ' ', 0xc36d, 0xc36e, ' ', 
		' ', 0xc36f, ' ', 0xc370, ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', 0xc371, ' ', ' ', ' ', ' ', 
		0xc372, 0xc373, ' ', 0xc374, ' ', ' ', ' ', 0xc375, //0xc0
		0xc376, ' ', 0xc377, ' ', ' ', 0xc378, 0xc379, 0xc37a, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', 0xc37b, ' ', 0xc37c, 0xc37d, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', 0xc37e, ' ', 0xc37f, ' ', 0xc380, ' ', ' '
	};
	protected static final char[] cvtbl_u_6f = {
		' ', ' ', ' ', ' ', 0xc381, ' ', ' ', ' ', //0x0
		0xc382, ' ', 0xc383, ' ', 0xc384, 0xc385, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc386, ' ', //0x10
		0xc387, ' ', 0xc388, 0xc389, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc38a, ' ', //0x20
		' ', 0xc38b, 0xc38c, ' ', ' ', 0xc38d, ' ', 0xc38e, 
		0xc38f, ' ', ' ', 0xc390, ' ', ' ', 0xc391, ' ', //0x30
		' ', ' ', ' ', 0xc392, 0xc393, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc394, 
		' ', 0xc395, 0xc396, 0xc397, ' ', ' ', ' ', 0xc398, //0x50
		' ', 0xc399, 0xc39a, ' ', ' ', 0xc39b, 0xc39c, ' ', 
		' ', 0xc39d, 0xc39e, ' ', ' ', ' ', ' ', ' ', //0x60
		0xc39f, ' ', ' ', ' ', 0xc3a0, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', 0xc3a1, 0xc3a2, ' ', 
		' ', ' ', ' ', 0xc3a3, ' ', ' ', ' ', 0xc3a4, //0x80
		' ', ' ', ' ', 0xc3a5, 0xc3a6, 0xc3a7, ' ', ' ', 
		0xc3a8, ' ', 0xc3a9, 0xc3aa, 0xc3ab, ' ', 0xc3ac, ' ', //0x90
		' ', ' ', 0xc3ad, ' ', ' ', ' ', ' ', 0xc3ae, 
		0xc3af, ' ', ' ', ' ', ' ', 0xc3b0, 0xc3b1, 0xc3b2, //0xa0
		0xc3b3, ' ', ' ', ' ', ' ', ' ', 0xc3b4, 0xc3b5, 
		0xc3b6, ' ', ' ', ' ', ' ', ' ', 0xc3b7, ' ', //0xb0
		' ', ' ', ' ', ' ', 0xc3b8, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc3b9, ' ', 0xc3ba, //0xc0
		0xc3bb, ' ', 0xc3bc, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', 0xc3bd, ' ', ' ', ' ', 0xc3be, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		0xc3bf, 0xc3c0, ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc3c1, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', 0xc3c2, ' ', ' ', 0xc3c3, 0xc3c4, ' ', ' '
	};
	protected static final char[] cvtbl_u_70 = {
		0xc3c5, ' ', ' ', ' ', ' ', ' ', 0xc3c6, ' ', //0x0
		' ', ' ', ' ', ' ', ' ', 0xc3c7, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc3c8, //0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc3c9, ' ', ' ', 0xc3ca, ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc3cb, 
		' ', ' ', ' ', ' ', 0xc3cc, ' ', ' ', 0xc3cd, //0x30
		' ', 0xc3ce, ' ', ' ', 0xc3cf, ' ', ' ', ' ', 
		' ', ' ', ' ', 0xc3d0, 0xc3d1, ' ', ' ', ' ', //0x40
		0xc3d2, 0xc3d3, 0xc3d4, 0xc3d5, ' ', ' ', 0xc3d6, ' ', 
		' ', ' ', ' ', ' ', 0xc3d7, 0xc3d8, ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', 0xc3d9, 0xc3da, ' ', 
		' ', ' ', ' ', ' ', 0xc3db, 0xc3dc, ' ', ' ', //0x60
		' ', ' ', ' ', ' ', 0xc3dd, ' ', 0xc3de, ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc3df, 0xc3e0, ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', 0xc3e1, ' ', 
		' ', 0xc3e2, ' ', ' ', ' ', ' ', 0xc3e3, ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc3e4, 0xc3e5, 0xc3e6, 0xc3e7, //0x90
		0xc3e8, ' ', ' ', 0xc3e9, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc3ea, ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc3eb, 0xc3ec, ' ', ' ', 0xc3ed, ' ', ' ', 0xc3ee, //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', ' ', 0xc3ef, ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc3f0, ' ', 0xc3f1, 0xc3f2, 0xc3f3, 0xc3f4, ' ', //0xd0
		0xc3f5, ' ', ' ', ' ', 0xc3f6, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc3f7, ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', 0xc3f8, ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_71 = {
		' ', ' ', ' ', 0xc3f9, ' ', 0xc3fa, 0xc3fb, 0xc3fc, //0x0
		' ', ' ', ' ', 0xc3fd, 0xc3fe, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', ' ', ' ', ' ', ' ', 0xc441, ' ', 
		0xc442, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', 0xc443, ' ', 0xc444, ' ', 0xc445, 
		0xc446, 0xc447, ' ', ' ', ' ', ' ', ' ', ' ', //0x30
		0xc448, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc449, ' ', ' ', ' ', 0xc44a, ' ', ' ', //0x40
		' ', ' ', 0xc44b, 0xc44c, ' ', ' ', ' ', ' ', 
		0xc44d, ' ', 0xc44e, ' ', ' ', ' ', ' ', 0xc44f, //0x50
		' ', ' ', 0xc450, ' ', ' ', ' ', 0xc451, ' ', 
		0xc452, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		0xc453, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', 0xc454, ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc455, ' ', ' ', ' ', ' ', 0xc456, ' ', 0xc457, //0x80
		' ', ' ', ' ', ' ', 0xc458, ' ', ' ', ' ', 
		' ', ' ', 0xc459, ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', 0xc45a, 0xc45b, ' ', ' ', ' ', ' ', 
		0xc45c, ' ', 0xc45d, ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc45e, 
		0xc45f, ' ', 0xc460, 0xc461, ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', 0xc462, ' ', ' ', ' ', ' ', 0xc463, 
		0xc464, ' ', ' ', ' ', 0xc465, ' ', ' ', ' ', //0xc0
		' ', ' ', ' ', 0xc466, 0xc467, ' ', ' ', ' ', 
		' ', ' ', ' ', 0xc468, ' ', ' ', 0xc469, ' ', //0xd0
		' ', 0xc46a, 0xc46b, ' ', 0xc46c, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		0xc46d, ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_72 = {
		0xc46e, ' ', ' ', ' ', ' ', ' ', ' ', 0xc46f, //0x0
		0xc470, 0xc471, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xc472, ' ', ' ', ' ', 0xc473, //0x10
		' ', ' ', 0xc474, ' ', ' ', 0xc475, ' ', 0xc476, 
		' ', ' ', ' ', ' ', 0xc477, ' ', ' ', ' ', //0x20
		' ', ' ', ' ', 0xc478, ' ', ' ', ' ', 0xc479, 
		' ', ' ', ' ', ' ', 0xc47a, ' ', ' ', ' ', //0x30
		0xc47b, 0xc47c, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc47d, 0xc47e, 0xc47f, ' ', 0xc480, ' ', ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', 0xc481, 0xc482, 
		0xc483, ' ', ' ', 0xc484, ' ', 0xc485, 0xc486, ' ', //0x50
		' ', ' ', 0xc487, ' ', 0xc488, ' ', 0xc489, ' ', 
		0xc48a, ' ', ' ', 0xc48b, ' ', ' ', ' ', ' ', //0x60
		0xc48c, ' ', ' ', 0xc48d, ' ', ' ', 0xc48e, 0xc48f, 
		' ', 0xc490, ' ', ' ', ' ', ' ', ' ', 0xc491, //0x70
		0xc492, ' ', ' ', 0xc493, 0xc494, ' ', ' ', 0xc495, 
		' ', ' ', ' ', ' ', 0xc496, ' ', ' ', ' ', //0x80
		' ', 0xc497, ' ', ' ', ' ', 0xc498, 0xc499, ' ', 
		' ', ' ', ' ', 0xc49a, ' ', ' ', ' ', ' ', //0x90
		' ', ' ', ' ', 0xc49b, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		0xc49c, ' ', ' ', ' ', ' ', 0xc49d, 0xc49e, ' ', 
		' ', ' ', ' ', ' ', 0xc49f, ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc4a0, ' ', ' ', ' ', ' ', ' ', 0xc4a1, //0xc0
		' ', 0xc4a2, ' ', ' ', 0xc4a3, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc4a4, 0xc4a5, ' ', //0xd0
		0xc4a6, ' ', ' ', ' ', ' ', ' ', ' ', 0xc4a7, 
		' ', ' ', ' ', ' ', ' ', 0xc4a8, ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xc4a9, 0xc4aa, ' ', ' ', ' ', //0xf0
		' ', ' ', 0xc4ab, 0xc4ac, ' ', ' ', 0xc4ad, ' '
	};
	protected static final char[] cvtbl_u_73 = {
		' ', ' ', 0xc4ae, ' ', 0xc4af, 0xc4b0, ' ', 0xc4b1, //0x0
		' ', ' ', ' ', 0xc4b2, ' ', 0xc4b3, ' ', ' ', 
		' ', ' ', 0xc4b4, 0xc4b5, ' ', ' ', ' ', ' ', //0x10
		0xc4b6, 0xc4b7, ' ', ' ', ' ', ' ', 0xc4b8, ' ', 
		' ', ' ', 0xc4b9, ' ', ' ', ' ', ' ', 0xc4ba, //0x20
		0xc4bb, ' ', ' ', ' ', 0xc4bc, ' ', ' ', ' ', 
		' ', 0xc4bd, 0xc4be, ' ', ' ', 0xc4bf, ' ', ' ', //0x30
		' ', ' ', 0xc4c0, 0xc4c1, ' ', 0xc4c2, ' ', ' ', 
		' ', ' ', ' ', 0xc4c3, ' ', ' ', ' ', ' ', //0x40
		' ', ' ', ' ', ' ', ' ', 0xc4c4, ' ', ' ', 
		0xc4c5, ' ', 0xc4c6, ' ', ' ', ' ', 0xc4c7, ' ', //0x50
		0xc4c8, ' ', ' ', ' ', ' ', 0xc4c9, 0xc4ca, 0xc4cb, 
		0xc4cc, ' ', ' ', ' ', ' ', ' ', 0xc4cd, 0xc4ce, //0x60
		' ', 0xc4cf, ' ', 0xc4d0, 0xc4d1, ' ', 0xc4d2, 0xc4d3, 
		' ', 0xc4d4, ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', 0xc4d5, ' ', ' ', 0xc4d6, ' ', ' ', ' ', 
		0xc4d7, 0xc4d8, ' ', 0xc4d9, ' ', 0xc4da, 0xc4db, ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', 0xc4dc, ' ', 
		0xc4dd, ' ', ' ', 0xc4de, ' ', 0xc4df, ' ', 0xc4e0, //0x90
		0xc4e1, ' ', ' ', ' ', 0xc4e2, ' ', 0xc4e3, 0xc4e4, 
		0xc4e5, ' ', 0xc4e6, ' ', ' ', 0xc4e7, 0xc4e8, ' ', //0xa0
		' ', ' ', 0xc4e9, 0xc4ea, ' ', 0xc4eb, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc4ec, ' ', 0xc4ed, //0xb0
		' ', 0xc4ee, ' ', ' ', 0xc4ef, ' ', ' ', 0xc4f0, 
		' ', ' ', ' ', ' ', ' ', 0xc4f1, 0xc4f2, ' ', //0xc0
		' ', ' ', ' ', 0xc4f3, 0xc4f4, ' ', ' ', 0xc4f5, 
		' ', ' ', ' ', 0xc4f6, ' ', ' ', ' ', ' ', //0xd0
		' ', 0xc4f7, ' ', ' ', ' ', 0xc4f8, ' ', ' ', 
		' ', 0xc4f9, ' ', ' ', ' ', ' ', 0xc4fa, 0xc4fb, //0xe0
		' ', 0xc4fc, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc4fd, ' ', ' ', 0xc4fe, //0xf0
		' ', 0xc541, 0xc542, 0xc543, ' ', 0xc544, ' ', 0xc545
	};
	protected static final char[] cvtbl_u_74 = {
		0xc546, 0xc547, ' ', ' ', 0xc548, ' ', ' ', ' ', //0x0
		' ', ' ', 0xc549, ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc54a, ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', 0xc54b, 0xc54c, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc54d, ' ', ' ', ' ', //0x20
		0xc54e, ' ', ' ', 0xc54f, 0xc550, 0xc551, ' ', 0xc552, 
		0xc553, 0xc554, ' ', ' ', ' ', ' ', ' ', ' ', //0x30
		' ', 0xc555, ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc556, ' ', ' ', 0xc557, 0xc558, ' ', 0xc559, 0xc55a, //0x40
		' ', ' ', ' ', 0xc55b, ' ', 0xc55c, ' ', ' ', 
		' ', 0xc55d, 0xc55e, ' ', ' ', ' ', ' ', 0xc55f, //0x50
		' ', ' ', ' ', ' ', ' ', 0xc560, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc561, 0xc562, //0x60
		0xc563, ' ', ' ', 0xc564, ' ', 0xc565, 0xc566, ' ', 
		' ', 0xc567, 0xc568, ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc569, 0xc56a, ' ', ' ', ' ', 0xc56b, 0xc56c, 0xc56d, //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc56e, 
		0xc56f, 0xc570, 0xc571, ' ', ' ', ' ', ' ', ' ', //0x90
		0xc572, 0xc573, 0xc574, ' ', 0xc575, ' ', ' ', ' ', 
		0xc576, 0xc577, ' ', 0xc578, ' ', ' ', 0xc579, ' ', //0xa0
		0xc57a, 0xc57b, 0xc57c, 0xc57d, ' ', ' ', 0xc57e, 0xc57f, 
		' ', 0xc580, 0xc581, ' ', ' ', 0xc582, ' ', ' ', //0xb0
		' ', 0xc583, ' ', 0xc584, ' ', ' ', ' ', 0xc585, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		0xc586, 0xc587, ' ', ' ', 0xc588, ' ', ' ', ' ', 
		0xc589, ' ', ' ', 0xc58a, ' ', ' ', ' ', ' ', //0xd0
		0xc58b, ' ', 0xc58c, 0xc58d, ' ', ' ', 0xc58e, 0xc58f, 
		' ', ' ', ' ', ' ', 0xc590, ' ', ' ', ' ', //0xe0
		0xc591, ' ', 0xc592, 0xc593, ' ', ' ', ' ', 0xc594, 
		' ', ' ', ' ', ' ', 0xc595, ' ', ' ', ' ', //0xf0
		' ', ' ', 0xc596, 0xc597, 0xc598, ' ', ' ', 0xc599
	};
	protected static final char[] cvtbl_u_75 = {
		' ', ' ', ' ', ' ', ' ', ' ', 0xc59a, ' ', //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xc59b, ' ', ' ', ' ', 0xc59c, 0xc59d, //0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc59e, 0xc59f, ' ', ' ', 0xc5a0, ' ', ' ', 0xc5a1, //0x20
		' ', 0xc5a2, 0xc5a3, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc5a4, ' ', //0x30
		' ', 0xc5a5, ' ', ' ', ' ', 0xc5a6, 0xc5a7, 0xc5a8, 
		0xc5a9, ' ', ' ', 0xc5aa, ' ', ' ', ' ', 0xc5ab, //0x40
		0xc5ac, ' ', ' ', ' ', ' ', ' ', 0xc5ad, ' ', 
		0xc5ae, ' ', 0xc5af, ' ', ' ', ' ', ' ', 0xc5b0, //0x50
		' ', ' ', ' ', ' ', ' ', ' ', 0xc5b1, 0xc5b2, 
		' ', 0xc5b3, ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc5b4, ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', 0xc5b5, 0xc5b6, 0xc5b7, 0xc5b8, 0xc5b9, 0xc5ba, ' ', 
		' ', 0xc5bb, ' ', ' ', ' ', 0xc5bc, ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc5bd, ' ', 0xc5be, 0xc5bf, ' ', 0xc5c0, ' ', ' ', //0x90
		' ', 0xc5c1, ' ', ' ', 0xc5c2, ' ', ' ', ' ', 
		' ', ' ', 0xc5c3, ' ', 0xc5c4, ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc5c5, ' ', ' ', ' ', //0xb0
		' ', ' ', 0xc5c6, ' ', ' ', ' ', ' ', 0xc5c7, 
		0xc5c8, 0xc5c9, ' ', ' ', 0xc5ca, ' ', 0xc5cb, ' ', //0xc0
		' ', ' ', ' ', ' ', 0xc5cc, ' ', 0xc5cd, 0xc5ce, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc5cf, //0xd0
		' ', ' ', ' ', ' ', 0xc5d0, ' ', ' ', 0xc5d1, 
		0xc5d2, 0xc5d3, ' ', ' ', 0xc5d4, ' ', ' ', 0xc5d5, //0xe0
		' ', ' ', ' ', ' ', 0xc5d6, ' ', 0xc5d7, 0xc5d8, 
		' ', 0xc5d9, ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', 0xc5da, ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_76 = {
		0xc5db, ' ', 0xc5dc, 0xc5dd, 0xc5de, ' ', ' ', 0xc5df, //0x0
		0xc5e0, ' ', 0xc5e1, ' ', 0xc5e2, ' ', ' ', 0xc5e3, 
		' ', ' ', 0xc5e4, 0xc5e5, ' ', 0xc5e6, 0xc5e7, ' ', //0x10
		' ', 0xc5e8, ' ', 0xc5e9, 0xc5ea, 0xc5eb, 0xc5ec, ' ', 
		' ', ' ', ' ', 0xc5ed, ' ', 0xc5ee, 0xc5ef, ' ', //0x20
		' ', 0xc5f0, ' ', ' ', ' ', 0xc5f1, ' ', ' ', 
		' ', ' ', 0xc5f2, 0xc5f3, ' ', 0xc5f4, ' ', ' ', //0x30
		0xc5f5, 0xc5f6, 0xc5f7, ' ', 0xc5f8, ' ', ' ', ' ', 
		0xc5f9, 0xc5fa, ' ', 0xc5fb, 0xc5fc, 0xc5fd, ' ', ' ', //0x40
		' ', 0xc5fe, 0xc641, 0xc642, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc643, ' ', ' ', //0x50
		' ', 0xc644, ' ', ' ', ' ', ' ', ' ', 0xc645, 
		' ', ' ', ' ', ' ', 0xc646, 0xc647, ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', 0xc648, 0xc649, 0xc64a, 
		' ', 0xc64b, ' ', ' ', 0xc64c, ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc64d, ' ', ' ', ' ', 0xc64e, ' ', ' ', //0x80
		' ', ' ', ' ', ' ', 0xc64f, 0xc650, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc651, ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', 0xc652, ' ', 0xc653, 
		0xc654, ' ', 0xc655, 0xc656, 0xc657, 0xc658, ' ', 0xc659, //0xa0
		0xc65a, ' ', 0xc65b, ' ', ' ', 0xc65c, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', 0xc65d, ' ', ' ', 
		' ', 0xc65e, ' ', ' ', ' ', 0xc65f, ' ', ' ', //0xc0
		' ', 0xc660, ' ', 0xc661, 0xc662, ' ', 0xc663, ' ', 
		' ', ' ', ' ', ' ', 0xc664, ' ', ' ', ' ', //0xd0
		' ', 0xc665, ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc666, ' ', ' ', ' ', ' ', ' ', 0xc667, ' ', //0xe0
		0xc668, ' ', ' ', ' ', 0xc669, ' ', ' ', ' ', 
		0xc66a, 0xc66b, ' ', ' ', ' ', ' ', 0xc66c, ' ', //0xf0
		' ', 0xc66d, ' ', ' ', 0xc66e, ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_77 = {
		0xc66f, ' ', ' ', ' ', ' ', ' ', 0xc670, ' ', //0x0
		' ', ' ', 0xc671, ' ', ' ', ' ', 0xc672, ' ', 
		' ', ' ', 0xc673, ' ', 0xc674, 0xc675, ' ', 0xc676, //0x10
		' ', 0xc677, 0xc678, ' ', 0xc679, ' ', ' ', ' ', 
		' ', ' ', 0xc67a, ' ', ' ', ' ', ' ', ' ', //0x20
		0xc67b, ' ', ' ', ' ', ' ', 0xc67c, 0xc67d, 0xc67e, 
		' ', ' ', ' ', ' ', 0xc67f, 0xc680, 0xc681, ' ', //0x30
		' ', 0xc682, ' ', ' ', ' ', 0xc683, 0xc684, ' ', 
		' ', ' ', 0xc685, ' ', ' ', 0xc686, ' ', ' ', //0x40
		' ', ' ', 0xc687, ' ', ' ', 0xc688, 0xc689, 0xc68a, 
		' ', ' ', 0xc68b, ' ', ' ', ' ', 0xc68c, 0xc68d, //0x50
		' ', ' ', ' ', ' ', 0xc68e, ' ', 0xc68f, 0xc690, 
		0xc691, ' ', 0xc692, ' ', 0xc693, ' ', ' ', 0xc694, //0x60
		' ', ' ', 0xc695, ' ', 0xc696, ' ', ' ', ' ', 
		0xc697, ' ', 0xc698, 0xc699, 0xc69a, ' ', ' ', ' ', //0x70
		' ', ' ', 0xc69b, ' ', ' ', 0xc69c, ' ', ' ', 
		0xc69d, ' ', ' ', ' ', 0xc69e, ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', 0xc69f, 0xc6a0, ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc6a1, 0xc6a2, 0xc6a3, ' ', //0x90
		' ', ' ', 0xc6a4, ' ', ' ', ' ', ' ', 0xc6a5, 
		' ', ' ', 0xc6a6, ' ', ' ', ' ', ' ', 0xc6a7, //0xa0
		' ', ' ', 0xc6a8, ' ', ' ', ' ', 0xc6a9, 0xc6aa, 
		' ', 0xc6ab, ' ', ' ', ' ', 0xc6ac, ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', 0xc6ad, ' ', 
		' ', ' ', ' ', 0xc6ae, ' ', ' ', ' ', ' ', //0xc0
		' ', 0xc6af, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc6b0, 0xc6b1, ' ', ' ', 0xc6b2, ' ', ' ', //0xd0
		' ', 0xc6b3, ' ', ' ', ' ', ' ', 0xc6b4, 0xc6b5, 
		0xc6b6, ' ', ' ', ' ', 0xc6b7, ' ', 0xc6b8, ' ', //0xe0
		' ', ' ', 0xc6b9, ' ', 0xc6ba, ' ', ' ', ' ', 
		0xc6bb, 0xc6bc, ' ', ' ', 0xc6bd, ' ', ' ', ' ', //0xf0
		0xc6be, ' ', ' ', 0xc6bf, ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_78 = {
		' ', ' ', ' ', ' ', ' ', 0xc6c0, 0xc6c1, ' ', //0x0
		' ', 0xc6c2, ' ', ' ', ' ', 0xc6c3, 0xc6c4, ' ', 
		' ', 0xc6c5, ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', ' ', ' ', ' ', 0xc6c6, ' ', ' ', 
		' ', ' ', 0xc6c7, 0xc6c8, ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', 0xc6c9, 0xc6ca, ' ', 
		0xc6cb, ' ', ' ', ' ', ' ', 0xc6cc, ' ', 0xc6cd, //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xc6ce, 0xc6cf, ' ', ' ', 0xc6d0, //0x40
		0xc6d1, ' ', ' ', ' ', 0xc6d2, ' ', ' ', ' ', 
		' ', ' ', 0xc6d3, ' ', ' ', ' ', ' ', ' ', //0x50
		' ', ' ', ' ', ' ', 0xc6d4, ' ', 0xc6d5, ' ', 
		0xc6d6, 0xc6d7, ' ', 0xc6d8, ' ', ' ', ' ', ' ', //0x60
		0xc6d9, ' ', 0xc6da, ' ', ' ', ' ', 0xc6db, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', 0xc6dc, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', 0xc6dd, ' ', ' ', ' ', ' ', 0xc6de, 
		' ', ' ', ' ', ' ', 0xc6df, ' ', ' ', ' ', //0x90
		0xc6e0, ' ', ' ', ' ', ' ', 0xc6e1, 0xc6e2, 0xc6e3, 
		' ', 0xc6e4, ' ', ' ', 0xc6e5, ' ', ' ', ' ', //0xa0
		0xc6e6, ' ', ' ', ' ', 0xc6e7, 0xc6e8, ' ', ' ', 
		0xc6e9, 0xc6ea, 0xc6eb, 0xc6ec, ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', 0xc6ed, ' ', 0xc6ee, ' ', 0xc6ef, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc6f0, //0xc0
		0xc6f1, 0xc6f2, ' ', ' ', 0xc6f3, ' ', 0xc6f4, ' ', 
		' ', ' ', 0xc6f5, 0xc6f6, ' ', 0xc6f7, 0xc6f8, ' ', //0xd0
		' ', ' ', ' ', 0xc6f9, ' ', ' ', ' ', 0xc6fa, 
		0xc6fb, 0xc6fc, ' ', ' ', 0xc6fd, ' ', 0xc6fe, ' ', //0xe0
		' ', ' ', 0xc741, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xc742, 0xc743, ' ', ' ', 0xc744, 0xc745, //0xf0
		' ', ' ', 0xc746, 0xc747, ' ', ' ', ' ', 0xc748
	};
	protected static final char[] cvtbl_u_79 = {
		0xc749, ' ', ' ', ' ', ' ', ' ', 0xc74a, ' ', //0x0
		' ', ' ', ' ', ' ', 0xc74b, ' ', ' ', ' ', 
		0xc74c, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', 0xc74d, ' ', 0xc74e, ' ', 0xc74f, 0xc750, 
		0xc751, ' ', ' ', ' ', ' ', 0xc752, ' ', 0xc753, //0x20
		' ', 0xc754, ' ', ' ', ' ', 0xc755, ' ', ' ', 
		' ', 0xc756, ' ', ' ', 0xc757, 0xc758, ' ', ' ', //0x30
		' ', ' ', ' ', 0xc759, ' ', 0xc75a, ' ', 0xc75b, 
		' ', ' ', ' ', ' ', 0xc75c, 0xc75d, 0xc75e, ' ', //0x40
		' ', ' ', 0xc75f, 0xc760, ' ', ' ', ' ', 0xc761, 
		' ', 0xc762, ' ', ' ', 0xc763, ' ', ' ', ' ', //0x50
		0xc764, ' ', ' ', 0xc765, 0xc766, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc767, //0x60
		' ', 0xc768, ' ', 0xc769, ' ', ' ', ' ', ' ', 
		' ', ' ', 0xc76a, ' ', ' ', ' ', ' ', ' ', //0x70
		' ', 0xc76b, ' ', 0xc76c, 0xc76d, ' ', 0xc76e, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', 0xc76f, 0xc770, ' ', ' ', ' ', 
		' ', 0xc771, ' ', 0xc772, ' ', 0xc773, 0xc774, ' ', //0x90
		0xc775, ' ', ' ', ' ', 0xc776, ' ', ' ', ' ', 
		' ', 0xc777, ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		0xc778, 0xc779, ' ', 0xc77a, ' ', ' ', ' ', 0xc77b, 
		' ', 0xc77c, ' ', ' ', 0xc77d, ' ', ' ', ' ', //0xb0
		0xc77e, ' ', ' ', 0xc77f, ' ', ' ', ' ', ' ', 
		' ', ' ', 0xc780, ' ', 0xc781, ' ', ' ', 0xc782, //0xc0
		0xc783, ' ', 0xc784, ' ', ' ', ' ', ' ', 0xc785, 
		' ', ' ', ' ', ' ', 0xc786, ' ', 0xc787, ' ', //0xd0
		' ', ' ', 0xc788, ' ', ' ', 0xc789, 0xc78a, ' ', 
		0xc78b, ' ', 0xc78c, ' ', ' ', 0xc78d, ' ', ' ', //0xe0
		' ', ' ', 0xc78e, 0xc78f, ' ', 0xc790, ' ', ' ', 
		' ', 0xc791, ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		0xc792, ' ', ' ', ' ', 0xc793, ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_7a = {
		' ', ' ', 0xc794, 0xc795, ' ', ' ', ' ', 0xc796, //0x0
		' ', 0xc797, 0xc798, ' ', 0xc799, ' ', ' ', ' ', 
		' ', 0xc79a, ' ', ' ', ' ', 0xc79b, ' ', ' ', //0x10
		' ', ' ', ' ', 0xc79c, ' ', ' ', 0xc79d, ' ', 
		' ', 0xc79e, ' ', ' ', ' ', ' ', ' ', 0xc79f, //0x20
		' ', ' ', ' ', 0xc7a0, ' ', 0xc7a1, ' ', 0xc7a2, 
		0xc7a3, ' ', ' ', ' ', 0xc7a4, 0xc7a5, ' ', ' ', //0x30
		0xc7a6, 0xc7a7, 0xc7a8, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc7a9, 0xc7aa, ' ', 0xc7ab, //0x40
		0xc7ac, ' ', ' ', ' ', 0xc7ad, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc7ae, 0xc7af, ' ', //0x50
		' ', 0xc7b0, ' ', ' ', 0xc7b1, 0xc7b2, ' ', 0xc7b3, 
		0xc7b4, ' ', ' ', ' ', ' ', 0xc7b5, ' ', 0xc7b6, //0x60
		' ', ' ', 0xc7b7, ' ', ' ', 0xc7b8, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc7b9, ' ', ' ', //0x70
		0xc7ba, ' ', ' ', ' ', ' ', ' ', 0xc7bb, ' ', 
		0xc7bc, ' ', 0xc7bd, ' ', ' ', 0xc7be, 0xc7bf, ' ', //0x80
		' ', ' ', 0xc7c0, 0xc7c1, ' ', ' ', ' ', ' ', 
		0xc7c2, 0xc7c3, ' ', ' ', 0xc7c4, ' ', ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', ' ', 0xc7c5, ' ', 
		0xc7c6, ' ', ' ', 0xc7c7, ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', 0xc7c8, ' ', ' ', ' ', 
		' ', ' ', ' ', 0xc7c9, ' ', 0xc7ca, ' ', ' ', //0xb0
		' ', 0xc7cb, ' ', 0xc7cc, 0xc7cd, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc7ce, ' ', //0xc0
		' ', 0xc7cf, ' ', ' ', 0xc7d0, ' ', 0xc7d1, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', 0xc7d2, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		0xc7d3, 0xc7d4, ' ', ' ', 0xc7d5, ' ', ' ', ' ', 
		' ', 0xc7d6, ' ', ' ', 0xc7d7, ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', 0xc7d8, ' ', 0xc7d9, 0xc7da, ' '
	};
	protected static final char[] cvtbl_u_7b = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc7db, //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc7dc, ' ', ' ', ' ', //0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc7dd, 
		' ', ' ', ' ', 0xc7de, ' ', ' ', ' ', 0xc7df, //0x20
		' ', 0xc7e0, 0xc7e1, 0xc7e2, ' ', 0xc7e3, 0xc7e4, 0xc7e5, 
		0xc7e6, 0xc7e7, ' ', ' ', 0xc7e8, ' ', ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', 0xc7e9, ' ', 0xc7ea, 
		0xc7eb, 0xc7ec, ' ', ' ', ' ', ' ', ' ', 0xc7ed, //0x40
		' ', ' ', ' ', ' ', ' ', ' ', 0xc7ee, ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc7ef, ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc7f0, ' ', ' ', ' ', 0xc7f1, ' ', 0xc7f2, ' ', //0x60
		' ', 0xc7f3, 0xc7f4, ' ', ' ', 0xc7f5, ' ', 0xc7f6, 
		' ', ' ', 0xc7f7, 0xc7f8, ' ', ' ', ' ', 0xc7f9, //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc7fa, ' ', ' ', ' ', //0x80
		' ', 0xc7fb, ' ', ' ', ' ', ' ', 0xc7fc, ' ', 
		0xc7fd, 0xc7fe, ' ', ' ', ' ', ' ', 0xc841, ' ', //0x90
		' ', ' ', ' ', 0xc842, ' ', ' ', ' ', ' ', 
		0xc843, ' ', ' ', ' ', ' ', 0xc844, ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', 0xc845, ' ', ' ', 0xc846, 
		0xc847, ' ', 0xc848, ' ', ' ', 0xc849, 0xc84a, ' ', //0xb0
		' ', ' ', 0xc84b, 0xc84c, 0xc84d, 0xc84e, ' ', ' ', 
		' ', ' ', 0xc84f, ' ', ' ', 0xc850, ' ', ' ', //0xc0
		0xc851, ' ', 0xc852, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc853, ' ', 0xc854, 0xc855, //0xd0
		' ', 0xc856, 0xc857, 0xc858, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		0xc859, ' ', 0xc85a, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xc85b, ' ', 0xc85c, 0xc85d, ' ', ' ', //0xf0
		0xc85e, 0xc85f, 0xc860, ' ', 0xc861, ' ', 0xc862, ' '
	};
	protected static final char[] cvtbl_u_7c = {
		' ', 0xc863, 0xc864, 0xc865, 0xc866, ' ', 0xc867, ' ', //0x0
		' ', 0xc868, ' ', 0xc869, 0xc86a, ' ', 0xc86b, 0xc86c, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', 0xc86d, ' ', 0xc86e, ' ', ' ', ' ', ' ', 
		0xc86f, ' ', ' ', ' ', ' ', 0xc870, 0xc871, ' ', //0x20
		0xc872, ' ', ' ', ' ', 0xc873, ' ', ' ', ' ', 
		' ', 0xc874, ' ', 0xc875, 0xc876, ' ', 0xc877, ' ', //0x30
		' ', 0xc878, 0xc879, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc87a, ' ', //0x40
		' ', ' ', 0xc87b, ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc87c, 0xc87d, 0xc87e, ' ', 0xc87f, ' ', ' ', //0x50
		' ', 0xc880, 0xc881, 0xc882, 0xc883, 0xc884, 0xc885, ' ', 
		' ', 0xc886, ' ', 0xc887, ' ', ' ', ' ', 0xc888, //0x60
		' ', 0xc889, ' ', ' ', ' ', 0xc88a, 0xc88b, ' ', 
		0xc88c, ' ', 0xc88d, ' ', ' ', ' ', ' ', ' ', //0x70
		' ', 0xc88e, ' ', ' ', 0xc88f, 0xc890, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc891, 0xc892, //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc893, 
		' ', ' ', ' ', ' ', 0xc894, ' ', ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', ' ', 0xc895, ' ', 
		0xc896, ' ', ' ', ' ', ' ', ' ', 0xc897, ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc898, ' ', ' ', ' ', ' ', ' ', 0xc899, 0xc89a, //0xb0
		' ', ' ', 0xc89b, 0xc89c, 0xc89d, ' ', ' ', 0xc89e, 
		' ', ' ', ' ', ' ', 0xc89f, ' ', ' ', 0xc8a0, //0xc0
		0xc8a1, 0xc8a2, ' ', ' ', ' ', 0xc8a3, ' ', 0xc8a4, 
		' ', ' ', ' ', 0xc8a5, 0xc8a6, 0xc8a7, ' ', 0xc8a8, //0xd0
		' ', 0xc8a9, 0xc8aa, ' ', ' ', 0xc8ab, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc8ac, ' ', //0xe0
		' ', 0xc8ad, ' ', 0xc8ae, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc8af, ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_7d = {
		' ', ' ', ' ', 0xc8b0, ' ', ' ', ' ', 0xc8b1, //0x0
		0xc8b2, 0xc8b3, ' ', ' ', ' ', ' ', ' ', 0xc8b4, 
		' ', 0xc8b5, 0xc8b6, 0xc8b7, ' ', ' ', 0xc8b8, ' ', //0x10
		' ', ' ', ' ', ' ', ' ', 0xc8b9, 0xc8ba, ' ', 
		' ', ' ', ' ', 0xc8bb, ' ', ' ', 0xc8bc, ' ', //0x20
		' ', ' ', 0xc8bd, ' ', ' ', 0xc8be, ' ', ' ', 
		' ', 0xc8bf, ' ', ' ', ' ', ' ', ' ', ' ', //0x30
		' ', ' ', ' ', ' ', 0xc8c0, 0xc8c1, 0xc8c2, ' ', 
		0xc8c3, 0xc8c4, ' ', ' ', ' ', ' ', ' ', 0xc8c5, //0x40
		' ', ' ', ' ', ' ', ' ', 0xc8c6, ' ', ' ', 
		' ', 0xc8c7, ' ', 0xc8c8, ' ', ' ', ' ', 0xc8c9, //0x50
		' ', 0xc8ca, 0xc8cb, ' ', ' ', 0xc8cc, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc8cd, ' ', 0xc8ce, //0x60
		' ', ' ', 0xc8cf, ' ', ' ', ' ', ' ', ' ', 
		0xc8d0, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		0xc8d1, ' ', 0xc8d2, 0xc8d3, ' ', ' ', ' ', 0xc8d4, 
		' ', 0xc8d5, 0xc8d6, 0xc8d7, ' ', 0xc8d8, 0xc8d9, ' ', //0x80
		0xc8da, ' ', ' ', 0xc8db, 0xc8dc, 0xc8dd, ' ', ' ', 
		' ', 0xc8de, ' ', ' ', ' ', ' ', 0xc8df, 0xc8e0, //0x90
		' ', ' ', ' ', ' ', ' ', 0xc8e1, 0xc8e2, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc8e3, 0xc8e4, //0xa0
		' ', ' ', 0xc8e5, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xc8e6, ' ', ' ', 0xc8e7, ' ', //0xb0
		' ', 0xc8e8, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xc8e9, 0xc8ea, 0xc8eb, 0xc8ec, 0xc8ed, ' ', //0xc0
		' ', ' ', ' ', ' ', 0xc8ee, 0xc8ef, 0xc8f0, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc8f1, //0xd0
		' ', 0xc8f2, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xc8f3, ' ', ' ', 0xc8f4, 0xc8f5, ' ', //0xe0
		' ', ' ', 0xc8f6, 0xc8f7, ' ', 0xc8f8, ' ', ' ', 
		' ', 0xc8f9, ' ', ' ', ' ', 0xc8fa, 0xc8fb, ' ', //0xf0
		' ', 0xc8fc, 0xc8fd, ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_7e = {
		0xc8fe, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x0
		0xc941, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc942, 0xc943, ' ', ' ', ' ', 0xc944, ' ', 0xc945, //0x10
		' ', ' ', ' ', ' ', 0xc946, 0xc947, ' ', ' ', 
		0xc948, ' ', ' ', ' ', ' ', ' ', ' ', 0xc949, //0x20
		0xc94a, ' ', ' ', ' ', 0xc94b, 0xc94c, ' ', 0xc94d, 
		' ', ' ', ' ', 0xc94e, ' ', ' ', 0xc94f, ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc950, 
		' ', ' ', ' ', ' ', 0xc951, 0xc952, ' ', 0xc953, //0x40
		' ', ' ', ' ', ' ', ' ', ' ', 0xc954, ' ', 
		0xc955, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		0xc956, ' ', ' ', ' ', ' ', ' ', ' ', 0xc957, 
		' ', 0xc958, 0xc959, ' ', ' ', 0xc95a, ' ', ' ', //0x60
		' ', ' ', ' ', 0xc95b, ' ', ' ', 0xc95c, 0xc95d, 
		' ', ' ', ' ', 0xc95e, ' ', ' ', ' ', ' ', //0x70
		0xc95f, ' ', ' ', ' ', ' ', ' ', 0xc960, ' ', 
		' ', 0xc961, ' ', ' ', ' ', ' ', 0xc962, 0xc963, //0x80
		' ', ' ', ' ', ' ', ' ', 0xc964, ' ', ' ', 
		' ', 0xc965, ' ', ' ', ' ', 0xc966, ' ', ' ', //0x90
		0xc967, ' ', 0xc968, ' ', ' ', 0xc969, 0xc96a, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_7f = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x30
		' ', ' ', ' ', 0xc96b, 0xc96c, 0xc96d, 0xc96e, 0xc96f, 
		' ', ' ', ' ', 0xc970, 0xc971, ' ', ' ', ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc972, 
		' ', ' ', 0xc973, 0xc974, ' ', ' ', ' ', ' ', //0x50
		' ', ' ', ' ', 0xc975, 0xc976, 0xc977, ' ', ' ', 
		' ', 0xc978, ' ', 0xc979, 0xc97a, 0xc97b, 0xc97c, ' ', //0x60
		' ', ' ', ' ', ' ', ' ', 0xc97d, ' ', ' ', 
		' ', 0xc97e, ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', 0xc97f, 0xc980, 0xc981, 
		0xc982, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', 0xc983, ' ', 0xc984, ' ', 0xc985, 
		0xc986, 0xc987, ' ', ' ', ' ', ' ', 0xc988, 0xc989, //0x90
		' ', ' ', ' ', ' ', 0xc98a, ' ', ' ', ' ', 
		' ', ' ', 0xc98b, ' ', ' ', ' ', 0xc98c, ' ', //0xa0
		' ', ' ', 0xc98d, ' ', ' ', 0xc98e, ' ', ' ', 
		' ', ' ', ' ', ' ', 0xc98f, ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', 0xc990, ' ', ' ', 0xc991, 
		0xc992, ' ', ' ', 0xc993, ' ', ' ', ' ', ' ', //0xc0
		0xc994, ' ', ' ', ' ', ' ', ' ', 0xc995, 0xc996, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', 0xc997, ' ', ' ', ' ', 0xc998, 
		' ', ' ', ' ', 0xc999, ' ', 0xc99a, ' ', ' ', //0xe0
		0xc99b, ' ', ' ', ' ', 0xc99c, ' ', 0xc99d, 0xc99e, 
		' ', ' ', 0xc99f, ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', 0xc9a0, ' ', ' ', 0xc9a1, 0xc9a2, 0xc9a3
	};
}