/**
 * Title: UniCodePage
 * Copyright:   Copyright (c) 2001, 2002, 2003
 * Company:
 * @author  Kenneth J. Pouncey
 *          rewritten by LDC, WVL, Luc
 * @version 0.4
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j.encoding;

class UniCodeU80 {
	protected static final char[] cvtbl_u_80 = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc9a4, //0x0
		0xc9a5, ' ', 0xc9a6, ' ', ' ', 0xc9a7, 0xc9a8, 0xc9a9, 
		' ', 0xc9aa, ' ', 0xc9ab, 0xc9ac, ' ', 0xc9ad, ' ', //0x10
		' ', ' ', ' ', ' ', ' ', 0xc9ae, 0xc9af, 0xc9b0, 
		0xc9b1, ' ', ' ', ' ', 0xc9b2, ' ', 0xc9b3, ' ', //0x20
		' ', ' ', ' ', ' ', 0xc9b4, ' ', 0xc9b5, ' ', 
		0xc9b6, ' ', ' ', ' ', 0xc9b7, 0xc9b8, ' ', 0xc9b9, //0x30
		' ', 0xc9ba, 0xc9bb, ' ', 0xc9bc, ' ', 0xc9bd, ' ', 
		0xc9be, ' ', ' ', ' ', 0xc9bf, ' ', ' ', ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc9c0, ' ', ' ', ' ', 0xc9c1, ' ', 0xc9c2, ' ', //0x60
		' ', ' ', ' ', ' ', ' ', 0xc9c3, ' ', ' ', 
		' ', 0xc9c4, ' ', ' ', ' ', 0xc9c5, ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xc9c6, ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		0xc9c7, ' ', ' ', ' ', ' ', ' ', 0xc9c8, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', ' ', ' ', 0xc9c9, ' ', 0xc9ca, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc9cb, 0xc9cc, //0xa0
		' ', ' ', ' ', 0xc9cd, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		0xc9ce, 0xc9cf, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		0xc9d0, ' ', ' ', ' ', ' ', 0xc9d1, ' ', 0xc9d2, 
		' ', ' ', 0xc9d3, ' ', 0xc9d4, 0xc9d5, ' ', 0xc9d6, //0xd0
		0xc9d7, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc9d8, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', 0xc9d9, 0xc9da, ' ', 
		0xc9db, ' ', 0xc9dc, 0xc9dd, ' ', ' ', 0xc9de, ' ', //0xf0
		' ', 0xc9df, 0xc9e0, ' ', ' ', ' ', 0xc9e1, ' '
	};
	protected static final char[] cvtbl_u_81 = {
		' ', ' ', ' ', 0xc9e2, ' ', ' ', ' ', ' ', //0x0
		' ', ' ', ' ', 0xc9e3, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xc9e4, 0xc9e5, //0x10
		0xc9e6, ' ', ' ', ' ', 0xc9e7, ' ', 0xc9e8, ' ', 
		0xc9e9, ' ', ' ', ' ', 0xc9ea, ' ', ' ', 0xc9eb, //0x20
		' ', ' ', ' ', ' ', 0xc9ec, ' ', ' ', ' ', 
		0xc9ed, ' ', ' ', ' ', ' ', 0xc9ee, ' ', ' ', //0x30
		' ', ' ', 0xc9ef, ' ', 0xc9f0, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xc9f1, ' ', 0xc9f2, //0x40
		' ', ' ', 0xc9f3, ' ', 0xc9f4, ' ', ' ', ' ', 
		' ', ' ', 0xc9f5, ' ', ' ', ' ', ' ', 0xc9f6, //0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xc9f7, 0xc9f8, ' ', ' ', ' ', ' ', ' ', 0xc9f9, //0x60
		0xc9fa, 0xc9fb, ' ', ' ', ' ', 0xc9fc, ' ', 0xc9fd, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xc9fe, //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xca41, ' ', ' ', 0xca42, 0xca43, 0xca44, ' ', //0x80
		' ', ' ', ' ', 0xca45, ' ', ' ', 0xca46, ' ', 
		0xca47, ' ', ' ', ' ', ' ', ' ', 0xca48, ' ', //0x90
		0xca49, ' ', ' ', 0xca4a, ' ', ' ', 0xca4b, ' ', 
		' ', ' ', 0xca4c, ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', 0xca4d, ' ', 
		' ', ' ', 0xca4e, ' ', 0xca4f, ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', 0xca50, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xca51, ' ', 0xca52, ' ', ' ', //0xc0
		' ', ' ', 0xca53, 0xca54, ' ', ' ', 0xca55, 0xca56, 
		' ', ' ', ' ', ' ', ' ', 0xca57, ' ', 0xca58, //0xd0
		' ', ' ', ' ', 0xca59, ' ', 0xca5a, 0xca5b, ' ', 
		' ', 0xca5c, ' ', ' ', 0xca5d, ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', 0xca5e, 0xca5f, ' ', ' ', ' ', 
		0xca60, 0xca61, 0xca62, ' ', ' ', 0xca63, 0xca64, ' ', //0xf0
		0xca65, 0xca66, ' ', ' ', ' ', 0xca67, ' ', 0xca68
	};
	protected static final char[] cvtbl_u_82 = {
		0xca69, ' ', ' ', 0xca6a, ' ', ' ', ' ', ' ', //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xca6b, 
		' ', ' ', ' ', 0xca6c, 0xca6d, ' ', ' ', ' ', //0x10
		' ', 0xca6e, 0xca6f, ' ', ' ', 0xca70, ' ', ' ', 
		' ', 0xca71, 0xca72, ' ', ' ', ' ', ' ', ' ', //0x20
		0xca73, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xca74, ' ', 0xca75, ' ', ' ', ' ', //0x30
		' ', ' ', 0xca76, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xca77, 0xca78, 0xca79, 0xca7a, ' ', //0x40
		' ', ' ', ' ', 0xca7b, ' ', ' ', 0xca7c, 0xca7d, 
		' ', 0xca7e, ' ', ' ', ' ', ' ', 0xca7f, ' ', //0x50
		' ', ' ', ' ', ' ', 0xca80, ' ', ' ', ' ', 
		0xca81, ' ', ' ', 0xca82, ' ', ' ', ' ', 0xca83, //0x60
		' ', ' ', ' ', ' ', ' ', 0xca84, ' ', ' ', 
		' ', ' ', ' ', ' ', 0xca85, ' ', ' ', ' ', //0x70
		' ', ' ', ' ', 0xca86, ' ', 0xca87, ' ', 0xca88, 
		0xca89, 0xca8a, ' ', 0xca8b, 0xca8c, ' ', ' ', 0xca8d, //0x80
		' ', 0xca8e, 0xca8f, ' ', ' ', ' ', 0xca90, ' ', 
		' ', 0xca91, ' ', ' ', 0xca92, ' ', 0xca93, ' ', //0x90
		0xca94, ' ', 0xca95, 0xca96, ' ', ' ', ' ', ' ', 
		0xca97, 0xca98, ' ', 0xca99, 0xca9a, ' ', ' ', 0xca9b, //0xa0
		0xca9c, 0xca9d, 0xca9e, ' ', ' ', ' ', 0xca9f, ' ', 
		0xcaa0, ' ', 0xcaa1, ' ', 0xcaa2, ' ', ' ', 0xcaa3, //0xb0
		' ', ' ', 0xcaa4, ' ', 0xcaa5, ' ', 0xcaa6, 0xcaa7, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xcaa8, ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xcaa9, ' ', ' ', ' ', ' ', 0xcaaa, ' ', ' ', //0xd0
		' ', ' ', 0xcaab, ' ', ' ', ' ', ' ', ' ', 
		0xcaac, ' ', 0xcaad, ' ', 0xcaae, ' ', ' ', ' ', //0xe0
		0xcaaf, ' ', 0xcab0, ' ', ' ', 0xcab1, ' ', 0xcab2, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xcab3, 0xcab4, //0xf0
		' ', ' ', ' ', ' ', ' ', 0xcab5, 0xcab6, ' '
	};
	protected static final char[] cvtbl_u_83 = {
		0xcab7, ' ', ' ', ' ', ' ', ' ', ' ', 0xcab8, //0x0
		0xcab9, ' ', 0xcaba, 0xcabb, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', ' ', 0xcabc, ' ', 0xcabd, 0xcabe, 0xcabf, 
		' ', 0xcac0, 0xcac1, ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', 0xcac2, 0xcac3, 0xcac4, ' ', 
		0xcac5, ' ', ' ', 0xcac6, ' ', ' ', ' ', 0xcac7, //0x30
		' ', ' ', 0xcac8, ' ', 0xcac9, 0xcaca, ' ', ' ', 
		' ', ' ', 0xcacb, 0xcacc, 0xcacd, ' ', ' ', 0xcace, //0x40
		' ', ' ', ' ', ' ', ' ', 0xcacf, 0xcad0, ' ', 
		' ', 0xcad1, ' ', 0xcad2, 0xcad3, 0xcad4, 0xcad5, 0xcad6, //0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xcad7, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		0xcad8, ' ', ' ', ' ', ' ', 0xcad9, ' ', ' ', 
		0xcada, ' ', 0xcadb, ' ', 0xcadc, ' ', 0xcadd, ' ', //0x80
		' ', ' ', ' ', ' ', ' ', 0xcade, ' ', ' ', 
		' ', ' ', 0xcadf, ' ', 0xcae0, 0xcae1, ' ', ' ', //0x90
		0xcae2, 0xcae3, ' ', 0xcae4, 0xcae5, 0xcae6, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xcae7, 0xcae8, //0xa0
		' ', 0xcae9, ' ', ' ', 0xcaea, 0xcaeb, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', 0xcaec, 0xcaed, 
		0xcaee, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', 0xcaef, ' ', ' ', ' ', ' ', ' ', 0xcaf0, 
		0xcaf1, 0xcaf2, ' ', ' ', 0xcaf3, ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', 0xcaf4, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		0xcaf5, ' ', 0xcaf6, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		0xcaf7, 0xcaf8, ' ', ' ', 0xcaf9, ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_84 = {
		' ', 0xcafa, ' ', ' ', ' ', ' ', 0xcafb, ' ', //0x0
		' ', ' ', 0xcafc, ' ', ' ', ' ', ' ', 0xcafd, 
		' ', 0xcafe, ' ', ' ', ' ', 0xcb41, ' ', ' ', //0x10
		' ', 0xcb42, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xcb43, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x30
		' ', 0xcb44, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xcb45, ' ', 0xcb46, //0x40
		' ', ' ', 0xcb47, ' ', ' ', 0xcb48, ' ', 0xcb49, 
		' ', 0xcb4a, 0xcb4b, ' ', ' ', ' ', 0xcb4c, ' ', //0x50
		0xcb4d, 0xcb4e, 0xcb4f, ' ', 0xcb50, ' ', ' ', ' ', 
		0xcb51, ' ', ' ', ' ', 0xcb52, 0xcb53, ' ', 0xcb54, //0x60
		' ', ' ', 0xcb55, ' ', ' ', ' ', ' ', ' ', 
		0xcb56, ' ', ' ', 0xcb57, 0xcb58, ' ', 0xcb59, ' ', //0x70
		0xcb5a, ' ', ' ', ' ', 0xcb5b, 0xcb5c, ' ', ' ', 
		' ', 0xcb5d, ' ', ' ', ' ', 0xcb5e, ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xcb5f, 0xcb60, ' ', 0xcb61, ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', ' ', 0xcb62, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xcb63, ' ', //0xa0
		0xcb64, 0xcb65, 0xcb66, ' ', ' ', ' ', ' ', 0xcb67, 
		' ', 0xcb68, ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', 0xcb69, ' ', ' ', 0xcb6a, 0xcb6b, ' ', 
		0xcb6c, ' ', 0xcb6d, ' ', ' ', ' ', ' ', 0xcb6e, //0xc0
		0xcb6f, ' ', ' ', ' ', 0xcb70, ' ', ' ', 0xcb71, 
		' ', ' ', ' ', 0xcb72, ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xcb73, //0xe0
		' ', ' ', 0xcb74, ' ', ' ', ' ', ' ', 0xcb75, 
		0xcb76, 0xcb77, 0xcb78, ' ', ' ', ' ', ' ', 0xcb79, //0xf0
		' ', ' ', 0xcb7a, 0xcb7b, ' ', 0xcb7c, ' ', ' '
	};
	protected static final char[] cvtbl_u_85 = {
		' ', ' ', 0xcb7d, 0xcb7e, ' ', ' ', ' ', 0xcb7f, //0x0
		' ', ' ', ' ', ' ', 0xcb80, ' ', 0xcb81, ' ', 
		0xcb82, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', ' ', ' ', 0xcb83, ' ', 0xcb84, ' ', 
		' ', ' ', 0xcb85, 0xcb86, 0xcb87, 0xcb88, ' ', 0xcb89, //0x20
		' ', ' ', 0xcb8a, 0xcb8b, ' ', ' ', ' ', 0xcb8c, 
		' ', ' ', 0xcb8d, 0xcb8e, 0xcb8f, ' ', 0xcb90, ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xcb91, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xcb92, ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xcb93, 
		0xcb94, 0xcb95, 0xcb96, ' ', ' ', ' ', 0xcb97, ' ', //0x50
		' ', ' ', ' ', ' ', 0xcb98, 0xcb99, 0xcb9a, 0xcb9b, 
		0xcb9c, 0xcb9d, 0xcb9e, ' ', 0xcb9f, ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xcba0, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', 0xcba1, 0xcba2, 0xcba3, ' ', 0xcba4, ' ', 0xcba5, 
		' ', 0xcba6, ' ', ' ', ' ', 0xcba7, 0xcba8, ' ', //0x80
		' ', 0xcba9, ' ', 0xcbaa, 0xcbab, ' ', ' ', 0xcbac, 
		' ', ' ', ' ', 0xcbad, ' ', ' ', ' ', ' ', //0x90
		0xcbae, ' ', ' ', ' ', ' ', 0xcbaf, ' ', 0xcbb0, 
		0xcbb1, ' ', 0xcbb2, ' ', ' ', 0xcbb3, ' ', 0xcbb4, //0xa0
		' ', ' ', ' ', ' ', ' ', 0xcbb5, ' ', ' ', 
		' ', ' ', ' ', ' ', 0xcbb6, ' ', 0xcbb7, 0xcbb8, //0xb0
		0xcbb9, ' ', ' ', ' ', 0xcbba, 0xcbbb, 0xcbbc, 0xcbbd, 
		' ', ' ', 0xcbbe, ' ', ' ', ' ', ' ', 0xcbbf, //0xc0
		' ', ' ', 0xcbc0, 0xcbc1, ' ', ' ', 0xcbc2, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		0xcbc3, ' ', 0xcbc4, ' ', ' ', ' ', ' ', 0xcbc5, 
		0xcbc6, ' ', ' ', ' ', ' ', ' ', 0xcbc7, ' ', //0xe0
		0xcbc8, ' ', ' ', ' ', ' ', 0xcbc9, ' ', ' ', 
		' ', ' ', ' ', 0xcbca, ' ', ' ', 0xcbcb, ' ', //0xf0
		' ', ' ', ' ', ' ', 0xcbcc, ' ', ' ', 0xcbcd
	};
	protected static final char[] cvtbl_u_86 = {
		0xcbce, ' ', ' ', ' ', 0xcbcf, 0xcbd0, ' ', ' ', //0x0
		' ', ' ', ' ', ' ', ' ', 0xcbd1, 0xcbd2, ' ', 
		0xcbd3, 0xcbd4, 0xcbd5, ' ', ' ', ' ', ' ', ' ', //0x10
		0xcbd6, 0xcbd7, ' ', 0xcbd8, ' ', ' ', 0xcbd9, ' ', 
		' ', 0xcbda, ' ', ' ', ' ', ' ', ' ', 0xcbdb, //0x20
		' ', 0xcbdc, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xcbdd, ' ', //0x30
		0xcbde, ' ', 0xcbdf, ' ', 0xcbe0, 0xcbe1, ' ', ' ', 
		0xcbe2, 0xcbe3, 0xcbe4, ' ', ' ', ' ', 0xcbe5, ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xcbe6, 0xcbe7, ' ', ' ', 0xcbe8, 0xcbe9, //0x50
		0xcbea, 0xcbeb, ' ', ' ', ' ', 0xcbec, ' ', ' ', 
		0xcbed, 0xcbee, 0xcbef, 0xcbf0, 0xcbf1, ' ', ' ', ' ', //0x60
		' ', 0xcbf2, ' ', ' ', 0xcbf3, ' ', ' ', 0xcbf4, 
		' ', ' ', ' ', ' ', ' ', 0xcbf5, 0xcbf6, 0xcbf7, //0x70
		' ', ' ', 0xcbf8, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		0xcbf9, ' ', ' ', ' ', ' ', 0xcbfa, ' ', ' ', 
		' ', 0xcbfb, ' ', ' ', ' ', ' ', 0xcbfc, ' ', //0x90
		0xcbfd, ' ', 0xcbfe, ' ', 0xcc41, ' ', ' ', ' ', 
		' ', 0xcc42, ' ', ' ', ' ', ' ', 0xcc43, 0xcc44, //0xa0
		0xcc45, ' ', ' ', ' ', ' ', 0xcc46, ' ', ' ', 
		' ', 0xcc47, ' ', 0xcc48, 0xcc49, 0xcc4a, ' ', 0xcc4b, //0xb0
		0xcc4c, 0xcc4d, ' ', ' ', ' ', ' ', ' ', 0xcc4e, 
		0xcc4f, 0xcc50, ' ', 0xcc51, ' ', 0xcc52, ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xcc53, 0xcc54, ' ', ' ', 0xcc55, ' ', 0xcc56, //0xd0
		' ', ' ', 0xcc57, ' ', 0xcc58, ' ', ' ', ' ', 
		0xcc59, ' ', ' ', 0xcc5a, ' ', 0xcc5b, ' ', 0xcc5c, //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', 0xcc5d, ' ', 0xcc5e, 0xcc5f, ' ', ' '
	};
	protected static final char[] cvtbl_u_87 = {
		' ', ' ', ' ', ' ', 0xcc60, 0xcc61, ' ', 0xcc62, //0x0
		' ', ' ', ' ', 0xcc63, ' ', ' ', 0xcc64, 0xcc65, 
		0xcc66, ' ', ' ', 0xcc67, 0xcc68, ' ', ' ', ' ', //0x10
		' ', 0xcc69, ' ', ' ', ' ', ' ', 0xcc6a, 0xcc6b, 
		' ', 0xcc6c, ' ', 0xcc6d, ' ', ' ', ' ', ' ', //0x20
		0xcc6e, ' ', ' ', ' ', ' ', ' ', 0xcc6f, 0xcc70, 
		' ', 0xcc71, 0xcc72, ' ', ' ', ' ', ' ', ' ', //0x30
		' ', 0xcc73, 0xcc74, ' ', 0xcc75, 0xcc76, 0xcc77, ' ', 
		0xcc78, ' ', ' ', 0xcc79, ' ', 0xcc7a, ' ', ' ', //0x40
		' ', ' ', ' ', ' ', ' ', 0xcc7b, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		0xcc7c, ' ', ' ', ' ', ' ', 0xcc7d, ' ', ' ', 
		' ', 0xcc7e, ' ', ' ', 0xcc7f, 0xcc80, ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xcc81, 
		' ', 0xcc82, 0xcc83, ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', 0xcc84, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xcc85, 0xcc86, 0xcc87, 0xcc88, 0xcc89, //0x80
		0xcc8a, 0xcc8b, ' ', 0xcc8c, 0xcc8d, ' ', ' ', ' ', 
		0xcc8e, ' ', ' ', 0xcc8f, ' ', 0xcc90, ' ', 0xcc91, //0x90
		0xcc92, 0xcc93, ' ', ' ', ' ', ' ', 0xcc94, ' ', 
		0xcc95, ' ', ' ', 0xcc96, ' ', ' ', ' ', 0xcc97, //0xa0
		' ', ' ', ' ', ' ', 0xcc98, 0xcc99, 0xcc9a, ' ', 
		' ', 0xcc9b, ' ', ' ', ' ', 0xcc9c, ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', 0xcc9d, 0xcc9e, 
		' ', 0xcc9f, ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		0xcca0, 0xcca1, 0xcca2, ' ', ' ', ' ', 0xcca3, ' ', 
		' ', ' ', ' ', ' ', ' ', 0xcca4, 0xcca5, ' ', //0xd0
		' ', 0xcca6, 0xcca7, ' ', 0xcca8, ' ', ' ', 0xcca9, 
		' ', ' ', 0xccaa, 0xccab, 0xccac, ' ', ' ', ' ', //0xe0
		' ', ' ', 0xccad, 0xccae, ' ', 0xccaf, ' ', ' ', 
		' ', 0xccb0, ' ', 0xccb1, ' ', ' ', ' ', ' ', //0xf0
		0xccb2, ' ', 0xccb3, ' ', ' ', ' ', ' ', 0xccb4
	};
	protected static final char[] cvtbl_u_88 = {
		' ', 0xccb5, ' ', 0xccb6, ' ', ' ', 0xccb7, ' ', //0x0
		' ', 0xccb8, 0xccb9, 0xccba, ' ', ' ', ' ', ' ', 
		0xccbb, ' ', 0xccbc, 0xccbd, 0xccbe, ' ', ' ', ' ', //0x10
		0xccbf, 0xccc0, 0xccc1, 0xccc2, 0xccc3, ' ', 0xccc4, 0xccc5, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		0xccc6, ' ', ' ', ' ', ' ', 0xccc7, 0xccc8, ' ', 
		0xccc9, ' ', 0xccca, ' ', ' ', 0xcccb, ' ', ' ', //0x30
		' ', ' ', 0xcccc, ' ', 0xcccd, ' ', ' ', ' ', 
		' ', 0xccce, ' ', 0xcccf, ' ', 0xccd0, ' ', ' ', //0x40
		0xccd1, 0xccd2, 0xccd3, 0xccd4, ' ', ' ', 0xccd5, ' ', 
		' ', 0xccd6, ' ', ' ', ' ', 0xccd7, 0xccd8, ' ', //0x50
		0xccd9, ' ', 0xccda, ' ', 0xccdb, ' ', ' ', 0xccdc, 
		0xccdd, ' ', ' ', ' ', 0xccde, ' ', ' ', ' ', //0x60
		' ', 0xccdf, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xcce0, ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', 0xcce1, ' ', 0xcce2, ' ', ' ', ' ', ' ', 
		0xcce3, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		0xcce4, ' ', 0xcce5, 0xcce6, 0xcce7, ' ', ' ', 0xcce8, 
		0xcce9, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		0xccea, ' ', 0xcceb, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', 0xccec, ' ', ' ', 0xcced, 0xccee, ' ', 
		0xccef, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', ' ', 0xccf0, 0xccf1, 0xccf2, 0xccf3, 0xccf4, ' ', 
		' ', 0xccf5, 0xccf6, 0xccf7, ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', 0xccf8, ' ', ' ', 0xccf9, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xccfa, //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xccfb, 
		0xccfc, 0xccfd, ' ', ' ', ' ', ' ', ' ', 0xccfe, //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_89 = {
		' ', 0xcd41, ' ', ' ', ' ', ' ', 0xcd42, ' ', //0x0
		' ', ' ', ' ', ' ', ' ', 0xcd43, 0xcd44, 0xcd45, 
		' ', ' ', ' ', ' ', ' ', 0xcd46, 0xcd47, ' ', //0x10
		0xcd48, 0xcd49, 0xcd4a, ' ', ' ', ' ', ' ', ' ', 
		0xcd4b, ' ', ' ', ' ', ' ', ' ', 0xcd4c, 0xcd4d, //0x20
		0xcd4e, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xcd4f, 0xcd50, 0xcd51, ' ', ' ', 0xcd52, ' ', ' ', //0x30
		' ', 0xcd53, 0xcd54, ' ', ' ', ' ', 0xcd55, ' ', 
		0xcd56, ' ', 0xcd57, ' ', ' ', 0xcd58, 0xcd59, ' ', //0x40
		' ', 0xcd5a, ' ', ' ', ' ', ' ', ' ', 0xcd5b, 
		' ', ' ', 0xcd5c, ' ', ' ', ' ', ' ', 0xcd5d, //0x50
		' ', ' ', 0xcd5e, 0xcd5f, 0xcd60, ' ', ' ', ' ', 
		' ', 0xcd61, 0xcd62, 0xcd63, ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', 0xcd64, ' ', ' ', 0xcd65, ' ', 
		0xcd66, ' ', ' ', 0xcd67, ' ', 0xcd68, ' ', ' ', //0x70
		' ', ' ', 0xcd69, 0xcd6a, 0xcd6b, 0xcd6c, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', 0xcd6d, ' ', ' ', ' ', 0xcd6e, ' ', ' ', 
		0xcd6f, ' ', ' ', ' ', 0xcd70, 0xcd71, ' ', ' ', //0x90
		' ', ' ', ' ', 0xcd72, 0xcd73, ' ', ' ', 0xcd74, 
		0xcd75, ' ', ' ', ' ', ' ', 0xcd76, ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xcd77, ' ', ' ', ' ', 0xcd78, 0xcd79, 0xcd7a, 0xcd7b, //0xb0
		' ', ' ', ' ', ' ', 0xcd7c, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xcd7d, 0xcd7e, 0xcd7f, 0xcd80, //0xd0
		0xcd81, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xcd82, ' ', ' ', //0xe0
		' ', 0xcd83, ' ', 0xcd84, ' ', 0xcd85, ' ', ' ', 
		' ', 0xcd86, ' ', 0xcd87, ' ', ' ', 0xcd88, ' ', //0xf0
		' ', 0xcd89, ' ', ' ', ' ', 0xcd8a, ' ', 0xcd8b
	};
	protected static final char[] cvtbl_u_8a = {
		' ', ' ', ' ', ' ', 0xcd8c, 0xcd8d, ' ', 0xcd8e, //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xcd8f, 
		' ', 0xcd90, ' ', ' ', 0xcd91, 0xcd92, ' ', ' ', //0x10
		' ', ' ', ' ', ' ', ' ', ' ', 0xcd93, ' ', 
		0xcd94, ' ', 0xcd95, ' ', 0xcd96, ' ', 0xcd97, ' ', //0x20
		' ', ' ', ' ', 0xcd98, 0xcd99, ' ', ' ', 0xcd9a, 
		' ', ' ', ' ', ' ', ' ', 0xcd9b, ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', 0xcd9c, 0xcd9d, ' ', 
		0xcd9e, ' ', ' ', 0xcd9f, ' ', 0xcda0, ' ', 0xcda1, //0x40
		' ', 0xcda2, ' ', ' ', ' ', 0xcda3, 0xcda4, ' ', 
		' ', ' ', ' ', 0xcda5, ' ', ' ', 0xcda6, 0xcda7, //0x50
		0xcda8, ' ', ' ', ' ', 0xcda9, 0xcdaa, ' ', ' ', 
		' ', 0xcdab, ' ', ' ', ' ', 0xcdac, ' ', 0xcdad, //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xcdae, 0xcdaf, 0xcdb0, //0x70
		' ', ' ', 0xcdb1, 0xcdb2, ' ', ' ', 0xcdb3, 0xcdb4, 
		0xcdb5, ' ', ' ', 0xcdb6, ' ', ' ', 0xcdb7, ' ', //0x80
		' ', ' ', ' ', 0xcdb8, ' ', ' ', ' ', 0xcdb9, 
		0xcdba, ' ', 0xcdbb, ' ', ' ', ' ', 0xcdbc, 0xcdbd, //0x90
		' ', 0xcdbe, ' ', ' ', ' ', ' ', ' ', 0xcdbf, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', 0xcdc0, ' ', ' ', ' ', ' ', 0xcdc1, 0xcdc2, 
		' ', ' ', ' ', 0xcdc3, ' ', ' ', 0xcdc4, 0xcdc5, //0xb0
		' ', ' ', ' ', 0xcdc6, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xcdc7, ' ', ' ', 0xcdc8, ' ', //0xc0
		0xcdc9, 0xcdca, 0xcdcb, ' ', ' ', ' ', ' ', ' ', 
		' ', 0xcdcc, ' ', 0xcdcd, 0xcdce, 0xcdcf, ' ', 0xcdd0, //0xd0
		' ', ' ', ' ', ' ', ' ', 0xcdd1, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', 0xcdd2, ' ', ' ', ' ', 
		0xcdd3, ' ', ' ', ' ', 0xcdd4, 0xcdd5, ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', 0xcdd6, ' ', ' ', 0xcdd7
	};
	protected static final char[] cvtbl_u_8b = {
		' ', ' ', ' ', ' ', ' ', 0xcdd8, 0xcdd9, ' ', //0x0
		' ', ' ', 0xcdda, 0xcddb, ' ', ' ', ' ', ' ', 
		' ', 0xcddc, ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', ' ', ' ', 0xcddd, ' ', 0xcdde, 0xcddf, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', 0xcde0, ' ', ' ', 
		0xcde1, ' ', ' ', ' ', ' ', ' ', ' ', 0xcde2, //0x30
		' ', ' ', ' ', ' ', 0xcde3, ' ', ' ', ' ', 
		' ', ' ', 0xcde4, 0xcde5, 0xcde6, 0xcde7, 0xcde8, ' ', //0x40
		0xcde9, ' ', ' ', ' ', ' ', 0xcdea, ' ', ' ', 
		' ', ' ', 0xcdeb, ' ', 0xcdec, ' ', ' ', ' ', //0x50
		' ', 0xcded, ' ', ' ', ' ', ' ', 0xcdee, ' ', 
		' ', ' ', ' ', 0xcdef, ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', 0xcdf0, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xcdf1, ' ', //0x70
		0xcdf2, 0xcdf3, ' ', ' ', 0xcdf4, ' ', 0xcdf5, ' ', 
		' ', 0xcdf6, ' ', ' ', 0xcdf7, 0xcdf8, ' ', ' ', //0x80
		' ', ' ', ' ', 0xcdf9, ' ', 0xcdfa, ' ', 0xcdfb, 
		' ', ' ', ' ', ' ', 0xcdfc, 0xcdfd, ' ', ' ', //0x90
		' ', ' ', ' ', ' ', 0xcdfe, ' ', 0xce41, 0xce42, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_8c = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x30
		0xce43, 0xce44, ' ', ' ', ' ', 0xce45, 0xce46, ' ', 
		' ', ' ', ' ', ' ', ' ', 0xce47, ' ', 0xce48, //0x40
		' ', 0xce49, ' ', 0xce4a, ' ', ' ', ' ', 0xce4b, 
		' ', 0xce4c, ' ', 0xce4d, 0xce4e, ' ', ' ', 0xce4f, //0x50
		0xce50, 0xce51, ' ', 0xce52, ' ', 0xce53, ' ', ' ', 
		' ', ' ', ' ', 0xce54, 0xce55, ' ', 0xce56, ' ', //0x60
		0xce57, 0xce58, ' ', ' ', ' ', 0xce59, ' ', ' ', 
		' ', ' ', ' ', 0xce5a, ' ', 0xce5b, 0xce5c, ' ', //0x70
		' ', ' ', ' ', 0xce5d, ' ', ' ', 0xce5e, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xce5f, 0xce60, //0x80
		' ', ' ', ' ', 0xce61, ' ', ' ', ' ', ' ', 
		0xce62, ' ', 0xce63, 0xce64, ' ', ' ', ' ', ' ', //0x90
		' ', 0xce65, ' ', 0xce66, 0xce67, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xce68, ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', 0xce69, 0xce6a, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xce6b, 0xce6c, ' ', //0xc0
		' ', 0xce6d, ' ', 0xce6e, ' ', ' ', ' ', 0xce6f, 
		' ', ' ', ' ', ' ', ' ', 0xce70, 0xce71, ' ', //0xd0
		' ', 0xce72, ' ', ' ', ' ', 0xce73, ' ', ' ', 
		' ', 0xce74, ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		0xce75, ' ', ' ', ' ', 0xce76, ' ', ' ', 0xce77, 
		' ', ' ', 0xce78, ' ', ' ', 0xce79, ' ', 0xce7a, //0xf0
		0xce7b, ' ', ' ', ' ', ' ', ' ', 0xce7c, 0xce7d
	};
	protected static final char[] cvtbl_u_8d = {
		' ', 0xce7e, ' ', 0xce7f, ' ', ' ', ' ', ' ', //0x0
		' ', 0xce80, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xce81, //0x10
		' ', ' ', ' ', 0xce82, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xce83, ' ', ' ', //0x60
		' ', 0xce84, ' ', ' ', 0xce85, ' ', 0xce86, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xce87, 
		' ', ' ', 0xce88, ' ', 0xce89, ' ', ' ', ' ', //0x80
		0xce8a, ' ', ' ', ' ', ' ', 0xce8b, ' ', ' ', 
		0xce8c, 0xce8d, ' ', ' ', ' ', 0xce8e, ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', ' ', 0xce8f, 0xce90, 
		0xce91, ' ', ' ', ' ', ' ', ' ', 0xce92, ' ', //0xa0
		' ', ' ', ' ', 0xce93, 0xce94, ' ', ' ', 0xce95, 
		' ', ' ', 0xce96, ' ', ' ', 0xce97, ' ', 0xce98, //0xb0
		' ', 0xce99, ' ', 0xce9a, 0xce9b, ' ', ' ', ' ', 
		0xce9c, ' ', ' ', ' ', ' ', 0xce9d, 0xce9e, 0xce9f, //0xc0
		0xcea0, ' ', 0xcea1, ' ', ' ', ' ', 0xcea2, ' ', 
		' ', 0xcea3, ' ', ' ', 0xcea4, 0xcea5, ' ', 0xcea6, //0xd0
		' ', 0xcea7, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xcea8, 0xcea9, ' ', 0xceaa, //0xe0
		' ', ' ', ' ', ' ', 0xceab, ' ', ' ', ' ', 
		0xceac, 0xcead, 0xceae, ' ', 0xceaf, ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', 0xceb0, ' ', ' '
	};
	protected static final char[] cvtbl_u_8e = {
		' ', 0xceb1, ' ', ' ', 0xceb2, 0xceb3, 0xceb4, ' ', //0x0
		' ', ' ', ' ', 0xceb5, ' ', ' ', ' ', ' ', 
		' ', 0xceb6, ' ', ' ', 0xceb7, ' ', 0xceb8, ' ', //0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xceb9, 0xceba, 0xcebb, 0xcebc, ' ', ' ', 0xcebd, 0xcebe, //0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xcebf, ' ', 0xcec0, ' ', ' ', 0xcec1, 0xcec2, //0x30
		0xcec3, 0xcec4, ' ', ' ', ' ', 0xcec5, ' ', ' ', 
		0xcec6, 0xcec7, ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', ' ', 0xcec8, ' ', 0xcec9, 0xceca, 0xcecb, 
		' ', ' ', ' ', ' ', 0xcecc, ' ', ' ', ' ', //0x50
		' ', ' ', ' ', 0xcecd, 0xcece, 0xcecf, 0xced0, ' ', 
		' ', 0xced1, 0xced2, ' ', ' ', ' ', ' ', ' ', //0x60
		' ', 0xced3, ' ', ' ', 0xced4, 0xced5, ' ', 0xced6, 
		0xced7, 0xced8, ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', 0xced9, 0xceda, 0xcedb, ' ', ' ', ' ', ' ', 
		' ', ' ', 0xcedc, 0xcedd, ' ', ' ', ' ', ' ', //0x80
		' ', 0xcede, ' ', ' ', ' ', ' ', ' ', ' ', 
		0xcedf, ' ', 0xcee0, ' ', ' ', 0xcee1, ' ', ' ', //0x90
		' ', ' ', 0xcee2, 0xcee3, ' ', 0xcee4, 0xcee5, ' ', 
		' ', ' ', 0xcee6, ' ', ' ', ' ', ' ', 0xcee7, //0xa0
		' ', 0xcee8, ' ', ' ', ' ', 0xcee9, 0xceea, ' ', 
		' ', ' ', ' ', 0xceeb, ' ', 0xceec, ' ', ' ', //0xb0
		' ', ' ', 0xceed, 0xceee, ' ', ' ', ' ', ' ', 
		0xceef, 0xcef0, ' ', 0xcef1, 0xcef2, ' ', ' ', 0xcef3, //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xcef4, ' ', ' ', 0xcef5, ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', 0xcef6, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		0xcef7, ' ', ' ', ' ', ' ', 0xcef8, 0xcef9, ' ', 
		0xcefa, 0xcefb, ' ', ' ', ' ', ' ', ' ', 0xcefc, //0xf0
		' ', 0xcefd, 0xcefe, ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_8f = {
		0xcf41, ' ', 0xcf42, ' ', ' ', ' ', ' ', 0xcf43, //0x0
		0xcf44, ' ', ' ', ' ', ' ', ' ', ' ', 0xcf45, 
		0xcf46, ' ', ' ', ' ', ' ', ' ', 0xcf47, 0xcf48, //0x10
		0xcf49, ' ', ' ', ' ', ' ', ' ', 0xcf4a, ' ', 
		0xcf4b, 0xcf4c, ' ', 0xcf4d, ' ', 0xcf4e, ' ', 0xcf4f, //0x20
		0xcf50, ' ', ' ', ' ', 0xcf51, 0xcf52, 0xcf53, ' ', 
		' ', ' ', ' ', ' ', 0xcf54, 0xcf55, 0xcf56, 0xcf57, //0x30
		' ', ' ', 0xcf58, ' ', ' ', ' ', ' ', ' ', 
		0xcf59, 0xcf5a, ' ', 0xcf5b, ' ', ' ', ' ', 0xcf5c, //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xcf5d, 
		' ', 0xcf5e, 0xcf5f, 0xcf60, 0xcf61, 0xcf62, ' ', ' ', //0x50
		0xcf63, ' ', ' ', ' ', ' ', 0xcf64, 0xcf65, ' ', 
		' ', ' ', ' ', ' ', ' ', 0xcf66, ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', 0xcf67, ' ', ' ', 
		0xcf68, 0xcf69, ' ', ' ', 0xcf6a, 0xcf6b, 0xcf6c, ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xcf6d, 0xcf6e, ' ', //0xb0
		0xcf6f, ' ', ' ', ' ', ' ', ' ', 0xcf70, ' ', 
		0xcf71, 0xcf72, ' ', ' ', ' ', ' ', 0xcf73, ' ', //0xc0
		' ', ' ', 0xcf74, 0xcf75, ' ', 0xcf76, ' ', ' ', 
		0xcf77, ' ', 0xcf78, 0xcf79, ' ', 0xcf7a, ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xcf7b, ' ', ' ', 0xcf7c, 0xcf7d, ' ', ' ', ' ', //0xe0
		0xcf7e, ' ', ' ', ' ', ' ', ' ', 0xcf7f, ' ', 
		' ', 0xcf80, ' ', ' ', ' ', 0xcf81, 0xcf82, ' ', //0xf0
		' ', ' ', ' ', 0xcf83, ' ', ' ', 0xcf84, ' '
	};
	protected static final char[] cvtbl_u_90 = {
		' ', ' ', 0xcf85, ' ', 0xcf86, ' ', ' ', ' ', //0x0
		0xcf87, ' ', ' ', ' ', 0xcf88, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		0xcf89, ' ', ' ', 0xcf8a, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		0xcf8b, 0xcf8c, 0xcf8d, ' ', 0xcf8e, 0xcf8f, ' ', 0xcf90, 
		' ', ' ', ' ', 0xcf91, 0xcf92, ' ', ' ', 0xcf93, //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xcf94, 
		' ', ' ', ' ', 0xcf95, 0xcf96, ' ', ' ', ' ', //0x40
		' ', ' ', ' ', ' ', 0xcf97, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		' ', ' ', ' ', 0xcf98, ' ', 0xcf99, ' ', ' ', 
		' ', ' ', 0xcf9a, ' ', ' ', ' ', 0xcf9b, ' ', //0x60
		' ', ' ', ' ', ' ', 0xcf9c, ' ', ' ', ' ', 
		0xcf9d, ' ', ' ', ' ', 0xcf9e, ' ', ' ', ' ', //0x70
		' ', 0xcf9f, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xcfa0, ' ', ' ', //0x80
		0xcfa1, ' ', ' ', 0xcfa2, 0xcfa3, ' ', 0xcfa4, ' ', 
		0xcfa5, ' ', ' ', ' ', ' ', 0xcfa6, ' ', 0xcfa7, //0x90
		0xcfa8, 0xcfa9, ' ', 0xcfaa, ' ', ' ', ' ', ' ', 
		0xcfab, 0xcfac, 0xcfad, ' ', ' ', 0xcfae, ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xcfaf, ' ', 0xcfb0, 0xcfb1, 0xcfb2, ' ', 0xcfb3, ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', 0xcfb4, 0xcfb5, ' ', 
		' ', ' ', ' ', 0xcfb6, 0xcfb7, 0xcfb8, ' ', 0xcfb9, //0xc0
		0xcfba, ' ', ' ', ' ', 0xcfbb, ' ', ' ', ' ', 
		' ', ' ', 0xcfbc, ' ', ' ', 0xcfbd, ' ', 0xcfbe, //0xd0
		0xcfbf, 0xcfc0, ' ', ' ', 0xcfc1, 0xcfc2, ' ', 0xcfc3, 
		' ', ' ', ' ', ' ', ' ', 0xcfc4, ' ', ' ', //0xe0
		' ', ' ', ' ', 0xcfc5, ' ', ' ', ' ', 0xcfc6, 
		0xcfc7, ' ', ' ', ' ', 0xcfc8, ' ', 0xcfc9, ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', 0xcfca, 0xcfcb
	};
	protected static final char[] cvtbl_u_91 = {
		0xcfcc, ' ', ' ', ' ', 0xcfcd, 0xcfce, 0xcfcf, ' ', //0x0
		0xcfd0, ' ', ' ', ' ', ' ', 0xcfd1, ' ', ' ', 
		0xcfd2, ' ', ' ', ' ', 0xcfd3, ' ', 0xcfd4, 0xcfd5, //0x10
		0xcfd6, 0xcfd7, ' ', ' ', 0xcfd8, ' ', 0xcfd9, ' ', 
		0xcfda, ' ', 0xcfdb, 0xcfdc, ' ', 0xcfdd, ' ', ' ', //0x20
		' ', 0xcfde, ' ', ' ', ' ', ' ', 0xcfdf, 0xcfe0, 
		' ', 0xcfe1, ' ', ' ', 0xcfe2, ' ', 0xcfe3, 0xcfe4, //0x30
		' ', 0xcfe5, 0xcfe6, ' ', 0xcfe7, 0xcfe8, ' ', ' ', 
		' ', ' ', ' ', 0xcfe9, ' ', ' ', ' ', 0xcfea, //0x40
		0xcfeb, ' ', ' ', ' ', ' ', ' ', ' ', 0xcfec, 
		' ', ' ', ' ', 0xcfed, ' ', ' ', ' ', 0xcfee, //0x50
		' ', 0xcfef, 0xcff0, 0xcff1, ' ', ' ', ' ', ' ', 
		' ', 0xcff2, ' ', ' ', 0xcff3, ' ', ' ', 0xcff4, //0x60
		' ', ' ', ' ', ' ', ' ', 0xcff5, ' ', ' ', 
		' ', ' ', ' ', ' ', 0xcff6, ' ', ' ', ' ', //0x70
		' ', 0xcff7, 0xcff8, 0xcff9, ' ', ' ', ' ', ' ', 
		' ', 0xcffa, ' ', 0xcffb, ' ', 0xcffc, 0xcffd, ' ', //0x80
		' ', ' ', 0xcffe, ' ', ' ', ' ', 0xd041, ' ', 
		' ', 0xd042, ' ', 0xd043, 0xd044, 0xd045, ' ', ' ', //0x90
		0xd046, ' ', ' ', ' ', ' ', ' ', 0xd047, ' ', 
		' ', 0xd048, ' ', ' ', ' ', ' ', 0xd049, ' ', //0xa0
		0xd04a, ' ', ' ', ' ', 0xd04b, 0xd04c, 0xd04d, ' ', 
		0xd04e, 0xd04f, 0xd050, 0xd051, ' ', ' ', 0xd052, ' ', //0xb0
		' ', ' ', ' ', 0xd053, 0xd054, 0xd055, ' ', 0xd056, 
		' ', ' ', 0xd057, 0xd058, ' ', 0xd059, ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xd05a, 0xd05b, ' ', ' ', ' ', //0xd0
		' ', 0xd05c, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', 0xd05d, 0xd05e, ' ', 0xd05f, ' ', ' ', 0xd060, 
		0xd061, 0xd062, ' ', ' ', ' ', ' ', ' ', 0xd063, //0xf0
		' ', 0xd064, ' ', 0xd065, ' ', 0xd066, ' ', ' '
	};
	protected static final char[] cvtbl_u_92 = {
		0xd067, 0xd068, ' ', ' ', 0xd069, 0xd06a, ' ', 0xd06b, //0x0
		' ', 0xd06c, ' ', ' ', 0xd06d, ' ', ' ', ' ', 
		' ', ' ', 0xd06e, 0xd06f, ' ', ' ', 0xd070, ' ', //0x10
		0xd071, ' ', ' ', ' ', 0xd072, 0xd073, ' ', ' ', 
		' ', ' ', ' ', 0xd074, 0xd075, 0xd076, 0xd077, ' ', //0x20
		0xd078, ' ', ' ', ' ', ' ', ' ', 0xd079, 0xd07a, 
		0xd07b, ' ', ' ', 0xd07c, ' ', 0xd07d, 0xd07e, ' ', //0x30
		0xd07f, ' ', ' ', ' ', ' ', ' ', 0xd080, ' ', 
		' ', ' ', 0xd081, 0xd082, ' ', ' ', 0xd083, 0xd084, //0x40
		' ', ' ', 0xd085, ' ', ' ', 0xd086, ' ', 0xd087, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		0xd088, ' ', ' ', ' ', 0xd089, 0xd08a, ' ', ' ', 
		0xd08b, 0xd08c, ' ', ' ', ' ', 0xd08d, ' ', ' ', //0x60
		0xd08e, 0xd08f, ' ', ' ', ' ', ' ', 0xd090, 0xd091, 
		0xd092, ' ', ' ', ' ', ' ', 0xd093, 0xd094, ' ', //0x70
		' ', 0xd095, ' ', 0xd096, 0xd097, 0xd098, ' ', 0xd099, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', 0xd09a, 0xd09b, ' ', ' ', 0xd09c, 0xd09d, ' ', 
		' ', ' ', 0xd09e, ' ', ' ', ' ', ' ', 0xd09f, //0x90
		' ', 0xd0a0, ' ', ' ', ' ', ' ', ' ', 0xd0a1, 
		0xd0a2, ' ', ' ', ' ', 0xd0a3, 0xd0a4, ' ', ' ', //0xa0
		0xd0a5, ' ', ' ', 0xd0a6, ' ', ' ', ' ', 0xd0a7, 
		' ', ' ', 0xd0a8, ' ', ' ', ' ', 0xd0a9, ' ', //0xb0
		0xd0aa, ' ', 0xd0ab, 0xd0ac, 0xd0ad, 0xd0ae, ' ', 0xd0af, 
		0xd0b0, 0xd0b1, 0xd0b2, 0xd0b3, ' ', 0xd0b4, 0xd0b5, 0xd0b6, //0xc0
		0xd0b7, ' ', ' ', 0xd0b8, 0xd0b9, 0xd0ba, 0xd0bb, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		0xd0bc, ' ', ' ', ' ', 0xd0bd, 0xd0be, ' ', 0xd0bf, 
		' ', 0xd0c0, ' ', 0xd0c1, ' ', 0xd0c2, ' ', ' ', //0xe0
		0xd0c3, ' ', ' ', ' ', 0xd0c4, ' ', 0xd0c5, ' ', 
		0xd0c6, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_93 = {
		0xd0c7, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x0
		0xd0c8, ' ', ' ', ' ', ' ', 0xd0c9, ' ', ' ', 
		' ', 0xd0ca, ' ', ' ', 0xd0cb, 0xd0cc, ' ', ' ', //0x10
		' ', ' ', ' ', ' ', 0xd0cd, ' ', ' ', 0xd0ce, 
		' ', ' ', ' ', ' ', 0xd0cf, ' ', ' ', 0xd0d0, //0x20
		' ', 0xd0d1, 0xd0d2, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xd0d3, 0xd0d4, ' ', 0xd0d5, 0xd0d6, //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xd0d7, //0x40
		' ', 0xd0d8, ' ', ' ', ' ', ' ', ' ', ' ', 
		0xd0d9, 0xd0da, 0xd0db, ' ', ' ', 0xd0dc, ' ', ' ', //0x50
		0xd0dd, ' ', 0xd0de, ' ', ' ', ' ', 0xd0df, ' ', 
		' ', ' ', ' ', ' ', 0xd0e0, 0xd0e1, ' ', 0xd0e2, //0x60
		' ', 0xd0e3, 0xd0e4, ' ', ' ', 0xd0e5, ' ', 0xd0e6, 
		' ', 0xd0e7, ' ', 0xd0e8, 0xd0e9, ' ', 0xd0ea, ' ', //0x70
		' ', ' ', 0xd0eb, ' ', ' ', 0xd0ec, ' ', 0xd0ed, 
		0xd0ee, 0xd0ef, 0xd0f0, ' ', ' ', ' ', ' ', ' ', //0x80
		0xd0f1, ' ', 0xd0f2, 0xd0f3, ' ', 0xd0f4, ' ', 0xd0f5, 
		' ', ' ', 0xd0f6, ' ', ' ', 0xd0f7, ' ', ' ', //0x90
		0xd0f8, ' ', ' ', 0xd0f9, ' ', ' ', 0xd0fa, ' ', 
		' ', 0xd0fb, ' ', 0xd0fc, ' ', ' ', 0xd0fd, ' ', //0xa0
		0xd0fe, 0xd141, ' ', 0xd142, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xd143, 0xd144, 0xd145, ' ', //0xb0
		' ', ' ', 0xd146, ' ', ' ', ' ', ' ', ' ', 
		' ', 0xd147, ' ', ' ', 0xd148, 0xd149, ' ', 0xd14a, //0xc0
		' ', 0xd14b, 0xd14c, 0xd14d, 0xd14e, 0xd14f, ' ', ' ', 
		' ', ' ', ' ', 0xd150, ' ', ' ', ' ', ' ', //0xd0
		' ', 0xd151, ' ', ' ', 0xd152, ' ', ' ', 0xd153, 
		' ', ' ', 0xd154, ' ', ' ', ' ', 0xd155, 0xd156, //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xd157, //0xf0
		' ', 0xd158, 0xd159, 0xd15a, ' ', 0xd15b, ' ', ' '
	};
	protected static final char[] cvtbl_u_94 = {
		' ', 0xd15c, 0xd15d, ' ', 0xd15e, ' ', ' ', ' ', //0x0
		0xd15f, 0xd160, ' ', ' ', ' ', 0xd161, 0xd162, 0xd163, 
		' ', ' ', ' ', ' ', ' ', 0xd164, 0xd165, 0xd166, //0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xd167, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', ' ', 0xd168, 0xd169, 
		' ', ' ', 0xd16a, 0xd16b, 0xd16c, ' ', ' ', ' ', //0x30
		' ', ' ', ' ', 0xd16d, ' ', 0xd16e, ' ', 0xd16f, 
		' ', ' ', ' ', 0xd170, ' ', ' ', ' ', ' ', //0x40
		' ', ' ', 0xd171, ' ', 0xd172, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xd173, ' ', ' ', //0x50
		' ', 0xd174, ' ', ' ', 0xd175, ' ', ' ', 0xd176, 
		' ', 0xd177, ' ', 0xd178, ' ', ' ', ' ', ' ', //0x60
		0xd179, ' ', ' ', 0xd17a, ' ', 0xd17b, 0xd17c, 0xd17d, 
		' ', 0xd17e, 0xd17f, ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xd180, 0xd181, ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_95 = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		0xd182, 0xd183, ' ', ' ', ' ', ' ', 0xd184, ' ', 
		' ', ' ', ' ', ' ', 0xd185, ' ', ' ', ' ', //0x80
		0xd186, ' ', ' ', ' ', 0xd187, 0xd188, 0xd189, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', 0xd18a, 0xd18b, 0xd18c, 
		' ', 0xd18d, ' ', ' ', ' ', ' ', 0xd18e, ' ', //0xa0
		' ', 0xd18f, ' ', 0xd190, 0xd191, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xd192, ' ', 0xd193, ' ', //0xb0
		' ', ' ', 0xd194, ' ', ' ', 0xd195, ' ', 0xd196, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xd197, ' ', //0xc0
		0xd198, 0xd199, ' ', 0xd19a, ' ', ' ', ' ', ' ', 
		0xd19b, 0xd19c, 0xd19d, 0xd19e, ' ', ' ', ' ', ' ', //0xd0
		' ', 0xd19f, 0xd1a0, ' ', ' ', 0xd1a1, 0xd1a2, 0xd1a3, 
		0xd1a4, ' ', ' ', ' ', 0xd1a5, ' ', 0xd1a6, ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_96 = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', ' ', ' ', ' ', 0xd1a7, 0xd1a8, ' ', 
		' ', ' ', 0xd1a9, ' ', 0xd1aa, 0xd1ab, 0xd1ac, ' ', //0x20
		' ', ' ', ' ', ' ', 0xd1ad, ' ', ' ', ' ', 
		' ', 0xd1ae, ' ', 0xd1af, ' ', ' ', ' ', 0xd1b0, //0x30
		0xd1b1, 0xd1b2, 0xd1b3, ' ', 0xd1b4, 0xd1b5, ' ', ' ', 
		' ', 0xd1b6, ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xd1b7, ' ', 0xd1b8, ' ', 0xd1b9, 0xd1ba, //0x50
		0xd1bb, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xd1bc, ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', 0xd1bd, ' ', 
		' ', ' ', ' ', ' ', 0xd1be, ' ', ' ', ' ', //0x70
		' ', ' ', ' ', 0xd1bf, 0xd1c0, ' ', 0xd1c1, 0xd1c2, 
		' ', 0xd1c3, 0xd1c4, 0xd1c5, 0xd1c6, ' ', ' ', ' ', //0x80
		' ', 0xd1c7, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xd1c8, ' ', ' ', ' ', ' ', 0xd1c9, ' ', //0x90
		' ', ' ', 0xd1ca, ' ', ' ', ' ', ' ', 0xd1cb, 
		' ', ' ', ' ', ' ', 0xd1cc, 0xd1cd, 0xd1ce, ' ', //0xa0
		' ', 0xd1cf, ' ', ' ', ' ', ' ', 0xd1d0, ' ', 
		' ', ' ', ' ', 0xd1d1, ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', 0xd1d2, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', ' ', 0xd1d3, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xd1d4, ' ', ' ', ' ', ' ', ' ', //0xd0
		0xd1d5, ' ', 0xd1d6, ' ', ' ', 0xd1d7, 0xd1d8, 0xd1d9, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', 0xd1da, ' ', ' ', ' ', ' ', ' ', 0xd1db, 
		' ', 0xd1dc, ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', 0xd1dd, ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_97 = {
		' ', ' ', 0xd1de, 0xd1df, ' ', 0xd1e0, ' ', ' ', //0x0
		' ', 0xd1e1, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', 0xd1e2, 0xd1e3, ' ', 0xd1e4, ' ', ' ', 
		' ', 0xd1e5, 0xd1e6, 0xd1e7, ' ', ' ', ' ', ' ', //0x20
		0xd1e8, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xd1e9, ' ', ' ', ' ', ' ', ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xd1ea, ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', 0xd1eb, ' ', ' ', ' ', 0xd1ec, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xd1ed, //0x50
		0xd1ee, ' ', 0xd1ef, 0xd1f0, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xd1f1, ' ', ' ', ' ', 0xd1f2, //0x60
		' ', ' ', 0xd1f3, ' ', ' ', ' ', 0xd1f4, ' ', 
		' ', ' ', ' ', 0xd1f5, ' ', ' ', 0xd1f6, 0xd1f7, //0x70
		0xd1f8, ' ', ' ', 0xd1f9, ' ', 0xd1fa, ' ', 0xd1fb, 
		0xd1fc, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', 0xd1fd, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xd1fe, 0xd241, 0xd242, //0x90
		' ', 0xd243, 0xd244, ' ', ' ', ' ', 0xd245, 0xd246, 
		' ', ' ', 0xd247, ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', 0xd248, ' ', 0xd249, ' ', 
		' ', 0xd24a, 0xd24b, ' ', ' ', 0xd24c, 0xd24d, ' ', //0xb0
		0xd24e, 0xd24f, 0xd250, ' ', 0xd251, ' ', 0xd252, 0xd253, 
		' ', 0xd254, ' ', ' ', 0xd255, 0xd256, ' ', 0xd257, //0xc0
		' ', 0xd258, 0xd259, ' ', 0xd25a, 0xd25b, 0xd25c, ' ', 
		0xd25d, 0xd25e, ' ', ' ', 0xd25f, ' ', ' ', 0xd260, //0xd0
		0xd261, 0xd262, ' ', 0xd263, ' ', 0xd264, 0xd265, ' ', 
		0xd266, 0xd267, ' ', ' ', 0xd268, ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xd269, 
		' ', 0xd26a, ' ', ' ', 0xd26b, ' ', ' ', 0xd26c, //0xf0
		0xd26d, ' ', 0xd26e, ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_98 = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xd26f, //0x0
		' ', ' ', 0xd270, ' ', ' ', 0xd271, 0xd272, ' ', 
		' ', ' ', ' ', ' ', 0xd273, ' ', 0xd274, ' ', //0x10
		' ', 0xd275, ' ', ' ', 0xd276, ' ', 0xd277, ' ', 
		0xd278, ' ', ' ', 0xd279, ' ', 0xd27a, 0xd27b, ' ', //0x20
		' ', ' ', ' ', 0xd27c, ' ', ' ', 0xd27d, 0xd27e, 
		0xd27f, ' ', 0xd280, 0xd281, ' ', 0xd282, ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', 0xd283, ' ', 
		' ', ' ', ' ', ' ', 0xd284, ' ', ' ', 0xd285, //0x40
		' ', ' ', 0xd286, ' ', ' ', ' ', ' ', ' ', 
		' ', 0xd287, 0xd288, 0xd289, ' ', ' ', 0xd28a, ' ', //0x50
		' ', 0xd28b, 0xd28c, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xd28d, 0xd28e, ' ', ' ', 0xd28f, ' ', //0x60
		' ', ' ', 0xd290, ' ', 0xd291, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', 0xd292, ' ', 0xd293, 0xd294, ' ', 
		0xd295, ' ', ' ', ' ', 0xd296, ' ', ' ', 0xd297, //0xb0
		0xd298, ' ', 0xd299, 0xd29a, ' ', ' ', ' ', 0xd29b, 
		' ', ' ', 0xd29c, ' ', ' ', 0xd29d, ' ', ' ', //0xc0
		0xd29e, ' ', ' ', ' ', 0xd29f, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xd2a0, ' ', 0xd2a1, ' ', 0xd2a2, 0xd2a3, 0xd2a4, //0xe0
		' ', ' ', 0xd2a5, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xd2a6, ' ', ' ', 0xd2a7, ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_99 = {
		' ', ' ', 0xd2a8, ' ', ' ', ' ', ' ', 0xd2a9, //0x0
		0xd2aa, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xd2ab, ' ', ' ', ' ', 0xd2ac, 0xd2ad, 0xd2ae, //0x10
		' ', ' ', 0xd2af, 0xd2b0, 0xd2b1, ' ', ' ', 0xd2b2, 
		' ', ' ', 0xd2b3, ' ', ' ', ' ', 0xd2b4, ' ', //0x20
		' ', ' ', ' ', 0xd2b5, ' ', ' ', ' ', ' ', 
		' ', 0xd2b6, 0xd2b7, 0xd2b8, 0xd2b9, 0xd2ba, ' ', ' ', //0x30
		' ', 0xd2bb, 0xd2bc, 0xd2bd, 0xd2be, ' ', ' ', ' ', 
		0xd2bf, 0xd2c0, ' ', ' ', ' ', ' ', 0xd2c1, 0xd2c2, //0x40
		0xd2c3, ' ', ' ', ' ', ' ', 0xd2c4, 0xd2c5, ' ', 
		' ', ' ', ' ', ' ', 0xd2c6, ' ', ' ', ' ', //0x50
		0xd2c7, 0xd2c8, ' ', 0xd2c9, 0xd2ca, ' ', 0xd2cb, 0xd2cc, 
		0xd2cd, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', ' ', 0xd2ce, ' ', 0xd2cf, ' ', 0xd2d0, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xd2d1, ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xd2d2, 0xd2d3, 0xd2d4, ' ', ' ', 0xd2d5, ' ', ' ', //0xb0
		' ', 0xd2d6, 0xd2d7, ' ', ' ', 0xd2d8, ' ', 0xd2d9, 
		' ', ' ', ' ', 0xd2da, ' ', ' ', ' ', ' ', //0xc0
		' ', 0xd2db, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xd2dc, 0xd2dd, ' ', ' ', ' ', //0xd0
		' ', 0xd2de, 0xd2df, ' ', 0xd2e0, ' ', 0xd2e1, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xd2e2, //0xe0
		' ', ' ', 0xd2e3, 0xd2e4, 0xd2e5, ' ', ' ', ' ', 
		0xd2e6, ' ', ' ', ' ', 0xd2e7, 0xd2e8, ' ', ' ', //0xf0
		' ', 0xd2e9, ' ', ' ', ' ', 0xd2ea, 0xd2eb, ' '
	};
	protected static final char[] cvtbl_u_9a = {
		' ', ' ', 0xd2ec, 0xd2ed, 0xd2ee, ' ', ' ', ' ', //0x0
		' ', ' ', ' ', 0xd2ef, 0xd2f0, ' ', ' ', ' ', 
		0xd2f1, 0xd2f2, ' ', ' ', ' ', ' ', 0xd2f3, ' ', //0x10
		' ', ' ', ' ', ' ', ' ', ' ', 0xd2f4, ' ', 
		0xd2f5, ' ', 0xd2f6, 0xd2f7, 0xd2f8, ' ', ' ', 0xd2f9, //0x20
		' ', ' ', ' ', ' ', ' ', 0xd2fa, 0xd2fb, ' ', 
		' ', ' ', ' ', 0xd2fc, ' ', 0xd2fd, 0xd2fe, ' ', //0x30
		0xd341, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xd342, ' ', ' ', 0xd343, ' ', ' ', 0xd344, //0x40
		' ', ' ', 0xd345, 0xd346, 0xd347, ' ', ' ', ' ', 
		' ', 0xd348, ' ', ' ', 0xd349, ' ', 0xd34a, ' ', //0x50
		' ', ' ', ' ', ' ', ' ', 0xd34b, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', 0xd34c, ' ', 0xd34d, ' ', 0xd34e, 0xd34f, 
		' ', ' ', 0xd350, ' ', 0xd351, 0xd352, 0xd353, ' ', //0xb0
		' ', 0xd354, ' ', 0xd355, ' ', ' ', 0xd356, 0xd357, 
		' ', 0xd358, ' ', 0xd359, ' ', ' ', 0xd35a, ' ', //0xc0
		0xd35b, ' ', ' ', ' ', ' ', ' ', 0xd35c, ' ', 
		0xd35d, ' ', 0xd35e, ' ', ' ', 0xd35f, 0xd360, 0xd361, //0xd0
		' ', ' ', ' ', 0xd362, ' ', ' ', ' ', ' ', 
		0xd363, ' ', ' ', ' ', 0xd364, 0xd365, ' ', 0xd366, //0xe0
		' ', 0xd367, ' ', ' ', 0xd368, ' ', ' ', ' ', 
		' ', ' ', 0xd369, 0xd36a, ' ', 0xd36b, ' ', ' ', //0xf0
		' ', 0xd36c, 0xd36d, ' ', ' ', 0xd36e, ' ', 0xd36f
	};
	protected static final char[] cvtbl_u_9b = {
		0xd370, 0xd371, 0xd372, 0xd373, 0xd374, 0xd375, ' ', ' ', //0x0
		0xd376, 0xd377, ' ', 0xd378, 0xd379, 0xd37a, 0xd37b, ' ', 
		0xd37c, ' ', 0xd37d, ' ', ' ', ' ', 0xd37e, ' ', //0x10
		' ', 0xd37f, ' ', 0xd380, 0xd381, ' ', ' ', ' ', 
		0xd382, ' ', ' ', ' ', ' ', ' ', 0xd383, ' ', //0x20
		' ', ' ', ' ', 0xd384, ' ', 0xd385, ' ', ' ', 
		' ', ' ', ' ', 0xd386, 0xd387, 0xd388, ' ', 0xd389, //0x30
		' ', 0xd38a, 0xd38b, ' ', ' ', 0xd38c, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		0xd38d, ' ', ' ', 0xd38e, 0xd38f, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xd390, 0xd391, 0xd392, //0x50
		' ', ' ', ' ', 0xd393, ' ', ' ', 0xd394, ' ', 
		' ', 0xd395, ' ', 0xd396, ' ', 0xd397, 0xd398, ' ', //0x60
		0xd399, ' ', 0xd39a, 0xd39b, 0xd39c, 0xd39d, 0xd39e, ' ', 
		' ', ' ', ' ', 0xd39f, ' ', ' ', ' ', 0xd3a0, //0x70
		0xd3a1, 0xd3a2, ' ', ' ', ' ', ' ', ' ', 0xd3a3, 
		0xd3a4, ' ', ' ', ' ', 0xd3a5, 0xd3a6, 0xd3a7, 0xd3a8, //0x80
		' ', 0xd3a9, 0xd3aa, 0xd3ab, ' ', 0xd3ac, ' ', ' ', 
		0xd3ad, ' ', ' ', ' ', 0xd3ae, ' ', ' ', ' ', //0x90
		' ', ' ', 0xd3af, ' ', ' ', 0xd3b0, 0xd3b1, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xd3b2, 0xd3b3, //0xa0
		' ', 0xd3b4, ' ', ' ', 0xd3b5, ' ', ' ', ' ', 
		0xd3b6, ' ', 0xd3b7, ' ', ' ', ' ', ' ', 0xd3b8, //0xb0
		0xd3b9, ' ', ' ', ' ', 0xd3ba, ' ', 0xd3bb, 0xd3bc, 
		' ', 0xd3bd, ' ', ' ', ' ', ' ', ' ', 0xd3be, //0xc0
		0xd3bf, ' ', ' ', ' ', ' ', ' ', 0xd3c0, ' ', 
		0xd3c1, ' ', ' ', ' ', ' ', ' ', ' ', 0xd3c2, //0xd0
		0xd3c3, ' ', ' ', ' ', ' ', 0xd3c4, ' ', 0xd3c5, 
		' ', ' ', ' ', ' ', ' ', 0xd3c6, ' ', 0xd3c7, //0xe0
		' ', ' ', 0xd3c8, 0xd3c9, ' ', ' ', ' ', 0xd3ca, 
		' ', ' ', ' ', 0xd3cb, ' ', ' ', ' ', 0xd3cc, //0xf0
		0xd3cd, 0xd3ce, 0xd3cf, ' ', ' ', 0xd3d0, ' ', 0xd3d1
	};
	protected static final char[] cvtbl_u_9c = {
		' ', ' ', 0xd3d2, ' ', ' ', ' ', ' ', ' ', //0x0
		' ', ' ', ' ', 0xd3d3, ' ', ' ', ' ', 0xd3d4, 
		' ', 0xd3d5, ' ', ' ', ' ', ' ', 0xd3d6, ' ', //0x10
		0xd3d7, 0xd3d8, 0xd3d9, ' ', 0xd3da, ' ', 0xd3db, ' ', 
		' ', ' ', 0xd3dc, 0xd3dd, ' ', ' ', 0xd3de, 0xd3df, //0x20
		0xd3e0, 0xd3e1, 0xd3e2, ' ', ' ', ' ', ' ', ' ', 
		' ', 0xd3e3, ' ', ' ', ' ', 0xd3e4, 0xd3e5, 0xd3e6, //0x30
		' ', ' ', ' ', ' ', ' ', 0xd3e7, ' ', ' ', 
		' ', 0xd3e8, ' ', 0xd3e9, 0xd3ea, 0xd3eb, ' ', ' ', //0x40
		' ', 0xd3ec, 0xd3ed, ' ', ' ', ' ', 0xd3ee, 0xd3ef, 
		0xd3f0, ' ', ' ', 0xd3f1, 0xd3f2, ' ', 0xd3f3, ' ', //0x50
		0xd3f4, ' ', ' ', 0xd3f5, 0xd3f6, 0xd3f7, 0xd3f8, 0xd3f9, 
		' ', ' ', ' ', 0xd3fa, ' ', ' ', ' ', ' ', //0x60
		0xd3fb, 0xd3fc, 0xd3fd, 0xd3fe, ' ', ' ', 0xd441, ' ', 
		0xd442, ' ', 0xd443, ' ', ' ', 0xd444, ' ', 0xd445, //0x70
		' ', ' ', ' ', 0xd446, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xd447, ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xd448, ' ', ' ', ' ', ' ', 0xd449, //0xf0
		' ', 0xd44a, ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_9d = {
		' ', ' ', 0xd44b, ' ', ' ', ' ', ' ', ' ', //0x0
		' ', ' ', ' ', 0xd44c, ' ', ' ', ' ', ' ', 
		' ', 0xd44d, ' ', ' ', ' ', ' ', ' ', 0xd44e, //0x10
		0xd44f, ' ', ' ', ' ', 0xd450, 0xd451, 0xd452, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xd453, 
		0xd454, ' ', 0xd455, 0xd456, 0xd457, ' ', ' ', ' ', //0x30
		' ', ' ', 0xd458, ' ', 0xd459, 0xd45a, ' ', ' ', 
		' ', ' ', 0xd45b, 0xd45c, ' ', 0xd45d, ' ', 0xd45e, //0x40
		' ', ' ', 0xd45f, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xd460, 0xd461, ' ', ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xd462, 
		' ', ' ', 0xd463, 0xd464, ' ', 0xd465, ' ', ' ', //0x60
		' ', 0xd466, 0xd467, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xd468, 0xd469, //0x70
		' ', ' ', ' ', 0xd46a, 0xd46b, ' ', 0xd46c, ' ', 
		' ', ' ', ' ', 0xd46d, 0xd46e, ' ', 0xd46f, ' ', //0x80
		' ', ' ', 0xd470, ' ', ' ', 0xd471, 0xd472, ' ', 
		' ', ' ', 0xd473, 0xd474, ' ', 0xd475, 0xd476, 0xd477, //0x90
		0xd478, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xd479, ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', 0xd47a, ' ', 0xd47b, ' ', 0xd47c, ' ', 
		' ', 0xd47d, ' ', ' ', ' ', 0xd47e, ' ', ' ', //0xb0
		' ', 0xd47f, ' ', ' ', 0xd480, ' ', ' ', 0xd481, 
		' ', ' ', ' ', 0xd482, ' ', ' ', ' ', 0xd483, //0xc0
		' ', 0xd484, 0xd485, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xd486, 0xd487, 0xd488, 0xd489, //0xd0
		' ', ' ', 0xd48a, ' ', ' ', ' ', 0xd48b, 0xd48c, 
		0xd48d, ' ', ' ', ' ', ' ', 0xd48e, ' ', 0xd48f, //0xe0
		' ', 0xd490, ' ', 0xd491, ' ', ' ', 0xd492, ' ', 
		0xd493, ' ', ' ', 0xd494, 0xd495, ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', 0xd496, ' '
	};
	protected static final char[] cvtbl_u_9e = {
		' ', ' ', 0xd497, ' ', ' ', ' ', ' ', 0xd498, //0x0
		' ', ' ', 0xd499, ' ', ' ', ' ', 0xd49a, ' ', 
		0xd49b, 0xd49c, 0xd49d, ' ', ' ', 0xd49e, 0xd49f, ' ', //0x10
		' ', ' ', ' ', ' ', 0xd4a0, 0xd4a1, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', 0xd4a2, 0xd4a3, 0xd4a4, ' ', ' ', ' ', 
		0xd4a5, ' ', 0xd4a6, 0xd4a7, 0xd4a8, 0xd4a9, ' ', 0xd4aa, //0x80
		' ', ' ', ' ', ' ', ' ', ' ', 0xd4ab, 0xd4ac, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xd4ad, ' ', //0x90
		0xd4ae, ' ', ' ', 0xd4af, ' ', ' ', 0xd4b0, ' ', 
		' ', ' ', ' ', ' ', 0xd4b1, ' ', ' ', ' ', //0xa0
		0xd4b2, ' ', ' ', ' ', 0xd4b3, ' ', 0xd4b4, 0xd4b5, 
		0xd4b6, ' ', ' ', 0xd4b7, 0xd4b8, 0xd4b9, ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xd4ba, ' ', //0xc0
		0xd4bb, ' ', ' ', 0xd4bc, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xd4bd, ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xd4be, 
		' ', ' ', ' ', ' ', 0xd4bf, ' ', ' ', 0xd4c0, //0xe0
		' ', ' ', ' ', ' ', 0xd4c1, 0xd4c2, 0xd4c3, ' ', 
		0xd4c4, 0xd4c5, 0xd4c6, ' ', ' ', 0xd4c7, ' ', ' ', //0xf0
		0xd4c8, ' ', ' ', ' ', ' ', ' ', ' ', 0xd4c9
	};
	protected static final char[] cvtbl_u_9f = {
		' ', ' ', 0xd4ca, 0xd4cb, ' ', ' ', ' ', ' ', //0x0
		' ', 0xd4cc, ' ', ' ', ' ', ' ', ' ', 0xd4cd, 
		0xd4ce, 0xd4cf, 0xd4d0, ' ', 0xd4d1, ' ', 0xd4d2, 0xd4d3, //0x10
		' ', 0xd4d4, 0xd4d5, 0xd4d6, ' ', ' ', ' ', 0xd4d7, 
		' ', ' ', 0xd4d8, ' ', ' ', ' ', 0xd4d9, ' ', //0x20
		' ', ' ', 0xd4da, 0xd4db, ' ', ' ', ' ', 0xd4dc, 
		' ', 0xd4dd, 0xd4de, ' ', 0xd4df, ' ', ' ', 0xd4e0, //0x30
		' ', 0xd4e1, 0xd4e2, ' ', 0xd4e3, 0xd4e4, ' ', 0xd4e5, 
		' ', 0xd4e6, ' ', 0xd4e7, 0xd4e8, 0xd4e9, 0xd4ea, 0xd4eb, //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xd4ec, ' ', 0xd4ed, 0xd4ee, 0xd4ef, //0x50
		0xd4f0, ' ', 0xd4f1, ' ', ' ', 0xd4f2, 0xd4f3, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		0xd4f4, 0xd4f5, ' ', ' ', ' ', 0xd4f6, 0xd4f7, 0xd4f8, 
		0xd4f9, 0xd4fa, ' ', 0xd4fb, ' ', 0xd4fc, ' ', ' ', //0x70
		' ', ' ', 0xd4fd, ' ', ' ', 0xd4fe, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xd541, 
		0xd542, 0xd543, 0xd544, ' ', 0xd545, ' ', 0xd546, 0xd547, //0x90
		' ', ' ', ' ', ' ', ' ', ' ', 0xd548, ' ', 
		' ', 0xd549, 0xd54a, 0xd54b, ' ', 0xd54c, ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_ff = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x00
		' ', ' ', ' ', ' ', ' ', 0xe9f3, ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x50
		' ', ' ', ' ', ' ', ' ', ' ', 0xe9f4, ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', 0xe9f5, ' ', ' ', ' ',	//0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};

}