/**
 * Title: tn5250J
 * Copyright:   Copyright (c) 2001
 * Company:
 * @author  Kenneth J. Pouncey
 * @version 0.5
 * 
 * Modified by pei DEC/2004
 * 
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j;

import java.util.*;
import java.net.Socket;
import java.io.*;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

import je.tn5250j.encoding.CodePage;
import je.tn5250j.encoding.CharMappings;
import je.tn5250j.transport.SocketConnector;
import je.tn5250j.tools.*;
import je.tn5250j.event.*;
import je.tn5250j.keyboard.*;

public final class tnvt implements Runnable, TN5250jConstants {

	Socket sock;
	BufferedInputStream bin;
	BufferedOutputStream bout;
	DataStreamQueue dsq;
	Stream5250 bk;
	DataStreamProducer producer;
	private Screen5250 screen52;
	private boolean waitingForInput;
	boolean invited;
	private boolean dumpBytes = false;
	private boolean negotiated = false;
	private Thread me;
	private Thread pthread;
	private int readType;
	private boolean enhanced = true;
	private Session controller;
	private boolean cursorOn = false;
	private String session = "";
	private int port = 23;
	private boolean connected = false;
	private boolean support132 = true;
	ByteArrayOutputStream baosp = null;
	ByteArrayOutputStream baosrsp = null;
	byte[] saveStream;
	private boolean proxySet = false;
	private String proxyHost = null;
	private String proxyPort = "1080";
	private int devSeq = 0;
	private String devName;
	private String devNameUsed;
	private String user;
	private String password;
	private String library;
	private String initialMenu;
	private String program;
	private boolean keepTrucking = true;
	private boolean pendingUnlock = false;

	private boolean[] dataIncluded;

	private CodePage codePage;
	private CodePage alt_codePage;

	private FileOutputStream fw;
	private BufferedOutputStream dw;
	private boolean firstScreen;
	private boolean onConnect;
	private String connectMacro;
	private String sslType;
	private DataStreamTracer tracer;
	private boolean auto_reconnect;
	private int retry_sleep;
	private boolean stop= false;
	private String cmd;
	private Thread pcowait= null;

	tnvt(Screen5250 screen52) {

		this(screen52, false, false);

	}

	tnvt(Screen5250 screen52, boolean type, boolean support132) {

		cmd= System.getProperty("os.name").equals("Windows 98") ? "command" : "cmd";
		enhanced = type;
		this.support132 = support132;
		String trc_file = screen52.getStringProperty("debug");
		// chg pei 070124 OɃZbVID擾
		//tracer = new DataStreamTracer();
		tracer = new DataStreamTracer(screen52.getSessionID());
		
		if (trc_file != null && trc_file.length() != 0) {
			tracer.setFName(trc_file);
			tracer.setDebug(true);
		}
		String cdpg = screen52.getStringProperty("codepage");
		if (cdpg == null)
			cdpg = "930-2";
		setCodePage(cdpg);
		this.screen52 = screen52;
		dataIncluded = new boolean[24];

		if (System.getProperties().containsKey("SESSION_CONNECT_USER")) {
			user = System.getProperties().getProperty("SESSION_CONNECT_USER");
			if (System.getProperties().containsKey("SESSION_CONNECT_PASSWORD"))
				password =
					System.getProperties().getProperty(
						"SESSION_CONNECT_PASSWORD");
			if (System.getProperties().containsKey("SESSION_CONNECT_LIBRARY"))
				library =
					System.getProperties().getProperty(
						"SESSION_CONNECT_LIBRARY");
			if (System.getProperties().containsKey("SESSION_CONNECT_MENU"))
				initialMenu =
					System.getProperties().getProperty("SESSION_CONNECT_MENU");
			if (System.getProperties().containsKey("SESSION_CONNECT_PROGRAM"))
				program =
					System.getProperties().getProperty(
						"SESSION_CONNECT_PROGRAM");
		}

		baosp = new ByteArrayOutputStream();
		baosrsp = new ByteArrayOutputStream();
	
		// add by pei JUL/2005		
		auto_reconnect= !"false".equals(screen52.getStringProperty("autoreconnect"));
		String sretry_sleep= screen52.getStringProperty("connect.retry.interval");
		try {
			retry_sleep= Integer.parseInt(sretry_sleep) * 1000;
		} catch (Exception e) {
			retry_sleep= 30000;			// default 30 sec.
		}
	}

	public String getHostName() {

		return session;
	}

	public void setController(Session c) {

		controller = c;

		// We will now see if there are any bypass signon parameters to be
		//    processed.  The system properties override these parameters so
		//    have precidence if specified.
		Properties props = controller.getConfiguration().getProperties();
		if (user == null && props.containsKey("connect.user")) {
			user = props.getProperty("connect.user");
			if (props.containsKey("connect.password"))
				password = props.getProperty("connect.password");
			if (props.containsKey("connect.library"))
				library = props.getProperty("connect.library");
			if (props.containsKey("connect.menu"))
				initialMenu = props.getProperty("connect.menu");
			if (props.containsKey("connect.program"))
				program = props.getProperty("connect.program");
		}

	}

	public void setSSLType(String type) {
		sslType = type;
	}

	public void setDeviceName(String name) {

		devName = name;

	}

	public String getDeviceName() {
		return devName;
	}

	public String getAllocatedDeviceName() {
		return devNameUsed;
	}

	public boolean isConnected() {

		return connected;
	}

	public final boolean connect() {
		return connect(session, port);

	}

	public final void setProxy(String proxyHost, String proxyPort) {

		this.proxyHost = proxyHost;
		this.proxyPort = proxyPort;
		proxySet = true;

		Properties systemProperties = System.getProperties();
		systemProperties.put("socksProxySet", "true");
		systemProperties.put("socksProxyHost", proxyHost);
		systemProperties.put("socksProxyPort", proxyPort);

		System.setProperties(systemProperties);
		System.out.println(" socks set ");
	}

	public final boolean connect(String s, int port) {

		try {
			session = s;
			this.port = port;

			try {
				SwingUtilities.invokeAndWait(new Runnable() {
					public void run() {
						screen52.setStatus(
							Screen5250.STATUS_SYSTEM,
							Screen5250.STATUS_VALUE_ON,
							"X - Connecting");

					}
				});

			} catch (Exception exc) {
				System.out.println("setStatus(ON) " + exc);

			}

			//         sock = new Socket(s, port);
			//smk - For SSL compability
			SocketConnector sc = new SocketConnector();
			if (sslType != null)
				sc.setSSLType(sslType);
			while (true) {	// add by pei JUL/2005
				sock = sc.createSocket(s, port);

				if (sock != null) break;
				SwingUtilities.invokeAndWait(new Runnable() {
					public void run() {
						screen52.setStatus(
							Screen5250.STATUS_SYSTEM,
							Screen5250.STATUS_VALUE_ON,
							"X - Connecting retry");

					}
				});
				Thread.sleep(retry_sleep);
				if (stop) return (false);
			}

			connected = true;
			// used for JDK1.3
			sock.setKeepAlive(true);
			sock.setTcpNoDelay(true);
			sock.setSoLinger(false, 0);
			InputStream in = sock.getInputStream();
			OutputStream out = sock.getOutputStream();

			bin = new BufferedInputStream(in, 8192);
			bout = new BufferedOutputStream(out);

			byte abyte0[];
			while (negotiate(abyte0 = readNegotiations()));
			negotiated = true;
			try {
				screen52.setCursorActive(false);
			} catch (Exception excc) {
				System.out.println("setCursorOff " + excc);

			};

			dsq = new DataStreamQueue();
			producer = new DataStreamProducer(this, bin, dsq, abyte0, tracer);
			pthread = new Thread(producer);
			//         pthread.setPriority(pthread.MIN_PRIORITY);
			pthread.setPriority(Thread.NORM_PRIORITY / 2);
			pthread.start();

			try {
				SwingUtilities.invokeAndWait(new Runnable() {
					public void run() {
						screen52.setStatus(
							Screen5250.STATUS_SYSTEM,
							Screen5250.STATUS_VALUE_OFF,
							null);
					}
				});

			} catch (Exception exc) {
				System.out.println("setStatus(OFF) " + exc);
			}

			keepTrucking = true;
			me = new Thread(this);
			me.start();

		} catch (Exception exception) {
			if (exception.getMessage() == null)
				exception.printStackTrace();
			System.out.println("connect() " + exception);

			if (sock == null)
				System.out.println("I did not get a socket");

			disconnect();
			return false;
		}
		return true;

	}

	public final boolean disconnect() {

		if (me != null && me.isAlive()) {
			me.interrupt();
			keepTrucking = false;
			pthread.interrupt();
		}
		screen52.clearScreen_onerr();
		screen52.setStatus(
			Screen5250.STATUS_SYSTEM,
			Screen5250.STATUS_VALUE_ON,
			"X - Disconnected");
		screen52.setKeyboardLocked(false);
		pendingUnlock = false;
		stop= true;

		try {
			if (sock != null) {
				System.out.println("Closing socket");
				sock.close();
			}
			if (bin != null)
				bin.close();
			if (bout != null)
				bout.close();

			connected = false;
			firstScreen = false;
			controller.fireSessionChanged(TN5250jConstants.STATE_DISCONNECTED);

		} catch (Exception exception) {
			System.out.println(exception);
			connected = false;
			devSeq = 0;
			return false;

		}
		devSeq = 0;
		return true;
	}

	private final ByteArrayOutputStream appendByteStream(byte abyte0[]) {
		ByteArrayOutputStream bytearrayoutputstream =
			new ByteArrayOutputStream();
		for (int i = 0; i < abyte0.length; i++) {
			bytearrayoutputstream.write(abyte0[i]);
			if (abyte0[i] == -1)
				bytearrayoutputstream.write(-1);
		}

		return bytearrayoutputstream;
	}

	private final byte[] readNegotiations() throws IOException {
		int i = bin.read();
		if (i < 0) {
			throw new IOException("Connection closed.");
		} else {
			int j = bin.available();
			byte abyte0[] = new byte[j + 1];
			abyte0[0] = (byte) i;
			bin.read(abyte0, 1, j);
			tracer.dump(abyte0, 0);
			return abyte0;
		}
	}

	private final void writeByte(byte abyte0[]) throws IOException {

		bout.write(abyte0);
		bout.flush();
		tracer.dump(abyte0, 1);
	}

	private final void writeByte(byte byte0) throws IOException {

		bout.write(byte0);
		bout.flush();
	}

	protected final void sendHeartBeat() throws IOException {
		/*
		byte[] b = {(byte) 0xff, (byte) 0xf1 };
		bout.write(b);
		bout.flush();
		*/
		if (pthread.isAlive()) {
			System.out.println("ALIVE");
		} else {
			System.out.println("DEAD");
		}			
	}

	private final void readImmediate(int readType) {

		if (screen52.isStatusErrorCode()) {
			screen52.restoreErrorLine();
			screen52.setStatus(
				Screen5250.STATUS_ERROR_CODE,
				Screen5250.STATUS_VALUE_OFF,
				null);
		}

		if (!enhanced) {
			screen52.setCursorActive(false);
		}
		screen52.setStatus(
			Screen5250.STATUS_SYSTEM,
			Screen5250.STATUS_VALUE_ON,
			null);

		screen52.setKeyboardLocked(true);
		pendingUnlock = false;
		invited = false;

		screen52.getScreenFields().readFormatTable(baosp, readType, codePage);

		try {

			writeGDS(0, 3, baosp.toByteArray());
		} catch (IOException ioe) {

			System.out.println(ioe);
			baosp.reset();
		}
		baosp.reset();

	}

	public final boolean sendAidKey(int aid) {

		if (screen52.isStatusErrorCode()) {
			screen52.restoreErrorLine();
			screen52.setStatus(
				Screen5250.STATUS_ERROR_CODE,
				Screen5250.STATUS_VALUE_OFF,
				null);
		}

		if (!enhanced) {
			screen52.setCursorActive(false);
		}
		screen52.setStatus(
			Screen5250.STATUS_SYSTEM,
			Screen5250.STATUS_VALUE_ON,
			null);

		screen52.setKeyboardLocked(true);
		pendingUnlock = false;
		invited = false;
		baosp.write(screen52.getCurrentRow());
		baosp.write(screen52.getCurrentCol());
		baosp.write(aid);

		if (dataIncluded(aid))
			screen52.getScreenFields().readFormatTable(
				baosp,
				readType,
				codePage);

		try {

			writeGDS(0, 3, baosp.toByteArray());
		} catch (IOException ioe) {

			System.out.println(ioe);
			baosp.reset();
			return false;
		}
		baosp.reset();
		return true;

	}

	// chg pei 080208
//	public final boolean sendAidKey_SB(int aid, int n, int pos) {
	public final boolean sendAidKey_SB(int aid, int n, int pos, ScrollBarField sbf) {

		if (screen52.isStatusErrorCode()) {
			screen52.restoreErrorLine();
			screen52.setStatus(
				Screen5250.STATUS_ERROR_CODE,
				Screen5250.STATUS_VALUE_OFF,
				null);
		}

		if (!enhanced) {
			screen52.setCursorActive(false);
		}
		screen52.setStatus(
			Screen5250.STATUS_SYSTEM,
			Screen5250.STATUS_VALUE_ON,
			null);

		screen52.setKeyboardLocked(true);
		pendingUnlock = false;
		invited = false;
//		baosp.write(screen52.getCurrentRow());
//		baosp.write(screen52.getCurrentCol());
//		baosp.write(aid);
//
//		baosp.write((byte)0x11);
		baosp.write(screen52.getRow(pos) + 1);
		baosp.write(screen52.getCol(pos) + 1);

// add start pei 080208	
		baosp.write(aid);
	
		if (sbf.isList()) {
			screen52.getScreenFields().readFormatTable(
				baosp,
				readType,
				codePage);
		}
		baosp.write((byte)0x11);
		baosp.write(screen52.getCurrentRow());
		baosp.write(screen52.getCurrentCol());
		baosp.write((byte)0);
		baosp.write((byte)0);
	
		if (!sbf.isList()) {
			baosp.write((byte)0x11);
			baosp.write(screen52.getRow(pos) + 1);
			baosp.write(screen52.getCol(pos) + 1);
		}
// add end

		baosp.write((byte)(n >> 24));
		baosp.write((byte)(n >> 16));
		baosp.write((byte)(n >> 8));
		baosp.write((byte)n);

		try {

			writeGDS(0, 3, baosp.toByteArray());
		} catch (IOException ioe) {

			System.out.println(ioe);
			baosp.reset();
			return false;
		}
		baosp.reset();
		return true;

	}

	private boolean dataIncluded(int aid) {

		switch (aid) {

			case PF1 :
				return !dataIncluded[0];
			case PF2 :
				return !dataIncluded[1];
			case PF3 :
				return !dataIncluded[2];
			case PF4 :
				return !dataIncluded[3];
			case PF5 :
				return !dataIncluded[4];
			case PF6 :
				return !dataIncluded[5];
			case PF7 :
				return !dataIncluded[6];
			case PF8 :
				return !dataIncluded[7];
			case PF9 :
				return !dataIncluded[8];
			case PF10 :
				return !dataIncluded[9];
			case PF11 :
				return !dataIncluded[10];
			case PF12 :
				return !dataIncluded[11];
			case PF13 :
				return !dataIncluded[12];
			case PF14 :
				return !dataIncluded[13];
			case PF15 :
				return !dataIncluded[14];
			case PF16 :
				return !dataIncluded[15];
			case PF17 :
				return !dataIncluded[16];
			case PF18 :
				return !dataIncluded[17];
			case PF19 :
				return !dataIncluded[18];
			case PF20 :
				return !dataIncluded[19];
			case PF21 :
				return !dataIncluded[20];
			case PF22 :
				return !dataIncluded[21];
			case PF23 :
				return !dataIncluded[22];
			case PF24 :
				return !dataIncluded[23];

			default :
				return true;

		}

	}

	/**
	 * Help request -
	 *
	 *
	 *    See notes inside method
	 */
	public final void sendHelpRequest() {

		// Client sends header           000D12A0000004000003####F3FFEF
		//       operation code 3
		//       row - first ##
		//       column - second ##
		//       F3 - Help Aid Key
		//      System.out.println("Help request sent");
		baosp.write(screen52.getCurrentRow());
		baosp.write(screen52.getCurrentCol());
		baosp.write(AID_HELP);

		try {
			writeGDS(0, 3, baosp.toByteArray());
		} catch (IOException ioe) {

			System.out.println(ioe);
		}
		baosp.reset();
	}

	/**
	 * Attention Key -
	 *
	 *
	 *    See notes inside method
	 */
	public final void sendAttentionKey() {

		// Client sends header           000A12A000004400000FFEF
		//    0x40 -> 01000000
		//
		// flags
		// bit 0 - ERR
		// bit 1 - ATN Attention
		// bits 2-4   - reserved
		// bit 5 -  SRQ system request
		// bit 6 - TRQ Test request key
		// bit 7 - HLP

		//      System.out.println("Attention key sent");

		try {
			writeGDS(0x40, 0, null);
		} catch (IOException ioe) {

			System.out.println(ioe);
		}
	}

	public final void systemRequest() {
		systemRequest(' ');
	}

	/**
	 * System request - taken from the rfc1205 - 5250 Telnet interface
	 *    section 4.3
	 *
	 *    See notes inside method
	 *
	 *  @param sr - system request option
	 */
	public final void systemRequest(char sr) {

		if (sr == ' ') {
			JPanel srp = new JPanel();
			srp.setLayout(new BorderLayout());
//			JLabel jl = new JLabel("Enter alternate job");
			JLabel jl = new JLabel(LangTool.getString("sreq.prompt"));
			final JTextField sro = new JTextField();
			srp.add(jl, BorderLayout.NORTH);
			srp.add(sro, BorderLayout.CENTER);
			Object[] message = new Object[1];
			message[0] = srp;
//			String[] options = { "SysReq", "Cancel" };
			String[] options = { LangTool.getString("sreq.req"), LangTool.getString("sreq.can") };

			final JOptionPane pane= new JOptionPane(message, // the dialog message array
				JOptionPane.QUESTION_MESSAGE, // message type
				JOptionPane.DEFAULT_OPTION, // option type
				null, // optional icon, use null to use the default icon
				options, // options string array, will be made into buttons//
				options[0]); // option that should be made into a default button

			// create a dialog wrapping the pane
			final JDialog dialog = pane.createDialog(controller, // parent frame
//				"System Request" // dialog title
				LangTool.getString("sreq.title") // dialog title
				);

			// add the listener that will set the focus to
			// the desired option
			dialog.addWindowListener(new WindowAdapter() {
				public void windowOpened(WindowEvent e) {
					super.windowOpened(e);

					// now we're setting the focus to the desired component
					// it's not the best solution as it depends on internals
					// of the OptionPane class, but you can use it temporarily
					// until the bug gets fixed
					// also you might want to iterate here thru the set of
					// the buttons and pick one to call requestFocus() for it

					sro.requestFocus();
				}
			});
// add start pei 060829 SysReqʂōECtrlL[L
			sro.addKeyListener(new KeyListener() {
				protected KeyMapper keymap= KeyMapper.getKeyMapper(controller.getConfiguration().getStringProperty("keymapPath"));

				public void keyTyped(KeyEvent e) {
				}

				public void keyPressed(KeyEvent e) {
					String s = keymap.getKeyStrokeText(e);
					if (MNEMONIC_RESET.equals(s)) {
						dialog.dispose();
					}
				}

				public void keyReleased(KeyEvent e) {
					String s = keymap.getKeyStrokeText(e);
					if (MNEMONIC_ENTER.equals(s)) {
						dialog.getRootPane().getDefaultButton().doClick();
					} else if (MNEMONIC_RESET.equals(s)) {
						dialog.dispose();
					}
				}
			});
// add end
			dialog.show();
			// now we can process the value selected
			Object o = pane.getValue();

			// but only if it is a String
			if (o instanceof String) {

				String value = (String) o;
				if (value.equals(options[0])) {
					// from rfc1205 section 4.3
					// Client sends header with the           000A12A0000004040000FFEF
					// System Request bit set.
					//
					// if we wanted to send an option with it we would need to send
					//    it at the end such as the following
					//
					// byte abyte0[] = new byte[1];    or number of bytes in option
					// abyte0[0] = codePage.uni2ebcdic(option);

					//                  System.out.println("SYSRQS sent");

					// send option along with system request
					if (sro.getText().length() > 0) {
						for (int x = 0; x < sro.getText().length(); x++) {
							//                     System.out.println(sro.getText().charAt(x));
							if (sro.getText().charAt(0) == '2') {
								//                           System.out.println("dataq cleared");
								dsq.clear();
							}
							try {
								baosp.write(
									codePage.uni2ebcdic(
										sro.getText().charAt(x), false));
							} catch (IOException e) {
							}
						}

						try {
							writeGDS(4, 0, baosp.toByteArray());
						} catch (IOException ioe) {

							System.out.println(ioe);
						}
						baosp.reset();
					} else { // no option sent with system request
						try {
							writeGDS(4, 0, null);
						} catch (IOException ioe) {

							System.out.println(ioe);
						}
					}
				}
			}
			controller.requestFocus();
		} else {

			try {
				baosp.write(codePage.uni2ebcdic(sr, false));
			} catch (IOException e) {
			}

			try {
				writeGDS(4, 0, baosp.toByteArray());
			} catch (IOException ioe) {
				baosp.reset();
				System.out.println(ioe);
			}
			baosp.reset();
		}
	}

	/**
	 * Cancel Invite - taken from the rfc1205 - 5250 Telnet interface
	 *    section 4.3
	 *
	 *    See notes inside method
	 */
	public final void cancelInvite() {

		screen52.setStatus(
			Screen5250.STATUS_SYSTEM,
			Screen5250.STATUS_VALUE_ON,
			null);

		// from rfc1205 section 4.3
		// Server: Sends header with the          000A12A0 00000400 000AFFEF
		// Opcode = Cancel Invite.

		// Client: sends header with the          000A12A0 00000400 000AFFEF
		// Opcode = Cancel Invite to
		// indicate that the work station is
		// no longer invited.
		
		// add pei 061031 LZꍇɃL[obt@NA
		screen52.setPrehelpState(false, true, false);
		
		try {
			writeGDS(0, 10, null);
		} catch (IOException ioe) {

			System.out.println(ioe);
		}

	}

	public final void hostPrint(int aid) {

		if (screen52.isStatusErrorCode()) {
			screen52.restoreErrorLine();
			screen52.setStatus(
				Screen5250.STATUS_ERROR_CODE,
				Screen5250.STATUS_VALUE_OFF,
				null);
		}

		screen52.setCursorActive(false);
		screen52.setStatus(
			Screen5250.STATUS_SYSTEM,
			Screen5250.STATUS_VALUE_ON,
			null);
		// From client access ip capture
		// it seems to use an operation code of 3 and 4
		// also note that the flag field that says reserved is being sent as well
		// with a value of 0x80
		//
		// I have tried with not setting these flags and sending with 3 or 1
		// there is no effect and I still get a host print screen.  Go figure
		//0000:  000D 12A0 0000 0400 8003 1407 F6FFEF
		//0000:  000D 12A0 0000 0400 8001 110E F6FFEF
		//
		// Client sends header           000D12A0000004000003####F6FFEF
		//       operation code 3
		//       row - first ##
		//       column - second ##
		//       F6 - Print Aid Key

		baosp.write(screen52.getCurrentRow());
		baosp.write(screen52.getCurrentCol());
		baosp.write(AID_PRINT); // aid key

		try {
			writeGDS(0, 3, baosp.toByteArray());
		} catch (IOException ioe) {

			System.out.println(ioe);
		}
		baosp.reset();
	}

	protected final void toggleDebug() {
		tracer.toggleDebug(codePage);
	}

	// write gerneral data stream
	// chg pei 061031
	//public final void writeGDS(int flags, int opcode, byte abyte0[])
	public final synchronized void writeGDS(int flags, int opcode, byte abyte0[])
		throws IOException {

		// Added to fix for JDK 1.4 this was null coming from another method.
		//  There was a weird keyRelease event coming from another panel when
		//  using a key instead of the mouse to select button.
		//  The other method was fixed as well but this check should be here anyway.
		if (bout == null)
			return;

		int length;
		if (abyte0 != null)
			length = abyte0.length + 10;
		else
			length = 10;

		// refer to rfc1205 - 5250 Telnet interface
		// Section 3.  Data Stream Format

		// Logical Record Length   -  16 bits
		baosrsp.write(length >> 8); // Length LL
		baosrsp.write(length & 0xff); //        LL

		// Record Type -  16 bits
		// It should always be set to '12A0'X to indicate the
		// General Data Stream (GDS) record type.
		baosrsp.write(18); // 0x12
		baosrsp.write(160); // 0xA0

		// the next 16 bits are not used
		baosrsp.write(0); // 0x00
		baosrsp.write(0); // 0x00

		//  The second part is meant to be variable in length
		//  currently this portion is 4 octets long (1 byte or 8 bits for us ;-O)
		baosrsp.write(4); // 0x04

		baosrsp.write(flags); // flags
		// bit 0 - ERR
		// bit 1 - ATN Attention
		// bits 2-4   - reserved
		// bit 5 -  SRQ system request
		// bit 6 - TRQ Test request key
		// bit 7 - HLP
		//		baosrsp.write(0); // reserved - set to 0x00
		baosrsp.write(opcode >> 8); // reserved - set to 0x00
		baosrsp.write(opcode); // opcode

		if (abyte0 != null)
			baosrsp.write(abyte0, 0, abyte0.length);

		baosrsp = appendByteStream(baosrsp.toByteArray());

		// make sure we indicate no more to be sent
		baosrsp.write(IAC);
		baosrsp.write(EOR);

		baosrsp.writeTo(bout);
		tracer.dump(baosrsp.toByteArray(), 1);
		//        byte[] b = new byte[baosrsp.size()];
		//        b = baosrsp.toByteArray();
		//      dump(b);
		bout.flush();
		//      baos = null;
		baosrsp.reset();
	}

	public final int getOpCode() {

		return bk.getOpCode();
	}

	private final void sendNotify() throws IOException {

		writeGDS(0, 0, null);
	}

	private final void setInvited() {

		//      System.out.println("invited");
		if (!screen52.isStatusErrorCode())
			screen52.setStatus(
				Screen5250.STATUS_SYSTEM,
				Screen5250.STATUS_VALUE_OFF,
				null);

		invited = true;
	}

	public void run() {

		while (keepTrucking) {

			try {
				bk = (Stream5250) dsq.get();
			} catch (InterruptedException ie) {
				System.out.println("   vt thread interrupted and stopping ");
				keepTrucking = false;
				continue;
			}

			// lets play nicely with the others on the playground
			//         me.yield();

			Thread.yield();

			invited = false;
// chg start pei 061101 Synchronized
			synchronized (screen52) {
				screen52.setCursorActive(false);

				//      System.out.println("operation code: " + bk.getOpCode());
				if (bk == null)
					continue;

				switch (bk.getOpCode()) {
					case 00 :
						//               System.out.println("No operation");
						break;
					case 1 :
						//               System.out.println("Invite Operation");
						parseIncoming();
						//               screen52.setKeyboardLocked(false);
						pendingUnlock = true;
						cursorOn = true;
						setInvited();
						break;
					case 2 :
						//               System.out.println("Output Only");
						parseIncoming();
						//               System.out.println(screen52.dirty);
						screen52.updateDirty();
						//            invited = true;
						break;
					case 3 :
						//               System.out.println("Put/Get Operation");
						parseIncoming();
						//               inviteIt =true;
						setInvited();
						if (!firstScreen) {
							firstScreen = true;
							controller.fireSessionChanged(
								TN5250jConstants.STATE_CONNECTED);
						}
						break;
					case 4 :
						//            System.out.println("Save Screen Operation");
						parseIncoming();
						break;
	
					case 5 :
						//               System.out.println("Restore Screen Operation");
						parseIncoming();
						break;
					case 6 :
						//               System.out.println("Read Immediate");
						sendAidKey(0);
						break;
					case 7 :
						//               System.out.println("Reserved");
						break;
					case 8 :
						//               System.out.println("Read Screen Operation");						
						try {
							// chg pei 080319 HostPrintQΉ
							//readScreen(CMD_READ_SCREEN_IMMEDIATE);

							byte cmd= CMD_READ_SCREEN_IMMEDIATE;
							try {
								bk.getNextByte();		//esc
								cmd= bk.getNextByte();
							} catch (Exception e) {
							}
							readScreen(cmd);

						} catch (IOException ex) {
	
						}
						break;

					case 9 :
						//               System.out.println("Reserved");
						break;
	
					case 10 :
						//               System.out.println("Cancel Invite Operation");
						cancelInvite();
						break;
	
					case 11 :
						//               System.out.println("Turn on message light");
						screen52.setMessageLightOn();
						screen52.setCursorActive(true);
	
						break;
					case 12 :
						//               System.out.println("Turn off Message light");
						screen52.setMessageLightOff();
						screen52.setCursorActive(true);
	
						break;
					default :
						break;
				}	

				// add by pei for PCO JUN/2005
				String pco= screen52.checkPCO();
				if (pco != null) {
					if (pco.length() != 0) {
						screen52.setStatus(
							Screen5250.STATUS_SYSTEM,
							Screen5250.STATUS_VALUE_ON,
							null);
						System.out.println("pco [" + pco + "]");
						Runtime rt= Runtime.getRuntime();
						try {
							Process pcoproc= rt.exec(pco);
							pcowait= Thread.currentThread();
							pcoproc.waitFor();
						} catch (InterruptedException e) {
						} catch (Exception e) {
							System.out.println("pco exec error:" + e);
						} finally {
							pcowait= null;
							if (Thread.currentThread().isInterrupted()) {
								// chg pei 070118
								//Thread.currentThread().interrupted();
								Thread.interrupted();
							}
	
						}
					}
					screen52.setPrehelpState(false, false, true);
					screen52.clearScreen();
					screen52.sendKeys("[enter]");
					continue;
				} 
	
				if (screen52.isUsingGuiInterface())
					screen52.drawFields();
	
				//      if (screen52.screen[0][1].getChar() == '#' &&
				//         screen52.screen[0][2].getChar() == '!')
				//         execCmd();
				//      else {
	
				if (screen52.isHotSpots()) {
					screen52.checkHotSpots();
				}
	
				try {
					//               SwingUtilities.invokeAndWait(
					//                  new Runnable () {
					//                     public void run() {
					//                        screen52.updateDirty();
					//                     }
					//                  }
					//               );
					screen52.updateDirty();
					controller.validate();
					//            System.out.println("update dirty");
				} catch (Exception exd) {
					System.out.println(" tnvt.run: " + exd);
					exd.printStackTrace();
				}
	
				if (pendingUnlock && !screen52.isStatusErrorCode()) {
					screen52.setKeyboardLocked(false);
					pendingUnlock = false;
				}
	
				if (cursorOn && !screen52.isKeyboardLocked()) {
					screen52.setCursorActive(true);
					cursorOn = false;
				}
			}
// chg end
			// lets play nicely with the others on the playground
			//me.yield();
			Thread.yield();

		}
	}

	public void dumpStuff() {

		System.out.println(" Pending unlock " + pendingUnlock);
		System.out.println(" Status Error " + screen52.isStatusErrorCode());
		System.out.println(" Keyboard Locked " + screen52.isKeyboardLocked());
		System.out.println(" Cursor On " + cursorOn);
		System.out.println(" Cursor Active " + screen52.cursorActive);

	}
	//      private final void execCmd() {
	//         String name = "";
	//         String argString = "";
	//
	//         StringBuffer sb = new StringBuffer();
	//         sb.append(screen52.screen[0][3].getChar());
	//         sb.append(screen52.screen[0][4].getChar());
	//         sb.append(screen52.screen[0][5].getChar());
	//         sb.append(screen52.screen[0][6].getChar());
	//
	//         System.out.println("command = " + sb);
	//         int x = 8;
	//         sb.setLength(0);
	//         while (screen52.screen[0][x].getChar() > ' ') {
	//            sb.append(screen52.screen[0][x].getChar());
	//            x++;
	//         }
	//         name = sb.toString();
	//         System.out.println("name = " + name);
	//
	//         sb.setLength(0);
	//         x++;
	//         while (screen52.screen[0][x].getChar() >= ' ') {
	//            sb.append(screen52.screen[0][x].getChar());
	//            x++;
	//         }
	//         argString = sb.toString();
	//         System.out.println("args = " + argString);
	//
	//         sendAidKey(AID_ENTER);
	//
	//         try {
	//
	//            Class c = Class.forName(name);
	//            String args1[] = {argString};
	//            String args2[] = {};
	//
	//            Method m = c.getMethod("main",
	//            new Class[] { args1.getClass() });
	//            m.setAccessible(true);
	//            int mods = m.getModifiers();
	//            if (m.getReturnType() !=
	//                   void.class || !Modifier.isStatic(mods) ||
	//                  !Modifier.isPublic(mods)) {
	//
	//                     throw new NoSuchMethodException("main");
	//                  }
	//            try {
	//               if (argString.length() > 0)
	//                  m.invoke(null, new Object[] { args1 });
	//               else
	//                  m.invoke(null, new Object[] { args2 });
	//            }
	//            catch (IllegalAccessException e) {
	//                 // This should not happen, as we have
	//                 // disabled access checks
	//                  System.out.println("iae " + e.getMessage());
	//
	//            }
	//         }
	//         catch (ClassNotFoundException cnfe) {
	//            System.out.println("cnfe " + cnfe.getMessage());
	//         }
	//         catch (NoSuchMethodException nsmf) {
	//            System.out.println("nsmf " + nsmf.getMessage());
	//         }
	//         catch (InvocationTargetException ite) {
	//            System.out.println("ite " + ite.getMessage());
	//         }
	//   //      catch (IllegalAccessException iae) {
	//   //         System.out.println("iae " + iae.getMessage());
	//   //      }
	//   //      catch (InstantiationException ie) {
	//   //         System.out.println("ie " + ie.getMessage());
	//   //      }
	//   //      try {
	//   //
	//   //         Runtime rt = Runtime.getRuntime();
	//   //         Process proc = rt.exec("notepad");
	//   //         int exitVal = proc.exitValue();
	//   //      }
	//   //      catch (Throwable t) {
	//   //
	//   //         t.printStackTrace();
	//   //      }
	//      }

	//Mod by pei (compress and grid info)
	private final void readScreen(byte cmd) throws IOException {

		int rows = screen52.getRows();
		int cols = screen52.getCols();
		boolean att = false;
		int off = 0;
		byte abyte0[] = new byte[rows * cols];
		fillScreenArray(abyte0, rows, cols);
		writeGDS(0, (cmd == CMD_READ_SCREEN_TO_PRINT_WITH_EA_AND_G || cmd == CMD_READ_SCREEN_TO_PRINT_WITH_G) ? 0x8002 : 0x08, reform(abyte0, rows, cols, cmd));
		abyte0 = null;
	}

	private final void fillScreenArray(byte[] sa, int rows, int cols) {

		int la = 32;
		int sac = 0;
		int len = rows * cols;
		for (int y = 0; y < len && sac < len; y++) { // save the screen data
			if (screen52.screen[y].isAttributePlace()) {
				la = screen52.screen[y].getCharAttr();
				sa[sac++] = (byte) la;
			} else {
				if (screen52.screen[y].getCharAttr() != la) {
					la = screen52.screen[y].getCharAttr();
					// add pei 080317 if
					if (sac > 0) {
						sac--;
						sa[sac++] = (byte) la;
					}
				}
				//LDC: Check to see if it is an displayable character. If not,
				//  do not convert the character.
				//  The characters on screen are in unicode
				//sa[sac++] = (byte)codePage.uni2ebcdic(screen52.screen[y].getChar());
				char ch = screen52.screen[y].getChar();
				byte byteCh = (byte) ch;
				if (isDataUnicode(ch))
					byteCh = this.uni2ebcdic(ch);
					
				int dbc = screen52.screen[y].getDBCF();
				switch (dbc) {
					case 0 :
						sa[sac++] = byteCh;
						break;
					case ScreenChar.F_DBC_IN :
						sa[sac++] = 0x0e;
						break;
					case ScreenChar.F_DBC_OUT :
						sa[sac++] = 0x0f;
						break;
					case ScreenChar.F_DBC1 :
						byte[] dbch = codePage.uni2ebcdic(ch, true);
						if (dbch.length == 2) {
							sa[sac++] = dbch[0];
							sa[sac++] = dbch[1];
						} else {
							sa[sac++] = 0x40;
							sa[sac++] = 0x40;
						}
						break;
					case ScreenChar.F_DBC2 :
						break;
				}
			}
		}
	}

	private byte [] fillScreenArray2(int rows, int cols) {

		ByteArrayOutputStream baos= new ByteArrayOutputStream();
		int la = 32;
//		int sac = 0;
		int len = rows * cols;
		boolean dbcsf= false;
		for (int y = 0; y < len; y++) { // save the screen data
			if (screen52.screen[y].isAttributePlace()) {
				if (dbcsf) {
					baos.write(0x0d);
					dbcsf= false;
				}
				la = screen52.screen[y].getCharAttr();
				baos.write(la);
			} else {

// del start pei 060831
//				if (screen52.screen[y].getCharAttr() != la) {
//					System.out.println("???????? FillArray2");
// del end

//					la = screen52.screen[y].getCharAttr();
//					sac--;
//					sa[sac++] = (byte) la;
//				}
				//LDC: Check to see if it is an displayable character. If not,
				//  do not convert the character.
				//  The characters on screen are in unicode
				//sa[sac++] = (byte)codePage.uni2ebcdic(screen52.screen[y].getChar());
				char ch = screen52.screen[y].getChar();
				byte byteCh = (byte) ch;
/* del pei 080317
				if (ch == 0xffed) {
					byteCh = 0x11;
				} else if (ch == 0xffee) {
					byteCh = 0x12;
				} else if (isDataUnicode(ch)) {
*/
				if (isDataUnicode(ch)) {
					byteCh = this.uni2ebcdic(ch);
				}
				//pei
				int gui= screen52.screen[y].getWhichGUI();
				if (gui >= ScreenChar.UPPER_LEFT && gui <= ScreenChar.LOWER_RIGHT) {
					if (dbcsf) {
						baos.write(0x0d);
						dbcsf= false;
					}
					baos.write(gui);
					// add pei 060908
					baos.write(uni2ebcdic(screen52.screen[y].getChar()));
					// add pei 060831
					baos.write(screen52.screen[y].getCharAttr());
				} else {
					int dbc = screen52.screen[y].getDBCF();
					switch (dbc) {
						case 0 :
							if (dbcsf) {
								baos.write(0x0d);
								dbcsf= false;
							}
							baos.write(byteCh);
							break;
						case ScreenChar.F_DBC_IN :
							baos.write(0x0e);
							dbcsf= true;
							break;
						case ScreenChar.F_DBC_OUT :
							baos.write(0x0f);
							dbcsf= false;
							break;
						case ScreenChar.F_DBC1 :
							if (!dbcsf) {
								baos.write(0x0c);
								dbcsf= true;
							}
							byte[] dbch = codePage.uni2ebcdic(ch, true);
							if (dbch.length == 2) {
								baos.write(dbch[0]);
								baos.write(dbch[1]);
							} else {
								baos.write(0x40);
								baos.write(0x40);
							}
							break;
						case ScreenChar.F_DBC2 :
							break;
					}
				}
			}
		}
		return (baos.toByteArray());
	}

	public final void saveScreen() throws IOException {

		ByteArrayOutputStream sc = new ByteArrayOutputStream();
		sc.write(4);
		sc.write(0x12); // 18
		sc.write(0); // 18
		sc.write(0); // 18

		sc.write((byte) screen52.getRows()); // store the current size
		sc.write((byte) screen52.getCols()); //    ""

//		int cp = screen52.getCurrentPos(); // save off current position
		int cp = screen52.getLastPos(); // save off current position
		sc.write((byte) (cp >> 8 & 0xff)); //    ""
		sc.write((byte) (cp & 0xff)); //    ""

		sc.write((byte) (screen52.homePos >> 8 & 0xff)); // save home pos
		sc.write((byte) (screen52.homePos & 0xff)); //    ""

		int rows = screen52.getRows(); // store the current size
		int cols = screen52.getCols(); //    ""
//		byte[] sa = new byte[rows * cols];
//		fillScreenArray(sa, rows, cols);
		byte[] sa= fillScreenArray2(rows, cols);

		sc.write(sa);
		sa = null;
		int sizeFields = screen52.getScreenFields().getSize();
		sc.write((byte) (sizeFields >> 8 & 0xff)); //    ""
		sc.write((byte) (sizeFields & 0xff)); //    ""

		if (sizeFields > 0) {
			int x = 0;
			int s = screen52.getScreenFields().getSize();
			ScreenField sf = null;
			while (x < s) {
				sf = screen52.getScreenFields().getField(x);
				sc.write((byte) sf.getAttr()); // attribute
				int sp = sf.startPos();
				sc.write((byte) (sp >> 8 & 0xff)); //    ""
				sc.write((byte) (sp & 0xff)); //    ""
				if (sf.mdt)
					sc.write((byte) 1);
				else
					sc.write((byte) 0);
				sc.write((byte) (sf.getLength() >> 8 & 0xff)); //    ""
				sc.write((byte) (sf.getLength() & 0xff)); //    ""
				sc.write((byte) sf.getRows() & 0xff);
				sc.write((byte) sf.getFFW1() & 0xff);
				sc.write((byte) sf.getFFW2() & 0xff);
				sc.write((byte) sf.getFCW1() & 0xff);
				sc.write((byte) sf.getFCW2() & 0xff);
				int ftype= (byte)sf.getType();
				sc.write((byte)ftype);
				switch (ftype) {
					case ScreenField.F_BUTTON:
						sc.write(((ButtonField)sf).getAid());
						break;
					case ScreenField.F_SINGLESELECTION:
					case ScreenField.F_MULTISELECTION:
					// add pei 080208
					case ScreenField.F_SINGLESELECTION_PD:
					case ScreenField.F_SINGLESELECTION_LIST:
//						sc.write((byte)((SingleSelectionField)sf).getSelectPos());
//						int srows= sf.getRows();
//						sc.write((byte)srows);
//						for (int i= 1; i <= srows; ++i) {
//							sc.write((byte)(((SingleSelectionField)sf).isAvalilable(i) ? 1 : 0));
//						}
						SelectionField ssf= (SelectionField)sf;
//						sc.write((byte)ssf.getSelectPos());
						// del pei 080317
						//int srows= ssf.getRows();
						int mcc= ssf.getMaxColChoice();
						// del pei 080317
						//mcc *= srows;
						sc.write((byte)mcc);
						// add pei 080317
						mcc *= ssf.getRows();
						for (int i= 1; i <= mcc; ++i) {
							sc.write((byte)(ssf.isSelected(i) ? 1 : 0));
							sc.write((byte)(ssf.isAvalilable(i) ? 1 : 0));
							int wi= ssf.getChoice_pos(i);
							sc.write((byte) (wi >> 8 & 0xff));
							sc.write((byte)wi);
							wi= ssf.getChoice_len(i);
							sc.write((byte) (wi >> 8 & 0xff));
							sc.write((byte)wi);
						}
						break;
					case ScreenField.F_SCROLLBAR:
						ScrollBarField sbf= (ScrollBarField)sf;
						int w= sbf.getFlag();
						sc.write((byte)(w >> 8));
						sc.write((byte)w);
						w= sbf.getTotalRowScrollable();
						sc.write((byte)(w >> 8));
						sc.write((byte)w);
						w= sbf.getTotalColScrollable();
						sc.write((byte)(w >> 8));
						sc.write((byte)w);
						w= sbf.getSliderRowPos();
						sc.write((byte)(w >> 8));
						sc.write((byte)w);
						w= sbf.getSliderColPos();
						sc.write((byte)(w >> 8));
						sc.write((byte)w);
						w= sbf.getSBSize();
						sc.write((byte)(w >> 8));
						sc.write((byte)w);
						break;
				}
				//            System.out.println("Saved ");
				//            System.out.println(sf.toString());

				x++;
			}
			sf = null;
		}
		// chg pei 061121 rQΉ
		//byte [] gb= screen52.gridbf;
		//if (gb != null) {
		if (screen52.gridbf_bs != null) {
			byte [] gb= screen52.gridbf_bs.toByteArray();
			
			int l= gb.length;
			sc.write((byte)( l >> 8));
			sc.write((byte)l);
			sc.write(gb);
		} else {
			sc.write((byte)0);
			sc.write((byte)0);
		}
		//Programable mouse button
		int pmbc= screen52.p_mouse_btn.size();
		if (pmbc != 0) {
			sc.write((byte)pmbc);
			for (int i= 0; i < pmbc; ++i) {
				ProgMouseButton pmb= (ProgMouseButton)screen52.p_mouse_btn.elementAt(i);
				sc.write((byte)pmb.getFlag());
				sc.write((byte)pmb.getEV1());
				sc.write((byte)pmb.getEV2());
				sc.write((byte)pmb.getAid());
			}		
		} else {
			sc.write((byte)0);
		}
		// The following two lines of code looks to have caused all sorts of
		//    problems so for now we have commented them out.
		//      screen52.getScreenFields().setCurrentField(null);    // set it to null for GC ?
		//      screen52.clearTable();

		try {
			writeGDS(0, 3, sc.toByteArray());
		} catch (IOException ioe) {

			System.out.println(ioe);
		}

		sc = null;
		//      System.out.println("Save Screen end ");
	}

	/**
	 *
	 * @throws IOException
	 */
	public final void restoreScreen() throws IOException {
		int which = 0;
		try {
			//         System.out.println("Restore ");

			bk.getNextByte();
			bk.getNextByte();

			int rows = bk.getNextByte() & 0xff;
			int cols = bk.getNextByte() & 0xff;
			int pos = bk.getNextByte() << 8 & 0xff00;
			pos |= bk.getNextByte() & 0xff;
			int hPos = bk.getNextByte() << 8 & 0xff00;
			hPos |= bk.getNextByte() & 0xff;
			if (rows != screen52.getRows())
				screen52.setRowsCols(rows, cols);
			screen52.clearAll(); // initialize what we currenty have
			int b = 32;
			int la = 32;
			int len= rows * cols;
			boolean kin = false;
			for (int y = 0; y < len; y++) {
				b = bk.getNextByte();
				if (b >= ScreenChar.UPPER_LEFT && b <= ScreenChar.LOWER_RIGHT) {
// chg start pei 060908
					char c= ebcdic2uni(bk.getNextByte());
					screen52.screen[y].setCharAndAttr(
						c,
						bk.getNextByte(),
						false,
						0,
						(byte) 0);
/*
					switch(b) {
						case ScreenChar.UPPER_LEFT:
						case ScreenChar.UPPER:
						case ScreenChar.UPPER_RIGHT:
						case ScreenChar.BOTTOM:
							screen52.screen[y].setCharAndAttr(
								'.',
								// chg pei 060831
								//la,
								bk.getNextByte(),
								false,
								0,
								(byte) 0);
							break;
						case ScreenChar.LEFT:
						case ScreenChar.LOWER_LEFT:
						case ScreenChar.RIGHT:
						case ScreenChar.LOWER_RIGHT:
							screen52.screen[y].setCharAndAttr(
								':',
								// chg pei 060831
								//la,
								bk.getNextByte(),
								false,
								0,
								(byte) 0);
							break;
					}
*/
// chg end
					screen52.screen[y].setUseGUI(b);
				} else {
					if (isAttribute(b)) {
						screen52.screen[y].setCharAndAttr(
							screen52.screen[y].getChar(),
							b,
							true,
							0,
							(byte) 0);
						la = b;
						kin = false;
					} else {
						//pei
						switch (b) {
/* del pei 080317
							case 0x11:
								screen52.screen[y].setCharAndAttr(
									(char)0xffed,
									la,
									false,
									0,
									(byte) 0);
								break;
							case 0x12:
								screen52.screen[y].setCharAndAttr(
									(char)0xffee,
									la,
									false,
									0,
									(byte) 0);
								break;
*/
							case 0x0c:
								kin = true;
								--y;
								break;
							case 0x0d:
								kin = false;
								--y;
								break;
							case 0x0e:
								kin = true;
								screen52.screen[y].setCharAndAttr(
									'.',
									la,
									false,
									ScreenChar.F_DBC_IN,
									(byte) 0);
								break;
							case 0x0f:
								kin = false;
								screen52.screen[y].setCharAndAttr(
									' ',
									la,
									false,
									ScreenChar.F_DBC_OUT,
									(byte) 0);
								break;
							default:
								//LDC - 12/02/2003 - Check to see if it is an displayable character. If not,
								//  do not convert the character.
								//  The characters on screen are in unicode
								if (kin) {
									char ch = codePage.ebcdic2unik(b, bk.getNextByte());
									screen52.screen[y].setCharAndAttr(
									//getASCIIChar(b),
									ch, la, false, ScreenChar.F_DBC1, (byte) 0);
									++y;
									screen52.screen[y].setCharAndAttr(
									//getASCIIChar(b),
									'*', la, false, ScreenChar.F_DBC2, (byte) 0);
								} else {
									char ch = (char) b;
									if (isDataEBCDIC(b)) {
										ch = ebcdic2uni(b);
									}
									screen52.screen[y].setCharAndAttr(
									//getASCIIChar(b),
									ch, la, false, 0, (byte) b);
								}
								break;
						}
					}
				}
			}

			int numFields = bk.getNextByte() << 8 & 0xff00;
			numFields |= bk.getNextByte() & 0xff;
			//         System.out.println("number of fields " + numFields);

			if (numFields > 0) {
				int x = 0;
				int attr = 0;
				int fPos = 0;
				int fLen = 0;
				int frows = 0;
				int ffw1 = 0;
				int ffw2 = 0;
				int fcw1 = 0;
				int fcw2 = 0;
				boolean mdt = false;

				ScreenField sf = null;
				while (x < numFields) {

					attr = bk.getNextByte();
					fPos = bk.getNextByte() << 8 & 0xff00;
					fPos |= bk.getNextByte() & 0xff;
					if (bk.getNextByte() == 1)
						mdt = true;
					else
						mdt = false;
					fLen = bk.getNextByte() << 8 & 0xff00;
					fLen |= bk.getNextByte() & 0xff;
					frows = bk.getNextByte() & 0xff;
					ffw1 = bk.getNextByte() & 0xff;
					ffw2 = bk.getNextByte() & 0xff;
					fcw1 = bk.getNextByte() & 0xff;
					fcw2 = bk.getNextByte() & 0xff;
					int ftype= bk.getNextByte() & 0xff;

					switch (ftype) {
						case ScreenField.F_BUTTON:
							sf=screen52.getScreenFields().setField(
								ftype,
								attr,
								screen52.getRow(fPos),
								screen52.getCol(fPos),
								fLen,
								frows,
								ffw1,
								ffw2,
								fcw1,
								fcw2);
							((ButtonField)sf).setAid(bk.getNextByte());
							screen52.drawButton(sf);
							break;
						case ScreenField.F_SINGLESELECTION:
						case ScreenField.F_MULTISELECTION:
						// add pei 080208
						case ScreenField.F_SINGLESELECTION_PD:
						case ScreenField.F_SINGLESELECTION_LIST:
							sf=screen52.getScreenFields().setField(
								ftype,
								attr,
								screen52.getRow(fPos),
								screen52.getCol(fPos),
								fLen,
								frows,
								ffw1,
								ffw2,
								fcw1,
								fcw2);
//							SingleSelectionField ssf= (SingleSelectionField)sf;
//							ssf.setSelectPos(bk.getNextByte());
//							int srows= bk.getNextByte();
//							for (int i= 1; i <= srows; ++i) {
//								ssf.setAvailable(i, bk.getNextByte() == 1);
//							}
							SelectionField ssf= (SelectionField)sf;
//							ssf.setSelectPos(bk.getNextByte());
							int choicen= bk.getNextByte();
							ssf.setMaxColChoice(choicen);
							// add pei 080317
							choicen *= ssf.getRows();
							for (int i= 1; i <= choicen; ++i) {
								if (bk.getNextByte() == 1) {
									ssf.setSelectPos(i);
								}
								ssf.setAvailable(i, bk.getNextByte() == 1);
								int c_pos= (bk.getNextByte() << 8) & 0xff00;
								c_pos |= bk.getNextByte() & 0xff;
								int c_len= (bk.getNextByte() << 8) & 0xff00;
								c_len |= bk.getNextByte() & 0xff;
								ssf.setChoice_pos(i, c_pos, c_len);
							}
							// chg pei 080208
							//screen52.drawSingleSelection(ssf);
							screen52.drawSelection(ssf);
							break;
						case ScreenField.F_SCROLLBAR:
							int flag= (bk.getNextByte() << 8) & 0xff00;
							flag |= bk.getNextByte() & 0xff;
							int totalRowScrollable= (bk.getNextByte() << 8) & 0xff00;
							totalRowScrollable |= bk.getNextByte() & 0xff;
							int totalColScrollable= (bk.getNextByte() << 8) & 0xff00;
							totalColScrollable |= bk.getNextByte() & 0xff;
							int sliderRowPos= (bk.getNextByte() << 8) & 0xff00;
							sliderRowPos |= bk.getNextByte() & 0xff;
							int sliderColPos= (bk.getNextByte() << 8) & 0xff00;
							sliderColPos |= bk.getNextByte() & 0xff;
							int sbSize= (bk.getNextByte() << 8) & 0xff00;
							sbSize |= bk.getNextByte() & 0xff;
							screen52.createScrollBar(fPos, flag, totalRowScrollable,
									totalColScrollable, sliderRowPos, sliderColPos, sbSize);
							break;
						default:
							sf=screen52.getScreenFields().setField(
								ftype,
								attr,
								screen52.getRow(fPos),
								screen52.getCol(fPos),
								fLen,
								frows,
								ffw1,
								ffw2,
								fcw1,
								fcw2);
					}
//					if (sf.isDBCSPure()) {
//						int n= fLen / 2;
//						int cpos= sf.startPos();
//						for (int i= 0; i < n; ++i) {
//							char c= codePage.ebcdic2unik(screen52.screen[cpos].getEbcdic() & 0xff,
//									 screen52.screen[cpos + 1].getEbcdic() & 0xff);
//							screen52.screen[cpos++].setChar(c, ScreenChar.F_DBC1, (byte) 0);
//							screen52.screen[cpos++].setChar('*', ScreenChar.F_DBC2, (byte) 0);
//						}
//					}
					if (mdt) {
						sf.setMDT();
						screen52.getScreenFields().setMasterMDT();
					}

					//               System.out.println("/nRestored ");
					//               System.out.println(sf.toString());
					//
					x++;
				}
			}

			int l= ((bk.getNextByte() << 8) & 0xff00) + (bk.getNextByte() & 0xff);
			if (l != 0) {
				ByteArrayOutputStream baos =
					new ByteArrayOutputStream();
				while (l-- > 0) {
					baos.write(bk.getNextByte());
				}
				// chg pei 061121 rQΉ
				//screen52.writeGrid(0, baos.toByteArray());
				screen52.writeGrid(0, baos);
				
			} else {
				screen52.clearGrid();
			}
			l= bk.getNextByte() & 0xff;
			if (l != 0) {
				for (int i= 0; i < l; ++i) {
					screen52.p_mouse_btn.addElement(new ProgMouseButton(bk.getNextByte(),
																bk.getNextByte(),
																bk.getNextByte(),
																bk.getNextByte()));
				}
			}
			screen52.restoreScreen(); // display the screen
			// chg pei 060817
//			screen52.setPendingInsert(
//				true,
//				screen52.getRow(pos) + 1,
//				screen52.getCol(pos) + 1);
			// chg pei 060926
			//screen52.setPendingInsertRestore();
			screen52.setPendingInsertRestore(true);
			
			screen52.goto_XY(pos);
			screen52.isInField();
			if (screen52.isUsingGuiInterface())
				screen52.drawFields();
			screen52.homePos= hPos;
//			screen52.skipgohome= true;
		} catch (Exception e) {
			System.out.println(
				"error restoring screen " + which + " with " + e);
		}
	}

	public final boolean waitingForInput() {

		return waitingForInput;
	}

	private void parseIncoming() {

		boolean controlChars = false;
		byte control0;
		byte control1;
		boolean done = false;
		boolean error = false;

		try {
			while (bk.hasNext() && !done) {
				byte b = bk.getNextByte();
				switch (b) {
					case 0 :
					case 1 :
						break;
					case CMD_SAVE_SCREEN : // 0x02 2 Save Screen
					case 3 : // 0x03 3 Save Partial Screen
						//                  System.out.println("save screen partial");
						saveScreen();
						break;

					case ESC : // ESCAPE
						break;
					case 7 : // audible bell
						Toolkit.getDefaultToolkit().beep();
						bk.getNextByte();
						bk.getNextByte();
						break;
					case CMD_WRITE_TO_DISPLAY : // 0x11 17 write to display
						// add pei 060926
						screen52.setPendingInsertRestore(false);
						error = writeToDisplay(true);
						// del pei 061027
						//if (screen52.checkTBG()) screen52.clearScreen();
						break;
					case CMD_RESTORE_SCREEN : // 0x12 18 Restore Screen
					case 13 : // 0x13 19 Restore Partial Screen
						//                  System.out.println("restore screen partial");
						restoreScreen();
						break;

					case CMD_CLEAR_UNIT_ALTERNATE : // 0x20 32 clear unit alternate
						int param = bk.getNextByte();
						if (param != 0) {
							//                     System.out.println(" clear unit alternate error " + Integer.toHexString(param));
							sendNegResponse(
								NR_REQUEST_ERROR,
								03,
								01,
								05,
								" clear unit alternate not supported");
							done = true;
						} else {
							if (screen52.getRows() != 27)
								screen52.setRowsCols(27, 132);

							screen52.clearAll();

						}
						break;

					case CMD_WRITE_ERROR_CODE : // 0x21 33 Write Error Code
						writeErrorCode();
						error = writeToDisplay(false);
						break;
					case CMD_WRITE_ERROR_CODE_TO_WINDOW : // 0x22 34
						// Write Error Code to window
						writeErrorCodeToWindow();
						error = writeToDisplay(false);
						break;

					case CMD_ROLL: // 0x23 35	V1.3
						roll();
						break;
					case CMD_READ_SCREEN_IMMEDIATE : // 0x62  98
					case CMD_READ_SCREEN_TO_PRINT : // 0x66  102 read screen to print
					case CMD_READ_SCREEN_WITH_EA : // 0x64 pei
					case CMD_READ_SCREEN_TO_PRINT_WITH_EA : // 0x68 pei
					case CMD_READ_SCREEN_TO_PRINT_WITH_G : // 0x6a pei
					case CMD_READ_SCREEN_TO_PRINT_WITH_EA_AND_G : // 0x6c pei
						readScreen(b);
						break;

					case CMD_CLEAR_UNIT : // 64 0x40 clear unit
						if (screen52.getRows() != 24)
							screen52.setRowsCols(24, 80);
						screen52.clearAll();
						break;

					case CMD_CLEAR_FORMAT_TABLE : // 80 0x50 Clear format table
						screen52.clearTable();
						break;

					case CMD_READ_INPUT_FIELDS : //0x42 66 read input fields
					case CMD_READ_MDT_FIELDS : // 0x52 82 read MDT Fields
						bk.getNextByte();
						bk.getNextByte();
						readType = b;
						screen52.goHome();
						// do nothing with the cursor here it is taken care of
						//   in the main loop.
						////////////////                  screen52.setCursorOn();
						waitingForInput = true;
						pendingUnlock = true;
						//                  screen52.setKeyboardLocked(false);
						break;
					case CMD_READ_MDT_IMMEDIATE_ALT : // 0x53 83
						readType = b;
						//                  screen52.goHome();
						//                  waitingForInput = true;
						//                  screen52.setKeyboardLocked(false);
						readImmediate(readType);
						break;
					case CMD_WRITE_STRUCTURED_FIELD : // 243 0xF3 -13 Write structured field
						writeStructuredField();
						break;

					default :
						done = true;
						sendNegResponse(
							NR_REQUEST_ERROR,
							03,
							01,
							01,
							"parseIncoming");
						break;
				}

				if (error)
					done = true;
			}
		} catch (Exception exc) {
			System.out.println("incoming " + exc);
		};
	}

	/**
	 * This routine handles sending negative responses back to the host.
	 *
	 *    You can find a description of the types of responses to be sent back
	 *    by looking at section 12.4 of the 5250 Functions Reference manual
	 *
	 *
	 * @param cat
	 * @param modifier
	 * @param uByte1
	 * @param uByte2
	 * @param from
	 *
	 */
	private void sendNegResponse(
		int cat,
		int modifier,
		int uByte1,
		int uByte2,
		String from) {

		try {

			int os = bk.getByteOffset(-1) & 0xff;
			int cp = (bk.getCurrentPos() - 1);
			System.out.println(
				"invalid " + from + " command " + os + " at pos " + cp);
		} catch (Exception e) {

			System.out.println(
				"Send Negative Response error " + e);
		}

		baosp.write(cat);
		baosp.write(modifier);
		baosp.write(uByte1);
		baosp.write(uByte2);

		try {
			writeGDS(128, 0, baosp.toByteArray());
		} catch (IOException ioe) {

			System.out.println(ioe);
		}
		baosp.reset();

	}

	public void sendNegResponse2(int ec) {

		screen52.setPrehelpState(true, true, false);
		baosp.write(0x00);
		baosp.write(ec);

		try {
			writeGDS(1, 0, baosp.toByteArray());
		} catch (IOException ioe) {

			System.out.println(ioe);
		}

		baosp.reset();
	}

	private boolean writeToDisplay(boolean controlsExist) {

		int pos = 0;
		boolean error = false;
		boolean done = false;
		boolean kanji = false;
		int attr;
		byte nextOne;
		byte control0 = 0;
		byte control1 = 0;
		int saRows = screen52.getRows();
		int saCols = screen52.getCols();
		// add pei 061027
		int tbg_sts= 0;
		char tbg_char= ' ';
		ByteArrayOutputStream tbg_baos= null;

		try {
			if (controlsExist) {
				control0 = bk.getNextByte();
				control1 = bk.getNextByte();
				processCC0(control0);
			}
			while (bk.hasNext() && !done) {
				//            pos = bk.getCurrentPos();
				switch (bk.getNextByte()) {

					case 1 : // SOH - Start of Header Order

						error = processSOH();

						break;
					case 02 : // RA - Repeat to address

						int row = screen52.getCurrentRow();
						int col = screen52.getCurrentCol();

						int toRow = bk.getNextByte();
						int toCol = bk.getNextByte() & 0xff;
						// chg pei 071030 rowcol͈̔͂𖾊m
						//if (toRow >= row) {
						if (row > 0 && row <= saRows && col > 0 && col <= saCols && toRow >= row) {
							int repeat = bk.getNextByte();

							// a little intelligence here I hope
							if (row == 1
								&& col == 2
								&& toRow == screen52.getRows()
								&& toCol == screen52.getCols())
								screen52.clearScreen();
							else {
								byte ebc = (byte) repeat;
								if (repeat != 0) {
									//LDC - 13/02/2003 - convert it to unicode
									repeat = this.ebcdic2uni(repeat);
									//repeat = getASCIIChar(repeat);
								}

								int times =
									((toRow * screen52.getCols()) + toCol)
										- ((row * screen52.getCols()) + col);
								while (times-- >= 0) {
									// chg pei 071002 HotSpotcQC
									//screen52.setChar(repeat, 0, ebc);
									screen52.setChar(repeat, 0, ebc, true);
								}

							}
						} else {
							sendNegResponse(
								NR_REQUEST_ERROR,
								0x05,
								0x01,
								0x23,
								" RA invalid");
							error = true;
						}
						break;

					case 03 : // EA - Erase to address
						int EArow = screen52.getCurrentRow();
						int EAcol = screen52.getCurrentCol();

						int toEARow = bk.getNextByte();
						int toEACol = bk.getNextByte() & 0xff;
						int EALength = bk.getNextByte() & 0xff;
						
						// add pei 071030 toEARowtoEACol͈̔͂𖾊m
						if (toEARow <= 0 || toEARow > saRows ||
								toEACol <= 0 || toEACol > saCols) {
							sendNegResponse(
								NR_REQUEST_ERROR,
								0x05,
								0x01,
								0x22,
								"invalid row/col order");

							error = true;
							break;
						}
						
						while (--EALength > 0) {

							bk.getNextByte();

						}
						char EAAttr = (char) 0;

						// a little intelligence here I hope
						if (EArow == 1
							&& EAcol == 2
							&& toEARow == screen52.getRows()
							&& toEACol == screen52.getCols())
							screen52.clearScreen();
						else {
							int times =
								((toEARow * screen52.getCols()) + toEACol)
									- ((EArow * screen52.getCols()) + EAcol);
							while (times-- >= 0) {
								// chg pei 070528 HotSpotcQC
								//screen52.setChar(EAAttr, 0, (byte) 0);
								// chg pei 071002 HotSpotcQC
								//screen52.clearChar(EAAttr, 0, (byte) 0);
								screen52.setChar(EAAttr, 0, (byte) 0, true);
							}
						}
						break;
					case 04 : // Command - Escape
						done = true;
						break;

					case 14 : // K-IN
						// chg pei 071002 HotSpotcQC
						//screen52.setChar(' ', ScreenChar.F_DBC_IN, (byte) 0);
						screen52.setChar(' ', ScreenChar.F_DBC_IN, (byte) 0, true);
						kanji = true;
						break;

					case 15 : // K-OUT
						//screen52.setChar(' ', ScreenChar.F_DBC_OUT, (byte) 0);
						screen52.setChar(' ', ScreenChar.F_DBC_OUT, (byte) 0, true);
						kanji = false;
						break;

					case 16 : // TD - Transparent Data
						int j =
							(bk.getNextByte() & 0xff)
								<< 8 | bk.getNextByte() & 0xff;
						// length
						break;

					case 17 : // SBA - set buffer address order (row column)
						kanji= false;
						int saRow = bk.getNextByte();
						int saCol = bk.getNextByte() & 0xff;
						// make sure it is in bounds
						// chg pei 071030 
//						if (saRow >= 0
//							&& saRow <= screen52.getRows()
//							&& saCol >= 0
//							&& saCol <= screen52.getCols()) {
						if (saRow > 0
							&& saRow <= saRows
							&& saCol > 0
							&& saCol <= saCols) {
								
							screen52.goto_XY(saRow, saCol);
							//							screen52.goto_XY_with_C(saRow, saCol);
							// now set screen position for output

						} else {

							sendNegResponse(
								NR_REQUEST_ERROR,
								0x05,
								0x01,
								0x22,
								"invalid row/col order"
									+ " saRow = "
									+ saRow
									+ " saRows = "
									+ screen52.getRows()
									+ " saCol = "
									+ saCol);

							error = true;

						}
						break;

					case 18 : // WEA - Extended Attribute
						byte b1= bk.getNextByte();
						byte b2= bk.getNextByte();
						if (b1 == 0x05) {
							if (b2 == (byte)0x81) {
								kanji= true;
							} else if (b2 == (byte)0x80) {
								kanji=false;
							}
						}
						break;

					case 19 : // IC - Insert Cursor
						int icX = bk.getNextByte();
						int icY = bk.getNextByte() & 0xff;
						// chg pei 071030
//						if (icX >= 0
//							&& icX <= saRows
//							&& icY >= 0
//							&& icY <= saCols) {
						if (icX > 0
							&& icX <= saRows
							&& icY > 0
							&& icY <= saCols) {

//							System.out.println(" IC " + icX + " " + icY + " " + control1);
							screen52.setPendingInsert(true, icX, icY);
						} else {
							sendNegResponse(
								NR_REQUEST_ERROR,
								0x05,
								0x01,
								0x22,
								" IC/IM position invalid ");
							error = true;
						}

						break;

					case 20 : // MC - Move Cursor
						int imcX = bk.getNextByte();
						int imcY = bk.getNextByte() & 0xff;
						// chg pei 071030
//						if (imcX >= 0
//							&& imcX <= saRows
//							&& imcY >= 0
//							&& imcY <= saCols) {
						if (imcX > 0
							&& imcX <= saRows
							&& imcY > 0
							&& imcY <= saCols) {

//							System.out.println(" MC " + imcX + " " + imcY + " " + control1);
							screen52.setPendingInsert(false, imcX, imcY);
						} else {
							sendNegResponse(
								NR_REQUEST_ERROR,
								0x05,
								0x01,
								0x22,
								" IC/IM position invalid ");
							error = true;
						}

						break;

					case 21 : // WTDSF - Write To Display Structured Field order
						error = writeToDisplayStructuredField();
						break;

					case 29 : // SF - Start of Field
						int fcw1 = 0;
						int fcw2 = 0;
						// add 2lines pei 070718
						int fcw3 = 0;
						int fcw4 = 0;
						
						int ffw1 = 0;
						int ffw0 = bk.getNextByte() & 0xff; // FFW

						if ((ffw0 & 0x40) == 0x40) {
							ffw1 = bk.getNextByte() & 0xff; // FFW 1

							fcw1 = bk.getNextByte() & 0xff;
							// check for field control word

							// check if the first fcw1 is an 0x81 if it is then get the
							// next pair for checking
							if (fcw1 == 0x81) {
								bk.getNextByte();
								fcw1 = bk.getNextByte() & 0xff;
								// check for field control word
							}

							if (!isAttribute(fcw1)) {

								fcw2 = bk.getNextByte() & 0xff; // FCW 2
								attr = bk.getNextByte() & 0xff;
								// attribute field
								// add pei 071025 1byteڂ0x88̏ꍇ  3byteڂł͂Ȃꍇ							
								if (fcw1 == 0x88 && !isAttribute(attr)) {
									fcw3= fcw1;		// 1byteڂfcw3Ƃ
									fcw4= fcw2;		// 2byteڂfcw4Ƃ
									fcw1= attr;		// 3byteڂfcw1Ƃ
									fcw2= bk.getNextByte() & 0xff; 	// 4byteڂfcw2Ƃ
									attr = bk.getNextByte() & 0xff;	// 5byteڂ𑮐Ƃ
								}
								// add pei 070718 3byteڂ0x88őł͂Ȃꍇifcw4bytȅꍇj
								if (attr == 0x88) {
									fcw3= attr;		// 3byteڂfcw3Ƃ
									fcw4= bk.getNextByte() & 0xff; 	// 4byteڂfcw4Ƃ
									attr = bk.getNextByte() & 0xff;	// 5byteڂ𑮐Ƃ
								}
								
								while (!isAttribute(attr)) {
//									System.out.print(
//										Integer.toHexString(fcw1)
//											+ " "
//											+ Integer.toHexString(fcw2)
//											+ " ");
//									System.out.println(
//										Integer.toHexString(attr)
//											+ " "
//											+ Integer.toHexString(
//												bk.getNextByte() & 0xff));
									//                           bk.getNextByte();
									attr = bk.getNextByte() & 0xff;
									// attribute field
								}
							} else {
								attr = fcw1; // attribute of field
								fcw1 = 0;
							}
						} else {
							attr = ffw0;
						}

						int fLength =
							(bk.getNextByte() & 0xff)
								<< 8 | bk.getNextByte() & 0xff;
						screen52.addField(
							attr,
							fLength,
							1,
							ffw0,
							ffw1,
							fcw1,
							fcw2, 0);
						// add pei 070718
						if (fcw3 == 0x88) {
							screen52.getScreenFields().getCurrentField().setCursorProgression(fcw4);
						}
						break;

					default : // all others must be output to screen
						byte byte0 = bk.getByteOffset(-1);
// add start pei 061027
						if (tbg_sts != 0) {
							if (tbg_sts == 1) {
								tbg_char= codePage.ebcdic2uni(byte0);
								if (tbg_char >='A' && tbg_char <= 'F') {
									tbg_baos= new ByteArrayOutputStream();
									tbg_sts= 2;
								} else {
									tbg_sts= 0;
								}
							}
							if (tbg_sts == 2 && screen52.getLastPos() >= 3) {
								if (byte0 < 0) break;
								if (!isAttribute(byte0)) tbg_baos.write(byte0);
								break;
							}
						}
// add end
						if (isAttribute(byte0)) {
							kanji= false;
							// add pei 061027 chg pei 070629 TOOLBOXr 20rɒǉ
							//if (screen52.getLastPos() == 1 && byte0 == 0x2f && bk.getByteOffset(-2) != 0x28) {
							if (screen52.getLastPos() == 1 && 
									byte0 == 0x2f && 
//									bk.getByteOffset(-2) != 0x28 && 
//									bk.getByteOffset(-2) != 0x20) {
									(bk.getByteOffset(-2) & 0x01) != 0) { 
								tbg_sts= 1;
							}
							
							screen52.setAttr(byte0);
						} else {
							if (!screen52.isStatusErrorCode()) {
								if (kanji) {
									byte byte1 = bk.getNextByte();
									if (byte1 == 15) {
										kanji = false;
										screen52.setChar(
											' ',
											ScreenChar.F_DBC_OUT,
											//(byte) 0);
											(byte) 0, true);
										screen52.setChar(
											' ',
											0,
											//(byte) 0x40);
											(byte) 0x40, true);
									} else if (byte1 > 0 && byte1 < 0x40) {
										bk.setPrevByte();
										// add pei 060815
										screen52.setChar(
											' ',
											0,
											//(byte) 0x40);
											(byte) 0x40, true);
										continue;
									} else {
										screen52.setChar(
											codePage.ebcdic2unik(
												byte0,
												byte1),
											ScreenChar.F_DBC1,
											//(byte) 0);
											(byte) 0, true);
										screen52.setChar(
											'*',
											ScreenChar.F_DBC2,
											//(byte) 0);
											(byte) 0, true);
									}
								} else {
									if (!isDataEBCDIC(byte0)) {
										//screen52.setChar(0, 0, (byte) 0);
										screen52.setChar(0, 0, (byte) 0, true);
									} else {
										//LDC - 13/02/2003 - Convert it to unicode
										//screen52.setChar(getASCIIChar(byte0));
										screen52.setChar(
											codePage.ebcdic2uni(byte0),
											0,
											//byte0);
											byte0, true);
									}
								}
							} else {
								if (byte0 == 0)
									//screen52.setChar(byte0, 0, (byte) 0);
									screen52.setChar(byte0, 0, (byte) 0, true);
								else
									//LDC - 13/02/2003 - Convert it to unicode
									//screen52.setChar(getASCIIChar(byte0));
									if (kanji) {
										byte byte1 = bk.getNextByte();
										if (byte1 == 15) {
											kanji = false;
											screen52.setChar(
												' ',
												ScreenChar.F_DBC_OUT,
												//(byte) 0);
												(byte) 0, true);
											screen52.setChar(
												' ',
												0,
												//(byte) 0x40);
												(byte) 0x40, true);
										} else {
											screen52.setChar(
												codePage.ebcdic2unik(
													byte0,
													byte1),
												ScreenChar.F_DBC1,
												//(byte) 0);
												(byte) 0, true);
											screen52.setChar(
												'*',
												ScreenChar.F_DBC2,
												//(byte) 0);
												(byte) 0, true);
										}
									} else {
										//LDC - 13/02/2003 - Convert it to unicode
										//screen52.setChar(getASCIIChar(byte0));
										screen52.setChar(
											codePage.ebcdic2uni(byte0),
											0,
											//byte0);
											byte0, true);
									}
							}
						}

						break;
				}

				if (error)
					done = true;
			}
		} catch (Exception e) {
			System.out.println("write to display " + e);
			e.printStackTrace(System.out);
		};
		// add pei 061027
		if (tbg_sts == 2) {
			screen52.writeGrid_tb(0, tbg_baos.toByteArray(), tbg_char - 'A');	// ToolBox Grid
		}

		processCC1(control1);

		return error;

	}

	private boolean processSOH() throws Exception {

		int l = bk.getNextByte(); // length
		//      System.out.println(" byte 0 " + l);

		if (l > 0 && l <= 7) {
			bk.getNextByte(); // flag byte 2
			bk.getNextByte(); // reserved
			bk.getNextByte(); // resequence fields

			screen52.clearTable();

			// well that is the first time I have seen this.  This fixes a problem
			// with S/36 command line.  Finally got it.
			if (l <= 3)
				return false;

			screen52.setErrorLine(bk.getNextByte()); // error row

			int byte1 = 0;
			if (l >= 5) {
				byte1 = bk.getNextByte();
				dataIncluded[23] = (byte1 & 0x80) == 0x80;
				dataIncluded[22] = (byte1 & 0x40) == 0x40;
				dataIncluded[21] = (byte1 & 0x20) == 0x20;
				dataIncluded[20] = (byte1 & 0x10) == 0x10;
				dataIncluded[19] = (byte1 & 0x8) == 0x8;
				dataIncluded[18] = (byte1 & 0x4) == 0x4;
				dataIncluded[17] = (byte1 & 0x2) == 0x2;
				dataIncluded[16] = (byte1 & 0x1) == 0x1;
			}

			if (l >= 6) {
				byte1 = bk.getNextByte();
				dataIncluded[15] = (byte1 & 0x80) == 0x80;
				dataIncluded[14] = (byte1 & 0x40) == 0x40;
				dataIncluded[13] = (byte1 & 0x20) == 0x20;
				dataIncluded[12] = (byte1 & 0x10) == 0x10;
				dataIncluded[11] = (byte1 & 0x8) == 0x8;
				dataIncluded[10] = (byte1 & 0x4) == 0x4;
				dataIncluded[9] = (byte1 & 0x2) == 0x2;
				dataIncluded[8] = (byte1 & 0x1) == 0x1;
			}

			if (l >= 7) {
				byte1 = bk.getNextByte();
				dataIncluded[7] = (byte1 & 0x80) == 0x80;
				dataIncluded[6] = (byte1 & 0x40) == 0x40;
				dataIncluded[5] = (byte1 & 0x20) == 0x20;
				dataIncluded[4] = (byte1 & 0x10) == 0x10;
				dataIncluded[3] = (byte1 & 0x8) == 0x8;
				dataIncluded[2] = (byte1 & 0x4) == 0x4;
				dataIncluded[1] = (byte1 & 0x2) == 0x2;
				dataIncluded[0] = (byte1 & 0x1) == 0x1;
			}

			//         if (l >= 5)
			//            System.out.println(" byte 5 " + Integer.toBinaryString(bk.getNextByte()));
			//         if (l >= 6)
			//            System.out.println(" byte 6 " + Integer.toBinaryString(bk.getNextByte()));
			//         if (l == 7)
			//            System.out.println(" byte 7 " + Integer.toBinaryString(bk.getNextByte()));

			return false;
		} else {
			sendNegResponse(
				NR_REQUEST_ERROR,
				0x05,
				0x01,
				0x2B,
				"invalid SOH length");
			return true;
		}

	}

	private void processCC0(byte byte0) {
		//      System.out.println(" Control byte0 " + Integer.toBinaryString(byte0 & 0xff));
		boolean lockKeyboard = true;
		boolean resetMDT = false;
		boolean resetMDTAll = false;
		boolean nullMDT = false;
		boolean nullAll = false;

		// Bits 3 to 6 are reserved and should be set to '0000'
		// 0xE0 = '11100000' - only the first 3 bits are tested
		if ((byte0 & 0xE0) == 0x00) {
			lockKeyboard = false;
		}

		// '00100000' = 0x20 /32 -- just lock keyboard
		// '01000000' = 0x40 /64
		// '01100000' = 0x60 /96
		// '10000000' = 0x80 /128
		// '10100000' = 0xA0 /160
		// '11000000' = 0xC0 /192
		// '11100000' = 0xE0 /224

		switch (byte0 & 0xE0) {

			case 0x40 :
				resetMDT = true;
				break;
			case 0x60 :
				resetMDTAll = true;
				break;
			case 0x80 :
				nullMDT = true;
				break;
			case 0xA0 :
				resetMDT = true;
				nullAll = true;
				break;
			case 0xC0 :
				resetMDT = true;
				nullMDT = true;
				break;

			case 0xE0 :
				resetMDTAll = true;
				nullAll = true;
				break;

		}

		if (lockKeyboard) {
			screen52.setKeyboardLocked(true);
			pendingUnlock = false;
		} else
			pendingUnlock = false;

		if (resetMDT || resetMDTAll || nullMDT || nullAll) {
			ScreenField sf;

			int f = screen52.getScreenFields().getSize();
			for (int x = 0; x < f; x++) {
				sf = screen52.getScreenFields().getField(x);

				if (!sf.isBypassField()) {
					if ((nullMDT && sf.mdt) || nullAll) {
						sf.setFieldChar((char) 0x0, (byte) 0);
						screen52.drawField(sf);
					}
				}
				if (resetMDTAll || (resetMDT && !sf.isBypassField()))
					sf.resetMDT();

			}
			sf = null;
		}

	}

	private void processCC1(byte byte1) {
		//      System.out.println(" Control byte1 " + Integer.toBinaryString(byte1 & 0xff));

		if ((byte1 & 0x04) == 0x04) {
			Toolkit.getDefaultToolkit().beep();
		}
		if ((byte1 & 0x02) == 0x02) {
			screen52.setMessageLightOff();
		}
		if ((byte1 & 0x01) == 0x01) {
			screen52.setMessageLightOn();
		}

		if ((byte1 & 0x01) == 0x01 && (byte1 & 0x02) == 0x02) {
			screen52.setMessageLightOn();
		}

		// reset blinking cursor seems to control whether to set or not set the
		// the cursor position.  No documentation for this just testing and
		// looking at the bit settings of this field.  This was a pain in the ass!
		//
		// if it is off '0' then keep existing cursor positioning information
		// if it is on '1' then reset the cursor positioning information
		// *** Note *** unless we receive bit 4 on at the same time
		// this seems to work so far
		// delete MAR/2006 ????????
//????	if ((byte1 & 0x20) == 0x20 && (byte1 & 0x08) == 0x00) {
//		if ((byte1 & 0x40) == 0x40 && (byte1 & 0x08) == 0x00) {
//			screen52.setPendingInsert(false);
			//         System.out.println(" WTD position no move");
//		} else {

//			screen52.setPendingInsert(true);		delete MAR/2006 ????????
			//         System.out.println(" WTD position move to home" + screen52.homePos +
			//                              " row " + screen52.getRow(screen52.homePos) +
			//                              " col " + screen52.getCol(screen52.homePos) );

//		}
		// in enhanced mode we sometimes only receive bit 6 turned on which
		// is reset blinking cursor
		if ((byte1 & 0x20) == 0x20 && enhanced) {
			cursorOn = true;
		}

		if (!screen52.isStatusErrorCode() && (byte1 & 0x08) == 0x08) {

			//         screen52.setStatus(screen52.STATUS_SYSTEM,screen52.STATUS_VALUE_OFF,null);
			cursorOn = true;
		}

//????	if ((byte1 & 0x20) == 0x20 && (byte1 & 0x08) == 0x00) {
		// delete MAR/2006 ????????
//		if ((byte1 & 0x40) == 0x40 && (byte1 & 0x08) == 0x00) {
//			screen52.setPendingInsert(false, 1, 1);
//		}

	}

	private boolean isAttribute(int byte0) {
		int byte1 = byte0 & 0xff;
		return (byte1 & 0xe0) == 0x20;
	}

	//LDC - 12/02/2003 - Function name changed from isData to isDataEBCDIC
	private boolean isDataEBCDIC(int byte0) {
		int byte1 = byte0 & 0xff;
		// here it should always be less than 255
		if (byte1 >= 64 && byte1 < 255)
			return true;
		else
			return false;

	}

	//LDC - 12/02/2003 - Test if the unicode character is a displayable character.
	//  The first 32 characters are non displayable characters
	//  This is normally the inverse of isDataEBCDIC (That's why there is a
	//  check on 255 -> 0xFFFF
	private boolean isDataUnicode(int byte0) {
		return (((byte0 < 0) || (byte0 >= 32)) && (byte0 != 0xFFFF));
	}

	private boolean writeToDisplayStructuredField() {

		boolean error = false;
		boolean done = false;
		boolean windowDefined = false;
		int nextone;
		try {
			int length =
				((bk.getNextByte() & 0xff) << 8 | (bk.getNextByte() & 0xff));

			while (!done) {
				int s = bk.getNextByte() & 0xff;
				switch (s) {

					case 0xD9 : // Class Type 0xD9 - Create Window

						switch (bk.getNextByte()) {
							case 0x50 : // Define Selection Field

								defineSelectionField(length);
								done = true;
								break;
							case 0x51 : // Create Window

								boolean cr = false;
								int rows = 0;
								int cols = 0;
								// pull down not supported yet
								if ((bk.getNextByte() & 0x80) == 0x80)
									cr = true; // restrict cursor
								bk.getNextByte(); // get reserved field pos 6
								bk.getNextByte(); // get reserved field pos 7
								rows = bk.getNextByte();
								// get window depth rows pos 8
								cols = bk.getNextByte();
								// get window width cols pos 9
								length -= 9;
								if (length == 0) {
									done = true;
									//                           System.out.println("Create Window");
									//                           System.out.println("   restrict cursor " + cr);
									//                           System.out.println(" Depth = " + rows + " Width = " + cols);
									screen52.createWindow(
										rows,
										cols,
										1,
										true,
										32,
										58,
										'.',
										'.',
										'.',
										':',
										':',
										':',
										'.',
										':');
									windowDefined = true;
									break;
								}

								// pos 10 is Minor Structure
								int ml = 0;
								int type = 0;
								int lastPos = screen52.getLastPos();
								//                        if (cr)
								//                           screen52.setPendingInsert(true,
								//                                          screen52.getCurrentRow(),
								//                                          screen52.getCurrentCol());
								int mAttr = 0;
								int cAttr = 0;

								while (length > 0) {

									// get minor length
									ml = (bk.getNextByte() & 0xff);
									length -= ml;

									// only normal windows are supported at this time
									type = bk.getNextByte();

									switch (type) {

										case 0x01 : // Border presentation
											boolean gui = false;
											if ((bk.getNextByte() & 0x80)
												== 0x80)
												gui = true;
											mAttr = bk.getNextByte();
											cAttr = bk.getNextByte();

											char ul = '.';
											char upper = '.';
											char ur = '.';
											char left = ':';
											char right = ':';
											char ll = ':';
											char bottom = '.';
											char lr = ':';

											// if minor length is greater than 5 then
											//    the border characters are specified
											if (ml > 5) {
												ul =
													codePage.ebcdic2uni(
														bk.getNextByte());
												//                                    ul = getASCIIChar(bk.getNextByte());
												if (ul == 0)
													ul = '.';

												upper =
													codePage.ebcdic2uni(
														bk.getNextByte());
												//                                    upper = getASCIIChar(bk.getNextByte());
												if (upper == 0)
													upper = '.';

												ur =
													codePage.ebcdic2uni(
														bk.getNextByte());
												//                                    ur = getASCIIChar(bk.getNextByte());
												if (ur == 0)
													ur = '.';

												left =
													codePage.ebcdic2uni(
														bk.getNextByte());
												//                                    left = getASCIIChar(bk.getNextByte());
												if (left == 0)
													left = ':';

												right =
													codePage.ebcdic2uni(
														bk.getNextByte());
												//                                    right = getASCIIChar(bk.getNextByte());
												if (right == 0)
													right = ':';

												ll =
													codePage.ebcdic2uni(
														bk.getNextByte());
												//                                    ll = getASCIIChar(bk.getNextByte());
												if (ll == 0)
													ll = ':';

												bottom =
													codePage.ebcdic2uni(
														bk.getNextByte());
												//                                    bottom = getASCIIChar(bk.getNextByte());
												if (bottom == 0)
													bottom = '.';

												lr =
													codePage.ebcdic2uni(
														bk.getNextByte());
												//                                    lr = getASCIIChar(bk.getNextByte());
												if (lr == 0)
													lr = ':';
											}

											//                                 System.out.println("Create Window");
											//                                 System.out.println("   restrict cursor " + cr);
											//                                 System.out.println("   Depth = " + rows + " Width = " + cols);
											//                                 System.out.println("   type = " + type + " gui = " + gui);
											//                                 System.out.println("   mono attr = " + mAttr + " color attr = " + cAttr);
											//                                 System.out.println("   ul = " + ul + " upper = " + upper +
											//                                                         " ur = " + ur +
											//                                                         " left = " + left +
											//                                                         " right = " + right +
											//                                                         " ll = " + ll +
											//                                                         " bottom = " + bottom +
											//                                                         " lr = " + lr
											//                                                         );
											screen52.createWindow(
												rows,
												cols,
												type,
												gui,
												mAttr,
												cAttr,
												ul,
												upper,
												ur,
												left,
												right,
												ll,
												bottom,
												lr);
											windowDefined = true;
											break;
											//
											//  The following shows the input for window with a title
											//
											//      +0000 019A12A0 00000400 00020411 00200107  .?.?..?...?..?.
											//      +0010 00000018 00000011 06131500 37D95180  ........?.?..R??
											//      +0020 00000A24 0D018023 23404040 40404040  ..??..???
											//      +0030 40211000 000000D7 C2C1D9C4 C5D4D67A   \uFFFD.....PBARDEMO:
											//      +0040 40D79996 879985A2 A2408281 99408485   Progress bar de
											//      +0050 94961108 1520D5A4 94828599 40968640  mo.???Number of
											//      +0060 8595A399 8985A24B 4B4B4B4B 4B7A2011  entries......:?.
											//      +0070 082E2040 404040F5 F0F06BF0 F0F02011  ?.?    500,000?.
											//      +0080 091520C3 A4999985 95A34085 95A399A8  \uFFFD??Current entry
											//      +0090 4095A494 8285994B 4B4B7A20 11092E20   number...:?.\uFFFD.?
											//      +00A0 40404040 4040F56B F0F0F020 110A1520        5,000?.???
											//      +00B0 D9859481 89958995 87408595 A3998985  Remaining entrie
											//      +00C0 A24B4B4B 4B4B4B7A 20110A2E 20404040  s......:?.?.?
											//      +00D0 40F4F9F5 6BF0F0F0 20110C15 20E2A381   495,000?..??Sta
											//      +00E0 99A340A3 8994854B 4B4B4B4B 4B4B4B4B  rt time.........
											//      +00F0 4B4B4B4B 7A20110C 2F2040F7 7AF5F37A  ....:?...? 7:53:

										case 0x10 : // Window title/footer
											if (!windowDefined) {
												screen52.createWindow(
													rows,
													cols,
													1,
													true,
													32,
													58,
													'.',
													'.',
													'.',
													':',
													':',
													':',
													'.',
													':');
												windowDefined = true;
											}

											byte orientation = bk.getNextByte();
											mAttr = bk.getNextByte();
											cAttr = bk.getNextByte();

											//reserved
											bk.getNextByte();
											ml -= 6;

//											StringBuffer hfBuffer =
//												new StringBuffer(ml);
											byte [] hfb= new byte[ml];
											
//											while (ml-- > 0) {
												//LDC - 13/02/2003 - Convert it to unicode
//												hfBuffer.append(
//													codePage.ebcdic2uni(
//														bk.getNextByte()));
												//                                    hfBuffer.append(getASCIIChar(bk.getNextByte()));
											for (int i= 0; i < ml; ++i) {
												hfb[i]= bk.getNextByte();
											}

//											System.out.println(
//												" orientation "
//													+ Integer.toBinaryString(
//														orientation)
//													+ " mAttr "
//													+ mAttr
//													+ " cAttr "
//													+ cAttr
//													+ " Header/Footer "
//													+ hfBuffer);
											screen52.writeWindowTitle(
												lastPos,
												rows,
												cols,
												orientation,
												mAttr,
												cAttr,
//												hfBuffer);
												hfb);
											break;
										default :
											System.out.println(
												"Invalid Window minor structure");
											length = 0;
											done = true;
									}

								}
								// add pei 061108
								screen52.clearPMouseB();
								
								done = true;

								break;

							case 0x53 : // Scroll Bar
								int sblen = 15;
								byte sbflag = bk.getNextByte();
								// flag position 5

								bk.getNextByte(); // reserved position 6

								// position 7,8
								int totalRowScrollable =
									((bk.getNextByte() & 0xff)
										<< 8 | (bk.getNextByte() & 0xff));

								// position 9,10
								int totalColScrollable =
									((bk.getNextByte() & 0xff)
										<< 8 | (bk.getNextByte() & 0xff));

								// position 11,12
								int sliderRowPos =
									((bk.getNextByte() & 0xff)
										<< 8 | (bk.getNextByte() & 0xff));

								// position 13,14
								int sliderColPos =
									((bk.getNextByte() & 0xff)
										<< 8 | (bk.getNextByte() & 0xff));

								// position 15
								int sliderRC = bk.getNextByte();

								screen52.createScrollBar(
									-1,
									sbflag,
									totalRowScrollable,
									totalColScrollable,
									sliderRowPos,
									sliderColPos,
									sliderRC);
								length -= 15;

								done = true;

								break;

							case 0x5B : // Remove GUI ScrollBar field

								bk.getNextByte();
								// reserved must be set to off pos 5
								bk.getNextByte();
								// reserved must be set to zero pos 6

								done = true;
								break;

							case 0x5F : // Remove All GUI Constructs
								//                        System.out.println("remove all gui contructs");
								int len = 4;
								int d = 0;
								length -= s;
								while (--len > 0)
									d = bk.getNextByte();
								//                        if (length > 0) {
								//                           len = (bk.getNextByte() & 0xff )<< 8;
								//
								//                           while (--len > 0)
								//                              d = bk.getNextByte();
								//                        }

								screen52.clearGuiStuff();
								// per 14.6.13.4 documentation we should clear the
								//    format table after this command
								screen52.clearTable();
								done = true;
								break;

							case 0x60 : // Erase/Draw Grid Lines 
								// do not know what they are
								// as of 03/11/2002 we should not be getting
								// this anymore but I will leave it here
								//  just in case.
								//                        System.out.println("erase/draw grid lines " + length);
								//pei
								byte[] hd = new byte[5];
								length -= 9;
								for (int i = 0; i < 5; ++i) {
									hd[i] = bk.getNextByte();
								}
								if ((hd[1] & 0x80) != 0) {
									screen52.clearGrid();
								}
								if (length >= 2) {
									d = bk.getNextByte();
									bk.getNextByte();
									length -= 2;
									if (length > 0) {
										ByteArrayOutputStream baos =
											new ByteArrayOutputStream();
										while (length-- > 0) {
											baos.write(bk.getNextByte());
										}
										// chg pei 061121 rQΉ
										//screen52.writeGrid(d, baos.toByteArray());
										screen52.writeGrid(d, baos);
									}
								}
								done = true;
								break;
							case 0x55:		// PROGRAMMABLE MOUSE BUTTONS
								length -= 7;
								for (int i= 0; i < 3; ++i) {
									bk.getNextByte();
								}
								if (length == 0) {
									screen52.clearPMouseB();
								} else {
									while (length >= 4) {
										screen52.addPMouseB(bk.getNextByte(), bk.getNextByte(), bk.getNextByte(), bk.getNextByte());
										length -= 4;
									}
									while (length-- > 0) {
										bk.getNextByte();
									}
								}
								done = true;
								break;
							case 0x58:		// REMOVE GUI SELECTION FIELD
//								System.out.println("REMOVE ");
								length -= 4;
								while (length-- > 0) {
									d = bk.getNextByte();
								}
								screen52.removeButton();
								done = true;
								break;
							case 0x52:		// UNRESTRICTED WINDOW CURSOR MOVEMENT
							case 0x54:		// WRITE DATA
							case 0x59:		// REMOVE GUI WINDOW
							case 0x61:		// CLEAR GRID LINE BUFFER
								System.out.println("???? not supported wtd structured field sub command " + bk.getByteOffset(-1));
								length -= 4;
								while (length-- > 0) {
									d = bk.getNextByte();
								}
								done = true;
								break;
							default :
								sendNegResponse(
									NR_REQUEST_ERROR,
									0x03,
									0x01,
									0x01,
									"invalid wtd structured field sub command "
										+ bk.getByteOffset(-1));
								error = true;
								break;
						}
						break;

					default :
						sendNegResponse(
							NR_REQUEST_ERROR,
							0x03,
							0x01,
							0x01,
							"invalid wtd structured field command "
								+ bk.getByteOffset(-1));
						error = true;
						break;
				}

				if (error)
					done = true;

			}
		} catch (Exception e) {
		// chg pei 061121 rQΉ
		//};
			e.printStackTrace();
		}

		return error;

	}

	private void defineSelectionField(int majLen) {

		//   0030:  20 00 2C 3E 00 00 00 69 12 A0 00 00 04 00 00 03  .,>...i........
		//   0040:  04 40 04 11 00 28 01 07 00 00 00 19 00 00 04 11 .@...(..........
		//   0050:  14 19 15 00 48 D9 50 00 60 00 11 01 84 84 00 00 ....H.P.`.......
		//   0060:  05 03 01 01 00 00 00 13 01 E0 00 21 00 21 00 3B ...........!.!.;
		//   0070:  22 20 20 20 20 3A 24 20 20 3A 0B 10 08 00 E0 00 "    :$  :......
		//   0080:  D6 95 85 40 40 0B 10 08 00 E0 00 E3 A6 96 40 40 ...@@.........@@
		//   0090:  0B 10 08 00 E0 00 E3 88 99 85 85 04 52 00 00 FF ............R...
		//   00A0:  EF                                              .
		try {
			int flag1 = bk.getNextByte(); // Flag byte 1 - byte 5
			int flag2 = bk.getNextByte(); // Flag byte 2 - byte 6
			int flag3 = bk.getNextByte(); // Flag byte 3 - byte 7
//			System.out.println("FALG1=" + Integer.toHexString(flag1));
			int typeSelection = bk.getNextByte();
			// Type of selection Field - byte 8

			// GUI Device Characteristics:
			//    This byte is used if the target device is a GUI PWS or a GUI-like
			//    NWS.  If neigher of these WS are the targets, this byte is ignored
			int guiDevice = bk.getNextByte(); // byte 9
			int withMnemonic = bk.getNextByte(); //  byte 10
			int noMnemonic = bk.getNextByte(); // byte 11

			bk.getNextByte(); // Reserved - byte 12
			bk.getNextByte(); // Reserved - byte 13

			int cols = bk.getNextByte(); // Text Size - byte 14
			int rows = bk.getNextByte(); // Rows - byte 15

			int maxColChoice = bk.getNextByte();
			// byte 16 num of column choices
			int padding = bk.getNextByte(); // byte 17
			int numSepChar = bk.getNextByte(); // byte 18
			int ctySepChar = bk.getNextByte(); // byte 19
			int cancelAID = bk.getNextByte(); // byte 20

			int cnt = 0;
			int minLen = 0;
			majLen -= 21;
//			System.out.println(
//				" row: "
//					+ screen52.getCurrentRow()
//					+ " col: "
//					+ screen52.getCurrentCol()
//					+ " type "
//					+ typeSelection
//					+ " gui "
//					+ guiDevice
//					+ " withMnemonic "
//					+ withMnemonic
//					+ " cols "
//					+ cols
//					+ " rows "
//					+ rows);
			int rowCtr = 0;
			int chcRowStart = screen52.getCurrentRow();
			int chcColStart = screen52.getCurrentCol();
			int colAvail = 0x20;
			int colSelAvail = 0x20;
			int fld = 0;
			screen52.addField(colAvail, cols, rows, 0x20, 0, 0, 0, typeSelection);
			ScreenField cf=screen52.getScreenFields().getCurrentField();
			// chg pei 080208
			//if (cf instanceof SingleSelectionField) {
			if (cf.isSelectionField()) {
				//SingleSelectionField ssf= (SingleSelectionField)cf;
				SelectionField ssf= (SelectionField)cf;
				ssf.setFlag(flag1, flag2, flag3);
				ssf.setMaxColChoice(maxColChoice);
				// add pei 080208
				if (typeSelection == ScreenField.F_MENU) {
					//ssf.setMenu_cnt(maxColChoice);
					ssf.setSelectPos(1);
				}
			}
			// add pei 080208
			// chg pei 080312
			//int menu_cnt= 0;
			int choice_cnt= 1;
//			int choice_row= 0;
			int chccol= chcColStart;
			if ((flag2 & 0x80) != 0) {
				int ss_rows = (bk.getNextByte() & 0xff) << 24;
				ss_rows += (bk.getNextByte() & 0xff) << 16;
				ss_rows += (bk.getNextByte() & 0xff) << 8;
				ss_rows += (bk.getNextByte() & 0xff);
				int ss_pos = (bk.getNextByte() & 0xff) << 24;
				ss_pos += (bk.getNextByte() & 0xff) << 16;
				ss_pos += (bk.getNextByte() & 0xff) << 8;
				ss_pos += (bk.getNextByte() & 0xff);
				majLen -= 8;
				screen52.createScrollBar(screen52.getPos(chcRowStart - 1, chcColStart + cols + 1), 0x100, 0, ss_rows, 0, ss_pos, rows);
			}
			
			do {
				minLen = bk.getNextByte(); // Minor Length byte 21

				int minType = bk.getNextByte(); // Minor Type

				switch (minType) {

					case 0x01 : // Choice Presentation Display

						// flag
						int flagCP1 = bk.getNextByte();

						bk.getNextByte();
						// mon select cursor avail emphasis - byte4
						colSelAvail = bk.getNextByte(); // -byte 5

						bk.getNextByte(); // mon select cursor - byte 6
						int colSelCur = bk.getNextByte(); // -byte 7

						bk.getNextByte();
						// mon select cursor not avail emphasis - byte 8
						int colSelNotAvail = bk.getNextByte(); // -byte 9

						bk.getNextByte(); // mon avail emphasis - byte 10
						colAvail = bk.getNextByte(); // -byte 11

						bk.getNextByte(); // mon select emphasis - byte 12
						int colSel = bk.getNextByte(); // -byte 13

						bk.getNextByte(); // mon not avail emphasis - byte 14
						int colNotAvail = bk.getNextByte(); // -byte 15

						bk.getNextByte(); // mon indicator emphasis - byte 16
						int colInd = bk.getNextByte(); // -byte 17

						bk.getNextByte();
						// mon indicator not avail emphasis - byte 18
						int colNotAvailInd = bk.getNextByte(); // -byte 19

						break;

					case 0x10 : // Choice Text minor structure
						// chg pei 080208
						// chg pei 080312
//						screen52.goto_XY(chcRowStart++, chcColStart);
//						screen52.goto_XY(chcRowStart, chcColStart);
//						if (typeSelection != ScreenField.F_MENU) {
//							++chcRowStart;
//						}
						screen52.goto_XY(chcRowStart, chccol);
						
						cnt = 5;
						int flagCT1 = bk.getNextByte();
						int flagCT2 = bk.getNextByte();
						int flagCT3 = bk.getNextByte();
						int mnemOffset = 0;
						int aid = 0;
						boolean selected = false;
						boolean available= true;

						// selected
						if ((flagCT1 & 0xc0) == 0x40) {
							selected = true;
						}

						// Not available
						if ((flagCT1 & 0xc0) == 0x80) {
							available= false;
						}

						// is mnemonic offset specified
						if ((flagCT1 & 0x08) == 8) {
							mnemOffset = bk.getNextByte();
							//System.out.println(" mnemOffset " + mnemOffset);
							cnt++;
						}

						// is aid key specified
						if ((flagCT1 & 0x04) == 4) {
							aid = bk.getNextByte();
//							System.out.println(" aidKey " + aid);
							cnt++;
						}

						// is single digit number specified
						if ((flagCT1 & 0x01) == 0x01) {
							System.out.println(" single digit ");
							bk.getNextByte();
							cnt++;
						}

						// is double digint number specified
						if ((flagCT1 & 0x02) == 0x02) {
							System.out.println(" double digit ");

							bk.getNextByte();
							cnt++;
						}

						byte byte0 = 0;
						switch (typeSelection) {
							case ScreenField.F_BUTTON:
								((ButtonField)cf).setAid((byte)aid);
								screen52.advancePos();
								break;
							case ScreenField.F_SINGLESELECTION:
							case ScreenField.F_MULTISELECTION:
							// add pei 080208
							case ScreenField.F_SINGLESELECTION_PD:
							case ScreenField.F_SINGLESELECTION_LIST:
//								SingleSelectionField ssf= (SingleSelectionField)cf;
//								// chg pei 080208
//								ssf.setAvailable(chcRowStart - ssf.startRow() - 1, available);
//								int n= chcRowStart - ssf.startRow() - 1;
//								ssf.setAvailable(n, available);
//								ssf.setMinorFlags(n, flagCT1, flagCT2, flagCT3);
//								
//								if (selected) {
//									ssf.setSelectPos(chcRowStart - ssf.startRow() - 1);
//									// add pei 080208
//									screen52.getScreenFields().setMasterMDT();
//								}
//								break;
							// add pei 080208
							case ScreenField.F_MENU:
//								++menu_cnt;
//								ssf= (SingleSelectionField)cf;
//								ssf.setAvailable(menu_cnt, available);
//								ssf.setMinorFlags(menu_cnt, flagCT1, flagCT2, flagCT3);
//								ssf.setMenu_pos(menu_cnt, screen52.getLastPos() + 1, minLen - cnt);
//								chcColStart += minLen - cnt + 3;
								SelectionField ssf= (SelectionField)cf;
								ssf.setAvailable(choice_cnt, available);
								ssf.setMinorFlags(choice_cnt, flagCT1, flagCT2, flagCT3);
								ssf.setChoice_pos(choice_cnt, screen52.getLastPos() + 1, minLen - cnt);
								chccol += minLen - cnt + 3;

								if (selected) {
									//ssf.setSelectPos(menu_cnt);
									ssf.setSelectPos(choice_cnt);
								}
								break;

							default:
								System.out.println("not support field type " + typeSelection);
								break;
						}
						boolean dbcs= false;
						screen52.advancePos();
						for (; cnt < minLen; cnt++) {

							byte0 = bk.getNextByte();
							switch (byte0) {
								case 0x0e:
									dbcs= true;
									//screen52.setChar(' ', ScreenChar.F_DBC_IN, (byte) 0);
									screen52.setChar(' ', ScreenChar.F_DBC_IN, (byte) 0, false);
									break;
								case 0x0f:
									dbcs= false;
									//screen52.setChar(' ', ScreenChar.F_DBC_OUT, (byte) 0);
									screen52.setChar(' ', ScreenChar.F_DBC_OUT, (byte) 0, false);
									break;
								default:
									if (dbcs) {
										byte byte1= bk.getNextByte();
										++cnt;
										screen52.setChar(
											codePage.ebcdic2unik(
												byte0,
												byte1),
											ScreenChar.F_DBC1,
											//(byte) 0);
											(byte) 0, false);
										screen52.setChar(
											'*',
											ScreenChar.F_DBC2,
											//(byte) 0);
											(byte) 0, false);
									} else {
										//screen52.setChar(ebcdic2uni(byte0), 0, byte0); 
										screen52.setChar(ebcdic2uni(byte0), 0, byte0, false); 
									}
									break;
							}
						}
						if ((choice_cnt % maxColChoice) == 0) {
//							++choice_row;
//							choice_cnt= 1;
							++chcRowStart;
							chccol= chcColStart;
						}
						++choice_cnt;
						break;
					default :
						for (cnt = 2; cnt < minLen; cnt++) {

							bk.getNextByte();
						}

				}

				majLen -= minLen;

			} while (majLen > 0);
			if (cf.isSelectionField()) {
//			if (typeSelection == ScreenField.F_SINGLESELECTION) {
				// chg pei 080208
//				screen52.drawSingleSelection((SingleSelectionField)cf);
				screen52.drawSelection(cf);
			}
		} catch (Exception exc) {
			System.out.println(" defineSelectionField :" + exc);
			exc.printStackTrace();
		}
	}

	private void writeStructuredField() {

		boolean done = false;
		int nextone;
		try {
			int length =
				((bk.getNextByte() & 0xff) << 8 | (bk.getNextByte() & 0xff));
			while (bk.hasNext() && !done) {
				switch (bk.getNextByte()) {

					case -39 : // SOH - Start of Header Order

						switch (bk.getNextByte()) {
							case 112 : // 5250 Query
								bk.getNextByte(); // get null required field
								sendQueryResponse();
								break;
							default :
								System.out.println(
									"invalid structured field sub command "
										+ bk.getByteOffset(-1));
								break;
						}
						break;
					default :
						System.out.println(
							"invalid structured field command "
								+ bk.getByteOffset(-1));
						break;
				}
			}
		} catch (Exception e) {
		};

	}

	private final void writeErrorCode() throws Exception {
		screen52.goto_XY(screen52.getErrorLine(), 1); // Skip the control byte
		screen52.setStatus(
			Screen5250.STATUS_ERROR_CODE,
			Screen5250.STATUS_VALUE_ON,
			null);
		screen52.saveErrorLine();
		cursorOn = true;

	}

	private final void writeErrorCodeToWindow() throws Exception {
		int fromCol = bk.getNextByte() & 0xff; // from column
		int toCol = bk.getNextByte() & 0xff; // to column
		screen52.goto_XY(screen52.getErrorLine(), fromCol);
		// Skip the control byte
		screen52.setStatus(
			Screen5250.STATUS_ERROR_CODE,
			Screen5250.STATUS_VALUE_ON,
			null);
		screen52.saveErrorLine();
		cursorOn = true;

	}

	/**
	 * Method sendQueryResponse
	 *
	 * The query command is used to obtain information about the capabilities
	 * of the 5250 display.
	 *
	 * The Query command must follow an Escape (0x04) and Write Structured
	 * Field command (0xF3).
	 *
	 * This section is modeled after the rfc1205 - 5250 Telnet Interface section
	 * 5.3
	 *
	 * @throws IOException
	 */
	public final void sendQueryResponse() throws IOException {

		System.out.println("sending query response");
		byte abyte0[] = new byte[64];
		abyte0[0] = 0; // Cursor Row/column (set to zero)
		abyte0[1] = 0; //           ""
		abyte0[2] = -120; // X'88' inbound write structure Field aid
		if (enhanced == true) {
			abyte0[3] = 0; // 0x003D (61) length of query response
			abyte0[4] = 64; //       ""  see note below ?????????
		} else {
			abyte0[3] = 0; // 0x003A (58) length of query response
			abyte0[4] = 58; //       ""
			//  the length between 58 and 64 seems to cause
			//  different formatting codes to be sent from
			//  the host ???????????????? why ???????
			//    Well the why can be found in the manual if
			//       read a little more ;-)
		}
		abyte0[5] = -39; // command class 0xD9
		abyte0[6] = 112; // Command type query 0x70
		abyte0[7] = -128; // 0x80 Flag byte
		//pei		abyte0[8] = 6; // Controller Hardware Class
		abyte0[8] = 5; // Controller Hardware Class
		abyte0[9] = 0; // 0x0600 - Other WSF or another 5250 Emulator
		//pei		abyte0[10] = 1; // Controller Code Level
		abyte0[10] = 3; // Controller Code Level
		//pei		abyte0[11] = 1; //    Version 1 Rel 1.0
		abyte0[11] = 2; //    Version 1 Rel 1.0
		abyte0[12] = 0; //       ""

		abyte0[13] = 0; // 13 - 28 are reserved so set to 0x00
		abyte0[14] = 0; //       ""
		abyte0[15] = 0; //       ""
		abyte0[16] = 0; //       ""
		abyte0[17] = 0; //       ""
		abyte0[18] = 0; //       ""
		abyte0[19] = 0; //       ""
		abyte0[20] = 0; //       ""
		abyte0[21] = 0; //       ""
		abyte0[22] = 0; //       ""
		abyte0[23] = 0; //       ""
		abyte0[24] = 0; //       ""
		abyte0[25] = 0; //       ""
		abyte0[26] = 0; //       ""
		abyte0[27] = 0; //       ""
		abyte0[28] = 0; //       ""
		abyte0[29] = 1; // Device type - 0x01 5250 Emulator
		//pei
		abyte0[30] = codePage.uni2ebcdic('5', false)[0]; // Device type character
		abyte0[31] = codePage.uni2ebcdic('5', false)[0]; //          ""
		abyte0[32] = codePage.uni2ebcdic('5', false)[0]; //          ""
		abyte0[33] = codePage.uni2ebcdic('5', false)[0]; //          ""
		abyte0[34] = codePage.uni2ebcdic('-', false)[0]; //          ""
		abyte0[35] = codePage.uni2ebcdic('0', false)[0]; //          ""
		abyte0[36] = codePage.uni2ebcdic('1', false)[0]; //          ""

		abyte0[37] = 0; // Keyboard Id - 0x02 Standard Keyboard
		abyte0[38] = 0; // extended keyboard id
		abyte0[39] = 0; // reserved

		abyte0[40] = 0; // 40 - 43 Display Serial Number
		abyte0[41] = 0; //
		abyte0[42] = 0; //
		abyte0[43] = 0; //

		abyte0[44] = 1; // Maximum number of display fields - 256
		abyte0[45] = 0; // 0x0100
		abyte0[46] = 0; // 46 -48 Reserved set to 0x00
		abyte0[47] = 0;
		abyte0[48] = 0;
		//		abyte0[49] = 1; // 49 - 53 Controller Display Capability
		abyte0[49] = 0x7f; // 49 - 53 Controller Display Capability
		//pei		abyte0[50] = 16; //      see rfc - tired of typing :-)
		if (support132) {
			abyte0[50] = 0x31; // 132
		} else {
			abyte0[50] = 0x11; // 80
		}
		abyte0[51] = 0; //          ""
		abyte0[52] = 0x40; //          ""  !!!! STRQSH

		//  53
		//    Bit 0-2: B'000'   -  no graphics capability
		//             B'001'   - 5292-2 style graphics
		//    Bit 3-7: B '00000' = reserved (it seems for Client access)
		/* pei
				if (enhanced == true) {
					abyte0[53] = 0x5E; //  0x5E turns on ehnhanced mode
					//         abyte0[53] = 0x1F;      //  0x5E turns on ehnhanced mode
					System.out.println("enhanced options");
				} else
					abyte0[53] = 0x0; //  0x0 is normal emulation
		*/
		//pei
		abyte0[53] = 0x1F; //  0x0 is normal emulation
		//pei		abyte0[54] = 24; // 54 - 60 Reserved set to 0x00
		abyte0[54] = (byte) 0x88; // 54 - 60 Reserved set to 0x00
		//  54 - I found out is used for enhanced user
		//       interface level 3.  Bit 4 allows headers
		//       and footers for windows
		abyte0[55] = 0;
		abyte0[56] = 0;
		abyte0[57] = 0;
		abyte0[58] = 0;
		abyte0[59] = 0;
		abyte0[60] = 0;
		//		abyte0[61] = 0; // gridlines are not supported
		//		abyte0[62] = 0; // gridlines are not supported
		abyte0[61] = 1; // gridlines are supported
		abyte0[62] = 1; // gridlines are supported
		abyte0[63] = 0;
		writeGDS(0, 0, abyte0); // now tell them about us
		abyte0 = null;

	}

	protected final boolean negotiate(byte abyte0[]) throws IOException {
		int i = 0;

		// from server negotiations
		if (abyte0[i] == IAC) { // -1

			while (i < abyte0.length && abyte0[i++] == -1)
				//         while(i < abyte0.length && (abyte0[i] == -1 || abyte0[i++] == 0x20))
				switch (abyte0[i++]) {

					// we will not worry about what it WONT do
					case WONT : // -4
					default :
						break;

					case DO : //-3

						switch (abyte0[i]) {
							case TERMINAL_TYPE : // 24
								baosp.write(IAC);
								baosp.write(WILL);
								baosp.write(TERMINAL_TYPE);
								//                        writeByte(baosp.toByteArray());
								//                        baosp.reset();

								break;

							case OPT_END_OF_RECORD : // 25

								baosp.write(IAC);
								baosp.write(WILL);
								baosp.write(OPT_END_OF_RECORD);
								//                        writeByte(baosp.toByteArray());
								//                        baosp.reset();
								break;

							case TRANSMIT_BINARY : // 0

								baosp.write(IAC);
								baosp.write(WILL);
								baosp.write(TRANSMIT_BINARY);
								//                        writeByte(baosp.toByteArray());
								//                        baosp.reset();

								break;

							case TIMING_MARK : // 6   rfc860
								//                        System.out.println("Timing Mark Received and notifying " +
								//                        "the server that we will not do it");
								baosp.write(IAC);
								baosp.write(WONT);
								baosp.write(TIMING_MARK);
								//                        writeByte(baosp.toByteArray());
								//                        baosp.reset();

								break;

							case NEW_ENVIRONMENT : // 39 rfc1572
								if (devName == null && user == null) {
									baosp.write(IAC);
									baosp.write(WILL);
									//p                           baosp.write(WONT);
									baosp.write(NEW_ENVIRONMENT);
									//                           writeByte(baosp.toByteArray());
									//                           baosp.reset();

								} else {
									baosp.write(IAC);
									baosp.write(WILL);
									baosp.write(NEW_ENVIRONMENT);
									//                           writeByte(baosp.toByteArray());
									//                           baosp.reset();

								}
								break;

							default : // every thing else we will not do at this time
								baosp.write(IAC);
								baosp.write(WONT);
								baosp.write(abyte0[i]); // either
								//                        writeByte(baosp.toByteArray());
								//                        baosp.reset();

								break;
						}

						i++;
						break;

					case WILL :

						switch (abyte0[i]) {
							case OPT_END_OF_RECORD : // 25
								baosp.write(IAC);
								baosp.write(DO);
								baosp.write(OPT_END_OF_RECORD);
								//                        writeByte(baosp.toByteArray());
								//                        baosp.reset();

								break;

							case TRANSMIT_BINARY : // '\0'
								baosp.write(IAC);
								baosp.write(DO);
								baosp.write(TRANSMIT_BINARY);
								//                        writeByte(baosp.toByteArray());
								//                        baosp.reset();

								break;
						}
						i++;
						break;

					case SB : // -6

						if (abyte0[i] == NEW_ENVIRONMENT
							&& abyte0[i + 1] == 1) {
							negNewEnvironment();

							while (++i < abyte0.length && abyte0[i + 1] != IAC);
						}

						if (abyte0[i] == TERMINAL_TYPE && abyte0[i + 1] == 1) {
							baosp.write(IAC);
							baosp.write(SB);
							baosp.write(TERMINAL_TYPE);
							baosp.write(QUAL_IS);
							//                     if(!support132)
							//                         baosp.write("IBM-3179-2".getBytes());
							baosp.write("IBM-5555-C01".getBytes());
							//                     else
							//                         baosp.write("IBM-3477-FC".getBytes());
							baosp.write(IAC);
							baosp.write(SE);
							writeByte(baosp.toByteArray());
							baosp.reset();

							i++;
						}
						i++;
						break;
				}
			writeByte(baosp.toByteArray());
			baosp.reset();
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Negotiate new environment string for device name
	 *
	 * @throws IOException
	 */
	private void negNewEnvironment() throws IOException {

		baosp.write(IAC);
		baosp.write(SB);
		baosp.write(NEW_ENVIRONMENT);
		baosp.write(IS);

		if (devName != null) {
			baosp.write(USERVAR);

			baosp.write("DEVNAME".getBytes());

			baosp.write(VALUE);

			baosp.write(negDeviceName().getBytes());
		}

		if (user != null) {

			baosp.write(VAR);
			baosp.write("USER".getBytes());
			baosp.write(VALUE);
			baosp.write(user.getBytes());

			if (password != null) {
				baosp.write(USERVAR);
				baosp.write("IBMRSEED".getBytes());
				baosp.write(VALUE);
				baosp.write(NEGOTIATE_ESC);
				baosp.write(0x0);
				baosp.write(0x0);
				baosp.write(0x0);
				baosp.write(0x0);
				baosp.write(0x0);
				baosp.write(0x0);
				baosp.write(0x0);
				baosp.write(0x0);
				baosp.write(USERVAR);
				baosp.write("IBMSUBSPW".getBytes());
				baosp.write(VALUE);
				baosp.write(password.getBytes());
			}

			if (library != null) {
				baosp.write(USERVAR);
				baosp.write("IBMCURLIB".getBytes());
				baosp.write(VALUE);
				baosp.write(library.getBytes());
			}

			if (initialMenu != null) {
				baosp.write(USERVAR);
				baosp.write("IBMIMENU".getBytes());
				baosp.write(VALUE);
				baosp.write(initialMenu.getBytes());
			}

			if (program != null) {
				baosp.write(USERVAR);
				baosp.write("IBMPROGRAM".getBytes());
				baosp.write(VALUE);
				baosp.write(program.getBytes());
			}
		}
		baosp.write(USERVAR);
		baosp.write("CODEPAGE".getBytes());
		baosp.write(VALUE);
		//baosp.write("1027".getBytes());
		baosp.write(codePage.getCodePage().getBytes());
		baosp.write(USERVAR);
		baosp.write("CHARSET".getBytes());
		baosp.write(VALUE);
		//baosp.write("1172".getBytes());
		baosp.write(codePage.getCharSet().getBytes());
// add start pei 070118 V5R4 R[hy[W939Ή
		baosp.write(USERVAR);
		baosp.write("KBDTYPE".getBytes());
		baosp.write(VALUE);
		//baosp.write("JPB".getBytes());
		baosp.write(codePage.getKBDType().getBytes());
// add end
		baosp.write(IAC);
		baosp.write(SE);

		writeByte(baosp.toByteArray());
		baosp.reset();

	}

	/**
	 * This will negotiate a device name with controller.
	 *    if the sequence is less than zero then it will send the device name
	 *    as specified.  On each unsuccessful attempt a sequential number is
	 *    appended until we find one or the controller says no way.
	 *
	 * @return String
	 */
	/* Modified By pei
	private String negDeviceName() {
	
		if (devSeq++ == -1) {
			devNameUsed = devName;
			return devName;
		} else {
			StringBuffer sb = new StringBuffer(devName + devSeq);
			int ei = 1;
			while (sb.length() > 10) {
	
				sb.setLength(0);
				sb.append(devName.substring(0, devName.length() - ei++));
				sb.append(devSeq);
	
			}
			devNameUsed = sb.toString();
			return devNameUsed;
		}
	}
	*/
	private String negDeviceName() {
		if (devName.endsWith("*")) {
			devNameUsed =
				devName.substring(0, devName.length() - 1)
					+ (devSeq >= 26 ? 'Z' : (char) ('A' + devSeq++));
			return devNameUsed;
		}
		if (devName.endsWith("=")) {
			devNameUsed =
				devName.substring(0, devName.length() - 1)
					+ (devSeq >= 35 ? 'Z' : (devSeq >= 9 ? (char) ('A' + devSeq++ - 9) : (char) ('1' + devSeq++)));
			return devNameUsed;
		}
		devNameUsed = devName;
		return devName;
	}

	public final void setCodePage(String cp) {
		codePage = CharMappings.getCodePage(cp);
		tracer.setCodePage(codePage);
		String acp = (codePage.getEncoding().equals("930") ? "939" : "930-2");
		alt_codePage = CharMappings.getCodePage(acp);
	}

	public final CodePage getCodePage() {

		return codePage;
	}

	public final Dimension getPreferredSize() {
		return screen52.getPreferredSize();
	}

	/**
	 * KJP - 20/02/2003 taken out
	 */
	//   public byte getEBCDIC(int index) {
	//      return codePage.getEBCDIC(index);
	//
	//   }
	//
	/**
	 * KJP - 20/02/2003 taken out
	 */
	//   public char getEBCDICChar(int index) {
	//      return codePage.getEBCDICChar(index);
	//
	//   }

	//      /**
	//       * LDC - 13/02/2003 -
	//   //    * @deprecated
	//       */
	//      public byte getASCII(int index) {
	//         return codePage.getASCII(index);
	//
	//      }
	//
	//      /**
	//       * LDC - 13/02/2003 -
	//   //    * @deprecated
	//       */
	//      public char getASCIIChar(int index) {
	//         return codePage.getASCIIChar(index);
	//      }

	public char ebcdic2uni(int index) {
		return codePage.ebcdic2uni(index);

	}

	public char ebcdic2unik(int index1, int index2) {
		return codePage.ebcdic2unik(index1, index2);

	}

	public byte uni2ebcdic(char index) {
		return codePage.uni2ebcdic(index, false)[0];

	}

	public void dumpScreen() {

		for (int y = 0; y < screen52.getRows(); y++) {
			System.out.print("row :" + (y + 1) + " ");

			for (int x = 0; x < screen52.getCols(); x++) {
				System.out.println(
					"row "
						+ (y + 1)
						+ " col "
						+ (x + 1)
						+ " "
						+ screen52.screen[y * x].toString());

			}
		}
	}

	public void altCodePage() {
		CodePage wcp = codePage;
		codePage = alt_codePage;
		alt_codePage = wcp;
	}

	//pei 
	private byte[] reform(byte[] d, int row, int col, byte cmd)
		throws IOException {
		// add pei 080215
		// chg pei 080401 CMD_READ_SCREEN_TO_PRINT̂܂ܕԂ
		if (cmd == CMD_READ_SCREEN_IMMEDIATE || cmd == CMD_READ_SCREEN_TO_PRINT) return (d);
		
		boolean grid= cmd == CMD_READ_SCREEN_TO_PRINT_WITH_EA_AND_G || cmd == CMD_READ_SCREEN_TO_PRINT_WITH_G;
		boolean eag= cmd == CMD_READ_SCREEN_TO_PRINT_WITH_EA_AND_G;
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		if (grid) {
			baos.write(new byte[] { 0, 0, 0, 0, 0 });
		}
		for (int i = 0; i < row; ++i) {
			int j = col;
			if (grid) {
				int gl = j;
				if (eag) ++gl;
				baos.write((byte) (i + 1));
				baos.write((byte) (gl >> 8));
				baos.write((byte) gl);
				baos.write((byte) 0);
				baos.write((byte) 0);
			} else {
				for (--j; j >= 0; --j) {
					byte bw = d[col * i + j];
					if (bw != 0x40 && bw != 0) {
						++j;
						break;
					}
				}
			}
			if (j > 0) {
				
				baos.write(d, col * i, j);
			}
			if (!grid || eag) {
				baos.write((byte) - 1);
			}
		}
		return (baos.toByteArray());
	}

	protected void tcpreset() {
		screen52.clearScreen_onerr();
		screen52.setStatus(
			Screen5250.STATUS_SYSTEM,
			Screen5250.STATUS_VALUE_ON,
			"X - Disconnected");
		if (auto_reconnect) {
			screen52.stopBlinker();
			controller.fireEmulatorAction(EmulatorActionEvent.RESTART_SESSION);
		}
	}
	protected void roll() throws Exception {
		byte b1= bk.getNextByte();
		int top= bk.getNextByte() & 0xff;;
		int bot= bk.getNextByte() & 0xff;
		int line= b1 & 0x1f;
		screen52.roll((b1 & 0x80) == 0, top, bot, line);
	}

	public void killPCO() {
		if (pcowait != null) {
			pcowait.interrupt();
		}
	}
		
	public final boolean sendPMB(ProgMouseButton pmb) {

		screen52.setStatus(
			Screen5250.STATUS_SYSTEM,
			Screen5250.STATUS_VALUE_ON,
			null);

		screen52.setKeyboardLocked(true);
		pendingUnlock = false;
		invited = false;
		int pos;
		if (!pmb.isSingle()) {
			pos= pmb.getPos2();
			baosp.write(screen52.getRow(pos) + 1);
			baosp.write(screen52.getCol(pos) + 1);
			baosp.write((byte)0x80);
			pos= pmb.getPos1();
			baosp.write(screen52.getRow(pos) + 1);
			baosp.write(screen52.getCol(pos) + 1);
		} else {
			pos= pmb.getPos1();
			baosp.write(screen52.getRow(pos) + 1);
			baosp.write(screen52.getCol(pos) + 1);
		}
		baosp.write(pmb.getAid());

		if (dataIncluded(pmb.getAid()))
			screen52.getScreenFields().readFormatTable(
				baosp,
				readType,
				codePage);

		try {

			writeGDS(0, 3, baosp.toByteArray());
		} catch (IOException ioe) {

			System.out.println(ioe);
			baosp.reset();
			return false;
		}
		baosp.reset();
		return true;

	}

	// negotiating commands
	private static final byte IAC = (byte) - 1; // 255  FF
	private static final byte DONT = (byte) - 2; //254  FE
	private static final byte DO = (byte) - 3; //253    FD
	private static final byte WONT = (byte) - 4; //252  FC
	private static final byte WILL = (byte) - 5; //251  FB
	private static final byte SB = (byte) - 6; //250 Sub Begin  FA
	private static final byte SE = (byte) - 16; //240 Sub End   F0
	private static final byte EOR = (byte) - 17; //239 End of Record  EF
	private static final byte TERMINAL_TYPE = (byte) 24; // 18
	private static final byte OPT_END_OF_RECORD = (byte) 25; // 19
	private static final byte TRANSMIT_BINARY = (byte) 0; // 0
	private static final byte QUAL_IS = (byte) 0; // 0
	private static final byte TIMING_MARK = (byte) 6; // 6
	private static final byte NEW_ENVIRONMENT = (byte) 39; // 27
	private static final byte IS = (byte) 0; // 0
	private static final byte SEND = (byte) 1; // 1
	private static final byte INFO = (byte) 2; // 2
	private static final byte VAR = (byte) 0; // 0
	private static final byte VALUE = (byte) 1; // 1
	private static final byte NEGOTIATE_ESC = (byte) 2; // 2
	private static final byte USERVAR = (byte) 3; // 3

	// miscellaneous
	private static final byte ESC = 0x04; // 04
	private static final char char0 = 0;

	//   private static final byte CMD_READ_IMMEDIATE_ALT = (byte)0x83; // 131

}