/* File: defines.h */

/* Purpose: global constants and macro definitions */


/*
 * Do not edit this file unless you know *exactly* what you are doing.
 *
 * Some of the values in this file were chosen to preserve game balance,
 * while others are hard-coded based on the format of old save-files, the
 * definition of arrays in various places, mathematical properties, fast
 * computation, storage limits, or the format of external text files.
 *
 * Changing some of these values will induce crashes or memory errors or
 * savefile mis-reads.  Most of the comments in this file are meant as
 * reminders, not complete descriptions, and even a complete knowledge
 * of the source may not be sufficient to fully understand the effects
 * of changing certain definitions.
 *
 * Lastly, note that the code does not always use the symbolic constants
 * below, and sometimes uses various hard-coded values that may not even
 * be defined in this file, but which may be related to definitions here.
 * This is of course bad programming practice, but nobody is perfect...
 *
 * For example, there are MANY things that depend on the screen being
 * 80x24, with the top line used for messages, the bottom line being
 * used for status, and exactly 22 lines used to show the dungeon.
 * Just because your screen can hold 46 lines does not mean that the
 * game will work if you try to use 44 lines to show the dungeon.
 *
 * You have been warned.
 */


/*
 * Name of the version/variant
 */
#define VERSION_NAME "TOband"

/* Savefile version for TOband 0.0.0 and later */
#define T_VER_MAJOR 0
#define T_VER_MINOR 1
#define T_VER_PATCH 0
#define T_VER_EXTRA 4

/* Added for ZAngband (now used for TOband) */
#define FAKE_VERSION   0

#define ANGBAND_2_8_1
#define ZANGBAND

/*
 * Number of grids in each block (vertically)
 * Probably hard-coded to 11, see "generate.c"
 */
#define BLOCK_HGT	11

/*
 * Number of grids in each block (horizontally)
 * Probably hard-coded to 11, see "generate.c"
 */
#define BLOCK_WID	11


/*
 * Number of grids in each panel (vertically)
 * Must be a multiple of BLOCK_HGT
 */
#define PANEL_HGT	11

/*
 * Number of grids in each panel (horizontally)
 * Must be a multiple of BLOCK_WID
 */
#define PANEL_WID	33


/*
 * Number of grids used to display the dungeon (vertically).
 * Must be a multiple of 11, probably hard-coded to 22.
 */
#define SCREEN_HGT      22

/*
 * Number of grids used to display the dungeon (horizontally).
 * Must be a multiple of 33, probably hard-coded to 66.
 */
#define SCREEN_WID      66


/*
 * Maximum dungeon height in grids, must be a multiple of SCREEN_HGT,
 * probably hard-coded to SCREEN_HGT * 3.
 */
#define MAX_HGT         66

/*
 * Maximum dungeon width in grids, must be a multiple of SCREEN_WID,
 * probably hard-coded to SCREEN_WID * 3.
 */
#define MAX_WID         198


/*
 * Quest constants
 */
#define MIN_RANDOM_QUEST    40
#define MAX_RANDOM_QUEST    49

#define MIN_RANDOM_QUEST_ASTRAL 50
#define MAX_RANDOM_QUEST_ASTRAL 59

#define quest_is_fixed(Q_IDX) (((Q_IDX) < MIN_RANDOM_QUEST) || ((Q_IDX) > MAX_RANDOM_QUEST_ASTRAL))

#define QUEST_LANCELOT       8
#define QUEST_DOLGARUA       9
#define QUEST_ARMORICA      14
#define QUEST_MONTSALVAT    16
#define QUEST_RUNEWEAPON    17
#define QUEST_DENIM         24
#define QUEST_BARMAMUTHA_L  35
#define QUEST_BARMAMUTHA_C  36
#define QUEST_RAMZEN        37
#define QUEST_HOLY_KNIGHTS  38
#define QUEST_FELLANA       60
#define QUEST_HOLP          61
#define QUEST_ISHTALLE      62
#define QUEST_FILARHH       63

/*
 * Arena constants
 */
#define MAX_ARENA_MONS		38	/* -KMW- */


/*
 * Total number of stores (see "store.c", etc)
 */
#define MAX_STORES      10

/*
 * Number of buildings
 */
#define MAX_BLDG		32

/*
 * Store types
 */
#define STORE_GENERAL   0
#define STORE_ARMOURY   1
#define STORE_WEAPON    2
#define STORE_TEMPLE    3
#define STORE_ALCHEMIST 4
#define STORE_MAGIC     5
#define STORE_BLACK     6
#define STORE_HOME      7
#define STORE_BOOK      8
#define STORE_MUSEUM    9


#define BUILDING_NON_MEMBER 0
#define BUILDING_MEMBER     1
#define BUILDING_OWNER      2

/*
 * Total number of owners per store (see "store.c", etc)
 */
#define MAX_OWNERS      32

/*
 * Maximum number of player "sex" types (see "table.c", etc)
 */
#define MAX_SEXES            2

/*
 * Maximum number of player "class" types (see "table.c", etc)
 */
#define MAX_CLASS            25

/* Number of entries in the sanity-blast descriptions */
#define MAX_SAN_HORROR 20
#define MAX_SAN_FUNNY 22
#define MAX_SAN_COMMENT 5

/* Chaos mutations */

/* "Activatable" mutations must be in MUT1_* */
#define MUT1_SPIT_ACID                  0x00000001L
#define MUT1_BR_FIRE                    0x00000002L
#define MUT1_HYPN_GAZE                  0x00000004L
#define MUT1_TELEKINES                  0x00000008L
#define MUT1_VTELEPORT                  0x00000010L /* Voluntary teleport */
#define MUT1_MIND_BLST                  0x00000020L
#define MUT1_RADIATION                  0x00000040L
#define MUT1_VAMPIRISM                  0x00000080L
#define MUT1_SMELL_MET                  0x00000100L
#define MUT1_SMELL_MON                  0x00000200L
#define MUT1_BLINK                      0x00000400L
#define MUT1_EAT_ROCK                   0x00000800L
#define MUT1_SWAP_POS                   0x00001000L
#define MUT1_SHRIEK                     0x00002000L
#define MUT1_ILLUMINE                   0x00004000L
#define MUT1_DET_CURSE                  0x00008000L
#define MUT1_BERSERK                    0x00010000L
#define MUT1_POLYMORPH                  0x00020000L
#define MUT1_MIDAS_TCH                  0x00040000L
#define MUT1_GROW_MOLD                  0x00080000L
#define MUT1_RESIST                     0x00100000L
#define MUT1_EARTHQUAKE                 0x00200000L
#define MUT1_EAT_MAGIC                  0x00400000L
#define MUT1_WEIGH_MAG                  0x00800000L
#define MUT1_STERILITY                  0x01000000L
#define MUT1_PANIC_HIT                  0x02000000L
#define MUT1_DAZZLE                     0x04000000L
#define MUT1_LASER_EYE                  0x08000000L
#define MUT1_RECALL                     0x10000000L
#define MUT1_BANISH                     0x20000000L
#define MUT1_COLD_TOUCH                 0x40000000L
#define MUT1_LAUNCHER                   0x80000000L

/* Randomly activating mutations must be MUT2_* */
#define MUT2_BERS_RAGE                  0x00000001L
#define MUT2_COWARDICE                  0x00000002L
#define MUT2_RTELEPORT                  0x00000004L /* Random teleport, instability */
#define MUT2_ALCOHOL                    0x00000008L
#define MUT2_HALLU                      0x00000010L
#define MUT2_ELEM_MULTI                 0x00000020L
#define MUT2_SCOR_TAIL                  0x00000040L
#define MUT2_HORNS                      0x00000080L
#define MUT2_BEAK                       0x00000100L
#define MUT2_ATT_DEMON                  0x00000200L
#define MUT2_PROD_MANA                  0x00000400L
#define MUT2_SPEED_FLUX                 0x00000800L
#define MUT2_BANISH_ALL                 0x00001000L
#define MUT2_EAT_LIGHT                  0x00002000L
#define MUT2_TRUNK                      0x00004000L
#define MUT2_ATT_ANIMAL                 0x00008000L
#define MUT2_TENTACLES                  0x00010000L
#define MUT2_RAW_CHAOS                  0x00020000L
#define MUT2_NORMALITY                  0x00040000L
#define MUT2_WRAITH                     0x00080000L
#define MUT2_POLY_WOUND                 0x00100000L
#define MUT2_WASTING                    0x00200000L
#define MUT2_ATT_DRAGON                 0x00400000L
#define MUT2_WEIRD_MIND                 0x00800000L
#define MUT2_NAUSEA                     0x01000000L
#define MUT2_TAROT                      0x02000000L
#define MUT2_ALTER_REALITY              0x04000000L
#define MUT2_WARNING                    0x08000000L
#define MUT2_INVULN                     0x10000000L
#define MUT2_SP_TO_HP                   0x20000000L
#define MUT2_HP_TO_SP                   0x40000000L
#define MUT2_DISARM                     0x80000000L



/* Other mutations will be mainly in MUT3_* */

#define MUT3_HYPER_STR                  0x00000001L
#define MUT3_PUNY                       0x00000002L
#define MUT3_HYPER_INT                  0x00000004L
#define MUT3_MORONIC                    0x00000008L
#define MUT3_RESILIENT                  0x00000010L
#define MUT3_XTRA_FAT                   0x00000020L
#define MUT3_ALBINO                     0x00000040L
#define MUT3_FLESH_ROT                  0x00000080L
#define MUT3_SILLY_VOI                  0x00000100L
#define MUT3_BLANK_FAC                  0x00000200L
#define MUT3_ILL_NORM                   0x00000400L
#define MUT3_XTRA_EYES                  0x00000800L
#define MUT3_MAGIC_RES                  0x00001000L
#define MUT3_XTRA_NOIS                  0x00002000L
#define MUT3_INFRAVIS                   0x00004000L
#define MUT3_XTRA_LEGS                  0x00008000L
#define MUT3_SHORT_LEG                  0x00010000L
#define MUT3_ELEC_TOUC                  0x00020000L
#define MUT3_FIRE_BODY                  0x00040000L
#define MUT3_WART_SKIN                  0x00080000L
#define MUT3_SCALES                     0x00100000L
#define MUT3_IRON_SKIN                  0x00200000L
#define MUT3_WINGS                      0x00400000L
#define MUT3_FEARLESS                   0x00800000L
#define MUT3_REGEN                      0x01000000L
#define MUT3_ESP                        0x02000000L
#define MUT3_LIMBER                     0x04000000L
#define MUT3_ARTHRITIS                  0x08000000L
#define MUT3_BAD_LUCK                   0x10000000L
#define MUT3_VULN_ELEM                  0x20000000L
#define MUT3_MOTION                     0x40000000L
#define MUT3_GOOD_LUCK                  0x80000000L


/* Monk martial arts... */
# define MAX_MA 17
# define MA_KNEE 1
# define MA_SLOW 2

/* Hallucination stuff */
#ifdef JP
#define MAX_SILLY_ATTACK 41
#else
#define MAX_SILLY_ATTACK 29
#endif


/*
 * Size of memory reserved for initialization of some arrays
 */
#define FAKE_NAME_SIZE  40 * 1024L
#define FAKE_TEXT_SIZE 150 * 1024L


/*
 * Maximum number of high scores in the high score file
 */
#define MAX_HISCORES    999


/*
 * Maximum dungeon level.  The player can never reach this level
 * in the dungeon, and this value is used for various calculations
 * involving object and monster creation.  It must be at least 100.
 * Setting it below 128 may prevent the creation of some objects.
 */
#define MAX_DEPTH       128


/*
 * Maximum number of saved floors.
 */
#define MAX_SAVED_FLOORS       20


/*
 * Maximum size of the "lite" array (see "cave.c")
 * Note that the "lite radius" will NEVER exceed 14, and we would
 * never require more than 581 entries in the array for circular "lite".
 */
#define LITE_MAX 600

/*
 * Maximum size of the "view" array (see "cave.c")
 * Note that the "view radius" will NEVER exceed 20, and even if the "view"
 * was octagonal, we would never require more than 1520 entries in the array.
 */
#define VIEW_MAX 1536

/*
 * Maximum size of the "temp" array (see "cave.c")
 * We must be as large as "VIEW_MAX" and "LITE_MAX" for proper functioning
 * of "update_view()" and "update_lite()".  We must also be as large as the
 * largest illuminatable room, but no room is larger than 800 grids.  We
 * must also be large enough to allow "good enough" use as a circular queue,
 * to calculate monster flow, but note that the flow code is "paranoid".
 */
#define TEMP_MAX 1536

/*
 * Maximum size of the "nomagic" array (see "cave.c")
 * Note that the "anti-magic field radius" will NEVER exceed 3, and we would
 * never require more than 37 entries in the array for circular "anti-magic field".
 */
#define NOMAGIC_MAX 40


/*
 * Number of keymap modes
 */
#define KEYMAP_MODES	2

/*
 * Mode for original keyset commands
 */
#define KEYMAP_MODE_ORIG	0

/*
 * Mode for roguelike keyset commands
 */
#define KEYMAP_MODE_ROGUE	1


/*
 * OPTION: Maximum number of macros (see "io.c")
 * Default: assume at most 256 macros are used
 */
#define MACRO_MAX       256

/*
 * OPTION: Maximum number of "quarks" (see "io.c")
 * Default: assume at most 512 different inscriptions are used
 */
#define QUARK_MAX       768
/* Was 512... 256 quarks added for random artifacts */

/*
 * OPTION: Maximum number of messages to remember (see "io.c")
 * Default: assume maximal memorization of 2048 total messages
 */
#define MESSAGE_MAX     2048

/*
 * OPTION: Maximum space for the message text buffer (see "io.c")
 * Default: assume that each of the 2048 messages is repeated an
 * average of three times, and has an average length of 48
 */
#define MESSAGE_BUF     32768


/*
 * Maximum value storable in a "byte" (hard-coded)
 */
#define MAX_UCHAR       255

/*
 * Maximum value storable in a "s16b" (hard-coded)
 */
#define MAX_SHORT       32767

/*
 * Maximum length of object's name
 */
#define MAX_NLEN        160

/*
 * Player death with special method?
 */
#define DEATH_DEAD        0x00000001L /* Player is dead */
#define DEATH_STONED      0x00000002L /* Player is stoned */
#define DEATH_SNAP_DRAGON 0x00000004L /* Player used Snap Dragon Spell */

/*
 * Special internal key
 */
#define SPECIAL_KEY_QUEST    255
#define SPECIAL_KEY_BUILDING 254
#define SPECIAL_KEY_STORE    253
#define SPECIAL_KEY_QUIT     252

/*
 * Store constants
 */
#define STORE_INVEN_MAX 24              /* Max number of discrete objs in inven */
#define STORE_CHOICES   48              /* Number of items to choose stock from */
#define STORE_OBJ_LEVEL 5               /* Magic Level for normal stores */
#define STORE_TURNOVER  9               /* Normal shop turnover, per day */
#define STORE_MIN_KEEP  6               /* Min slots to "always" keep full */
#define STORE_MAX_KEEP  18              /* Max slots to "always" keep full */
#define STORE_SHUFFLE   21              /* 1/Chance (per day) of an owner changing */
#define STORE_TURNS     1000    /* Number of turns between turnovers */


/*
 * Random energy
 */
#define ENERGY_NEED() (randnor(100, 31))

/*
 * Misc constants
 */
#define TOWN_DAWN         10000    /* Number of ticks from dawn to dawn XXX */
#define TURNS_PER_TICK    10L      /* Number of energy-gain-turns per ticks */
#define BREAK_GLYPH       550      /* Rune of protection resistance */
#define BREAK_MINOR_GLYPH 299      /* For explosive runes */
#define BTH_PLUS_ADJ       3       /* Adjust BTH per plus-to-hit */
#define MON_MULT_ADJ  	   8       /* High value slows multiplication */
#define MON_SUMMON_ADJ	   2       /* Adjust level of summoned creatures */
#define MON_DRAIN_LIFE	   2       /* Percent of player exp drained per hit */
#define USE_DEVICE    	   3       /* x> Harder devices x< Easier devices     */


/* "Biases" for random artifact gen */

#define BIAS_FIRE            1
#define BIAS_AQUA            2
#define BIAS_EARTH           3
#define BIAS_WIND            4
#define BIAS_LIGHT           5
#define BIAS_DARK            6


/*** Pet constants ***/


/*
 * Commands
 */
#define PET_DISMISS           1
#define PET_TARGET            2
#define PET_STAY_CLOSE        3
#define PET_FOLLOW_ME         4
#define PET_SEEK_AND_DESTROY  5
#define PET_ALLOW_SPACE       6
#define PET_STAY_AWAY         7
#define PET_OPEN_DOORS        8
#define PET_TAKE_ITEMS        9
#define PET_TELEPORT         10
#define PET_ATTACK_SPELL     11
#define PET_DISI_SPELL       12
#define PET_SUMMON_SPELL     13
#define PET_BALL_SPELL       14
#define PET_RIDING           15
#define PET_NAME             16
#define PET_RYOUTE           17

/*
 * Follow distances
 */
#define PET_CLOSE_DIST				1
#define PET_FOLLOW_DIST				6
#define PET_SEEK_DIST				10
#define PET_DESTROY_DIST			255
#define PET_SPACE_DIST				(-10)
#define PET_AWAY_DIST				(-25)

#define PF_OPEN_DOORS   0x0001
#define PF_PICKUP_ITEMS 0x0002
#define PF_TELEPORT     0x0004
#define PF_ATTACK_SPELL 0x0008
#define PF_SUMMON_SPELL 0x0010
#define PF_BALL_SPELL   0x0020
#define PF_RYOUTE       0x0040
#define PF_DISI_SPELL   0x0080


/*
 * There is a 1/20 (5%) chance of inflating the requested object_level
 * during the creation of an object (see "get_obj_num()" in "object.c").
 * Lower values yield better objects more often.
 */
#define GREAT_OBJ       20

/*
 * There is a 1/50 (2%) chance of inflating the requested monster_level
 * during the creation of a monsters (see "get_mon_num()" in "monster.c").
 * Lower values yield harder monsters more often.
 */
#define NASTY_MON       50              /* 1/chance of inflated monster level */

/* 1/x chance of hurting even if invulnerable! */
#define PENETRATE_INVULNERABILITY 13



/*
 * Refueling constants
 */
#define FUEL_TORCH      5000    /* Maximum amount of fuel in a torch */
#define FUEL_LAMP       15000   /* Maximum amount of fuel in a lantern */


/*
 * More maximum values
 */
#define MAX_SIGHT       20      /* Maximum view distance */
#define MAX_RANGE       18      /* Maximum range (spells, etc) */



/*
 * The town starts out with 4 residents during the day
 */
#define MIN_M_ALLOC_TD          4

/*
 * The town starts out with 8 residents during the night
 */
#define MIN_M_ALLOC_TN          8


/*
 * A monster can only "multiply" (reproduce) if there are fewer than 100
 * monsters on the level capable of such spontaneous reproduction.  This
 * is a hack which prevents the "m_list[]" array from exploding due to
 * reproducing monsters.  Messy, but necessary.
 */
#define MAX_REPRO       100


/*
 * Player constants
 */
#define PY_MAX_EXP      99999999L       /* Maximum exp */
#define PY_MAX_GOLD     999999999L      /* Maximum gold */
#define PY_MAX_LEVEL    50              /* Maximum level */

/*
 * Player "food" crucial values
 */
#define PY_FOOD_MAX     15000   /* Food value (Bloated) */
#define PY_FOOD_FULL    10000   /* Food value (Normal) */
#define PY_FOOD_ALERT   2000    /* Food value (Hungry) */
#define PY_FOOD_WEAK    1000    /* Food value (Weak) */
#define PY_FOOD_FAINT   500     /* Food value (Fainting) */
#define PY_FOOD_STARVE  100     /* Food value (Starving) */

/*
 * Player regeneration constants
 */
#define PY_REGEN_NORMAL         197     /* Regen factor*2^16 when full */
#define PY_REGEN_WEAK           98      /* Regen factor*2^16 when weak */
#define PY_REGEN_FAINT          33      /* Regen factor*2^16 when fainting */
#define PY_REGEN_HPBASE         1442    /* Min amount hp regen*2^16 */
#define PY_REGEN_MNBASE         524     /* Min amount mana regen*2^16 */

/*
 * Possible realms that can be chosen
 */
#define CH_NONE         0x0000
#define CH_MAGERY       0x0001
#define CH_FIRE         0x0002
#define CH_AQUA         0x0004
#define CH_EARTH        0x0008
#define CH_WIND         0x0010
#define CH_HOLY         0x0020
#define CH_DEATH        0x0040
#define CH_SYMBIOTIC    0x0080
#define CH_WITCH        0x0100
#define CH_DRAKONITE    0x0200
#define CH_CRUSADE      0x0400


/*
 * Magic realms
 */
#define REALM_NONE         0
#define REALM_MAGERY       1
#define REALM_FIRE         2
#define REALM_AQUA         3
#define REALM_EARTH        4
#define REALM_WIND         5
#define REALM_HOLY         6
#define REALM_DEATH        7
#define REALM_SYMBIOTIC    8
#define REALM_WITCH        9
#define REALM_DRAKONITE   10
#define REALM_CRUSADE     11
#define MAX_REALM         11

#define tval2realm(A) ((A) - TV_MAGERY_BOOK + 1)
#define is_good_realm(REALM)   ((REALM) == REALM_HOLY || (REALM) == REALM_CRUSADE)
#define can_use_realm(REALM)   (bool)((realm_choices[p_ptr->pclass] & (1L << ((REALM) - 1))) ? TRUE : FALSE)


/*
 * Maximum number of "normal" pack slots, and the index of the "overflow"
 * slot, which can hold an item, but only temporarily, since it causes the
 * pack to "overflow", dropping the "last" item onto the ground.  Since this
 * value is used as an actual slot, it must be less than "INVEN_RARM" (below).
 * Note that "INVEN_PACK" is probably hard-coded by its use in savefiles, and
 * by the fact that the screen can only show 23 items plus a one-line prompt.
 */
#define INVEN_PACK              23

/*
 * Indexes used for various "equipment" slots (hard-coded by savefiles, etc).
 */
#define INVEN_RARM      24
#define INVEN_LARM      25
#define INVEN_BOW       26
#define INVEN_RIGHT     27
#define INVEN_LEFT      28
#define INVEN_NECK      29
#define INVEN_LITE      30
#define INVEN_BODY      31
#define INVEN_OUTER     32
#define INVEN_HEAD      33
#define INVEN_HANDS     34
#define INVEN_FEET      35

/*
 * used for get_random_ego()
 */
#define INVEN_AMMO     23

/*
 * Total number of inventory slots (hard-coded).
 */
#define INVEN_TOTAL     36


/*
 * Special hack code for "throw pebble" and "throw grave"
 */
#define INVEN_PEBBLE    2000
#define INVEN_GRAVE     2001


/*
 * A "stack" of items is limited to less than 100 items (hard-coded).
 */
#define MAX_STACK_SIZE                  100



/*
 * Indexes of the various "stats" (hard-coded by savefiles, etc).
 */
#define A_STR   0
#define A_INT   1
#define A_WIS   2
#define A_DEX   3
#define A_CON   4
#define A_CHR   5

#define STAT_MAX_MAX (18 + 200)

/*
 * Total number of stats.
 */
#define A_MAX   6

/*
 * Player sex constants (hard-coded by save-files, arrays, etc)
 */
#define SEX_FEMALE              0
#define SEX_MALE                1


/*
 * Player race constants (hard-coded by save-files, arrays, etc)
 */
#define RACE_HUMAN               0
#define RACE_HAWKMAN             1
#define RACE_LIZARDMAN           2
#define RACE_FAIRY               3
#define RACE_GREMLIN             4
#define RACE_SKELETON            5
#define RACE_GHOST               6
#define RACE_PUMPKINHEAD         7
#define RACE_GOBLIN              8
#define RACE_GORGON              9
#define RACE_MERMAID            10

#define RACE_TYPE_NORMAL         0
#define RACE_TYPE_MALE           1
#define RACE_TYPE_FEMALE         2

/*
 * Maximum number of player "race" types (see "table.c", etc)
 */
#define MAX_RACES               11


/*
 * Player class constants (hard-coded by save-files, arrays, etc)
 */
#define CLASS_SOLDIER            0
#define CLASS_KNIGHT             1
#define CLASS_BERSERKER          2
#define CLASS_TERRORKNIGHT       3
#define CLASS_BEASTTAMER         4
#define CLASS_SWORDMASTER        5
#define CLASS_DRAGOON            6
#define CLASS_NINJA              7
#define CLASS_WIZARD             8
#define CLASS_WARLOCK            9
#define CLASS_EXORCIST          10
#define CLASS_AMAZONESS         11
#define CLASS_VALKYRIE          12
#define CLASS_ARCHER            13
#define CLASS_DRAGONTAMER       14
#define CLASS_WITCH             15
#define CLASS_SIRENE            16
#define CLASS_CLERIC            17
#define CLASS_PRIEST            18
#define CLASS_LICH              19
#define CLASS_ANGELKNIGHT       20
#define CLASS_HIGHWITCH         21
#define CLASS_GUNNER            22
#define CLASS_TEMPLEKNIGHT      23
#define CLASS_WHITEKNIGHT       24

#define CLASS_CHOOSE_MODE_NORMAL 0
#define CLASS_CHOOSE_MODE_BIRTH  1
#define CLASS_CHOOSE_MODE_DEATH  2

/*
 * Player race flags
 */
#define PRF_UNDEAD        0x00000001
#define PRF_NO_DIGEST     0x00000002

/*
 * Player class flags
 */
#define PCF_ALIGN_LAWFUL  0x00000001
#define PCF_ALIGN_NEUTRAL 0x00000002
#define PCF_ALIGN_CHAOTIC 0x00000004
#define PCF_SEX_MALE      0x00000008
#define PCF_SEX_FEMALE    0x00000010
#define PCF_BIRTH         0x00000020
#define PCF_REINCARNATE   0x00000040
#define PCF_NO_CHANGE     0x00000080
#define PCF_UNDEAD        0x00000100
#define PCF_NO_DIGEST     0x00000100

#define PCF_ALIGN_ANY     (PCF_ALIGN_LAWFUL | PCF_ALIGN_NEUTRAL | PCF_ALIGN_CHAOTIC)
#define PCF_SEX_ANY       (PCF_SEX_MALE | PCF_SEX_FEMALE)

/*** Screen Locations ***/

/*
 * Some screen locations for various display routines
 * Currently, row 8 and 15 are the only "blank" rows.
 * That leaves a "border" around the "stat" values.
 */

#define ROW_RACE                1
#define COL_RACE                0       /* <race name> */

#define ROW_TITLE               2
#define COL_TITLE               0       /* <title> or <mode> */

#define ROW_DAY                 21
#define COL_DAY                 0       /* day */

#define ROW_DUNGEON             22
#define COL_DUNGEON             0       /* dungeon */

#define ROW_LEVEL               3
#define COL_LEVEL               0       /* "LEVEL  xxxxx" */

#define ROW_EXP                 4
#define COL_EXP                 0       /* "EX  xxxxxxxx" */

#define ROW_CLEVEL              5
#define COL_CLEVEL              0       /* "CLEVEL xxxxx" */

#define ROW_CEXP                6
#define COL_CEXP                0       /* "CEX xxxxxxxx" */

#define ROW_GOLD                7
#define COL_GOLD                0       /* "AU xxxxxxxxx" */

#define ROW_EQUIPPY             8
#define COL_EQUIPPY             0       /* equippy chars */

#define ROW_STAT                9
#define COL_STAT                0       /* "xxx   xxxxxx" */

#define ROW_AC                  15
#define COL_AC                  0       /* "Cur AC xxxxx" */

#define ROW_CURHP               16
#define COL_CURHP               0       /* "Cur HP xxxxx" */

#define ROW_CURSP               17
#define COL_CURSP               0       /* "Cur SP xxxxx" */

#define ROW_RIDING_INFO         18
#define COL_RIDING_INFO         0       /* "xxxxxxxxxxxx" */

#define ROW_INFO                19
#define COL_INFO                0       /* "xxxxxxxxxxxx" */

#define ROW_MAP                 0
#define COL_MAP                 12

#define ROW_HUNGRY              20
#define COL_HUNGRY              0       /* "Weak" / "Hungry" / "Full" / "Gorged" */

#define ROW_STATE               20
#define COL_STATE                7      /* <state> */

#define ROW_SPEED               (-1)
#define COL_SPEED               (COL_WEATHER - 11)      /* "Slow (-NN)" or "Fast (+NN)" */

#define ROW_DEPTH               (-1)
#define COL_DEPTH               (-9)      /* "Lev NNN" / "NNNN ft" */

#define ROW_WEATHER             (-1)
#define COL_WEATHER             (COL_DEPTH - 10)

#define ROW_STATBAR             (-1)
#define COL_STATBAR              0
#define MAX_COL_STATBAR         (COL_SPEED - 2)


/*** Terrain Feature Indexes (see "lib/edit/f_info.txt") ***/

/* Nothing */
#define FEAT_NONE               0x00

/* Various */
#define FEAT_FLOOR              0x01
#define FEAT_INVIS              0x02
#define FEAT_GLYPH              0x03
#define FEAT_OPEN               0x04
#define FEAT_BROKEN             0x05
#define FEAT_LESS               0x06
#define FEAT_MORE               0x07

/* Quest features -KMW- */
#define FEAT_QUEST_ENTER		0x08
#define FEAT_QUEST_EXIT			0x09
#define FEAT_QUEST_DOWN			0x0A
#define FEAT_QUEST_UP			0x0B

#define FEAT_LESS_LESS          0x0D
#define FEAT_MORE_MORE          0x0E

/* Feature 0x0E - 0x0F unused */

/* Traps */
#define FEAT_TRAP_TRAPDOOR      0x10
#define FEAT_TRAP_PIT           0x11
#define FEAT_TRAP_SPIKED_PIT    0x12
#define FEAT_TRAP_POISON_PIT    0x13
#define FEAT_TRAP_TY_CURSE      0x14
#define FEAT_TRAP_TELEPORT      0x15
#define FEAT_TRAP_FIRE          0x16
#define FEAT_TRAP_ACID          0x17
#define FEAT_TRAP_SLOW          0x18
#define FEAT_TRAP_LOSE_STR      0x19
#define FEAT_TRAP_LOSE_DEX      0x1A
#define FEAT_TRAP_LOSE_CON      0x1B
#define FEAT_TRAP_BLIND         0x1C
#define FEAT_TRAP_CONFUSE       0x1D
#define FEAT_TRAP_POISON        0x1E
#define FEAT_TRAP_SLEEP         0x1F

/* Doors */
#define FEAT_DOOR_HEAD          0x20
#define FEAT_DOOR_TAIL          0x2F

/* Extra */
#define FEAT_SECRET             0x30
#define FEAT_RUBBLE             0x31

/* Seams */
#define FEAT_MAGMA              0x32
#define FEAT_QUARTZ             0x33
#define FEAT_MAGMA_H            0x34
#define FEAT_QUARTZ_H           0x35
#define FEAT_MAGMA_K            0x36
#define FEAT_QUARTZ_K           0x37

/* Walls */
#define FEAT_WALL_EXTRA         0x38
#define FEAT_WALL_INNER         0x39
#define FEAT_WALL_OUTER         0x3A
#define FEAT_WALL_SOLID         0x3B
#define FEAT_PERM_EXTRA         0x3C
#define FEAT_PERM_INNER         0x3D
#define FEAT_PERM_OUTER         0x3E
#define FEAT_PERM_SOLID         0x3F

/* Glyph */
#define FEAT_MINOR_GLYPH        0x40

/* Shops */
#define FEAT_SHOP_HEAD          0x4A
#define FEAT_SHOP_TAIL          0x52

/* Terrains */
#define FEAT_DEEP_WATER         0x53
#define FEAT_SHAL_WATER         0x54
#define FEAT_DEEP_LAVA          0x55
#define FEAT_SHAL_LAVA          0x56
#define FEAT_DARK_PIT           0x57
#define FEAT_DIRT               0x58
#define FEAT_GRASS              0x59

#define FEAT_TRAP_TRAPS         0x5A
#define FEAT_TRAP_ALARM         0x5B
#define FEAT_TRAP_OPEN          0x5C

/* Feature 0x5C unused */

#define FEAT_FLOWER             0x5D
#define FEAT_DEEP_GRASS         0x5E
#define FEAT_MUSEUM             0x5F


/* Terrain */
#define FEAT_TREES              0x60
#define FEAT_MOUNTAIN           0x61

/* Feature 0x62 - 0x7F unused */

/* Buildings */
#define FEAT_BLDG_HEAD          0x80
#define FEAT_BLDG_TAIL          0x9F

#define FEAT_TOWN               0xC0
#define FEAT_ENTRANCE           0xC1
#define FEAT_SWAMP              0xC2
#define FEAT_ENTRANCE_UPWARD    0xC3

/* unknown grid (not detected)  */
#define FEAT_UNDETECTED         0xC4

#define FEAT_TUNDRA             0xC5
#define FEAT_AIR                0xC6

#define FEAT_DEEP_SEA           0xC7

#define FEAT_BETWEEN            0xC8

/* special traps */
#define FEAT_TRAP_ARMAGEDDON    0xC9
#define FEAT_TRAP_PIRANHA       0xCA

/*
 * Wilderness terrains
 */
#define TERRAIN_EDGE             0 /* Edge of the World */
#define TERRAIN_TOWN             1 /* Town */
#define TERRAIN_DEEP_WATER       2 /* Deep water */
#define TERRAIN_SHALLOW_WATER    3 /* Shallow water */
#define TERRAIN_SWAMP            4 /* Swamp */
#define TERRAIN_DIRT             5 /* Dirt */
#define TERRAIN_GRASS            6 /* Grass */
#define TERRAIN_TREES            7 /* Trees */
#define TERRAIN_DESERT           8 /* Desert */
#define TERRAIN_SHALLOW_LAVA     9 /* Shallow lava */
#define TERRAIN_DEEP_LAVA       10 /* Deep lava */
#define TERRAIN_MOUNTAIN        11 /* Mountain */
#define TERRAIN_TUNDRA          12 /* Tundra */
#define TERRAIN_DEEP_SEA        13 /* Deep sea */

#define MAX_WILDERNESS          14 /* Maximum wilderness index */



/*** Artifact indexes (see "lib/edit/a_info.txt") ***/

/* Lites */
#define ART_LEGACY               1
#define ART_PUMPKIN              2
#define ART_HABORYM_EYE          3
#define ART_BARBATOS             7
#define ART_FIRECREST            13
#define ART_BLESSING             14
#define ART_BLISS                15
#define ART_FAKE                 168

/* Amulets */
#define ART_RESIST               4
#define ART_RODERIC              5
#define ART_EVIL_NECK            6
#define ART_RED                  139
#define ART_BLUE                 140
#define ART_SAVAGE               151
#define ART_CORAL                153
#define ART_NIGHT                174
#define ART_FIREBIRD             191
#define ART_CAMERA               192
#define ART_AMU_FIRE             199
#define ART_AMU_AQUA             200
#define ART_AMU_WIND             201
#define ART_AMU_EARTH            202

/* Rings */
#define ART_VIVID                8
#define ART_TULKAS               9
#define ART_SACRED_RING          10
#define ART_EVIL_RING            11
#define ART_DEMON_RING           12
#define ART_LICH                 165
#define ART_SKYWALKER            195

/* Hard Armour */
#define ART_RUNGVIE              16
#define ART_BLADETURNER          17
#define ART_SOULKEEPER           19
#define ART_WARRIOR_ARMOR        20
#define ART_TITANIA              21
#define ART_LANCELOT_H           22
#define ART_LANCELOT_D           24
#define ART_LEVIATHAN            25
#define ART_DEATH                160
#define ART_OGRE_ARMOR           162

/* Soft Armour */
#define ART_DENIM                23
#define ART_CYBIL_JACKET         26
#define ART_BELDA                27
#define ART_OBDA                 28
#define ART_CLARE                45
#define ART_SISTEENA             129
#define ART_ANGELIC_ARMOR        145
#define ART_PEREGRINE            181
#define ART_NATHALORK            182
#define ART_PHOENIX              183
#define ART_WIND                 184
#define ART_FIRE                 185
#define ART_EARTH                186
#define ART_WATER                187
#define ART_MAGI                 188
#define ART_WHITE                189
#define ART_BLACK                190
#define ART_VOLUPTUOUS           194

/* Shields */
#define ART_DOLGARUA             30
#define ART_SAINTS_SHIELD        31
#define ART_MILDAIN              32
#define ART_LEONARD              137
#define ART_YENDOR               141
#define ART_OGRE_SHIELD          163
#define ART_PERSEUS              171
#define ART_BLACK_SHIELD         180

/* Helms and Crowns */
#define ART_THOR                 33
#define ART_KING                 34
#define ART_BERNATA              35
#define ART_NYBBAS               36
#define ART_ORLANDO              37
#define ART_ZAEBOS               38
#define ART_GARINGA              39
#define ART_RENDAL               40
#define ART_SKULL_MASK           41
#define ART_DANIKA               42
#define ART_WARRIOR_HELM         53
#define ART_GUACHARO             54
#define ART_DENEB                56
#define ART_FREUDE_HELM          66
#define ART_ZADOVA               116
#define ART_BOLSENIA             138
#define ART_OGRE_HELM            161

/* Cloaks */
#define ART_PROKION              43
#define ART_BELZBUTE             44
#define ART_AISHA                46
#define ART_CLEMONT              47
#define ART_GRINCER_COAT         48
#define ART_ALBELEO              49
#define ART_ENDORA               50

/* Gloves */
#define ART_GUILDUS              52
#define ART_DEBARDES             55
#define ART_WARRIOR_GLOVE        57
#define ART_ERIG                 59

/* Boots */
#define ART_ROSHFEL              60
#define ART_NORN                 61
#define ART_ASHE                 62
#define ART_CYBIL_BOOTS          63
#define ART_HOLY_BOOTS           67

/* Swords */
#define ART_BALMUNG              58
#define ART_VOLGRAS              64
#define ART_YULIA                65
#define ART_SARA                 68
#define ART_BERSALIA             70
#define ART_GENAUNES             71
#define ART_DESERT_SWORD         73
#define ART_NOTOS                75
#define ART_SWORD_OF_TIAMAT      76
#define ART_VICE                 77
#define ART_LAEVATEINN           78
#define ART_REMONICA             79
#define ART_PENITENCE            80
#define ART_HABORYM              81
#define ART_SONIC_BLADE          82
#define ART_ZENOBIA              84
#define ART_ANBICION             85
#define ART_BARON                86
#define ART_ORACION              88
#define ART_FIREDRAKE_SWORD      90
#define ART_DOOMCALLER           91
#define ART_BRUNHILD             92
#define ART_NEPHRITE             123
#define ART_EXCALIBUR            133
#define ART_ZANZIBAR             136
#define ART_OXYONES              149
#define ART_ISLEBERG             157
#define ART_BLACK_CAT            158
#define ART_OGRE_BLADE           164
#define ART_TOUELNO              177
#define ART_CYANIC_CLAW          178
#define ART_BERSERK              193

/* Polearms */
#define ART_BOREAS               93
#define ART_PAIN                 94
#define ART_OSRIC                96
#define ART_GUNGNIR              97
#define ART_EVIL_SPEAR           98
#define ART_CANOPUS              99
#define ART_NIRDAM               100
#define ART_DIABLO               101
#define ART_BAPALU               103
#define ART_GRAMLOCK             104
#define ART_DEATH_TEMPLER        105
#define ART_CULNRIKOLNNE         107
#define ART_BENTISCA             108
#define ART_SATANS_BULLOVA       109
#define ART_LONGICOLNIS          118
#define ART_TURMIL               122
#define ART_ZEPHYRUS             135
#define ART_GAEBOLG              142
#define ART_HOLY_LANCE           143
#define ART_IGNIS                144
#define ART_VOLCAETUS            155
#define ART_PLOX                 179
#define ART_EARTH_DRAGON         197

/* Hafted */
#define ART_WARRIOR_SWORD        69
#define ART_USAR                 87
#define ART_CALDIA               95
#define ART_GYPSY_QUEEN          102
#define ART_SANSCION             106
#define ART_GROND                111
#define ART_BLOOD_WHIP           114
#define ART_RAPTURE_ROSE         115
#define ART_DAGDA                117
#define ART_BAIAN                119
#define ART_WARREN               120
#define ART_DEATHWREAKER         121
#define ART_EUROS                134
#define ART_RIPPLES_STAFF        147
#define ART_PRESANCE             152
#define ART_COMET                154
#define ART_FLAME                156
#define ART_MARITZA              159
#define ART_LIFE_STAFF           166
#define ART_CLEAR_STAFF          167

/* Bows */
#define ART_TATHLUM              89
#define ART_TUNDRA_BOW           112
#define ART_VELDO                113
#define ART_JIYGLAS_BOW          124
#define ART_ALOSER               125
#define ART_CRESCENTE            126
#define ART_SANDSTORM_BOW        132
#define ART_SHOTGUN              146
#define ART_SAINT_BOW            150
#define ART_RIMFIRE              175
#define ART_ASSAULT              176
#define ART_FRAME_BOW            196
#define ART_LIGHTNING_BOW        198

/* Arrows */
#define ART_ALOSER_ARROW         131

/*** Ego-Item indexes (see "lib/edit/e_info.txt") ***/


/* Nothing */
/* xxx */
/* xxx */
/* xxx */

/* Body Armor */
#define EGO_RESIST_ACID         4
#define EGO_RESIST_ELEC         5
#define EGO_RESIST_FIRE         6
#define EGO_RESIST_COLD         7
#define EGO_RESISTANCE          8
#define EGO_ZENOBIAN            9
#define EGO_GAMP                10
#define EGO_PERMANENCE          11
#define EGO_ARCH_MAGI           12
#define EGO_BALANCE             13
#define EGO_POWER               14
#define EGO_BALDAR_ARMOR        243

/* Shields */
#define EGO_ENDURE_ACID         16
#define EGO_ENDURE_ELEC         17
#define EGO_ENDURE_FIRE         18
#define EGO_ENDURE_COLD         19
#define EGO_ENDURANCE           20
#define EGO_REFLECTION          21
#define EGO_NIGHT_DAY           22
#define EGO_BALDAR_SHIELD      241

/* Crowns and Helms */
#define EGO_DARK                23
#define EGO_MAGI                27
#define EGO_MIGHT               28
#define EGO_LORDLINESS          29
#define EGO_SEEING              30
#define EGO_INFRAVISION         31
#define EGO_LITE                32
#define EGO_TELEPATHY           33
#define EGO_REGENERATION        34
#define EGO_TELEPORTATION       35
#define EGO_STUPIDITY           36
#define EGO_NAIVETY             37
#define EGO_UGLINESS            38
#define EGO_SICKLINESS          39
#define EGO_BALDAR_HELM        244

/* Cloaks */
#define EGO_NO_ELEM		26
#define EGO_PROTECTION		40
#define EGO_STEALTH		41
#define EGO_ARCADIA		42
#define EGO_AURA_FIRE		43
#define EGO_ENVELOPING		44
#define EGO_VULNERABILITY	45
#define EGO_IRRITATION		46
#define EGO_AURA_ELEC		47
#define EGO_AURA_COLD		128
#define EGO_BAT			129
#define EGO_SIRENE		238

/* Gloves */
#define EGO_FREE_ACTION         48
#define EGO_SLAYING             49
#define EGO_MAGIC_MASTERY       53
#define EGO_WEAKNESS            54
#define EGO_CLUMSINESS          55
#define EGO_BALDAR_GLOVES      245

/* Boots */
#define EGO_SLOW_DESCENT        56
#define EGO_QUIET               57
#define EGO_MOTION              58
#define EGO_SPEED               59
#define EGO_WARP                60
#define EGO_NOISE               61
#define EGO_SLOWNESS            62
#define EGO_ANNOYANCE           63
#define EGO_BALDAR_BOOTS       246

/* Weapons */
#define EGO_HA                  64
#define EGO_DF                  65
#define EGO_BLESS_BLADE         66
#define EGO_SHOOTING_STAR       67
#define EGO_LODIS               68
#define EGO_ATTACKS             69
#define EGO_SLAYING_WEAPON      70
#define EGO_FORCE_WEAPON        71
#define EGO_BRAND_ACID          72
#define EGO_BRAND_ELEC          73
#define EGO_BRAND_FIRE          74
#define EGO_BRAND_COLD          75
#define EGO_BRAND_POIS          76
#define EGO_CHAOTIC             77
#define EGO_SHARPNESS           78
#define EGO_EARTHQUAKES         79
#define EGO_SLAY_ANIMAL         80
#define EGO_SLAY_EVIL           81
#define EGO_SLAY_UNDEAD         82
#define EGO_SLAY_DEMON          83
#define EGO_SLAY_ORC            84
#define EGO_SLAY_TROLL          85
#define EGO_SLAY_GIANT          86
#define EGO_SLAY_DRAGON         87
#define EGO_BROKEN              88
#define EGO_EXETER              89
#define EGO_BARMAMUTHA          90
#define EGO_BASQUE              91
#define EGO_DRAGOON             95
#define EGO_VAMPIRIC            96
#define EGO_PRISM               97
#define EGO_ASMODE              98
#define EGO_ISHTALLE            99
#define EGO_SLAY_HUMAN          101
#define EGO_MORGUL              102
#define EGO_RIPPER              103
#define EGO_NETHERWORLD         239
#define EGO_BALDAR_WEAPON       240

/* Bows */
#define EGO_ACCURACY            104
#define EGO_VELOCITY            105
#define EGO_EXTRA_MIGHT         108
#define EGO_EXTRA_SHOTS         109
#define EGO_BALDAR_BOW          242

/* Ammo */
#define EGO_HURT_ANIMAL         112
#define EGO_HURT_EVIL           113
#define EGO_HURT_DRAGON         119
#define EGO_SLAYING_BOLT        120
#define EGO_LIGHTNING_BOLT      121
#define EGO_FLAME               122
#define EGO_FROST               123
#define EGO_WOUNDING            124
#define EGO_BACKBITING          125
#define EGO_SHATTERED           126
#define EGO_BLASTED             127

/* Lites */
#define EGO_LITE_SHINE          140
#define EGO_LITE_ILLUMINATION   141
#define EGO_LITE_AURA_FIRE      142
#define EGO_LITE_INFRA          143
#define EGO_LITE_LONG           144
#define EGO_LITE_DARKNESS       145
#define EGO_LITE_EYE            146

/* Rings */
#define EGO_RING_HERO           150
#define EGO_RING_SLAY           151
#define EGO_RING_SUPER_AC       152
#define EGO_RING_MAGIC_MIS      153
#define EGO_RING_FIRE_BOLT      154
#define EGO_RING_COLD_BOLT      155
#define EGO_RING_ELEC_BOLT      156
#define EGO_RING_ACID_BOLT      157
#define EGO_RING_MANA_BOLT      158
#define EGO_RING_FIRE_BALL      159
#define EGO_RING_COLD_BALL      160
#define EGO_RING_ELEC_BALL      161
#define EGO_RING_ACID_BALL      162
#define EGO_RING_MANA_BALL      163
#define EGO_RING_DRAGON_F       164
#define EGO_RING_DRAGON_C       165
#define EGO_RING_D_SPEED        166
#define EGO_RING_BERSERKER      167
#define EGO_RING_HUNTER         168
#define EGO_RING_THROW          169
#define EGO_RING_REGEN          170
#define EGO_RING_LITE           171
#define EGO_RING_M_DETECT       172
#define EGO_RING_STEALTH        173
#define EGO_RING_TELE_AWAY      174
#define EGO_RING_TO_H           175
#define EGO_RING_TO_D           176
#define EGO_RING_RES_LITE       177
#define EGO_RING_RES_DARK       178
#define EGO_RING_WIZARD         179
#define EGO_RING_DRAIN_EXP      181
#define EGO_RING_NO_MELEE       182
#define EGO_RING_AGGRAVATE      183
#define EGO_RING_TY_CURSE       184
#define EGO_RING_RES_TIME       185
#define EGO_RING_TELEPORT       186
#define EGO_RING_ALBINO         187

/* Amulets */
#define EGO_AMU_SLOW_D          210
#define EGO_AMU_INFRA           211
#define EGO_AMU_SEE_INVIS       212
#define EGO_AMU_HOLD_LIFE       213
#define EGO_AMU_DRAIN_EXP       214
#define EGO_AMU_FOOL            215
#define EGO_AMU_AGGRAVATE       216
#define EGO_AMU_TY_CURSE        217
#define EGO_AMU_AC              218
#define EGO_AMU_ANTI_MAGIC      219
#define EGO_AMU_STEALTH         221
#define EGO_AMU_JUMP            222
#define EGO_AMU_TELEPORT        223
#define EGO_AMU_D_DOOR          224
#define EGO_AMU_DEFENDER        225
#define EGO_AMU_RES_FIRE        226
#define EGO_AMU_RES_FIRE_       227
#define EGO_AMU_RES_COLD        228
#define EGO_AMU_RES_COLD_       229
#define EGO_AMU_RES_ELEC        230
#define EGO_AMU_RES_ELEC_       231
#define EGO_AMU_RES_ACID        232
#define EGO_AMU_RES_ACID_       233
#define EGO_AMU_LEVITATION      234
#define EGO_AMU_GREAT           235
#define EGO_AMU_DETECTION       236
#define EGO_AMU_NAIVETY         237

/* Activation effects for random artifacts */
#define ACT_SUNLIGHT            1
#define ACT_BO_MISS_1           2
#define ACT_BA_POIS_1           3
#define ACT_BO_ELEC_1           4
#define ACT_BO_ACID_1           5
#define ACT_BO_COLD_1           6
#define ACT_BO_FIRE_1           7
#define ACT_BA_COLD_1           8
#define ACT_BA_FIRE_1           9
#define ACT_DRAIN_1             10
#define ACT_BA_COLD_2           11
#define ACT_BA_ELEC_2           12
#define ACT_DRAIN_2             13
#define ACT_VAMPIRE_1           14
#define ACT_BO_MISS_2           15
#define ACT_BA_FIRE_2           16
#define ACT_BA_COLD_3           17
#define ACT_BA_ELEC_3           18
#define ACT_WHIRLWIND           19
#define ACT_VAMPIRE_2           20
#define ACT_CALL_CHAOS          21
#define ACT_ROCKET              22
#define ACT_DISP_EVIL           23
#define ACT_BA_MISS_3           24
#define ACT_DISP_GOOD           25
#define ACT_SUMMON1             26
#define ACT_SUMMON2             27
#define ACT_SUMMON3             28
#define ACT_SUMMON4             29
#define ACT_SUMMON5             30
#define ACT_SUMMON6             31
#define ACT_DEC_RAIN            32
#define ACT_INC_RAIN            33
#define ACT_DEC_WIND            34
#define ACT_INC_WIND            35
#define ACT_DEC_TEMP            36
#define ACT_INC_TEMP            37
#define ACT_SH_FIRE             38
#define ACT_SH_ELEC             39
#define ACT_SH_COLD             40
#define ACT_SH_SHARDS           41
/* 42 - 50 unused */
#define ACT_CONFUSE             51
#define ACT_SLEEP               52
#define ACT_QUAKE               53
#define ACT_TERROR              54
#define ACT_TELE_AWAY           55
#define ACT_BANISH_EVIL         56
#define ACT_GENOCIDE            57
#define ACT_MASS_GENO           58
/* 59 - 64 unused */
#define ACT_CHARM_ANIMAL        65
#define ACT_CHARM_UNDEAD        66
#define ACT_CHARM_OTHER         67
#define ACT_CHARM_ANIMALS       68
#define ACT_CHARM_OTHERS        69
#define ACT_SUMMON_ANIMAL       70
#define ACT_SUMMON_PHANTOM      71
#define ACT_SUMMON_ELEMENTAL    72
#define ACT_SUMMON_DEMON        73
#define ACT_SUMMON_UNDEAD       74
/* 75 - 80 unused */
#define ACT_CURE_LW             81
#define ACT_CURE_MW             82
#define ACT_CURE_POISON         83
#define ACT_REST_LIFE           84
#define ACT_REST_ALL            85
#define ACT_CURE_700            86
#define ACT_CURE_1000           87
/* 88 - 90 unused */
#define ACT_ESP                 91
#define ACT_BERSERK             92
#define ACT_PROT_EVIL           93
#define ACT_RESIST_ALL          94
#define ACT_SPEED               95
#define ACT_XTRA_SPEED          96
#define ACT_WRAITH              97
#define ACT_INVULN              98
/* 99 - 110 unused */
#define ACT_LIGHT               111
#define ACT_MAP_LIGHT           112
#define ACT_DETECT_ALL          113
#define ACT_DETECT_XTRA         114
#define ACT_ID_FULL             115
#define ACT_ID_PLAIN            116
#define ACT_RUNE_EXPLO          117
#define ACT_RUNE_PROT           118
#define ACT_SATIATE             119
#define ACT_DEST_DOOR           120
#define ACT_STONE_MUD           121
#define ACT_RECHARGE            122
#define ACT_ALCHEMY             123
#define ACT_DIM_DOOR            124
#define ACT_TELEPORT            125
#define ACT_RECALL              126
/* 127 -> unused */

/*** Object "tval" and "sval" codes ***/


/*
 * The values for the "tval" field of various objects.
 *
 * This value is the primary means by which items are sorted in the
 * player inventory, followed by "sval" and "cost".
 *
 * Note that a "BOW" with tval = 19 and sval S = 10*N+P takes a missile
 * weapon with tval = 16+N, and does (xP) damage when so combined.  This
 * fact is not actually used in the source, but it kind of interesting.
 *
 * Note that as of 2.7.8, the "item flags" apply to all items, though
 * only armor and weapons and a few other items use any of these flags.
 */

#define TV_SKELETON      1      /* Skeletons ('s'), not specified */
#define TV_BOTTLE        2      /* Empty bottles ('!') */
#define TV_JUNK          3      /* Sticks, Pottery, etc ('~') */
#define TV_SPIKE         5      /* Spikes ('~') */
#define TV_STONE         6      /* Stones ('*') */
#define TV_CHEST         7      /* Chests ('&') */
#define TV_FIGURINE      8      /* Magical figurines */
#define TV_STATUE        9      /* Statue, what a silly object... */
#define TV_CORPSE       10      /* Corpses and Skeletons, specific */
#define TV_BULLET       13      /* Ammo for pistols */
#define TV_ROUND        14      /* Ammo for rifles */
#define TV_SHELL        15      /* Ammo for shotguns */
#define TV_ROCKET       16      /* Ammo for rocket launchers */
#define TV_ARROW        17      /* Ammo for bows */
#define TV_BOLT         18      /* Ammo for x-bows */
#define TV_BOW          19      /* Bows/Xbows/Guns */
#define TV_DIGGING      20      /* Shovels/Picks */
#define TV_HAFTED       21      /* Priest Weapons */
#define TV_POLEARM      22      /* Axes and Pikes */
#define TV_SWORD        23      /* Edged Weapons */
#define TV_BOOTS        30      /* Boots */
#define TV_GLOVES       31      /* Gloves */
#define TV_HELM         32      /* Helms */
#define TV_CROWN        33      /* Crowns */
#define TV_SHIELD       34      /* Shields */
#define TV_CLOAK        35      /* Cloaks */
#define TV_SOFT_ARMOR   36      /* Soft Armor */
#define TV_HARD_ARMOR   37      /* Hard Armor */
#define TV_LITE         39      /* Lites (including Specials) */
#define TV_AMULET       40      /* Amulets (including Specials) */
#define TV_RING         45      /* Rings (including Specials) */
#define TV_CARD         50
#define TV_TAROT        51
#define TV_SCRATCH_CARD 52
#define TV_STAFF        55
#define TV_WAND         65
#define TV_ROD          66
#define TV_SCROLL       70
#define TV_POTION       75
#define TV_FLASK        77
#define TV_FOOD         80
#define TV_MAGERY_BOOK  90
#define TV_FIRE_BOOK    91
#define TV_AQUA_BOOK    92
#define TV_EARTH_BOOK   93
#define TV_WIND_BOOK    94
#define TV_HOLY_BOOK    95
#define TV_DEATH_BOOK   96
#define TV_SYMBIOTIC_BOOK 97
#define TV_WITCH_BOOK   98
#define TV_DRAKONITE_BOOK 99
#define TV_CRUSADE_BOOK 100
#define TV_GOLD         127     /* Gold can only be picked up by players */

/* Any subvalue */
#define SV_ANY 					255

/* The "sval" codes for TV_FIGURINE */
#define SV_FIGURINE_NORMAL		0

/* The "sval" codes for TV_STATUE */
#define SV_WOODEN_STATUE        0
#define SV_CLAY_STATUE          1
#define SV_STONE_STATUE         2
#define SV_IRON_STATUE          3
#define SV_COPPER_STATUE        4
#define SV_SILVER_STATUE        5
#define SV_GOLDEN_STATUE        6
#define SV_IVORY_STATUE         7
#define SV_MITHRIL_STATUE       8
#define SV_ORNATE_STATUE        9
#define SV_ADAMANTITE_STATUE   10
#define SV_PHOTO               50

/* The "sval" codes for TV_CORPSE */
#define SV_SKELETON         0
#define SV_CORPSE           1

/* The "sval" codes for TV_BULLET/TV_ROUND/TV_SHELL/TV_ROCKET/TV_ARROW/TV_BOLT */
#define SV_AMMO_LIGHT                    0	/* pebbles */
#define SV_AMMO_NORMAL                   1	/* shots, arrows, bolts */
#define SV_AMMO_HEAVY                    2	/* seeker arrows and bolts, mithril shots */

/* The "sval" codes for TV_BULLET */
#define SV_BULLET             0
#define SV_BALDAR_BULLET      1
#define SV_MITHRIL_BULLET     2
#define SV_ADAMANTITE_BULLET  3
#define SV_MAGNUM_BULLET     20

/* The "sval" codes for TV_ROUND */
#define SV_ROUND             0
#define SV_BALDAR_ROUND      1
#define SV_MITHRIL_ROUND     2
#define SV_ADAMANTITE_ROUND  3

/* The "sval" codes for TV_SHELL */
#define SV_SHELL             0
#define SV_BALDAR_SHELL      1
#define SV_MITHRIL_SHELL     2
#define SV_ADAMANTITE_SHELL  3

/* The "sval" codes for TV_ROCKET */
#define SV_ROCKET            0

/* The "sval" codes for TV_BOW (note information in "sval") */
#define SV_PISTOL                        0	/* (x2) */
#define SV_ASSAULT_RIFLE                 1	/* (x2) */
#define SV_SNIPER_RIFLE                  2	/* (x4) */
#define SV_SHOTGUN                       3	/* (x2) */
#define SV_ROCKET_LAUNCHER               4	/* (x4) */
#define SV_SHORT_BOW                    12	/* (x2) */
#define SV_LONG_BOW                     13	/* (x3) */
#define SV_BOWGUN                       23	/* (x3) */
#define SV_CROSSBOW                     24	/* (x4) */
#define SV_RUNEBOW                      62	/* (x3) */
#define SV_RUNEGUN                      63	/* (x4) */

/* The "sval" codes for TV_DIGGING */
#define SV_SHOVEL                        1
#define SV_PICK                          2
#define SV_MATTOCK                       3

/* The "sval" values for TV_HAFTED */
#define SV_CLUB                          1	/* 1d4  */
#define SV_WHIP                          2	/* 1d6  */
#define SV_QUARTERSTAFF                  3	/* 1d9  */
#define SV_SCIPPLAYS_STAFF               4	/* 1d4  */
#define SV_HALT_HAMMER                   5	/* 3d3  */
#define SV_PAUA_HAMMER                   6	/* 6d7  */
#define SV_FLAIL                         7	/* 2d6  */
#define SV_LEAD_FILLED_MACE              8	/* 3d4  */
#define SV_FAN                           9	/* 1d6  */
#define SV_GREAT_HAMMER                 10	/* 4d6  */
#define SV_MACE_OF_DISRUPTION           11	/* 5d8  */
#define SV_WIZSTAFF                     12	/* 1d4  */
#define SV_LIFE_STAFF                   13	/* 1d3  */
#define SV_CLEAR_STAFF                  14	/* 1d3  */
#define SV_SINAI                        15	/* 1d3  */
#define SV_GROND                        50	/* 3d4  */
#define SV_RUNEHAMMER                   60  /* 0d0 */
#define SV_RUNEWHIP                     61  /* 0d0 */
#define SV_RUNESTAFF                    62  /* 0d0 */
#define SV_RUNEFAN                      63  /* 0d0 */

/* The "sval" values for TV_POLEARM */
#define SV_SPEAR                         1	/* 1d6 */
#define SV_SLENDER_SPEAR                 2	/* 1d8 */
#define SV_BROAD_SPEAR                   3	/* 1d9 */
#define SV_FRANCISCA                     4	/* 2d6 */
#define SV_BROAD_AXE                     5	/* 2d6 */
#define SV_GLAIVE                        6	/* 2d6 */
#define SV_HALBERD                       7	/* 3d4 */
#define SV_SCYTHE                        8	/* 5d3 */
#define SV_LANCE                         9	/* 2d8 */
#define SV_BATTLE_AXE                   10	/* 2d8 */
#define SV_GREAT_AXE                    11	/* 4d4 */
#define SV_HEAVY_AXE                    12	/* 3d11 */
#define SV_HEAVY_LANCE                  13  /* 4d8 */
#define SV_SCYTHE_OF_SLICING            14	/* 8d4 */
#define SV_RUNESPEAR                    62  /* 0d0 */
#define SV_RUNEAXE                      63  /* 0d0 */

/* The "sval" codes for TV_SWORD */
#define SV_MINIMUM_DAGGER                1  /* 1d3 */
#define SV_DAGGER                        2  /* 1d4 */
#define SV_MAIN_GAUCHE                   3  /* 1d5 */
#define SV_RAPIER                        4  /* 1d6 */
#define SV_SHORT_SWORD                   5  /* 1d7 */
#define SV_BROAD_SWORD                   6  /* 2d5 */
#define SV_LONG_SWORD                    7  /* 2d5 */
#define SV_YOUTOU                        8  /* 6d4 */
#define SV_KATANA                        9  /* 3d4 */
#define SV_BASTARD_SWORD                10  /* 3d4 */
#define SV_FALCHION                     11  /* 4d5 */
#define SV_DARK_SWORD                   12  /* 5d5 */
#define SV_TWO_HANDED_SWORD             13  /* 3d6 */
#define SV_DIAMOND_EDGE                 14  /* 7d5 */
#define SV_MITHRIL_SWORD                15  /* 2d10 */
#define SV_MADU                         16  /* 3d2 */
#define SV_RUNEBLADE                    62  /* 0d0 */
#define SV_RUNECLAW                     63  /* 0d0 */

/* The "sval" codes for TV_SHIELD */
#define SV_WOOD_SHIELD                   1
#define SV_SMALL_LEATHER_SHIELD          2
#define SV_TOWER_SHIELD                  3
#define SV_LARGE_LEATHER_SHIELD          4
#define SV_KITE_SHIELD                   5
#define SV_DRAGON_SHIELD                 6
#define SV_KNIGHT_SHIELD                 7
#define SV_MIRROR_SHIELD                 8

/* The "sval" codes for TV_HELM */
#define SV_FUR_CAP                       1
#define SV_HARD_LEATHER_CAP              2
#define SV_METAL_CAP                     3
#define SV_IRON_HELM                     5
#define SV_STEEL_HELM                    6
#define SV_DRAGON_HELM                   7

/* The "sval" codes for TV_CROWN */
#define SV_IRON_CROWN                    1
#define SV_GOLDEN_CROWN                  2
#define SV_CORNUTHAUM                    3
#define SV_KATYUSHA                      4
#define SV_KING                         50

/* The "sval" codes for TV_BOOTS */
#define SV_PAIR_OF_SANDALS               1
#define SV_PAIR_OF_BATTLE_BOOTS          2
#define SV_PAIR_OF_DESERT_BOOTS          3
#define SV_PAIR_OF_DRAGON_GREAVE         4
#define SV_PAIR_OF_STEEL_BOOTS           5
#define SV_PAIR_OF_LONG_BOOTS            6

/* The "sval" codes for TV_CLOAK */
#define SV_CLOAK                         1
#define SV_BOLMARKAN_CLOAK               2
#define SV_FUR_CLOAK                     3
#define SV_CLOAK_OF_IVORY_TOWER          4
#define SV_SHADOW_CLOAK                  5
#define SV_RAINCOAT                      6
#define SV_SIR_COAT                      7

/* The "sval" codes for TV_GLOVES */
#define SV_SET_OF_LEATHER_GLOVES         1
#define SV_SET_OF_GAUNTLETS              2
#define SV_SET_OF_DRAGON_GLOVES          3
#define SV_SET_OF_CESTI                  4
#define SV_SET_OF_GLOVES                 5
#define SV_SET_OF_POWER_GLOVES           6
#define SV_SET_OF_MITHRIL_GLOVES         7
#define SV_SET_OF_KOTE                   8

/* The "sval" codes for TV_SOFT_ARMOR */
#define SV_T_SHIRT                       1
#define SV_ROBE                          2
#define SV_APRON                         3
#define SV_SOFT_LEATHER_ARMOR            4
#define SV_LEATHER_BELT                  5
#define SV_HARD_LEATHER_ARMOR            6
#define SV_DRAGON_LEATHER_ARMOR          7
#define SV_LEATHER_SCALE_MAIL            8
#define SV_KUROSHOUZOKU                  9
#define SV_ROBE_OF_MAGE                 10
#define SV_FEATHER_ARMOUR               11
#define SV_KILT                         12
#define SV_ROBE_DECOLLETE               13
#define SV_ROBE_MONTANTE                14
#define SV_SWALLOW_TAILED_COAT          15
#define SV_FROCK_COAT                   16

/* The "sval" codes for TV_HARD_ARMOR */
#define SV_METAL_SCALE_MAIL              1  /* 13  */
#define SV_CHAIN_MAIL                    2  /* 14  */
#define SV_DOUBLE_CHAIN_MAIL             3  /* 16  */
#define SV_SPLINT_MAIL                   4  /* 19  */
#define SV_FULL_PLATE_ARMOUR             5  /* 25  */
#define SV_MITHRIL_SCALE_MAIL            6  /* 25  */
#define SV_MITHRIL_CHAIN_MAIL            7  /* 28+ */
#define SV_MITHRIL_PLATE_MAIL            8  /* 35+ */
#define SV_DRAGON_SCALE_MAIL   	         9  /* 40+ */

/* The sval codes for TV_LITE */
#define SV_LITE_TORCH                    0
#define SV_LITE_LANTERN                  1
#define SV_LITE_FEANOR                   2
#define SV_LITE_WATCH                    3
#define SV_LITE_MUSIC_BOX                4
#define SV_LITE_PUMPKIN                  5
#define SV_LITE_LOST_EYE                 6
#define SV_LITE_BLISS                    7
#define SV_LITE_BLESSING                 8
#define SV_LITE_FAKE                     9
#define SV_LITE_MAGICAL_LAMP            10
#define SV_LITE_FIRECREST               11
#define SV_LITE_EMPTY			12

/* The "sval" codes for TV_AMULET */
#define SV_AMULET_DOOM                   0
#define SV_AMULET_TELEPORT               1
#define SV_AMULET_ADORNMENT              2
#define SV_AMULET_CASSOWARY              3
#define SV_AMULET_RESIST_ACID            4
#define SV_AMULET_SEARCHING              5
#define SV_AMULET_EMPTY			 6
#define SV_AMULET_ALIGNMENT              7
#define SV_AMULET_THE_MAGI               8
#define SV_AMULET_REFLECTION             9
#define SV_AMULET_RESIST_MAGIC          10
#define SV_AMULET_RODERIC               11
#define SV_AMULET_EVIL                  12
#define SV_AMULET_NO_MAGIC              13
#define SV_AMULET_NO_TELE               14
#define SV_AMULET_RESISTANCE            15
#define SV_AMULET_TELEPATHY             16
#define SV_AMULET_CAMERA                17
#define SV_AMULET_RED                   18
#define SV_AMULET_BLUE                  19
#define SV_AMULET_NANKA                 20
#define SV_AMULET_HORN                  21
#define SV_AMULET_HARP                  22
#define SV_AMULET_MAGIC_MASTERY         23
#define SV_AMULET_NIGHT                 24
#define SV_AMULET_FOL                   25
#define SV_AMULET_OHN                   26
#define SV_AMULET_SOL                   27
#define SV_AMULET_VAN                   28
#define SV_AMULET_FIRE                  29
#define SV_AMULET_AQUA                  30
#define SV_AMULET_WIND                  31
#define SV_AMULET_EARTH                 32

/* The sval codes for TV_RING */
#define SV_RING_WOE                      0
#define SV_RING_AGGRAVATION              1
#define SV_RING_WEAKNESS                 2
#define SV_RING_STUPIDITY                3
#define SV_RING_TELEPORTATION            4
#define SV_RING_SKYWALKER                5
#define SV_RING_EMPTY			 6
#define SV_RING_WIND                     7
#define SV_RING_RESIST_FIRE              8
#define SV_RING_RESIST_COLD              9
#define SV_RING_SUSTAIN_STR             10
#define SV_RING_SUSTAIN_INT             11
#define SV_RING_SUSTAIN_WIS             12
#define SV_RING_SUSTAIN_DEX             13
#define SV_RING_SUSTAIN_CON             14
#define SV_RING_SUSTAIN_CHR             15
#define SV_RING_PROTECTION              16
#define SV_RING_ACID                    17
#define SV_RING_FLAMES                  18
#define SV_RING_ICE                     19
#define SV_RING_RESIST_POIS             20
#define SV_RING_FREE_ACTION             21
#define SV_RING_SEE_INVIS               22
#define SV_RING_SEARCHING               23
#define SV_RING_WARNING                 24
#define SV_RING_ELEC                    25
#define SV_RING_SHOTS                   26
#define SV_RING_SUSTAIN                 27
#define SV_RING_ACCURACY                28
#define SV_RING_DAMAGE                  29
#define SV_RING_SLAYING                 30
#define SV_RING_SPEED                   31
#define SV_RING_VIVID                   32
#define SV_RING_TULKAS                  33
#define SV_RING_SACRED                  34
#define SV_RING_EVIL                    35
#define SV_RING_DEMON                   36
#define SV_RING_DEC_MANA                37
#define SV_RING_RES_FEAR                38
#define SV_RING_RES_LD                  39
#define SV_RING_RES_NETHER              40
#define SV_RING_RES_STONE               41
#define SV_RING_RES_SOUND               42
#define SV_RING_RES_CONFUSION           43
#define SV_RING_RES_SHARDS              44
#define SV_RING_RES_DISENCHANT          45
#define SV_RING_RES_CHAOS               46
#define SV_RING_RES_BLINDNESS           47
#define SV_RING_LORDLY                  48
#define SV_RING_ATTACKS                 49
#define SV_RING_LICH                    50

#define SV_EXPRESS_CARD                  0

/* The "sval" codes for TV_STAFF */
#define SV_STAFF_DARKNESS                0
#define SV_STAFF_SLOWNESS                1
#define SV_STAFF_HASTE_MONSTERS          2
#define SV_STAFF_SUMMONING               3
#define SV_STAFF_TELEPORTATION           4
#define SV_STAFF_IDENTIFY                5
#define SV_STAFF_REMOVE_CURSE            6
#define SV_STAFF_STARLITE                7
#define SV_STAFF_LITE                    8
#define SV_STAFF_MAPPING                 9
#define SV_STAFF_DETECT_GOLD            10
#define SV_STAFF_DETECT_ITEM            11
#define SV_STAFF_DETECT_TRAP            12
#define SV_STAFF_DETECT_DOOR            13
#define SV_STAFF_DETECT_INVIS           14
#define SV_STAFF_DETECT_EVIL            15
#define SV_STAFF_CURE_LIGHT             16
#define SV_STAFF_CURING                 17
#define SV_STAFF_HEALING                18
#define SV_STAFF_THE_MAGI               19
#define SV_STAFF_SLEEP_MONSTERS         20
#define SV_STAFF_SLOW_MONSTERS          21
#define SV_STAFF_SPEED                  22
#define SV_STAFF_PROBING                23
#define SV_STAFF_DISPEL_EVIL            24
#define SV_STAFF_POWER                  25
#define SV_STAFF_HOLINESS               26
#define SV_STAFF_GENOCIDE               27
#define SV_STAFF_EARTHQUAKES            28
#define SV_STAFF_DESTRUCTION            29
#define SV_STAFF_ANIMATE_DEAD           30
#define SV_STAFF_MSTORM                 31
#define SV_STAFF_VOID                   32


/* The "sval" codes for TV_WAND */
#define SV_WAND_HEAL_MONSTER             0
#define SV_WAND_HASTE_MONSTER            1
#define SV_WAND_TELEPORT_AWAY            3
#define SV_WAND_DISARMING                4
#define SV_WAND_TRAP_DOOR_DEST           5
#define SV_WAND_STONE_TO_MUD             6
#define SV_WAND_LITE                     7
#define SV_WAND_SLEEP_MONSTER            8
#define SV_WAND_SLOW_MONSTER             9
#define SV_WAND_CONFUSE_MONSTER         10
#define SV_WAND_FEAR_MONSTER            11
#define SV_WAND_DRAIN_LIFE              12
#define SV_WAND_POLYMORPH               13
#define SV_WAND_STINKING_CLOUD          14
#define SV_WAND_MAGIC_MISSILE           15
#define SV_WAND_ACID_BOLT               16
#define SV_WAND_CHARM_MONSTER           17
#define SV_WAND_FIRE_BOLT               18
#define SV_WAND_COLD_BOLT               19
#define SV_WAND_ACID_BALL               20
#define SV_WAND_ELEC_BALL               21
#define SV_WAND_FIRE_BALL               22
#define SV_WAND_COLD_BALL               23
#define SV_WAND_WONDER                  24
#define SV_WAND_DISINTEGRATE            25
#define SV_WAND_DRAGON_FIRE             26
#define SV_WAND_DRAGON_COLD             27
#define SV_WAND_DRAGON_BREATH           28
#define SV_WAND_PETRO_CLOUD             29
#define SV_WAND_STRIKING                30
#define SV_WAND_GENOCIDE                31
#define SV_WAND_ELEM_FIRE               32
#define SV_WAND_ELEM_AQUA               33
#define SV_WAND_ELEM_EARTH              34
#define SV_WAND_ELEM_WIND               35

/* The "sval" codes for TV_ROD */
#define SV_ROD_DETECT_TRAP               0
#define SV_ROD_DETECT_DOOR               1
#define SV_ROD_IDENTIFY                  2
#define SV_ROD_RECALL                    3
#define SV_ROD_ILLUMINATION              4
#define SV_ROD_MAPPING                   5
#define SV_ROD_DETECTION                 6
#define SV_ROD_PROBING                   7
#define SV_ROD_CURING                    8
#define SV_ROD_HEALING                   9
#define SV_ROD_RESTORATION              10
#define SV_ROD_SPEED                    11
#define SV_ROD_PESTICIDE                12
#define SV_ROD_TELEPORT_AWAY            13
#define SV_ROD_DISARMING                14
#define SV_ROD_LITE                     15
#define SV_ROD_SLEEP_MONSTER            16
#define SV_ROD_SLOW_MONSTER             17
#define SV_ROD_DRAIN_LIFE               18
#define SV_ROD_POLYMORPH                19
#define SV_ROD_ACID_BOLT                20
#define SV_ROD_ELEC_BOLT                21
#define SV_ROD_FIRE_BOLT                22
#define SV_ROD_COLD_BOLT                23
#define SV_ROD_ACID_BALL                24
#define SV_ROD_ELEC_BALL                25
#define SV_ROD_FIRE_BALL                26
#define SV_ROD_COLD_BALL                27
#define SV_ROD_HAVOC                    28
#define SV_ROD_STONE_TO_MUD             29
#define SV_ROD_AGGRAVATE                30
#define SV_ROD_ELEM_FIRE                31
#define SV_ROD_ELEM_AQUA                32
#define SV_ROD_ELEM_EARTH               33
#define SV_ROD_ELEM_WIND                34


/* The "sval" codes for TV_SCROLL */

#define SV_SCROLL_DARKNESS               0
#define SV_SCROLL_AGGRAVATE_MONSTER      1
#define SV_SCROLL_CURSE_ARMOR            2
#define SV_SCROLL_CURSE_WEAPON           3
#define SV_SCROLL_SUMMON_MONSTER         4
#define SV_SCROLL_SUMMON_UNDEAD          5
#define SV_SCROLL_SUMMON_PET             6
#define SV_SCROLL_TRAP_CREATION          7
#define SV_SCROLL_PHASE_DOOR             8
#define SV_SCROLL_TELEPORT               9
#define SV_SCROLL_TELEPORT_LEVEL        10
#define SV_SCROLL_WORD_OF_RECALL        11
#define SV_SCROLL_IDENTIFY              12
#define SV_SCROLL_STAR_IDENTIFY         13
#define SV_SCROLL_REMOVE_CURSE          14
#define SV_SCROLL_STAR_REMOVE_CURSE     15
#define SV_SCROLL_ENCHANT_ARMOR         16
#define SV_SCROLL_ENCHANT_WEAPON_TO_HIT 17
#define SV_SCROLL_ENCHANT_WEAPON_TO_DAM 18
/* xxx enchant missile? */
#define SV_SCROLL_STAR_ENCHANT_ARMOR    20
#define SV_SCROLL_STAR_ENCHANT_WEAPON   21
#define SV_SCROLL_RECHARGING            22
#define SV_SCROLL_MUNDANITY             23
#define SV_SCROLL_LIGHT                 24
#define SV_SCROLL_MAPPING               25
#define SV_SCROLL_DETECT_GOLD           26
#define SV_SCROLL_DETECT_ITEM           27
#define SV_SCROLL_DETECT_TRAP           28
#define SV_SCROLL_DETECT_DOOR           29
#define SV_SCROLL_DETECT_INVIS          30
#define SV_SCROLL_BLESS_WEAPON          31
#define SV_SCROLL_UNHOLY_WEAPON         32
#define SV_SCROLL_BLESSING              33
#define SV_SCROLL_HOLY_CHANT            34
#define SV_SCROLL_HOLY_PRAYER           35
#define SV_SCROLL_MONSTER_CONFUSION     36
#define SV_SCROLL_PROTECTION_FROM_EVIL  37
#define SV_SCROLL_RUNE_OF_PROTECTION    38
#define SV_SCROLL_TRAP_DOOR_DESTRUCTION 39
#define SV_SCROLL_ILLUSION              40
#define SV_SCROLL_STAR_DESTRUCTION      41
#define SV_SCROLL_DISPEL_UNDEAD         42
#define SV_SCROLL_SNAP_DRAGON           43
#define SV_SCROLL_GENOCIDE              44
#define SV_SCROLL_MASS_GENOCIDE         45
#define SV_SCROLL_ACQUIREMENT           46
#define SV_SCROLL_STAR_ACQUIREMENT      47
#define SV_SCROLL_FIRE                  48
#define SV_SCROLL_ICE                   49
#define SV_SCROLL_CHAOS                 50
#define SV_SCROLL_DEADLY_BLOW_LEARNING  51
#define SV_SCROLL_ARTIFACT              52
#define SV_SCROLL_RESET_RECALL          53
#define SV_SCROLL_SUMMON_KIN            54
#define SV_SCROLL_EGO_CREATION          55
#define SV_SCROLL_REVERT_ELEM           56
#define SV_SCROLL_ELEM_FIRE             57
#define SV_SCROLL_ELEM_AQUA             58
#define SV_SCROLL_ELEM_EARTH            59
#define SV_SCROLL_ELEM_WIND             60

/* The "sval" codes for TV_POTION */
#define SV_POTION_WATER                  0
#define SV_POTION_APPLE_JUICE            1
#define SV_POTION_SLIME_MOLD             2
#define SV_POTION_SLOWNESS               3
#define SV_POTION_SALT_WATER             4
#define SV_POTION_POISON                 5
#define SV_POTION_BLINDNESS              6
#define SV_POTION_CONFUSION              7
#define SV_POTION_SLEEP                  8
#define SV_POTION_LOSE_MEMORIES          9
#define SV_POTION_RUINATION             10
#define SV_POTION_DEC_STR               11
#define SV_POTION_DEC_INT               12
#define SV_POTION_DEC_WIS               13
#define SV_POTION_DEC_DEX               14
#define SV_POTION_DEC_CON               15
#define SV_POTION_DEC_CHR               16
#define SV_POTION_DETONATIONS           17
#define SV_POTION_DEATH                 18
#define SV_POTION_INFRAVISION           19
#define SV_POTION_DETECT_INVIS          20
#define SV_POTION_SLOW_POISON           21
#define SV_POTION_CURE_POISON           22
#define SV_POTION_BOLDNESS              23
#define SV_POTION_SPEED                 24
#define SV_POTION_RESIST_HEAT           25
#define SV_POTION_RESIST_COLD           26
#define SV_POTION_HEROISM               27
#define SV_POTION_BERSERK_STRENGTH      28
#define SV_POTION_CURE_LIGHT            29
#define SV_POTION_CURE_SERIOUS          30
#define SV_POTION_CURE_CRITICAL         31
#define SV_POTION_HEALING               32
#define SV_POTION_STAR_HEALING          33
#define SV_POTION_LIFE                  34
#define SV_POTION_RESTORE_MANA          35
#define SV_POTION_RESTORE_EXP           36
#define SV_POTION_RES_STR               37
#define SV_POTION_RES_INT               38
#define SV_POTION_RES_WIS               39
#define SV_POTION_RES_DEX               40
#define SV_POTION_RES_CON               41
#define SV_POTION_RES_CHR               42
#define SV_POTION_RESTORING             43
#define SV_POTION_ENLIGHTENMENT         44
#define SV_POTION_SELF_KNOWLEDGE        45
#define SV_POTION_EXPERIENCE            46
#define SV_POTION_RESISTANCE            47
#define SV_POTION_CURING                48
#define SV_POTION_INVULNERABILITY       49
#define SV_POTION_CURE_STONING          50
#define SV_POTION_CURE_MUTATIONS        51
#define SV_POTION_STAR_CURING           52
#define SV_POTION_POLYMORPH             53

/* The "sval" codes for TV_FLASK */
#define SV_FLASK_OIL                   0

/* The "sval" codes for TV_FOOD */
#define SV_FOOD_INC_STR                  1
#define SV_FOOD_INC_INT                  2
#define SV_FOOD_INC_WIS                  3
#define SV_FOOD_INC_DEX                  4
#define SV_FOOD_INC_CON                  5
#define SV_FOOD_INC_CHR                  6
#define SV_FOOD_AUGMENTATION             7
#define SV_FOOD_EGG                      8
#define SV_FOOD_BIG_EGG                  9
#define SV_FOOD_SPECIAL_EGG             10
#define SV_FOOD_ROTTEN_EGG              11
#define SV_FOOD_BISCUIT                 12
#define SV_FOOD_JERKY                   13
#define SV_FOOD_RATION                  14
#define SV_FOOD_SLIME_MOLD              15
#define SV_FOOD_WAYBREAD                16
#define SV_FOOD_PINT_OF_ALE             17
#define SV_FOOD_PINT_OF_WINE            18
#define SV_FOOD_FORTUNE_COOKIE          19
#define SV_FOOD_ROTTEN_PUMPKIN          20


/*
 * Special "sval" limit -- first "normal" food
 */
#define SV_FOOD_MIN_FOOD                32

/*
 * Special "sval" limit -- first "aimed" rod
 */
#define SV_ROD_MIN_DIRECTION    12

/*
 * Special "sval" limit -- first "large" chest
 */
#define SV_CHEST_MIN_LARGE      4


/* The "sval" codes for TV_GOLD */
#define SV_GOLD_NOTE        0 /* This is not really exist */
#define SV_GOLD_COPPER_1    1
#define SV_GOLD_COPPER_2    2
#define SV_GOLD_COPPER_3    3
#define SV_GOLD_SILVER_1    4
#define SV_GOLD_SILVER_2    5
#define SV_GOLD_SILVER_3    6
#define SV_GOLD_GARNETS_1   7
#define SV_GOLD_GARNETS_2   8
#define SV_GOLD_GOLD_1      9
#define SV_GOLD_GOLD_2     10
#define SV_GOLD_GOLD_3     11
#define SV_GOLD_OPALS      12
#define SV_GOLD_SAPPHIRES  13
#define SV_GOLD_RUBIES     14
#define SV_GOLD_DIAMONDS   15
#define SV_GOLD_EMERALDS   16
#define SV_GOLD_MITHRIL    17
#define SV_GOLD_ADAMANTITE 18


#define OBJ_GOLD_LIST   554     /* First "gold" entry */
#define MAX_GOLD        18      /* Number of "gold" entries */


/*** General flag values ***/


/*
 * Special cave grid flags
 */
#define CAVE_MARK       0x0001    /* memorized feature */
#define CAVE_GLOW       0x0002    /* self-illuminating */
#define CAVE_ICKY       0x0004    /* part of a vault */
#define CAVE_ROOM       0x0008    /* part of a room */
#define CAVE_LITE       0x0010    /* lite flag  */
#define CAVE_VIEW       0x0020    /* view flag */
#define CAVE_TEMP       0x0040    /* temp flag */
#define CAVE_XTRA       0x0080    /* misc flag */
#define CAVE_MNLT       0x0100    /* Illuminated by monster */

#define CAVE_XXX0       0x8000    /* Now unused */

/* Used only while cave generation */
#define CAVE_FLOOR      0x0200
#define CAVE_EXTRA      0x0400
#define CAVE_INNER      0x0800
#define CAVE_OUTER      0x1000
#define CAVE_SOLID      0x2000
#define CAVE_VAULT      0x4000
#define CAVE_MASK (CAVE_FLOOR | CAVE_EXTRA | CAVE_INNER | CAVE_OUTER | CAVE_SOLID | CAVE_VAULT)

/* Used only after cave generation */
#define CAVE_XXXX1      0x0200
#define CAVE_XXXX2      0x0400
#define CAVE_XXXX3      0x0800
#define CAVE_OBJECT     0x1000    /* object */
#define CAVE_UNSAFE     0x2000    /* Might have trap */
#define CAVE_IN_DETECT  0x4000    /* trap detected area (inner circle only) */


/*
 * Bit flags for the "project()" function
 *
 *   JUMP: Jump directly to the target location (this is a hack)
 *   BEAM: Work as a beam weapon (affect every grid passed through)
 *   THRU: Continue "through" the target (used for "bolts"/"beams")
 *   STOP: Stop as soon as we hit a monster (used for "bolts")
 *   GRID: Affect each grid in the "blast area" in some way
 *   ITEM: Affect each object in the "blast area" in some way
 *   KILL: Affect each monster in the "blast area" in some way
 *   HIDE: Hack -- disable "visual" feedback from projection
 *   DISI: Disintegrate non-permanent features
 *   PLAYER: Main target is player (used for riding player)
 *   AIMED: Target is only player or monster, so don't affect another.
 *          Depend on PROJECT_PLAYER.
 *          (used for minimum (rad == 0) balls on riding player)
 *   REFLECTABLE: Refrectable spell attacks (used for "bolts")
 *   NO_HANGEKI: Avoid counter attacks of monsters
 *   PATH: Only used for printing project path
 *   FAST: Hide "visual" of flying bolts until blast
 */
#define PROJECT_JUMP        0x00000001
#define PROJECT_BEAM        0x00000002
#define PROJECT_THRU        0x00000004
#define PROJECT_STOP        0x00000008
#define PROJECT_GRID        0x00000010
#define PROJECT_ITEM        0x00000020
#define PROJECT_KILL        0x00000040
#define PROJECT_HIDE        0x00000080
#define PROJECT_DISI        0x00000100
#define PROJECT_PLAYER      0x00000200
#define PROJECT_MONSTER     0x00000400
#define PROJECT_REFLECTABLE 0x00000800
#define PROJECT_NO_HANGEKI  0x00001000
#define PROJECT_PATH        0x00002000
#define PROJECT_FAST        0x00004000
#define PROJECT_NO_REDUCE   0x00008000
#define PROJECT_AVOIDABLE   0x00010000

/*
 * Bit flags for the "enchant()" function
 */
#define ENCH_TOHIT      0x01 /* Enchant to hit */
#define ENCH_TODAM      0x02 /* Enchant to damage */
#define ENCH_TOAC       0x04 /* Enchant to AC */
#define ENCH_FORCE      0x08 /* Force enchantment */

/*
 * Bit flags for the "target_set" function XXX XXX XXX
 *
 *      KILL: Target monsters
 *      LOOK: Describe grid fully
 *      XTRA: Currently unused flag
 *      GRID: Select from all grids
 */
#define TARGET_KILL             0x01
#define TARGET_LOOK             0x02
#define TARGET_XTRA             0x04
#define TARGET_GRID             0x08


/*
 * Bit flags for control of get_check_strict()
 */
#define CHECK_OKAY_CANCEL 0x01
#define CHECK_NO_ESCAPE   0x02
#define CHECK_NO_HISTORY  0x04


/*
 * Some bit-flags for the "smart1" field
 */
#define SM1_RES_ACID             0x00000001
#define SM1_RES_ELEC             0x00000002
#define SM1_RES_FIRE             0x00000004
#define SM1_RES_COLD             0x00000008
#define SM1_RES_POIS             0x00000010
#define SM1_RES_NETH             0x00000020
#define SM1_RES_LITE             0x00000040
#define SM1_RES_DARK             0x00000080
#define SM1_RES_FEAR             0x00000100
#define SM1_RES_CONF             0x00000200
#define SM1_RES_CHAOS            0x00000400
#define SM1_RES_DISEN            0x00000800
#define SM1_RES_BLIND            0x00001000
#define SM1_RES_STONE            0x00002000
#define SM1_RES_SOUND            0x00004000
#define SM1_RES_SHARD            0x00008000
#define SM1_OPP_ACID             0x00010000
#define SM1_OPP_ELEC             0x00020000
#define SM1_OPP_FIRE             0x00040000
#define SM1_OPP_COLD             0x00080000
#define SM1_OPP_POIS             0x00100000
#define SM1_OPP_XXX1             0x00200000 /* (unused) */
#define SM1_CLONED               0x00400000 /* XXX Cloned */
#define SM1_PET                  0x00800000 /* XXX Pet */
#define SM1_IMM_ACID             0x01000000
#define SM1_IMM_ELEC             0x02000000
#define SM1_IMM_FIRE             0x04000000
#define SM1_IMM_COLD             0x08000000
#define SM1_FRIENDLY             0x10000000 /* XXX Friendly */
#define SM1_IMM_REFLECT          0x20000000
#define SM1_IMM_FREE             0x40000000
#define SM1_IMM_MANA             0x80000000


/*
 * Some bit-flags for the "smart2" field
 */
#define SM2_RES_WATER            0x00000001
#define SM2_RES_TIME             0x00000002
#define SM2_IMM_NETH             0x00000004
#define SM2_IMM_DARK             0x00000008
#define SM2_IMM_PLASMA           0x00000010
#define SM2_IMM_TELE             0x00000020
#define SM2_IMM_DRAIN            0x00000040
#define SM2_IMM_AVOID0           0x00000080
#define SM2_IMM_AVOID1           0x00000100
#define SM2_IMM_AVOID2           0x00000200


/*
 * Bit flags for the "get_item" function
 */
#define USE_EQUIP	0x01	/* Allow equip items */
#define USE_INVEN	0x02	/* Allow inven items */
#define USE_FLOOR	0x04	/* Allow floor items */


/*
 * Bit flags for the "p_ptr->notice" variable
 */
#define PN_COMBINE      0x00000001L     /* Combine the pack */
#define PN_REORDER      0x00000002L     /* Reorder the pack */
#define PN_AUTODESTROY  0x00000004L     /* Auto-destroy marked item */
/* xxx (many) */


/*
 * Bit flags for the "p_ptr->update" variable
 */
#define PU_BONUS        0x00000001L     /* Calculate bonuses */
#define PU_TORCH        0x00000002L     /* Calculate torch radius */
#define PU_GOLD         0x00000004L     /* Calculate total gold */
/* xxx (many) */
#define PU_HP           0x00000010L     /* Calculate chp and mhp */
#define PU_MANA         0x00000020L     /* Calculate csp and msp */
#define PU_SPELLS       0x00000040L     /* Calculate spells */
/* xxx (many) */
/* xxx (many) */
#define PU_UN_VIEW      0x00010000L     /* Forget view */
#define PU_UN_LITE      0x00020000L     /* Forget lite */
/* xxx (many) */
#define PU_VIEW         0x00100000L     /* Update view */
#define PU_LITE         0x00200000L     /* Update lite */
#define PU_MON_LITE     0x00400000L     /* Monster illumination */
/* xxx */
#define PU_MONSTERS     0x01000000L     /* Update monsters */
#define PU_DISTANCE     0x02000000L     /* Update distances */
#define PU_FLOW         0x10000000L     /* Update flow */
/* xxx (many) */


/*
 * Bit flags for the "p_ptr->redraw" variable
 */
#define PR_MISC         0x00000001L     /* Display Race/Class */
#define PR_TITLE        0x00000002L     /* Display Title */
#define PR_LEV          0x00000004L     /* Display Level */
#define PR_EXP          0x00000008L     /* Display Experience */
#define PR_STATS        0x00000010L     /* Display Stats */
#define PR_ARMOR        0x00000020L     /* Display Armor */
#define PR_HP           0x00000040L     /* Display Hitpoints */
#define PR_MANA         0x00000080L     /* Display Mana */
#define PR_GOLD         0x00000100L     /* Display Gold */
#define PR_DEPTH        0x00000200L     /* Display Depth */
#define PR_EQUIPPY      0x00000400L     /* Display equippy chars */
#define PR_HEALTH       0x00000800L     /* Display Health Bar */
#define PR_CLEV         0x00001000L     /* Display Class Level */
#define PR_CEXP         0x00002000L     /* Display Class Experience */
#define PR_HUNGER       0x00004000L     /* Display Extra (Hunger) */
#define PR_STATUS       0x00008000L     /* Display Status Bar */
#define PR_DUNGEON      0x00010000L     /* Display Extra (Blind) */
#define PR_UHEALTH      0x00020000L     /* Display Uma Health Bar */
#define PR_WEATHER      0x00040000L     /* Display Weather */
#define PR_XXX2         0x00080000L     /* Display Extra (Poisoned) */
#define PR_STATE        0x00100000L     /* Display Extra (State) */
#define PR_SPEED        0x00200000L     /* Display Extra (Speed) */
#define PR_XXX3         0x00400000L
#define PR_XXX4         0x00800000L
#define PR_EXTRA        0x01000000L     /* Display Extra Info */
#define PR_BASIC        0x02000000L     /* Display Basic Info */
#define PR_MAP          0x04000000L     /* Display Map */
#define PR_WIPE         0x08000000L     /* Hack -- Total Redraw */
/* xxx */
/* xxx */
/* xxx */
/* xxx */

/*
 * Bit flags for the "p_ptr->window" variable (etc)
 */
#define PW_INVEN        0x00000001L     /* Display inven/equip */
#define PW_EQUIP        0x00000002L     /* Display equip/inven */
#define PW_SPELL        0x00000004L     /* Display spell list */
#define PW_PLAYER       0x00000008L     /* Display character */
/* xxx */
/* xxx */
#define PW_MESSAGE      0x00000040L     /* Display messages */
#define PW_OVERHEAD     0x00000080L     /* Display overhead view */
#define PW_MONSTER      0x00000100L     /* Display monster recall */
#define PW_OBJECT       0x00000200L     /* Display object recall */
#define PW_DUNGEON      0x00000400L     /* Display dungeon view */
#define PW_SNAPSHOT     0x00000800L     /* Display snap-shot */
/* xxx */
/* xxx */
#define PW_BORG_1       0x00004000L     /* Display borg messages */
#define PW_BORG_2       0x00008000L     /* Display borg status */

/*
 * Bit flags for the place_monster_???() (etc)
 */
#define PM_ALLOW_SLEEP    0x00000001
#define PM_ALLOW_GROUP    0x00000002
#define PM_FORCE_FRIENDLY 0x00000004
#define PM_FORCE_PET      0x00000008
#define PM_NO_PET         0x00000020
#define PM_ALLOW_UNIQUE   0x00000040
#define PM_IGNORE_TERRAIN 0x00000080
#define PM_HASTE          0x00000100
#define PM_IGNORE_AMGRID  0x00000200
#define PM_IN_GENERATE    0x00000400


/*
 * Bit flags for the "p_ptr->special_attack" variable. -LM-
 *
 * Note:  The elemental and poison attacks should be managed using the 
 * function "set_magical_weapon", in spell2.c.  This provides for timeouts and
 * prevents the player from getting more than one at a time.
 */
#define ATTACK_CONFUSE     0x00000001
#define ATTACK_EVIL        0x00000002
#define ATTACK_ACID        0x00000010
#define ATTACK_ELEC        0x00000020
#define ATTACK_FIRE        0x00000040
#define ATTACK_COLD        0x00000080
#define ATTACK_POIS        0x00000100


#define ACTION_NONE     0
#define ACTION_SEARCH   1
#define ACTION_REST     2
#define ACTION_SING     3
#define ACTION_STEALTH  4
#define ACTION_ELEMSCOPE 5

/*** General index values ***/


/*
 * Legal restrictions for "summon_specific()"
 */
#define SUMMON_ANT                   1
#define SUMMON_SPIDER                2
#define SUMMON_HOUND                 3
#define SUMMON_BEAST                 4
#define SUMMON_ANGEL                 5
#define SUMMON_DEMON                 6
#define SUMMON_UNDEAD                7
#define SUMMON_DRAGON                8
#define SUMMON_HI_DEMON              9
#define SUMMON_HI_UNDEAD            10
#define SUMMON_HI_DRAGON            12
#define SUMMON_TEMPLES              13
#define SUMMON_UNIQUE               14
#define SUMMON_MOLD                 15
#define SUMMON_CYBER                16
#define SUMMON_KIN                  17
#define SUMMON_ANIMAL               18
#define SUMMON_ANIMAL_RANGER        19
#define SUMMON_PHANTOM              20
#define SUMMON_GOLEM                21
#define SUMMON_ELEMENTAL            22
#define SUMMON_VORTEX               23
#define SUMMON_HYBRID               24
#define SUMMON_BIRD                 25
#define SUMMON_HUMANS               26
#define SUMMON_RIDING               27
#define SUMMON_RIDING_UNIQUE        28
#define SUMMON_GOOD_LAW             29
#define SUMMON_EAGLES               30
#define SUMMON_ZENOBIAN_FORCES      31
#define SUMMON_PIRANHAS             32


/*
 * Spell types used by project(), and related functions.
 */
#define GF_ACID              1
#define GF_ELEC              2
#define GF_FIRE              3
#define GF_COLD              4
#define GF_POIS              5
#define GF_LITE              6
#define GF_DARK              7
#define GF_LITE_WEAK         8
#define GF_DARK_WEAK         9
#define GF_NETHER           10
#define GF_WATER            11
#define GF_PLASMA           12
#define GF_SHARDS           13
#define GF_SOUND            14
#define GF_CONFUSION        15
#define GF_CHAOS            16
#define GF_STONE            17
#define GF_DISENCHANT       18
#define GF_FORCE            19
#define GF_INERTIA          20
#define GF_TIME             21
#define GF_GRAVITY          22
#define GF_ICE              23
#define GF_NUKE             24
#define GF_ROCKET           25
#define GF_MISSILE          26
#define GF_PHYSICAL         27
#define GF_BLUNT            28
#define GF_EDGED            29
#define GF_MANA             30
#define GF_METEOR           31
#define GF_DISINTEGRATE     32
#define GF_HOLY_FIRE        33
#define GF_HELL_FIRE        34
#define GF_GODLY_SPEAR      35
#define GF_PURE_FIRE        36
#define GF_PURE_AQUA        37
#define GF_PURE_EARTH       38
#define GF_PURE_WIND        39
#define GF_CAUSE_1          40
#define GF_CAUSE_2          41
#define GF_CAUSE_3          42
#define GF_CAUSE_4          43
#define GF_HAND_DOOM        44
#define GF_DEATH_RAY        45
#define GF_PSI              46
#define GF_MIND_BLAST       47
#define GF_BRAIN_SMASH      48
#define GF_KILL_WALL        49
#define GF_KILL_DOOR        50
#define GF_KILL_TRAP        51
#define GF_MAKE_TRAP        52
#define GF_MAKE_TREE        53
#define GF_MAKE_GLYPH       54
#define GF_OLD_CLONE        55
#define GF_OLD_POLY         56
#define GF_OLD_HEAL         57
#define GF_OLD_SPEED        58
#define GF_OLD_SLOW         59
#define GF_OLD_CONF         60
#define GF_OLD_SLEEP        61
#define GF_OLD_DRAIN        62
#define GF_OLD_STONE        63
#define GF_STAR_HEAL        64
#define GF_NEW_SLOW         65
#define GF_NEW_DRAIN        66
#define GF_STASIS           67
#define GF_STASIS_EVIL      68
#define GF_STUN             69
#define GF_CHARM            70
#define GF_SILENT           71
#define GF_CRUSADE          72
#define GF_AWAY_EVIL        73
#define GF_AWAY_ALL         74
#define GF_TURN_ALL         75
#define GF_DISP_UNDEAD      76
#define GF_DISP_EVIL        77
#define GF_DISP_GOOD        78
#define GF_DISP_ALL         79
#define GF_CONTROL_UNDEAD   80
#define GF_CONTROL_ANIMAL   81
#define GF_CONTROL_BEAST    82
#define GF_CONTROL_DRAGON   83
#define GF_GENOCIDE         84
#define GF_GENOCIDE_UNDEAD  85
#define GF_DRAIN_MANA       86
#define GF_ANIM_DEAD        87
#define GF_ATTACK           88
#define GF_PHOTO            89
#define GF_STRIKE_NOVA      90
#define GF_WORD_OF_PAIN     91
#define GF_SHINING          92
#define GF_SPECIAL_STONE    93
#define GF_DUAL_DRAIN       94
#define GF_ERASE_ELEM       95
#define GF_CAVE_TEMP        96
#define GF_WATER_FLOW       97

#define MAX_GF              98

/*
 * Some things which induce learning
 */
#define DRS_ACID         1
#define DRS_ELEC         2
#define DRS_FIRE         3
#define DRS_COLD         4
#define DRS_POIS         5
#define DRS_NETH         6
#define DRS_LITE         7
#define DRS_DARK         8
#define DRS_FEAR         9
#define DRS_CONF        10
#define DRS_CHAOS       11
#define DRS_DISEN       12
#define DRS_BLIND       13
#define DRS_STONE       14
#define DRS_SOUND       15
#define DRS_SHARD       16
#define DRS_WATER       17
#define DRS_PLASMA      18
#define DRS_TIME        19
#define DRS_TELE        20
#define DRS_DRAIN       21
#define DRS_AVOID0      22
#define DRS_AVOID1      23
#define DRS_AVOID2      24
#define DRS_FREE        30
#define DRS_MANA        31
#define DRS_REFLECT     32


#define DAMAGE_FORCE    0x00000001
#define DAMAGE_GENO     0x00000002
#define DAMAGE_LOSELIFE 0x00000004
#define DAMAGE_ATTACK   0x00000008
#define DAMAGE_NOESCAPE 0x00000010
#define DAMAGE_USELIFE  0x00000020
#define DAMAGE_ELEC     0x00000040


#define DO_DISI_TYPE_NONE   0
#define DO_DISI_TYPE_BREATH 1
#define DO_DISI_TYPE_BALL   2


/*
 * Game generated inscription indices. These are stored in the object,
 * and are used to index the string array from tables.c.
 */

#define FEEL_NONE              0
#define FEEL_BROKEN            1
#define FEEL_TERRIBLE          2
#define FEEL_WORTHLESS         3
#define FEEL_CURSED            4
#define FEEL_UNCURSED          5
#define FEEL_AVERAGE           6
#define FEEL_GOOD              7
#define FEEL_EXCELLENT         8
#define FEEL_SPECIAL           9
#define FEEL_TRIED            10

#define FEEL_MAX              10


/*
 * Chest trap flags (see "tables.c")
 */
#define CHEST_LOSE_STR          0x0001
#define CHEST_LOSE_CON          0x0002
#define CHEST_POISON            0x0004
#define CHEST_PARALYZE          0x0008
#define CHEST_EXPLODE           0x0010
#define CHEST_SUMMON            0x0020
#define CHEST_SCATTER           0x0040
#define CHEST_E_SUMMON          0x0080
#define CHEST_BIRD_STORM        0x0100
#define CHEST_H_SUMMON          0x0200
#define CHEST_RUNES_OF_EVIL     0x0400
#define CHEST_ALARM             0x0800


/*
 * Special Object Flags
 */
#define IDENT_SENSE     0x01    /* Item has been "sensed" */
#define IDENT_FIXED     0x02    /* Item has been "haggled" */
#define IDENT_EMPTY     0x04    /* Item charges are known */
#define IDENT_KNOWN     0x08    /* Item abilities are known */
#define IDENT_STOREB    0x10    /* Item is storebought !!!! */
#define IDENT_MENTAL    0x20    /* Item information is known */
#define IDENT_TRIED     0x40    /* Item sensing has been "tried" */
#define IDENT_BROKEN    0x80    /* Item is permanently worthless */


/* 
 * How object is marked (flags in object_type.mark)
 * OM_FOUND --- original boolean flag
 * OM_NOMSG --- temporary flag to suppress messages which were
 *              already printed in auto_pickup_items().
 */
#define OM_FOUND        0x01    /* original boolean flag */
#define OM_NOMSG        0x02    /* temporary flag to suppress messages */
#define OM_NO_QUERY     0x04    /* Query for auto-pick was already answered as 'No' */
#define OM_AUTODESTROY  0x08    /* Destroy later to avoid illegal inventory shift */



/*
 * Special Monster Flags (all temporary)
 */
#define MFLAG_VIEW      0x01    /* Monster is in line of sight */
#define MFLAG_TEMP      0x02    /* Monster is marked for project_hack() */
#define MFLAG_XXX2      0x04    /* (unused) */
#define MFLAG_XXX3      0x08    /* (unused) */
#define MFLAG_BORN      0x10    /* Monster is still being born */
#define MFLAG_NICE      0x20    /* Monster is still being nice */
#define MFLAG_SHOW      0x40    /* Monster is recently memorized */
#define MFLAG_MARK      0x80    /* Monster is currently memorized */

#define MFLAG_NOPET     0x02    /* Cannot make monster pet */
#define MFLAG_NOGENO    0x04    /* Cannot genocide */
#define MFLAG_NOFLOW    0x10    /* Monster is in no_flow_by_smell mode */


/*
 * Object bonuses to misc
 */
#define OB_MAGIC_MASTERY 0
#define OB_STEALTH       1
#define OB_SEARCH        2
#define OB_INFRA         3
#define OB_TUNNEL        4
#define OB_SPEED         5
#define OB_BLOWS         6
#define OB_ANTI_MAGIC    7

#define OB_MAX           8


/*
 * Object flags
 *
 * Old variables for object flags such as flags1, flags2, and flags3
 * are obsolated.  Now single array flgs[TR_FLAG_SIZE] contains all
 * object flags.  And each flag is refered by single index number
 * instead of a bit mask.
 *
 * Therefore it's very easy to add a lot of new flags; no one need to
 * worry about in which variable a new flag should be put, nor to
 * modify a huge number of files all over the source directory at once
 * to add new flag variables such as flags4, flags5, etc...
 *
 * All management of flags is now treated using a set of macros
 * instead of bit operations.
 * Note: These macros are using division, modulo, and bit shift
 * operations, and it seems that these operations are rather slower
 * than original bit operation.  But since index numbers are almost
 * always given as constant, such slow operations are performed in the
 * compile time.  So there is no problem on the speed.
 *
 * Exceptions of new flag management is a set of flags to control
 * object generation and the curse flags.  These are not yet rewritten
 * in new index form; maybe these have no merit of rewriting.
 */

/* Hack -- dividing by 32 is into 5-bit shift */
/* Hack -- MOD by 32 is into 5-bit mask */
#define have_flag(ARRAY, INDEX) (!(!((ARRAY)[((INDEX) >> 5)] & (1L << ((INDEX) & 0x1f)))))
#define add_flag(ARRAY, INDEX) ((ARRAY)[((INDEX) >> 5)] |= (1L << ((INDEX) & 0x1f)))
#define remove_flag(ARRAY, INDEX) ((ARRAY)[((INDEX) >> 5)] &= ~(1L << ((INDEX) & 0x1f)))
#define have_bonus_flags(ARRAY) (((ARRAY)[0] & 0x00003f7fL) || ((ARRAY)[2] & 0x20000000L))


#define TR_STR                 0      /* Fake flag - Affect STR */
#define TR_INT                 1      /* Fake flag - Affect INT */
#define TR_WIS                 2      /* Fake flag - Affect WIS */
#define TR_DEX                 3      /* Fake flag - Affect DEX */
#define TR_CON                 4      /* Fake flag - Affect CON */
#define TR_CHR                 5      /* Fake flag - Affect CHR */
#define TR_MAGIC_MASTERY       6      /* Fake flag - Affect Magic Mastery */
#define TR_FORCE_WEAPON        7      /* Later */
#define TR_STEALTH             8      /* Fake flag - Affect Stealth */
#define TR_SEARCH              9      /* Fake flag - Affect Search */
#define TR_INFRA               10     /* Fake flag - Affect Infra */
#define TR_TUNNEL              11     /* Fake flag - Affect Tunnel */
#define TR_SPEED               12     /* Fake flag - Affect Speed */
#define TR_BLOWS               13     /* Fake flag - Affect Blows */
#define TR_CHAOTIC             14
#define TR_VAMPIRIC            15
#define TR_SLAY_ANIMAL         16
#define TR_SLAY_EVIL           17
#define TR_SLAY_UNDEAD         18
#define TR_SLAY_DEMON          19
#define TR_SLAY_ORC            20
#define TR_SLAY_TROLL          21
#define TR_SLAY_GIANT          22
#define TR_SLAY_DRAGON         23
#define TR_KILL_DRAGON         24     /* Execute Dragon */
#define TR_VORPAL              25     /* Later */
#define TR_IMPACT              26     /* Cause Earthquakes */
#define TR_BRAND_POIS          27
#define TR_BRAND_ACID          28
#define TR_BRAND_ELEC          29
#define TR_BRAND_FIRE          30
#define TR_BRAND_COLD          31

#define TR_SUST_STR            32
#define TR_SUST_INT            33
#define TR_SUST_WIS            34
#define TR_SUST_DEX            35
#define TR_SUST_CON            36
#define TR_SUST_CHR            37
#define TR_RIDING              38
#define TR_SLAY_GOOD           39     /* Slay good */
#define TR_IM_ACID             40
#define TR_IM_ELEC             41
#define TR_IM_FIRE             42
#define TR_IM_COLD             43
#define TR_THROW               44     /* Later */
#define TR_REFLECT             45     /* Reflect 'bolts' */
#define TR_FREE_ACT            46     /* Free Action */
#define TR_HOLD_LIFE           47     /* Hold Life */
#define TR_RES_ACID            48
#define TR_RES_ELEC            49
#define TR_RES_FIRE            50
#define TR_RES_COLD            51
#define TR_RES_POIS            52
#define TR_RES_FEAR            53     /* Added for Zangband */
#define TR_RES_LITE            54
#define TR_RES_DARK            55
#define TR_RES_BLIND           56
#define TR_RES_CONF            57
#define TR_RES_SOUND           58
#define TR_RES_SHARDS          59
#define TR_RES_NETHER          60
#define TR_RES_STONE           61
#define TR_RES_CHAOS           62
#define TR_RES_DISEN           63

#define TR_SH_FIRE             64     /* Immolation (Fire) */
#define TR_SH_ELEC             65     /* Electric Sheath */
#define TR_SLAY_HUMAN          66     /* Slay human */
#define TR_SH_COLD             67     /* Cold aura */
#define TR_NO_TELE             68     /* Anti-teleportation */
#define TR_NO_MAGIC            69     /* Anti-magic */
#define TR_DEC_MANA            70     /* ??? */
#define TR_TY_CURSE            71     /* The Ancient Curse */
#define TR_WARNING             72     /* Warning */
#define TR_UNHOLY              73     /* Item is Unholy */
#define TR_SHOW_MODS           74     /* Always show Tohit/Todam */
#define TR_SLAY_LIVING         75     /* Slay living */
#define TR_FEATHER             76     /* Feather Falling */
#define TR_LITE                77     /* Permanent Light */
#define TR_SEE_INVIS           78     /* See Invisible */
#define TR_TELEPATHY           79     /* Telepathy */
#define TR_SLOW_DIGEST         80     /* Item slows down digestion */
#define TR_REGEN               81     /* Item induces regeneration */
#define TR_XTRA_MIGHT          82     /* Bows get extra multiplier */
#define TR_XTRA_SHOTS          83     /* Bows get extra shots */
#define TR_IGNORE_ACID         84     /* Item ignores Acid Damage */
#define TR_IGNORE_ELEC         85     /* Item ignores Elec Damage */
#define TR_IGNORE_FIRE         86     /* Item ignores Fire Damage */
#define TR_IGNORE_COLD         87     /* Item ignores Cold Damage */
#define TR_ACTIVATE            88     /* Item can be activated */
#define TR_DRAIN_EXP           89     /* Item drains Experience */
#define TR_TELEPORT            90     /* Item teleports player */
#define TR_AGGRAVATE           91     /* Item aggravates monsters */
#define TR_BLESSED             92     /* Item is Blessed */
#define TR_ANTI_MAGIC          93     /* Fake flag - Affect Anti-magic field */
#define TR_EASY_SPELL          94
#define TR_WRAITH              95     /* Permanent wraith form */

#define TR_ES_ATTACK           96     /* Fake flag for Gunner */
#define TR_FULL_NAME           97
#define TR_BALDAR              98     /* Material is Baldar metal */
#define TR_RES_MAGIC           99
#define TR_EXTRA_VORPAL       100     /* Weapon is like the "Vorpal Blade"!! */
#define TR_REGEN_MANA         101     /* Item induces mana regeneration */
#define TR_FEAR_FIELD         102     /* Fear field */
#define TR_FEMALE_ONLY        103     /* Ladies only */
#define TR_MALE_ONLY          104     /* Mens only */

#define TR_FLAG_MAX           105
#define TR_FLAG_SIZE            4


#define TRG_INSTA_ART           0x00000001L     /* Item must be an artifact */
#define TRG_QUESTITEM           0x00000002L     /* quest level item -KMW- */
#define TRG_XTRA_POWER          0x00000004L     /* Extra power */
#define TRG_ONE_SUSTAIN         0x00000008L     /* One sustain */
#define TRG_XTRA_RES_OR_POWER   0x00000010L     /* Extra resistance or power */
#define TRG_XTRA_H_RES          0x00000020L     /* Extra high resistance */
#define TRG_XTRA_E_RES          0x00000040L     /* Extra element resistance */
#define TRG_XTRA_L_RES          0x00000080L     /* Extra lordly resistance */
#define TRG_XTRA_D_RES          0x00000100L     /* Extra dragon resistance */
#define TRG_XTRA_RES            0x00000200L     /* Extra resistance */
#define TRG_CURSED              0x00000400L     /* Item is Cursed */
#define TRG_HEAVY_CURSE         0x00000800L     /* Item is Heavily Cursed */
#define TRG_PERMA_CURSE         0x00001000L     /* Item is Perma Cursed */
#define TRG_RANDOM_CURSE0       0x00002000L     /* Item is Random Cursed */
#define TRG_RANDOM_CURSE1       0x00004000L     /* Item is Random Cursed */
#define TRG_RANDOM_CURSE2       0x00008000L     /* Item is Random Cursed */
#define TRG_RUNEWEAPON          0x00010000L     /* Item is "Runeweapon" */
#define TRG_WALSTANIAN          0x00020000L     /* Walstanian Item */
#define TRG_GARGASTAN           0x00040000L     /* Gargastan Item */
#define TRG_BACRUM              0x00080000L     /* Bacrum Item */
#define TRG_ZENOBIAN            0x00100000L     /* Zenobian Item */
#define TRG_LODIS               0x00200000L     /* Lodis Item */


#define MAX_CURSE 17

#define TRC_CURSED              0x00000001L
#define TRC_HEAVY_CURSE         0x00000002L
#define TRC_PERMA_CURSE         0x00000004L
#define TRC_XXX1                0x00000008L
#define TRC_TY_CURSE            0x00000010L
#define TRC_AGGRAVATE           0x00000020L
#define TRC_DRAIN_EXP           0x00000040L
#define TRC_SLOW_REGEN          0x00000080L
#define TRC_ADD_L_CURSE         0x00000100L
#define TRC_ADD_H_CURSE         0x00000200L
#define TRC_CALL_ANIMAL         0x00000400L
#define TRC_CALL_DEMON          0x00000800L
#define TRC_CALL_DRAGON         0x00001000L
#define TRC_COWARDICE           0x00002000L
#define TRC_TELEPORT            0x00004000L
#define TRC_LOW_MELEE           0x00008000L
#define TRC_LOW_AC              0x00010000L
#define TRC_LOW_MAGIC           0x00020000L
#define TRC_FAST_DIGEST         0x00040000L
#define TRC_DRAIN_HP            0x00080000L
#define TRC_DRAIN_MANA          0x00100000L

#define TRC_TELEPORT_SELF       0x00000001L

#define TRC_SPECIAL_MASK \
	(TRC_TY_CURSE | TRC_AGGRAVATE)

#define TRC_HEAVY_MASK   \
	(TRC_TY_CURSE | TRC_AGGRAVATE | TRC_DRAIN_EXP | TRC_ADD_H_CURSE | \
	 TRC_CALL_DEMON | TRC_CALL_DRAGON | TRC_TELEPORT)

#define TRC_P_FLAG_MASK  \
	(TRC_TELEPORT_SELF | \
	 TRC_TY_CURSE | TRC_DRAIN_EXP | TRC_ADD_L_CURSE | TRC_ADD_H_CURSE | \
	 TRC_CALL_ANIMAL | TRC_CALL_DEMON | TRC_CALL_DRAGON | TRC_COWARDICE | \
	 TRC_TELEPORT | TRC_DRAIN_HP | TRC_DRAIN_MANA)


/*** Monster blow constants ***/


/*
 * New monster blow methods
 */
#define RBM_HIT          1
#define RBM_TOUCH        2
#define RBM_PUNCH        3
#define RBM_KICK         4
#define RBM_CLAW         5
#define RBM_BITE         6
#define RBM_STING        7
#define RBM_SLASH        8
#define RBM_BUTT         9
#define RBM_CRUSH       10
#define RBM_ENGULF      11
#define RBM_CHARGE      12
#define RBM_CRAWL       13
#define RBM_DROOL       14
#define RBM_SPIT        15
#define RBM_EXPLODE     16
#define RBM_GAZE        17
#define RBM_WAIL        18
#define RBM_SPORE       19
#define RBM_XXX4        20
#define RBM_BEG         21
#define RBM_INSULT      22
#define RBM_XXX5        23
#define RBM_SING        24
#define RBM_SHOOT       25


/*
 * New monster blow effects
 */
#define RBE_HURT         1
#define RBE_POISON       2
#define RBE_UN_BONUS     3
#define RBE_UN_POWER     4
#define RBE_EAT_GOLD     5
#define RBE_EAT_ITEM     6
#define RBE_EAT_FOOD     7
#define RBE_EAT_LITE     8
#define RBE_ACID         9
#define RBE_ELEC        10
#define RBE_FIRE        11
#define RBE_COLD        12
#define RBE_BLIND       13
#define RBE_CONFUSE     14
#define RBE_TERRIFY     15
#define RBE_PARALYZE    16
#define RBE_LOSE_STR    17
#define RBE_LOSE_INT    18
#define RBE_LOSE_WIS    19
#define RBE_LOSE_DEX    20
#define RBE_LOSE_CON    21
#define RBE_LOSE_CHR    22
#define RBE_LOSE_ALL    23
#define RBE_SHATTER     24
#define RBE_EXP_10      25
#define RBE_EXP_20      26
#define RBE_EXP_40      27
#define RBE_EXP_80      28
#define RBE_DISEASE     29
#define RBE_TIME        30
#define RBE_EXP_VAMP    31
#define RBE_DR_MANA     32
#define RBE_SUPERHURT   33
#define RBE_STONE       34
#define RBE_HOLY        35
#define RBE_HELL        36


/*** Monster flag values (hard-coded) ***/


/*
 * New monster race bit flags
 */
#define RF1_UNIQUE              0x00000001  /* Unique Monster */
#define RF1_QUESTOR             0x00000002  /* Quest Monster */
#define RF1_MALE                0x00000004  /* Male gender */
#define RF1_FEMALE              0x00000008  /* Female gender */
#define RF1_CHAR_CLEAR          0x00000010  /* Absorbs symbol */
#define RF1_XXX0                0x00000020
#define RF1_ATTR_CLEAR          0x00000040  /* Absorbs color */
#define RF1_ATTR_MULTI          0x00000080  /* Changes color */
#define RF1_FORCE_DEPTH         0x00000100  /* Start at "correct" depth */
#define RF1_FORCE_MAXHP         0x00000200  /* Start with max hitpoints */
#define RF1_FORCE_SLEEP         0x00000400  /* Start out sleeping */
#define RF1_NO_ESCORT           0x00000800  /* Never be escort */
#define RF1_XXX1                0x00001000  /* XXX */
#define RF1_FRIENDS             0x00002000  /* Arrive with some friends */
#define RF1_ESCORT              0x00004000  /* Arrive with an escort */
#define RF1_ESCORTS             0x00008000  /* Arrive with some escorts */
#define RF1_NEVER_BLOW          0x00010000  /* Never make physical blow */
#define RF1_NEVER_MOVE          0x00020000  /* Never make physical move */
#define RF1_RAND_25             0x00040000  /* Moves randomly (25%) */
#define RF1_RAND_50             0x00080000  /* Moves randomly (50%) */
#define RF1_ONLY_GOLD           0x00100000  /* Drop only gold */
#define RF1_ONLY_ITEM           0x00200000  /* Drop only items */
#define RF1_DROP_60             0x00400000  /* Drop an item/gold (60%) */
#define RF1_DROP_90             0x00800000  /* Drop an item/gold (90%) */
#define RF1_DROP_1D2            0x01000000  /* Drop 1d2 items/gold */
#define RF1_DROP_2D2            0x02000000  /* Drop 2d2 items/gold */
#define RF1_DROP_3D2            0x04000000  /* Drop 3d2 items/gold */
#define RF1_DROP_4D2            0x08000000  /* Drop 4d2 items/gold */
#define RF1_DROP_GOOD           0x10000000  /* Drop good items */
#define RF1_DROP_GREAT          0x20000000  /* Drop great items */
#define RF1_DROP_SPECIAL        0x40000000  /* Drop special items */
#define RF1_XXX3                0x80000000  /* XXX */

/*
 * New monster race bit flags
 */
#define RF2_STUPID          0x00000001  /* Monster is stupid */
#define RF2_SMART           0x00000002  /* Monster is smart */
#define RF2_CAN_SPEAK       0x00000004  /* TY: can speak */
#define RF2_REFLECTING      0x00000008  /* Reflects bolts */
#define RF2_INVISIBLE       0x00000010  /* Monster avoids vision */
#define RF2_COLD_BLOOD      0x00000020  /* Monster avoids infra */
#define RF2_EMPTY_MIND      0x00000040  /* Monster avoids telepathy */
#define RF2_WEIRD_MIND      0x00000080  /* Monster avoids telepathy? */
#define RF2_MULTIPLY        0x00000100  /* Monster reproduces */
#define RF2_REGENERATE      0x00000200  /* Monster regenerates */
#define RF2_SHAPECHANGER    0x00000400  /* TY: shapechanger */
#define RF2_ATTR_ANY        0x00000800  /* TY: Attr_any */
#define RF2_POWERFUL        0x00001000  /* Monster has strong breath */
#define RF2_ELDRITCH_HORROR 0x00002000  /* Sanity-blasting horror    */
#define RF2_AURA_FIRE       0x00004000  /* Burns in melee */
#define RF2_AURA_ELEC       0x00008000  /* Shocks in melee */
#define RF2_OPEN_DOOR       0x00010000  /* Monster can open doors */
#define RF2_BASH_DOOR       0x00020000  /* Monster can bash doors */
#define RF2_PASS_WALL       0x00040000  /* Monster can pass walls */
#define RF2_KILL_WALL       0x00080000  /* Monster can destroy walls */
#define RF2_MOVE_BODY       0x00100000  /* Monster can move monsters */
#define RF2_KILL_BODY       0x00200000  /* Monster can kill monsters */
#define RF2_TAKE_ITEM       0x00400000  /* Monster can pick up items */
#define RF2_KILL_ITEM       0x00800000  /* Monster can crush items */
#define RF2_WALSTANIAN      0x01000000  /* Walstanian Monster */
#define RF2_GARGASTAN       0x02000000  /* Gargastan Monster */
#define RF2_BACRUM          0x04000000  /* Bacrum Monster */
#define RF2_ZENOBIAN        0x08000000  /* Zenobian Monster */
#define RF2_LODIS           0x10000000  /* Lodis Monster */
#define RF2_XXX6            0x20000000
#define RF2_HUMAN           0x40000000
#define RF2_XXX7            0x80000000

/*
 * New monster race bit flags
 */
#define RF3_ORC             0x00000001  /* Orc */
#define RF3_TROLL           0x00000002  /* Troll */
#define RF3_GIANT           0x00000004  /* Giant */
#define RF3_DRAGON          0x00000008  /* Dragon */
#define RF3_DEMON           0x00000010  /* Demon */
#define RF3_UNDEAD          0x00000020  /* Undead */
#define RF3_EVIL            0x00000040  /* Evil */
#define RF3_ANIMAL          0x00000080  /* Animal */
#define RF3_TEMPLE          0x00000100  /* Temple Knight */
#define RF3_GOOD            0x00000200  /* Good */
#define RF3_AURA_COLD       0x00000400  /* Freezes in melee */
#define RF3_NONLIVING       0x00000800  /* TY: Non-Living (?) */
#define RF3_HURT_LITE       0x00001000  /* Hurt by lite */
#define RF3_HURT_ROCK       0x00002000  /* Hurt by rock remover */
#define RF3_HURT_FIRE       0x00004000  /* Hurt badly by fire */
#define RF3_HURT_COLD       0x00008000  /* Hurt badly by cold */
#define RF3_RES_TELE        0x00010000  /* Resist teleportation */
#define RF3_XXX1            0x00020000
#define RF3_NO_FEAR         0x00040000  /* Cannot be scared */
#define RF3_NO_STUN         0x00080000  /* Cannot be stunned */
#define RF3_NO_CONF         0x00100000  /* Cannot be confused */
#define RF3_NO_SLEEP        0x00200000  /* Cannot be slept */
#define RF3_NO_STONE        0x00400000  /* Cannot be stoned */
#define RF3_ELEM_FIRE       0x00800000  /* Monster always has fire element */
#define RF3_ELEM_AQUA       0x01000000  /* Monster always has aqua element */
#define RF3_ELEM_EARTH      0x02000000  /* Monster always has earth element */
#define RF3_ELEM_WIND       0x04000000  /* Monster always has wind element */
#define RF3_ELEM_MULTI      0x08000000  /* Monster's element is changing */
#define RF3_ANTI_MAGIC      0x10000000  /* Anti-magic Field */
#define RF3_HURT_ACID       0x20000000  /* Hurt badly by acid */
#define RF3_HURT_ELEC       0x40000000  /* Hurt badly by elec */
#define RF3_FEAR_FIELD      0x80000000  /* Fear Field */

/*
 * New monster race bit flags
 */
#define RF4_SHRIEK          0x00000001  /* Shriek for help */
#define RF4_SHIFT_ELEM      0x00000002  /* Shift own element */
#define RF4_DISPEL          0x00000004  /* Dispel magic */
#define RF4_ROCKET          0x00000008  /* TY: Rocket */
#define RF4_SHOOT           0x00000010  /* Fire missiles */
#define RF4_SHOOT_GUN       0x00000020  /* Shoot gun */
#define RF4_XXX3            0x00000040
#define RF4_XXX4            0x00000080
#define RF4_BR_ACID         0x00000100  /* Breathe Acid */
#define RF4_BR_ELEC         0x00000200  /* Breathe Elec */
#define RF4_BR_FIRE         0x00000400  /* Breathe Fire */
#define RF4_BR_COLD         0x00000800  /* Breathe Cold */
#define RF4_BR_POIS         0x00001000  /* Breathe Poison */
#define RF4_BR_NETH         0x00002000  /* Breathe Nether */
#define RF4_BR_LITE         0x00004000  /* Breathe Lite */
#define RF4_BR_DARK         0x00008000  /* Breathe Dark */
#define RF4_BR_CONF         0x00010000  /* Breathe Confusion */
#define RF4_BR_SOUN         0x00020000  /* Breathe Sound */
#define RF4_BR_CHAO         0x00040000  /* Breathe Chaos */
#define RF4_BR_DISE         0x00080000  /* Breathe Disenchant */
#define RF4_BR_STON         0x00100000  /* Breathe Stoning */
#define RF4_BR_TIME         0x00200000  /* Breathe Time */
#define RF4_BR_INER         0x00400000  /* Breathe Inertia */
#define RF4_BR_GRAV         0x00800000  /* Breathe Gravity */
#define RF4_BR_SHAR         0x01000000  /* Breathe Shards */
#define RF4_BR_PLAS         0x02000000  /* Breathe Plasma */
#define RF4_BR_WALL         0x04000000  /* Breathe Force */
#define RF4_BR_MANA         0x08000000  /* Breathe Mana */
#define RF4_BA_NUKE         0x10000000  /* TY: Nuke Ball */
#define RF4_BR_NUKE         0x20000000  /* TY: Toxic Breath */
#define RF4_BA_CHAO         0x40000000  /* Chaos Ball */
#define RF4_BR_DISI         0x80000000  /* Breathe Disintegration */

/*
 * New monster race bit flags
 */
#define RF5_BA_ACID         0x00000001  /* Acid Ball */
#define RF5_BA_ELEC         0x00000002  /* Elec Ball */
#define RF5_BA_FIRE         0x00000004  /* Fire Ball */
#define RF5_BA_COLD         0x00000008  /* Cold Ball */
#define RF5_BA_POIS         0x00000010  /* Poison Ball */
#define RF5_BA_NETH         0x00000020  /* Nether Ball */
#define RF5_BA_WATE         0x00000040  /* Water Ball */
#define RF5_BA_MANA         0x00000080  /* Mana Storm */
#define RF5_BA_DARK         0x00000100  /* Darkness Storm */
#define RF5_DRAIN_MANA      0x00000200  /* Drain Mana */
#define RF5_MIND_BLAST      0x00000400  /* Blast Mind */
#define RF5_BRAIN_SMASH     0x00000800  /* Smash Brain */
#define RF5_CAUSE_1         0x00001000  /* Cause Light Wound */
#define RF5_CAUSE_2         0x00002000  /* Cause Serious Wound */
#define RF5_CAUSE_3         0x00004000  /* Cause Critical Wound */
#define RF5_CAUSE_4         0x00008000  /* Cause Mortal Wound */
#define RF5_BO_ACID         0x00010000  /* Acid Bolt */
#define RF5_BO_ELEC         0x00020000  /* Elec Bolt (unused) */
#define RF5_BO_FIRE         0x00040000  /* Fire Bolt */
#define RF5_BO_COLD         0x00080000  /* Cold Bolt */
#define RF5_BA_LITE         0x00100000  /* StarBurst */
#define RF5_BO_NETH         0x00200000  /* Nether Bolt */
#define RF5_BO_WATE         0x00400000  /* Water Bolt */
#define RF5_BO_MANA         0x00800000  /* Mana Bolt */
#define RF5_BO_PLAS         0x01000000  /* Plasma Bolt */
#define RF5_BO_ICEE         0x02000000  /* Ice Bolt */
#define RF5_MISSILE         0x04000000  /* Magic Missile */
#define RF5_SCARE           0x08000000  /* Frighten Player */
#define RF5_BLIND           0x10000000  /* Blind Player */
#define RF5_CONF            0x20000000  /* Confuse Player */
#define RF5_SLOW            0x40000000  /* Slow Player */
#define RF5_HOLD            0x80000000  /* Paralyze Player */

/*
 * New monster race bit flags
 */
#define RF6_HASTE           0x00000001  /* Speed self */
#define RF6_HAND_DOOM       0x00000002  /* Hand of Doom */
#define RF6_HEAL            0x00000004  /* Heal self */
#define RF6_INVULNER        0x00000008  /* INVULNERABILITY! */
#define RF6_BLINK           0x00000010  /* Teleport Short */
#define RF6_TPORT           0x00000020  /* Teleport Long */
#define RF6_STOP_TIME       0x00000040  /* Stop Time */
#define RF6_SPECIAL         0x00000080  /* Special Attack */
#define RF6_TELE_TO         0x00000100  /* Move player to monster */
#define RF6_TELE_AWAY       0x00000200  /* Move player far away */
#define RF6_TELE_LEVEL      0x00000400  /* Move player vertically */
#define RF6_GODLY_SPEAR     0x00000800  /* Godly Spear */
#define RF6_DARKNESS        0x00001000  /* Create Darkness */
#define RF6_TRAPS           0x00002000  /* Create Traps */
#define RF6_FORGET          0x00004000  /* Cause amnesia */
#define RF6_RAISE_DEAD      0x00008000  /* Raise Dead */
#define RF6_S_KIN           0x00010000  /* Summon "kin" */
#define RF6_S_CYBER         0x00020000  /* Summon Cyberdemons! */
#define RF6_S_MONSTER       0x00040000  /* Summon Monster */
#define RF6_S_MONSTERS      0x00080000  /* Summon Monsters */
#define RF6_S_ANT           0x00100000  /* Summon Ants */
#define RF6_S_SPIDER        0x00200000  /* Summon Spiders */
#define RF6_S_HOUND         0x00400000  /* Summon Hounds */
#define RF6_S_BEAST         0x00800000  /* Summon Beasts */
#define RF6_S_ANGEL         0x01000000  /* Summon Angel */
#define RF6_S_DEMON         0x02000000  /* Summon Demon */
#define RF6_S_UNDEAD        0x04000000  /* Summon Undead */
#define RF6_S_DRAGON        0x08000000  /* Summon Dragon */
#define RF6_S_HI_UNDEAD     0x10000000  /* Summon Greater Undead */
#define RF6_S_HI_DRAGON     0x20000000  /* Summon Ancient Dragon */
#define RF6_S_TEMPLES       0x40000000  /* Summon Temple Knights */
#define RF6_S_UNIQUE        0x80000000  /* Summon Unique Monster */

/*
 * New monster race bit flags
 */
#define RF7_AQUATIC             0x00000001  /* Aquatic monster */
#define RF7_CAN_SWIM            0x00000002  /* Monster can swim */
#define RF7_CAN_FLY             0x00000004  /* Monster can fly */
#define RF7_FRIENDLY            0x00000008  /* Monster is friendly */
#define RF7_NAZGUL              0x00000010  /* Is a "Nazgul" unique */
#define RF7_UNIQUE2             0x00000020  /* Fake unique */
#define RF7_RIDING              0x00000040  /* Good for riding */
#define RF7_HAS_LITE_1          0x00000100  /* Monster carries light */
#define RF7_SELF_LITE_1         0x00000200  /* Monster lights itself */
#define RF7_HAS_LITE_2          0x00000400  /* Monster carries light */
#define RF7_SELF_LITE_2         0x00000800  /* Monster lights itself */
#define RF7_GUARDIAN            0x00001000  /* Guardian of a dungeon */
#define RF7_KILL_EXP            0x00004000  /* No exp until you kill it */
#define RF7_LAWFUL              0x00008000  /* Lawful */
#define RF7_CHAOTIC             0x00010000  /* Chaotic */
#define RF7_ZENOBIAN_FORCES     0x00020000  /* Zenobian Forces */
#define RF7_LONG_RANGE          0x00040000  /* Monster mainly uses long range attack */
#define RF7_EGG_ONLY            0x00080000  /* Egg Monster */

/*
 * Monster race flags
 */
#define RF8_WILD_ONLY           0x00000001
#define RF8_WILD_TOWN           0x00000002
#define RF8_XXX8X02             0x00000004
#define RF8_WILD_SHORE          0x00000008
#define RF8_WILD_OCEAN          0x00000010
#define RF8_WILD_WASTE          0x00000020
#define RF8_WILD_WOOD           0x00000040
#define RF8_WILD_VOLCANO        0x00000080
#define RF8_XXX8X08             0x00000100
#define RF8_WILD_MOUNTAIN       0x00000200
#define RF8_WILD_GRASS          0x00000400
#define RF8_WILD_ALL            0x80000000

/*
 * Monster drop info
 */

#define RF9_DROP_CORPSE         0x00000001
#define RF9_DROP_SKELETON       0x00000002

/*
 * Additional monster race flags
 */

#define RFA_FIRE_STORM          0x00000001  /* Pure Fire Storm */
#define RFA_AQUA_STORM          0x00000002  /* Pure Aqua Storm */
#define RFA_EARTH_STORM         0x00000004  /* Pure Earth Storm */
#define RFA_WIND_STORM          0x00000008  /* Pure Wind Storm */
#define RFA_BR_PURE_FIRE        0x00000010  /* Breathe Pure Fire */
#define RFA_BR_PURE_AQUA        0x00000020  /* Breathe Pure Aqua */
#define RFA_BR_PURE_EARTH       0x00000040  /* Breathe Pure Earth */
#define RFA_BR_PURE_WIND        0x00000080  /* Breathe Pure Wind */
#define RFA_PETRO_CLOUD         0x00000100  /* Stoning Ball */
#define RFA_SAND_STORM          0x00000200  /* Sand Storm */
#define RFA_ERASE_ELEM          0x00000400  /* Erase elements of grid */
#define RFA_CHANGE_ELEM         0x00000800  /* Change enemy's element */
#define RFA_SALAMANDER          0x00001000  /* Call the Salamander */
#define RFA_FENRER              0x00002000  /* Call the Fenrer */
#define RFA_GNOME               0x00004000  /* Call the Gnome */
#define RFA_THUNDERBIRD         0x00008000  /* Call the Thunderbird */
#define RFA_IGNIS_FATUUS        0x00010000  /* Call the Ignis Fatuus */
#define RFA_DARK_LORE           0x00020000  /* Call the Phantom */
#define RFA_STONE_GAZE          0x00040000  /* Stone Gaze */
#define RFA_HOLY_ORB            0x00080000  /* Holy Orb */
#define RFA_DARK_FIRE           0x00100000  /* Dark Fire */
#define RFA_S_ZENOBIAN          0x00200000  /* Summon Zenobian Forces */
#define RFA_S_HI_DEMON          0x00400000  /* Summon Major Demon */
#define RFA_BA_DISI             0x00800000  /* Disintegration */
#define RFA_PURE_ELEM_BEAM      0x01000000  /* Pure Element Beam */

/*
 * Monster resistance info
 */

#define RFR_RES_ACID        0x00000001  /* Resist acid */
#define RFR_RES_ELEC        0x00000002  /* Resist elec */
#define RFR_RES_FIRE        0x00000004  /* Resist fire */
#define RFR_RES_COLD        0x00000008  /* Resist cold */
#define RFR_RES_POIS        0x00000010  /* Resist poison */
#define RFR_RES_LITE        0x00000020  /* Resist lite */
#define RFR_RES_DARK        0x00000040  /* Resist dark */
#define RFR_RES_NETH        0x00000080  /* Resist nether */
#define RFR_RES_WATE        0x00000100  /* Resist water */
#define RFR_RES_PLAS        0x00000200  /* Resist plasma */
#define RFR_RES_SHAR        0x00000400  /* Resist shards */
#define RFR_RES_SOUN        0x00000800  /* Resist sound */
#define RFR_RES_CONF        0x00001000  /* Resist confusion */
#define RFR_RES_CHAO        0x00002000  /* Resist chaos */
#define RFR_RES_STON        0x00004000  /* Resist stone */
#define RFR_RES_DISE        0x00008000  /* Resist disenchantment */
#define RFR_RES_WALL        0x00010000  /* Resist force */
#define RFR_RES_INER        0x00020000  /* Resist inertia */
#define RFR_RES_TIME        0x00040000  /* Resist time */
#define RFR_RES_GRAV        0x00080000  /* Resist gravity */
#define RFR_RES_EDGED       0x00100000  /* Resist edged weapons */
#define RFR_RES_BLUNT       0x00200000  /* Resist blunt weapons */
#define RFR_IM_EDGED        0x00400000  /* Almost immune to edged weapons */
#define RFR_IM_BLUNT        0x00800000  /* Almost immune to blunt weapons */

/*
 * Hack -- Various mask
 */

#define RF2_ETHNICITY_MASK \
  (RF2_WALSTANIAN | RF2_GARGASTAN | RF2_BACRUM | RF2_ZENOBIAN | RF2_LODIS)

#define RF3_RACE_MASK \
  (RF3_DRAGON | RF3_DEMON | RF3_GIANT | RF3_TROLL | RF3_ORC)

#define RF3_ELEM_MASK \
  (RF3_ELEM_FIRE | RF3_ELEM_AQUA | RF3_ELEM_EARTH | RF3_ELEM_WIND | RF3_ELEM_MULTI)

/*
 * Hack -- choose "intelligent" spells when desperate
 */

#define RF4_INT_MASK \
   (RF4_SHIFT_ELEM | RF4_DISPEL)

#define RF5_INT_MASK \
  (RF5_HOLD | RF5_SLOW | RF5_CONF | RF5_BLIND | RF5_SCARE)

#define RF6_INT_MASK \
   (RF6_BLINK |  RF6_TPORT | RF6_TELE_LEVEL | RF6_TELE_AWAY | \
    RF6_HEAL | RF6_INVULNER | RF6_HASTE | RF6_TRAPS | \
    RF6_S_KIN | RF6_S_CYBER | RF6_S_MONSTER | RF6_S_MONSTERS | \
    RF6_S_ANT | RF6_S_SPIDER | RF6_S_HOUND | RF6_S_BEAST | \
    RF6_S_ANGEL | RF6_S_DRAGON | RF6_S_UNDEAD | RF6_S_DEMON | \
    RF6_S_HI_DRAGON | RF6_S_HI_UNDEAD | RF6_S_TEMPLES | RF6_S_UNIQUE)

#define RFA_INT_MASK \
   (RFA_ERASE_ELEM | RFA_CHANGE_ELEM | RFA_S_ZENOBIAN | RFA_S_HI_DEMON)


#define RF4_RIDING_MASK \
  (RF4_SHRIEK)

#define RF5_RIDING_MASK \
   0L

#define RF6_RIDING_MASK \
   (RF6_BLINK | RF6_TPORT | RF6_TRAPS | RF6_DARKNESS | RF6_SPECIAL)

#define RFA_RIDING_MASK \
   0L


/*
 * Hack -- "bolt" spells that may hurt fellow monsters
 */
#define RF4_BOLT_MASK \
   (RF4_ROCKET | RF4_SHOOT | RF4_SHOOT_GUN)

#define RF5_BOLT_MASK \
   (RF5_BO_ACID | RF5_BO_ELEC | RF5_BO_FIRE | RF5_BO_COLD | \
    RF5_BO_NETH | RF5_BO_WATE | RF5_BO_MANA | \
    RF5_BO_PLAS | RF5_BO_ICEE | RF5_MISSILE)

#define RF6_BOLT_MASK 0

#define RFA_BOLT_MASK 0

/*
 * Hack -- "beam" spells that may hurt fellow monsters
 */
#define RF4_BEAM_MASK 0

#define RF5_BEAM_MASK 0

#define RF6_BEAM_MASK (RF6_GODLY_SPEAR)

#define RFA_BEAM_MASK (RFA_PURE_ELEM_BEAM)

/*
 * Hack -- 'ball' spells with radius 4 that may hurt friends
 */
#define RF4_RAD4_BALL_MASK \
	(RF4_BA_CHAO)

#define RF5_RAD4_BALL_MASK \
	(RF5_BA_LITE | RF5_BA_DARK | RF5_BA_WATE | RF5_BA_MANA)

#define RF6_RAD4_BALL_MASK \
	0L

#define RFA_RAD4_BALL_MASK \
	(RFA_FIRE_STORM | RFA_AQUA_STORM | RFA_EARTH_STORM | RFA_WIND_STORM | \
	 RFA_SAND_STORM | RFA_BA_DISI)


/*
 * Hack -- 'ball' spells with radius 3 that may hurt friends
 * (Including RAD4_BALL_MASK)
 */
#define RF4_RAD3_BALL_MASK \
	(RF4_RAD4_BALL_MASK)

#define RF5_RAD3_BALL_MASK \
	(RF5_RAD4_BALL_MASK)

#define RF6_RAD3_BALL_MASK \
	(RF6_RAD4_BALL_MASK)

#define RFA_RAD3_BALL_MASK \
	(RFA_RAD4_BALL_MASK | RFA_PETRO_CLOUD | RFA_SAND_STORM | RFA_SALAMANDER | \
	 RFA_GNOME | RFA_THUNDERBIRD | RFA_IGNIS_FATUUS | RFA_DARK_LORE)


/*
 * Hack -- 'orb' spells with radius 2 or 3 that may hurt friends
 */
#define RF4_ORB_MASK \
	0L

#define RF5_ORB_MASK \
	0L

#define RF6_ORB_MASK \
	0L

#define RFA_ORB_MASK \
	(RFA_HOLY_ORB | RFA_DARK_FIRE)


/*
 * Hack -- 'breath' spells that may hurt friends
 */
#define RF4_BREATH_MASK \
	(RF4_BR_ACID | RF4_BR_ELEC | RF4_BR_FIRE | RF4_BR_COLD | \
	 RF4_BR_POIS | RF4_BR_NETH | RF4_BR_LITE | RF4_BR_DARK | \
	 RF4_BR_CONF | RF4_BR_SOUN | RF4_BR_CHAO | RF4_BR_DISE | \
	 RF4_BR_STON | RF4_BR_SHAR | RF4_BR_TIME | RF4_BR_INER | \
	 RF4_BR_GRAV | RF4_BR_PLAS | RF4_BR_WALL | RF4_BR_MANA | \
	 RF4_BR_NUKE | RF4_BR_DISI)

#define RF5_BREATH_MASK \
    0L

#define RF6_BREATH_MASK \
    0L

#define RFA_BREATH_MASK \
	(RFA_BR_PURE_FIRE | RFA_BR_PURE_AQUA | RFA_BR_PURE_EARTH | RFA_BR_PURE_WIND)


/*
 * Hack -- 'ball' spells that may hurt friends
 * (Including RAD3_BALL_MASK, ORB_MASK, BREATH_MASK)
 */
#define RF4_BALL_MASK \
	(RF4_RAD3_BALL_MASK | RF4_ORB_MASK | RF4_BREATH_MASK | \
	 RF4_ROCKET | RF4_BA_NUKE)

#define RF5_BALL_MASK \
	(RF5_RAD3_BALL_MASK | RF5_ORB_MASK | RF5_BREATH_MASK | \
	 RF5_BA_ACID | RF5_BA_ELEC | RF5_BA_FIRE | RF5_BA_COLD | \
	 RF5_BA_POIS | RF5_BA_NETH)

#define RF6_BALL_MASK \
	(RF6_RAD3_BALL_MASK | RF6_ORB_MASK | RF6_BREATH_MASK)

#define RFA_BALL_MASK \
	(RFA_RAD3_BALL_MASK | RFA_ORB_MASK | RFA_BREATH_MASK)

/* Hack -- summon spells */

#define RF4_SUMMON_MASK \
    0L

#define RF5_SUMMON_MASK \
    0L

#define RF6_SUMMON_MASK \
	(RF6_S_KIN | RF6_S_CYBER | RF6_S_MONSTER | RF6_S_MONSTERS | RF6_S_ANT | \
	 RF6_S_SPIDER | RF6_S_HOUND | RF6_S_BEAST | RF6_S_ANGEL | RF6_S_DEMON | \
	 RF6_S_UNDEAD | RF6_S_DRAGON | RF6_S_HI_UNDEAD | RF6_S_HI_DRAGON | \
	 RF6_S_TEMPLES | RF6_S_UNIQUE)

#define RFA_SUMMON_MASK \
	(RFA_S_ZENOBIAN | RFA_S_HI_DEMON)


/*
 * Hack -- "attack" spells
 */
#define RF4_ATTACK_MASK \
	(RF4_SHRIEK | RF4_DISPEL | RF4_ROCKET | RF4_SHOOT | RF4_SHOOT_GUN | \
	 RF4_BR_ACID | RF4_BR_ELEC | RF4_BR_FIRE | \
	 RF4_BR_COLD | RF4_BR_POIS | RF4_BR_NETH | RF4_BR_LITE | RF4_BR_DARK | \
	 RF4_BR_CONF | RF4_BR_SOUN | RF4_BR_CHAO | RF4_BR_DISE | RF4_BR_STON | \
	 RF4_BR_TIME | RF4_BR_INER | RF4_BR_GRAV | RF4_BR_SHAR | RF4_BR_PLAS | \
	 RF4_BR_WALL | RF4_BR_MANA | RF4_BA_NUKE | RF4_BR_NUKE | RF4_BA_CHAO | \
	 RF4_BR_DISI)

#define RF5_ATTACK_MASK \
	(RF5_BA_ACID | RF5_BA_ELEC | RF5_BA_FIRE | RF5_BA_COLD | \
	 RF5_BA_POIS | RF5_BA_NETH | RF5_BA_WATE | RF5_BA_MANA | \
	 RF5_BA_DARK | RF5_DRAIN_MANA | RF5_MIND_BLAST | RF5_BRAIN_SMASH | \
	 RF5_CAUSE_1 | RF5_CAUSE_2 | RF5_CAUSE_3 | RF5_CAUSE_4 | \
	 RF5_BO_ACID | RF5_BO_ELEC | RF5_BO_FIRE | RF5_BO_COLD | \
	 RF5_BA_LITE | RF5_BO_NETH | RF5_BO_WATE | RF5_BO_MANA | \
	 RF5_BO_PLAS | RF5_BO_ICEE | RF5_MISSILE | RF5_SCARE | \
	 RF5_BLIND | RF5_CONF | RF5_SLOW | RF5_HOLD)

#define RF6_ATTACK_MASK \
	(RF6_HAND_DOOM | RF6_TELE_TO | RF6_TELE_AWAY | RF6_GODLY_SPEAR | \
	 RF6_DARKNESS | RF6_TRAPS | RF6_FORGET)

#define RFA_ATTACK_MASK \
	(RFA_FIRE_STORM | RFA_AQUA_STORM | RFA_EARTH_STORM | RFA_WIND_STORM | \
	 RFA_BR_PURE_FIRE | RFA_BR_PURE_AQUA | RFA_BR_PURE_EARTH | RFA_BR_PURE_WIND | \
	 RFA_PETRO_CLOUD | RFA_SAND_STORM | RFA_SALAMANDER | RFA_FENRER | \
	 RFA_GNOME | RFA_THUNDERBIRD | RFA_IGNIS_FATUUS | RFA_DARK_LORE | \
	 RFA_STONE_GAZE | RFA_HOLY_ORB | RFA_DARK_FIRE | RFA_BA_DISI | \
	 RFA_PURE_ELEM_BEAM)


/*
 * Hack -- "indirect" spells
 */
#define RF4_INDIRECT_MASK \
	(RF4_SHRIEK | RF4_SHIFT_ELEM | RF4_XXX3 | RF4_XXX4)

#define RF5_INDIRECT_MASK \
	0L

#define RF6_INDIRECT_MASK \
	(RF6_HASTE | RF6_HEAL | RF6_INVULNER | RF6_BLINK | RF6_STOP_TIME | \
	 RF6_TPORT | RF6_RAISE_DEAD | \
	 RF6_S_KIN | RF6_S_CYBER | RF6_S_MONSTER | RF6_S_MONSTERS | \
	 RF6_S_ANT | RF6_S_SPIDER | RF6_S_HOUND | RF6_S_BEAST | \
	 RF6_S_ANGEL | RF6_S_DEMON | RF6_S_UNDEAD | RF6_S_DRAGON | \
	 RF6_S_HI_UNDEAD | RF6_S_HI_DRAGON | RF6_S_TEMPLES | RF6_S_UNIQUE)

#define RFA_INDIRECT_MASK \
	(RFA_S_ZENOBIAN | RFA_S_HI_DEMON)


/*
 * Hack -- "no magic" spells
 */
#define RF4_NOMAGIC_MASK \
	(RF4_SHRIEK | RF4_ROCKET | RF4_SHOOT | RF4_SHOOT_GUN | \
	 RF4_BR_ACID | RF4_BR_ELEC | \
	 RF4_BR_FIRE | RF4_BR_COLD | RF4_BR_POIS | RF4_BR_NETH | \
	 RF4_BR_LITE | RF4_BR_DARK | RF4_BR_CONF | RF4_BR_SOUN | \
	 RF4_BR_CHAO | RF4_BR_DISE | RF4_BR_STON | RF4_BR_SHAR | \
	 RF4_BR_SOUN | RF4_BR_TIME | RF4_BR_INER | RF4_BR_GRAV | \
	 RF4_BR_PLAS | RF4_BR_WALL | RF4_BR_MANA | \
	 RF4_BR_NUKE | RF4_BR_DISI)

#define RF5_NOMAGIC_MASK \
	0L

#define RF6_NOMAGIC_MASK \
	(RF6_SPECIAL)

#define RFA_NOMAGIC_MASK \
	(RFA_BR_PURE_FIRE | RFA_BR_PURE_AQUA | RFA_BR_PURE_EARTH | RFA_BR_PURE_WIND | \
	 RFA_STONE_GAZE)


#define MR1_SINKA 0x01


#define is_friendly(A) \
	 (bool)(((A)->smart1 & SM1_FRIENDLY) ? TRUE : FALSE)

#define is_friendly_idx(IDX) \
	 (bool)((IDX) > 0 && is_friendly(&m_list[(IDX)]))

#define is_pet(A) \
	 (bool)(((A)->smart1 & SM1_PET) ? TRUE : FALSE)

#define is_hostile(A) \
	 (bool)((is_friendly(A) || is_pet(A)) ? FALSE : TRUE)


/*** Macro Definitions ***/


/*
 * Hack -- The main "screen"
 */
#define term_screen     (angband_term[0])


#ifndef SCRIPT_OBJ_KIND
/*
 * Determine if a given inventory item is "aware"
 */
#define object_aware_p(T) \
    (k_info[(T)->k_idx].aware)

/*
 * Determine if a given inventory item is "tried"
 */
#define object_tried_p(T) \
    (k_info[(T)->k_idx].tried)


/*
 * Determine if a given inventory item is "known"
 * Test One -- Check for special "known" tag
 * Test Two -- Check for "Easy Know" + "Aware"
 */
#define object_known_p(T) \
    (((T)->ident & (IDENT_KNOWN)) || \
     (k_info[(T)->k_idx].easy_know && k_info[(T)->k_idx].aware))


/*
 * Return the "attr" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_attr(T) \
	((k_info[(T)->k_idx].flavor) ? \
	 (misc_to_attr[k_info[(T)->k_idx].flavor]) : \
	 (k_info[(T)->k_idx].x_attr))

/*
 * Return the "char" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_char(T) \
	((k_info[(T)->k_idx].flavor) ? \
	 (misc_to_char[k_info[(T)->k_idx].flavor]) : \
	 (k_info[(T)->k_idx].x_char))


#else /* SCRIPT_OBJ_KIND */


/*
 * Determine if a given inventory item is "aware"
 */
#define object_aware_p(T) \
    ((T)->aware)

/*
 * Determine if a given inventory item is "tried"
 */
#define object_tried_p(T) \
    ((T)->tried)


/*
 * Determine if a given inventory item is "known"
 * Test One -- Check for special "known" tag
 * Test Two -- Check for "Easy Know" + "Aware"
 */
#define object_known_p(T) \
    (((T)->ident & (IDENT_KNOWN)) || \
     ((T)->easy_know && (T)->aware))


/*
 * Return the "attr" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_attr(T) \
	(((T)->flavor) ? \
	 (misc_to_attr[(T)->flavor]) : \
	 ((T)->x_attr))

/*
 * Return the "char" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_char(T) \
	(((T)->flavor) ? \
	 (misc_to_char[(T)->flavor]) : \
	 ((T)->x_char))

#endif /* SCRIPT_OBJ_KIND */




/*
 * Artifacts use the "name1" field
 */
#define artifact_p(T) \
	((T)->name1 ? TRUE : FALSE)

/*
 * Ego-Items use the "name2" field
 */
#define ego_item_p(T) \
	((T)->name2 ? TRUE : FALSE)


/*
 * Broken items.
 */
#define broken_p(T) \
	((T)->ident & (IDENT_BROKEN))

/*
 * Cursed items.
 */
#define cursed_p(T) \
	((T)->curse_flags)


/*
 * Convert an "attr"/"char" pair into a "pict" (P)
 */
#define PICT(A,C) \
	((((u16b)(A)) << 8) | ((byte)(C)))

/*
 * Convert a "pict" (P) into an "attr" (A)
 */
#define PICT_A(P) \
	((byte)((P) >> 8))

/*
 * Convert a "pict" (P) into an "char" (C)
 */
#define PICT_C(P) \
	((char)((byte)(P)))


/*
 * Convert a "location" (Y,X) into a "grid" (G)
 */
#define GRID(Y,X) \
	(256 * (Y) + (X))

/*
 * Convert a "grid" (G) into a "location" (Y)
 */
#define GRID_Y(G) \
	((int)((G) / 256U))

/*
 * Convert a "grid" (G) into a "location" (X)
 */
#define GRID_X(G) \
	((int)((G) % 256U))


/*
 * Determines if a map location is fully inside the outer walls
 */
#define in_bounds(Y,X) \
   (((Y) > 0) && ((X) > 0) && ((Y) < cur_hgt-1) && ((X) < cur_wid-1))

/*
 * Determines if a map location is on or inside the outer walls
 */
#define in_bounds2(Y,X) \
   (((Y) >= 0) && ((X) >= 0) && ((Y) < cur_hgt) && ((X) < cur_wid))

/*
 * Determines if a map location is on or inside the outer walls
 * (unsigned version)
 */
#define in_bounds2u(Y,X) \
   (((Y) < cur_hgt) && ((X) < cur_wid))

/*
 * Determines if a map location is currently "on screen" -RAK-
 * Note that "panel_contains(Y,X)" always implies "in_bounds2(Y,X)".
 */
#define panel_contains(Y,X) \
  (((Y) >= panel_row_min) && ((Y) <= panel_row_max) && \
   ((X) >= panel_col_min) && ((X) <= panel_col_max))



/*
 * Determine if a "legal" grid is a "floor" grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 *
 * Note that the terrain features are split by a one bit test
 * into those features which block line of sight and those that
 * do not, allowing an extremely fast single bit check below.
 *
 * Add in the fact that some new terrain (water & lava) do NOT block sight
 * -KMW-
 */
#define cave_floor_bold(Y,X) \
	(!(cave[Y][X].feat & 0x20))


/*
 * Determine if a "legal" grid is a "clean" floor grid
 *
 * Line 1 -- forbid non-floors
 * Line 2 -- forbid deep water -KMW-
 * Line 3 -- forbid deep lava -KMW-
 * Line 4 -- forbid normal objects
 */
#define cave_clean_bold(Y,X) \
	(((cave[Y][X].feat == FEAT_FLOOR) || \
	  (cave[Y][X].feat == FEAT_SHAL_WATER) || \
	  (cave[Y][X].feat == FEAT_SHAL_LAVA) || \
	  (cave[Y][X].feat == FEAT_DEEP_GRASS) || \
	  (cave[Y][X].feat == FEAT_FLOWER) || \
	  (cave[Y][X].feat == FEAT_GRASS) || \
	  (cave[Y][X].feat == FEAT_DIRT) || \
	  (cave[Y][X].feat == FEAT_SWAMP) || \
	  (cave[Y][X].feat == FEAT_TUNDRA)) && \
	  !(cave[Y][X].info & CAVE_OBJECT) && \
	  (cave[Y][X].o_idx == 0) && \
	  !(p_ptr->use_decoy && ((Y) == p_ptr->decoy_y) && ((X) == p_ptr->decoy_y)))


/*
 * Determine if a "legal" grid is an "empty" floor grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 * Line 2 -- forbid normal monsters
 * Line 3 -- forbid the player
 */
#define cave_empty_bold(Y,X) \
    (cave_floor_bold(Y,X) && \
     !(cave[Y][X].m_idx) && \
     !(((Y) == py) && ((X) == px)))


/*
 * Determine if a "legal" grid is an "empty" floor grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 * Line 2 -- forbid normal monsters
 * Line 3 -- forbid the player
 */
#define cave_empty_bold2(Y,X) \
    ((cave_floor_bold(Y,X) || \
     (character_dungeon && (cave[Y][X].feat == FEAT_TREES))) && \
     !(cave[Y][X].m_idx) && \
     !(((Y) == py) && ((X) == px)))


/*
 * Determine if a "legal" grid is an "naked" floor grid
 *
 * Line 1 -- forbid non-floors, non-shallow water & lava -KMW-
 * Line 4 -- forbid normal objects
 * Line 5 -- forbid player/monsters
 */
#define cave_naked_bold(Y,X) \
	(((cave[Y][X].feat == FEAT_FLOOR) || \
	  (cave[Y][X].feat == FEAT_SHAL_WATER) || \
	  (cave[Y][X].feat == FEAT_SHAL_LAVA) || \
	  (cave[Y][X].feat == FEAT_GRASS) || \
	  (cave[Y][X].feat == FEAT_DEEP_GRASS) || \
	  (cave[Y][X].feat == FEAT_FLOWER) || \
	  (cave[Y][X].feat == FEAT_DIRT) || \
	  (cave[Y][X].feat == FEAT_SWAMP) || \
	  (cave[Y][X].feat == FEAT_TUNDRA)) && \
	  !(cave[Y][X].info & CAVE_OBJECT) && \
	  (cave[Y][X].o_idx == 0) && \
	  (cave[Y][X].m_idx == 0) && \
	  !(p_ptr->use_decoy && ((Y) == p_ptr->decoy_y) && ((X) == p_ptr->decoy_y)))



/*
 * Determine if a "legal" grid is "permanent"
 *
 * Line 1   -- perma-walls
 * Line 2-3 -- stairs
 * Line 4-5 -- building doors -KMW-
 * Line 6-7 -- shop doors
 */
#define cave_perma_bold(Y,X) \
	(((cave[Y][X].feat >= FEAT_PERM_EXTRA) && \
	  (cave[Y][X].feat <= FEAT_PERM_SOLID)) || \
	  (cave[Y][X].feat == FEAT_LESS) || \
	  (cave[Y][X].feat == FEAT_MORE) || \
	  (cave[Y][X].feat == FEAT_ENTRANCE) || \
	  (cave[Y][X].feat == FEAT_ENTRANCE_UPWARD) || \
	  (cave[Y][X].feat == FEAT_LESS_LESS) || \
	  (cave[Y][X].feat == FEAT_MORE_MORE) || \
	  (cave[Y][X].feat == FEAT_BETWEEN) || \
	  (cave[Y][X].feat == FEAT_MOUNTAIN) || \
	  (cave[Y][X].feat == FEAT_AIR) || \
	 ((cave[Y][X].feat >= FEAT_QUEST_ENTER) && \
	  (cave[Y][X].feat <= FEAT_QUEST_UP)) || \
	 ((cave[Y][X].feat >= FEAT_SHOP_HEAD) && \
	  (cave[Y][X].feat <= FEAT_SHOP_TAIL)) || \
	  (cave[Y][X].feat == FEAT_MUSEUM) || \
	 ((cave[Y][X].feat >= FEAT_BLDG_HEAD) && \
	  (cave[Y][X].feat <= FEAT_BLDG_TAIL)))


/*
 * Grid based version of "cave_floor_bold()"
 */
#define cave_floor_grid(C) \
    (!((C)->feat & 0x20))


/*
 * Grid based version of "cave_empty_bold()"
 */
#define cave_empty_grid(C) \
    (cave_floor_grid(C) && \
     !((C)->m_idx) && \
     !((C) == &cave[py][px]))

/*
 * Grid based version of "cave_empty_bold()"
 */
#define cave_empty_grid2(C) \
    ((cave_floor_grid(C) || ((C)->feat == FEAT_TREES)) && \
     !((C)->m_idx) && \
     !((C) == &cave[py][px]))


/*
 * Grid based version of "cave_perma_bold()"
 */
#define cave_perma_grid(C) \
	((((C)->feat >= FEAT_PERM_EXTRA) && \
	  ((C)->feat <= FEAT_PERM_SOLID)) || \
	  ((C)->feat == FEAT_LESS) || \
	  ((C)->feat == FEAT_MORE) || \
	  ((C)->feat == FEAT_ENTRANCE) || \
	  ((C)->feat == FEAT_ENTRANCE_UPWARD) || \
	  ((C)->feat == FEAT_LESS_LESS) || \
	  ((C)->feat == FEAT_MORE_MORE) || \
	  ((C)->feat == FEAT_BETWEEN) || \
	  ((C)->feat == FEAT_MOUNTAIN) || \
	  ((C)->feat == FEAT_AIR) || \
	 (((C)->feat >= FEAT_QUEST_ENTER) && \
	  ((C)->feat <= FEAT_QUEST_UP)) || \
	 (((C)->feat >= FEAT_SHOP_HEAD) && \
	  ((C)->feat <= FEAT_SHOP_TAIL)) || \
	  ((C)->feat == FEAT_MUSEUM) || \
	 (((C)->feat >= FEAT_BLDG_HEAD) && \
	  ((C)->feat <= FEAT_BLDG_TAIL)))


/*
 * Does the grid stop disintegration?
 */
#define cave_stop_disintegration(Y,X) \
	(((cave[Y][X].feat >= FEAT_PERM_EXTRA) && \
	  (cave[Y][X].feat <= FEAT_PERM_SOLID)) || \
	  (cave[Y][X].feat == FEAT_MOUNTAIN) || \
	 ((cave[Y][X].feat >= FEAT_SHOP_HEAD) && \
	  (cave[Y][X].feat <= FEAT_SHOP_TAIL)) || \
	 ((cave[Y][X].feat >= FEAT_BLDG_HEAD) && \
	  (cave[Y][X].feat <= FEAT_BLDG_TAIL)) || \
	  (cave[Y][X].feat == FEAT_MUSEUM))


/*
 * Determine if a "legal" grid is within "los" of the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_has_los_grid(C) \
    (((C)->info & (CAVE_VIEW)) != 0)

/*
 * Determine if a "legal" grid is within "los" of the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_has_los_bold(Y,X) \
    ((cave[Y][X].info & (CAVE_VIEW)) != 0)

/*
 * Determine if a "boundary" grid is "floor mimic"
 */
#define boundary_floor_bold(Y,X) \
    ((cave[(Y)][(X)].feat == FEAT_PERM_SOLID) && \
      cave[(Y)][(X)].mimic && \
    !(cave[(Y)][(X)].mimic & 0x20))

#define boundary_floor_grid(C) \
    (((C)->feat == FEAT_PERM_SOLID) && \
      (C)->mimic && \
    !((C)->mimic & 0x20))

/*
 * Determine if a "legal" grid is "teleportable"
 */
#define teleportable_grid(C) \
	((((C)->feat == FEAT_FLOOR) || \
	  ((C)->feat == FEAT_GLYPH) || \
	  ((C)->feat == FEAT_OPEN) || \
	  ((C)->feat == FEAT_BROKEN) || \
	  ((C)->feat == FEAT_LESS) || \
	  ((C)->feat == FEAT_MORE) || \
	  ((C)->feat == FEAT_LESS_LESS) || \
	  ((C)->feat == FEAT_MORE_MORE) || \
	  ((C)->feat == FEAT_MINOR_GLYPH) || \
	  ((C)->feat == FEAT_DEEP_WATER) || \
	  ((C)->feat == FEAT_SHAL_WATER) || \
	  ((C)->feat == FEAT_SHAL_LAVA) || \
	 (((C)->feat == FEAT_DARK_PIT) && p_ptr->ffall) || \
	  ((C)->feat == FEAT_DIRT) || \
	  ((C)->feat == FEAT_GRASS) || \
	  ((C)->feat == FEAT_FLOWER) || \
	  ((C)->feat == FEAT_DEEP_GRASS) || \
	  ((C)->feat == FEAT_TREES) || \
	 (((C)->feat == FEAT_MOUNTAIN) && !dun_level && p_ptr->ffall) || \
	  ((C)->feat == FEAT_TOWN) || \
	  ((C)->feat == FEAT_ENTRANCE) || \
	  ((C)->feat == FEAT_SWAMP) || \
	  ((C)->feat == FEAT_ENTRANCE_UPWARD) || \
	  ((C)->feat == FEAT_TUNDRA) || \
	 (((C)->feat == FEAT_AIR) && p_ptr->ffall) || \
	  ((C)->feat == FEAT_DEEP_SEA) || \
	  ((C)->feat == FEAT_BETWEEN)) && \
	  !(C)->m_idx)


#define update_playtime() \
{\
	u32b tmp;\
	tmp = time(NULL);\
	playtime += (tmp - start_time);\
	start_time = tmp;\
}

/*
 * Hack -- Prepare to use the "Secure" routines
 */
#if defined(SET_UID) && defined(SECURE)
extern int PlayerUID;
# define getuid() PlayerUID
# define geteuid() PlayerUID
#endif



/*** Color constants ***/


/*
 * Angband "attributes" (with symbols, and base (R,G,B) codes)
 *
 * The "(R,G,B)" codes are given in "fourths" of the "maximal" value,
 * and should "gamma corrected" on most (non-Macintosh) machines.
 */
#define TERM_DARK                0  /* 'd' */   /* 0,0,0 */
#define TERM_WHITE               1  /* 'w' */   /* 4,4,4 */
#define TERM_SLATE               2  /* 's' */   /* 2,2,2 */
#define TERM_ORANGE              3  /* 'o' */   /* 4,2,0 */
#define TERM_RED                 4  /* 'r' */   /* 3,0,0 */
#define TERM_GREEN               5  /* 'g' */   /* 0,2,1 */
#define TERM_BLUE                6  /* 'b' */   /* 0,0,4 */
#define TERM_UMBER               7  /* 'u' */   /* 2,1,0 */
#define TERM_L_DARK              8  /* 'D' */   /* 1,1,1 */
#define TERM_L_WHITE             9  /* 'W' */   /* 3,3,3 */
#define TERM_VIOLET             10  /* 'v' */   /* 4,0,4 */
#define TERM_YELLOW             11  /* 'y' */   /* 4,4,0 */
#define TERM_L_RED              12  /* 'R' */   /* 4,0,0 */
#define TERM_L_GREEN            13  /* 'G' */   /* 0,4,0 */
#define TERM_L_BLUE             14  /* 'B' */   /* 0,4,4 */
#define TERM_L_UMBER            15  /* 'U' */   /* 3,2,1 */


/*** Sound constants ***/


/*
 * Mega-Hack -- some primitive sound support (see "main-win.c")
 *
 * Some "sound" constants for "Term_xtra(TERM_XTRA_SOUND, val)"
 */
#define SOUND_HIT        1
#define SOUND_MISS       2
#define SOUND_FLEE       3
#define SOUND_DROP       4
#define SOUND_KILL       5
#define SOUND_M_KILL     6
#define SOUND_F_KILL     7
#define SOUND_N_KILL     8 /* The player kills a non-living/undead monster */
#define SOUND_LEVEL      9
#define SOUND_DEATH     10
#define SOUND_TELEPORT  11
#define SOUND_SHOOT     12
#define SOUND_SHOOT_GUN 13
#define SOUND_QUAFF     14
#define SOUND_ZAP       15
#define SOUND_WALK      16
#define SOUND_TPOTHER   17
#define SOUND_HITWALL   18
#define SOUND_EAT       19
#define SOUND_STORE1    20
#define SOUND_STORE2    21
#define SOUND_STORE3    22
#define SOUND_STORE4    23
#define SOUND_DIG       24
#define SOUND_OPENDOOR  25
#define SOUND_SHUTDOOR  26
#define SOUND_TPLEVEL   27
#define SOUND_SCROLL    28
#define SOUND_BUY       29
#define SOUND_SELL      30
#define SOUND_WARN      31
#define SOUND_ROCKET    32 /* Somebody's shooting rockets */
#define SOUND_QUEST     33 /* The player has just completed a quest */
#define SOUND_HEAL      34 /* The player was healed a little bit */
#define SOUND_X_HEAL    35 /* The player was healed full health */
#define SOUND_BITE      36 /* A monster bites you */
#define SOUND_CLAW      37 /* A monster claws you */
#define SOUND_M_SPELL   38 /* A monster casts a miscellaneous spell */
#define SOUND_SUMMON    39 /* A monster casts a summoning spell  */
#define SOUND_BREATH    40 /* A monster breathes */
#define SOUND_BALL      41 /* A monster casts a ball / bolt spell */
#define SOUND_M_HEAL    42 /* A monster heals itself somehow */
#define SOUND_ATK_SPELL 43 /* A monster casts a misc. offensive spell */
#define SOUND_EVIL      44 /* Something nasty has just happened! */
#define SOUND_TOUCH     45 /* A monster touches you */
#define SOUND_STING     46 /* A monster stings you */
#define SOUND_CRUSH     47 /* A monster crushes / envelopes you */
#define SOUND_SLIME     48 /* A monster drools/spits/etc on you */
#define SOUND_WAIL      49 /* A monster wails */
#define SOUND_WINNER    50 /* Just won the game! */
#define SOUND_FIRE      51 /* An item was burned  */
#define SOUND_ACID      52 /* An item was destroyed by acid */
#define SOUND_ELEC      53 /* An item was destroyed by electricity */
#define SOUND_COLD      54 /* An item was shattered */
#define SOUND_ILLEGAL   55 /* Illegal command attempted */
#define SOUND_FAIL      56 /* Fail to get a spell off / activate an item */
#define SOUND_WAKEUP    57 /* A monster wakes up */
#define SOUND_INVULN    58 /* Invulnerability! */
#define SOUND_FALL      59 /* Falling through a trapdoor... */
#define SOUND_PAIN      60 /* A monster is in pain! */
#define SOUND_DESTITEM  61 /* An item was destroyed by misc. means */
#define SOUND_MOAN      62 /* A monster makes a moan/beg/insult attack */
#define SOUND_SING      63 /* A monster makes a "sing" attack */
#define SOUND_EXPLODE   64 /* Something (or somebody) explodes */
#define SOUND_ENCOUNT   65

/*
 * Mega-Hack -- maximum known sounds
 */
#define SOUND_MAX 66


/*** Hack ***/


/*
 * Hack -- attempt to reduce various values
 */
#ifdef ANGBAND_LITE
# undef MACRO_MAX
# define MACRO_MAX      128
# undef QUARK_MAX
# define QUARK_MAX      128
# undef MESSAGE_MAX
# define MESSAGE_MAX    128
# undef MESSAGE_BUF
# define MESSAGE_BUF    4096
#endif


/*
 * Buildings actions
 */
#define BACT_NOTHING                 0
#define BACT_RESEARCH_ITEM           1
#define BACT_TOWN_HISTORY            2
#define BACT_RACE_LEGENDS            3
#define BACT_GREET_KING              4
#define BACT_KING_LEGENDS            5
#define BACT_QUEST                   6
#define BACT_POSTER                  8
#define BACT_ARENA_RULES             9
#define BACT_ARENA                  10
#define BACT_ARENA_LEGENDS          11
#define BACT_IN_BETWEEN             12
#define BACT_GAMBLE_RULES           13
#define BACT_CRAPS                  14
#define BACT_SPIN_WHEEL             15
#define BACT_DICE_SLOTS             16
#define BACT_REST                   17
#define BACT_FOOD                   18
#define BACT_RUMORS                 19
#define BACT_RESEARCH_MONSTER       20
#define BACT_COMPARE_WEAPONS        21
#define BACT_LEGENDS                22
#define BACT_ENCHANT_WEAPON         23
#define BACT_ENCHANT_ARMOR          24
#define BACT_RECHARGE               25
#define BACT_IDENTS                 26
#define BACT_LEARN                  27
#define BACT_HEALING                28
#define BACT_RESTORE                29
#define BACT_ENCHANT_ARROWS         30
#define BACT_ENCHANT_BOW            31
#define BACT_GREET                  32
#define BACT_RECALL                 33
#define BACT_TELEPORT_LEVEL         34
#define BACT_LOSE_MUTATION          35
#define BACT_TSUCHINOKO             37
#define BACT_TARGET                 38
#define BACT_KUBI                   39
#define BACT_KANKIN                 40
#define BACT_EQUALIZATION           41
#define BACT_TELE_TOWN              42
#define BACT_POKER                  43
#define BACT_IDENT_ONE              44
#define BACT_RECHARGE_ALL           45
#define BACT_INC_STR                46
#define BACT_INC_INT                47
#define BACT_INC_WIS                48
#define BACT_INC_DEX                49
#define BACT_INC_CON                50
#define BACT_INC_CHR                51
#define BACT_DONATION               52
#define BACT_DONATION_LODIS         53
#define BACT_EVAL_AC                54
#define BACT_DONATION_ZENOBIAN      55
#define MAX_BACT                    56

/*
 * Quest status
 */
#define QUEST_STATUS_UNTAKEN         0
#define QUEST_STATUS_TAKEN           1
#define QUEST_STATUS_COMPLETED       2
#define QUEST_STATUS_REWARDED        3
#define QUEST_STATUS_FINISHED        4
#define QUEST_STATUS_FAILED          5
#define QUEST_STATUS_FAILED_DONE     6

/*
 * Quest type
 */
#define QUEST_TYPE_KILL_LEVEL                1
#define QUEST_TYPE_KILL_ANY_LEVEL            2
#define QUEST_TYPE_FIND_ARTIFACT             3
#define QUEST_TYPE_FIND_EXIT                 4
#define QUEST_TYPE_KILL_NUMBER               5
#define QUEST_TYPE_KILL_ALL                  6
#define QUEST_TYPE_RANDOM                    7

/*
 * Initialization flags
 */
#define INIT_SHOW_TEXT          0x01
#define INIT_ASSIGN             0x02
#define INIT_CREATE_DUNGEON     0x04
#define INIT_ONLY_FEATURES      0x08
#define INIT_ONLY_BUILDINGS     0x10
#define INIT_QUESTOR_UNIQUES    0x20

/*
 * Quest flags
 */
#define QUEST_FLAG_SILENT    0x01 /* no messages from completion */
#define QUEST_FLAG_PRESET    0x02 /* quest is outside the main dungeon */
#define QUEST_FLAG_ONCE      0x04 /* quest is marked finished after leaving */
#define QUEST_FLAG_NO_RECALL 0x08 /* no "recall" spells are allowed */
#define QUEST_FLAG_GUARDIAN  0x10 /* quest is "guardian" type (without rewarding) */

/*
 * Available graphic modes
 */
#define GRAPHICS_NONE       0


#ifdef JP
#define JVERB_AND 1
#define JVERB_TO  2
#define JVERB_OR  3
#endif

/*
 * Modes for the tokenizer
 */
#define TOKENIZE_CHECKQUOTE 0x01  /* Special handling of single quotes */

/*
 * Parse errors
 */
#define PARSE_ERROR_GENERIC                  1
#define PARSE_ERROR_ABSOLETE_FILE            2
#define PARSE_ERROR_MISSING_RECORD_HEADER    3
#define PARSE_ERROR_NON_SEQUENTIAL_RECORDS   4
#define PARSE_ERROR_INVALID_FLAG             5
#define PARSE_ERROR_UNDEFINED_DIRECTIVE      6
#define PARSE_ERROR_OUT_OF_MEMORY            7
#define PARSE_ERROR_OUT_OF_BOUNDS            8
#define PARSE_ERROR_TOO_FEW_ARGUMENTS        9
#define PARSE_ERROR_MAX                     10

#define SKILL_LEVEL_BEGINNER 0
#define SKILL_LEVEL_NOVICE   1
#define SKILL_LEVEL_AVERAGE  2
#define SKILL_LEVEL_SKILLED  3
#define SKILL_LEVEL_EXPERT   4
#define SKILL_LEVEL_MASTER   5

#define MAX_SKILL_LEVEL      6

/* Proficiency of weapons and misc. skills (except riding) */
#define SKILL_EXP_BEGINNER	 0
#define SKILL_EXP_NOVICE	 3
#define SKILL_EXP_AVERAGE	10
#define SKILL_EXP_SKILLED	25
#define SKILL_EXP_EXPERT	35
#define SKILL_EXP_MASTER	50

#define SKILL_MARTIAL_ARTS 0
#define SKILL_NITOURYU     1
#define SKILL_RIDING       2
#define SKILL_THROWING     3
#define SKILL_PET_UPKEEP   4
#define SKILL_SENSE_ARMS   5
#define SKILL_SENSE_ACC    6
#define SKILL_SPELL_CAST   7

#define MAX_SKILL          8

#define SKILL_MAGIC_MAGERY     1
#define SKILL_MAGIC_FIRE       2
#define SKILL_MAGIC_AQUA       3
#define SKILL_MAGIC_EARTH      4
#define SKILL_MAGIC_WIND       5
#define SKILL_MAGIC_HOLY       6
#define SKILL_MAGIC_DEATH      7
#define SKILL_MAGIC_SYMBIOTIC  8
#define SKILL_MAGIC_WITCH      9
#define SKILL_MAGIC_DRAKONITE 10
#define SKILL_MAGIC_CRUSADE   11

#define MAX_SKILL_MAGIC       11

#define TOWN_ARMORICA    1
#define TOWN_HEIM        2
#define TOWN_CORTANI     3
#define TOWN_RIME_CITY   4
#define TOWN_BARMAMUTHA  5
#define TOWN_LOST_ISLAND 6
#define TOWN_PORT_TOWN   7

#define NO_TOWN (TOWN_LOST_ISLAND)

#define NIKKI_HIGAWARI     0
#define NIKKI_BUNSHOU      1
#define NIKKI_ART          2
#define NIKKI_UNIQUE       3
#define NIKKI_FIX_QUEST_C  4
#define NIKKI_FIX_QUEST_F  5
#define NIKKI_RAND_QUEST_C 6
#define NIKKI_RAND_QUEST_F 7
#define NIKKI_MAXDEAPTH    8
#define NIKKI_TRUMP        9
#define NIKKI_STAIR       10
#define NIKKI_RECALL      11
#define NIKKI_TO_QUEST    12
#define NIKKI_TELE_LEV    13
#define NIKKI_BUY         14
#define NIKKI_SELL        15
#define NIKKI_ARENA       16
#define NIKKI_HANMEI      17
#define NIKKI_LEVELUP     18
#define NIKKI_GAMESTART   19
#define NIKKI_WIZ_TELE    20
#define NIKKI_NAMED_PET   21

#define MAX_KUBI 20

#define DETECT_RAD_DEFAULT 30
#define DETECT_RAD_MAP     30
#define DETECT_RAD_ALL     255

#define MON_MAN_LOOK_SEA  8
#define MON_BEGGAR        12
#define MON_LEPER         13
#define MON_CLARE         19
#define MON_GUARD         39
#define MON_SOLDIER       43
#define MON_GRIP          53
#define MON_WOLF          54
#define MON_FANG          55
#define MON_LOUSE         69
#define MON_PIRANHA       70
#define MON_AMAZONESS     83
#define MON_COPPER_COINS  85
#define MON_BAPALU        97
#define MON_SIMON         115
#define MON_ARCHER        116
#define MON_SILVER_COINS  117
#define MON_MANES         128
#define MON_SARA          138
#define MON_PHANTOM_W     152
#define MON_WOUNDED_BEAR  159
#define MON_GOLD_COINS    195
#define MON_KNIGHT        201
#define MON_PRIEST        225
#define MON_MITHRIL_COINS 239
#define MON_BEASTTAMER    287
#define MON_LIZARDMAN     290
#define MON_BERSERKER     293
#define MON_FAIRY         320
#define MON_HAWKMAN       322
#define MON_DRAGOON       372
#define MON_VELDO         380
#define MON_MENELDOR      384
#define MON_PHANTOM_B     385
#define MON_GWAIHIR       410
#define MON_SWORDMASTER   414
#define MON_ADAMANT_COINS 423
#define MON_POISON_DENIM  434
#define MON_TERROR_KNIGHT 442
#define MON_PUMPKIN_HEAD  445
#define MON_WARLOCK       449
#define MON_MITHRIL_GOLEM 464
#define MON_PIXY          467
#define MON_THORONDOR     468
#define MON_GORGON        475
#define MON_NINJA         485
#define MON_TEMPLE_KNIGHT 492
#define MON_BEASTMASTER   497
#define MON_GUNNER        498
#define MON_WATER_ELEM    512
#define MON_VALKYRIE      532
#define MON_ZILDOR        536
#define MON_BAIAN         553
#define MON_SIRENE        571
#define MON_GENAUNES      572
#define MON_RONWE         573
#define MON_T_COMMAND     597
#define MON_GUACHARO      606
#define MON_DEBARDES      615
#define MON_DRAGONTAMER   636
#define MON_DARK_PRIEST   637
#define MON_SORCERER      638
#define MON_VENEFIK       647
#define MON_URAM          651
#define MON_OZ            660
#define MON_MERCURY       669
#define MON_PROKION       670
#define MON_CENTAUR       677
#define MON_BESTEAR       679
#define MON_FALFADET      683
#define MON_ERIG          687
#define MON_HIGH_PRIEST   689
#define MON_NAZGUL        696
#define MON_WHITE_KNIGHT  699
#define MON_FAFNER        712
#define MON_RENDAL        734
#define MON_NECROMANCER   737
#define MON_LAUAU         738
#define MON_GRANDE        760
#define MON_OXYONES       761
#define MON_SISTEENA      762
#define MON_ZAEBOS        763
#define MON_BARBATOS      767
#define MON_SELYE         771
#define MON_WARREN        772
#define MON_OZMA          773
#define MON_BALANCE_WYRM  785
#define MON_LEONARD       789
#define MON_SHELLEY       791
#define MON_VOLAC         794
#define MON_HABORYM       797
#define MON_MARTYM        799
#define MON_FIRE_BRASS    805
#define MON_BARBAS        807
#define MON_BRANTA        813
#define MON_CYBER         816
#define MON_BELZBUTE      817
#define MON_OLIVIA        818
#define MON_RADLUM        819
#define MON_BALZEPHO      820
#define MON_ZADOVA        823
#define MON_ANDORAS       824
#define MON_ANGMAR        825
#define MON_YENDOR        832
#define MON_FELION        833
#define MON_DENEB         841
#define MON_FOGEL         842
#define MON_BLACMORE      844
#define MON_ENBU          848
#define MON_SEIGETSU      851
#define MON_KINBU         852
#define MON_JORMUNGAND    854
#define MON_VICE          855
#define MON_REKKUU        856
#define MON_NYBBAS        858
#define MON_BERSALIA      859
#define MON_LANCELOT      860
#define MON_DENIM         861
#define MON_DOLGARUA      862
#define MON_COCKATRICE    870
#define MON_ZEBRA         871
#define MON_MOLDOUX       879
#define MON_CANOPUS       883
#define MON_DJINNI        892
#define MON_LADY_CENTAUR  896
#define MON_ANGEL_KNIGHT  898
#define MON_GABIAR        900
#define MON_MAD_HALLOWEEN 902
#define MON_GAMP          914
#define MON_OBDA          915
#define MON_BELDA         916
#define MON_ZANGA         917
#define MON_BANGA         918
#define MON_OBDA_JR       919
#define MON_BELDA_JR      920
#define MON_FELLANA       922
#define MON_HOLP          923
#define MON_ISHTALLE      924
#define MON_FILARHH       925
#define MON_DIVINE_DRAGON 926
#define MON_FOOD_DRAGON   955
#define MON_FOOD_CHIMERA  956
#define MON_FOOD_OCTOPUS  957
#define MON_FOOD_SQUID    958
#define MON_FOOD_BIRD     959
#define MON_FOOD_COOK     960
#define MON_FOOD_MAEMAID  961

#define MON_EGG_BASE        933
#define MON_ROTTEN_EGG_BASE (MON_EGG_BASE + 5 * (SV_FOOD_ROTTEN_EGG - SV_FOOD_EGG))

#define MAX_MAX_MAXHP 20000000L

#define MAX_AUTOPICK 1009
#define DO_AUTOPICK       0x01
#define DO_AUTODESTROY    0x02
#define DO_DISPLAY        0x04
#define DONT_AUTOPICK     0x08
#define ITEM_DISPLAY      0x10
#define DO_QUERY_AUTOPICK 0x20

#define MAGIC_GLOVE_REDUCE_MANA 0x0001
#define MAGIC_FAIL_5PERCENT     0x0002

#define SPELL_DD_WIND    8
#define SPELL_DD_WITCH  24

/*
 * Music songs
 */
#define MUSIC_NONE              0
#define MUSIC_SAD               1
#define MUSIC_SILENT            2
#define MUSIC_TEMPTATION        3

#define PY_ATTACK_NONE     0
#define PY_ATTACK_CHARGE   1
#define PY_ATTACK_NYUSIN   2
#define PY_ATTACK_MINEUCHI 3
#define PY_ATTACK_3DAN     4
#define PY_ATTACK_PENET    5

#define PY_THROW_CHOSEN        0x0001
#define PY_THROW_BOOMERANG     0x0002
#define PY_THROW_SHOOTING_STAR 0x0004


#define ROCKET_MATERIAL_ORIGINAL   0
#define ROCKET_MATERIAL_NORMAL     1
#define ROCKET_MATERIAL_BALDAR     2
#define ROCKET_MATERIAL_MITHRIL    3
#define ROCKET_MATERIAL_ADAMANTITE 4

#define ROCKET_ANTIGRAV            5

#define DUNGEON_MODE_NONE       0
#define DUNGEON_MODE_AND        1
#define DUNGEON_MODE_NAND       2
#define DUNGEON_MODE_OR         3
#define DUNGEON_MODE_NOR        4

/*** Dungeon type flags -- DG ***/
#define DF1_WINNER              0x00000001L
#define DF1_XXX01               0x00000002L
#define DF1_SMALLEST            0x00000004L
#define DF1_BEGINNER            0x00000008L
#define DF1_BIG                 0x00000010L
#define DF1_NO_DOORS            0x00000020L
#define DF1_WATER_RIVER         0x00000040L
#define DF1_LAVA_RIVER          0x00000080L
#define DF1_SMALLER             0x00000100L
#define DF1_CLOSED              0x00000200L
#define DF1_CAVE                0x00000400L
#define DF1_CAVERN              0x00000800L
#define DF1_XXX12               0x00001000L
#define DF1_XXX13               0x00002000L
#define DF1_XXX14               0x00004000L
#define DF1_NO_BACK             0x00008000L
#define DF1_XXX16               0x00010000L
#define DF1_LAKE_WATER          0x00020000L
#define DF1_LAKE_LAVA           0x00040000L
#define DF1_LAKE_RUBBLE         0x00080000L
#define DF1_LAKE_TREE           0x00100000L
#define DF1_NO_VAULT            0x00200000L
#define DF1_ARENA               0x00400000L
#define DF1_DESTROY             0x00800000L
#define DF1_WILD_LITE           0x01000000L
#define DF1_NO_CAVE             0x02000000L
#define DF1_XXX26               0x04000000L
#define DF1_XXX27               0x08000000L
#define DF1_LITE                0x10000000L
#define DF1_XXX29               0x20000000L
#define DF1_UPWARD              0x40000000L
#define DF1_XXX31               0x80000000L

#define DF1_LAKE_MASK (DF1_LAKE_WATER | DF1_LAKE_LAVA | DF1_LAKE_RUBBLE | DF1_LAKE_TREE)

#define DUNGEON_PALACE      1
#define DUNGEON_ARMORICA    2
#define DUNGEON_HILLS       3
#define DUNGEON_DESERT      4
#define DUNGEON_ICEFIELD    5
#define DUNGEON_GRAVE       6
#define DUNGEON_SWANSEA     7
#define DUNGEON_MT_WEOBLEY  8
#define DUNGEON_HELL_WAY    9
#define DUNGEON_HEAVEN_WAY 10
#define DUNGEON_MARSHLAND  11
#define DUNGEON_BRIGANTES  12
#define DUNGEON_NYMLAHABA  13
#define DUNGEON_MT_HEDON   14
#define DUNGEON_MINE       15
#define DUNGEON_SEASIDE    16
#define DUNGEON_AIR_GARDEN 17
#define DUNGEON_HEAVEN     18


/*
 * Flags for change floor mode
 */
#define CFM_UP        	 0x0001  /* Move up */
#define CFM_DOWN      	 0x0002  /* Move down */
#define CFM_LONG_STAIRS  0x0004  /* Randomly occurred long stairs/shaft */
#define CFM_XXX  	 0x0008  /* XXX */
#define CFM_SHAFT     	 0x0010  /* Shaft */
#define CFM_RAND_PLACE   0x0020  /* Arrive at random grid */
#define CFM_RAND_CONNECT 0x0040  /* Connect with random stairs */
#define CFM_CLEAR_ALL    0x0080  /* Reach to the surface/Recall/Alter reality */
#define CFM_NO_RETURN    0x0100  /* Flee from random quest etc... */
#define CFM_FORCE1L      0x0200  /* Force move up/down 1 level only */
#define CFM_FORCE2L      0x0400  /* Force move up/down 2 level only */


/*
 * Flags for save/load temporal saved floor file
 */
#define SLF_SECOND     	 0x0001  /* Called from another save/load function */
#define SLF_NO_KILL      0x0002  /* Don't kill temporal files */


/*
 * Flags for wr_item()/rd_item()
 */
#define SAVE_ITEM_PVAL         0x00000001
#define SAVE_ITEM_DISCOUNT     0x00000002
#define SAVE_ITEM_NUMBER       0x00000004
#define SAVE_ITEM_NAME1        0x00000008
#define SAVE_ITEM_NAME2        0x00000010
#define SAVE_ITEM_TIMEOUT      0x00000020
#define SAVE_ITEM_TO_H         0x00000040
#define SAVE_ITEM_TO_D         0x00000080
#define SAVE_ITEM_TO_A         0x00000100
#define SAVE_ITEM_AC           0x00000200
#define SAVE_ITEM_DD           0x00000400
#define SAVE_ITEM_DS           0x00000800
#define SAVE_ITEM_IDENT        0x00001000
#define SAVE_ITEM_MARKED       0x00002000
#define SAVE_ITEM_ART_FLAGS0   0x00004000
#define SAVE_ITEM_ART_FLAGS1   0x00008000
#define SAVE_ITEM_ART_FLAGS2   0x00010000
#define SAVE_ITEM_ART_FLAGS3   0x00020000
#define SAVE_ITEM_CURSE_FLAGS  0x00040000
#define SAVE_ITEM_HELD_M_IDX   0x00080000
#define SAVE_ITEM_XTRA1        0x00100000
#define SAVE_ITEM_XTRA2        0x00200000
#define SAVE_ITEM_XTRA3        0x00400000
#define SAVE_ITEM_XTRA4        0x00800000
#define SAVE_ITEM_XTRA5        0x01000000
#define SAVE_ITEM_FEELING      0x02000000
#define SAVE_ITEM_INSCRIPTION  0x04000000
#define SAVE_ITEM_ART_NAME     0x08000000


/*
 * Flags for wr_monster()/rd_monster()
 */
#define SAVE_MON_AP_R_IDX      0x00000001
#define SAVE_MON_SUB_ALIGN     0x00000002
#define SAVE_MON_CSLEEP        0x00000004
#define SAVE_MON_FAST          0x00000008
#define SAVE_MON_SLOW          0x00000010
#define SAVE_MON_STUNNED       0x00000020
#define SAVE_MON_CONFUSED      0x00000040
#define SAVE_MON_MONFEAR       0x00000080
#define SAVE_MON_STONING       0x00000100
#define SAVE_MON_MELT_WEAPON   0x00000200
#define SAVE_MON_OPPOSITE_ELEM 0x00000400
#define SAVE_MON_SILENT        0x00000800
#define SAVE_MON_SILENT_SONG   0x00001000
#define SAVE_MON_TARGET_Y      0x00002000
#define SAVE_MON_TARGET_X      0x00004000
#define SAVE_MON_INVULNER      0x00008000
#define SAVE_MON_SMART1        0x00010000
#define SAVE_MON_EXP           0x00020000
#define SAVE_MON_MFLAG2        0x00040000
#define SAVE_MON_NICKNAME      0x00080000
#define SAVE_MON_SMART2        0x00100000


#define prace_is_(A) (p_ptr->prace == (A))

/* Sub-alignment flags for neutral monsters */
#define SUB_ALIGN_NEUTRAL  0x00
#define SUB_ALIGN_EVIL     0x01
#define SUB_ALIGN_GOOD     0x02
#define SUB_ALIGN_LAWFUL   0x04
#define SUB_ALIGN_CHAOTIC  0x08
#define SUB_ALIGN_TEMPLE   0x10
#define SUB_ALIGN_WHITE    0x20

#define SUB_ALIGN_GNE_MASK (SUB_ALIGN_EVIL | SUB_ALIGN_GOOD)
#define SUB_ALIGN_LNC_MASK (SUB_ALIGN_LAWFUL | SUB_ALIGN_CHAOTIC)
#define SUB_ALIGN_CLASS_MASK (SUB_ALIGN_TEMPLE | SUB_ALIGN_WHITE)

#define MAX_MACRO_MOD 12
#define MAX_MACRO_TRIG 200

#define SCREEN_BUF_SIZE 65536           /* max screen dump buffer size */

/*
 * Elements of player & monsters & grids
 */
#define ELEM_DONT_AFFECT -2
#define NO_ELEM          -1

#define ELEM_FIRE         0
#define ELEM_AQUA         1
#define ELEM_EARTH        2
#define ELEM_WIND         3

#define MIN_ELEM          0
#define ELEM_NUM          4

/*
* Alignment (GNE)
 */
#define ALIGN_GNE_GOOD     1
#define ALIGN_GNE_NEUTRAL  0
#define ALIGN_GNE_EVIL    -1

/*
* Alignment (LNC)
 */
#define ALIGN_LNC_LAWFUL   1
#define ALIGN_LNC_NEUTRAL  0
#define ALIGN_LNC_CHAOTIC -1

/*
 * Weather
 */
#define MIN_WEATHER_TYPE   0
#define WEATHER_RAIN       0
#define WEATHER_WIND       1
#define WEATHER_TEMP       2
#define WEATHER_TYPE_NUM   3

#define MIN_WEATHER_LEVEL  0
#define WEATHER_LEVEL_NUM  4

#define MIN_WEATHER_VAL    0
#define MAX_WEATHER_VAL   15

#define weather_level(val) ((val) / 4)

#define MODIFY_ELEM_MODE_NONE  0
#define MODIFY_ELEM_MODE_MELEE 1
#define MODIFY_ELEM_MODE_FIRE  2
#define MODIFY_ELEM_MODE_THROW 3
#define MODIFY_ELEM_MODE_MAGIC 4

/*
 * For "Runeweapon" using "Snap Dragon"
 */
#define MAX_RUNEWEAPON 3

/* Runeweapon status bit flags */
#define RW_STATUS_NONE    0x00
#define RW_STATUS_FOUND   0x02
#define RW_STATUS_ILLEGAL 0x80

#define runeweapon_r_idx_from(specific) (max_r_idx + (specific) - 1)
#define runeweapon_num_from(r_idx) ((r_idx) - max_r_idx + 1)

/*
 * Chaos frame & ethnicity
 */
#define NO_ETHNICITY         -1

#define ETHNICITY_WALSTANIAN  0
#define ETHNICITY_GARGASTAN   1
#define ETHNICITY_BACRUM      2
#define ETHNICITY_ZENOBIAN    3
#define ETHNICITY_LODIS       4

#define ETHNICITY_NUM         5

#define CFRAME_UPPER_LIMIT   300
#define CFRAME_GOOD_FEELING  150
#define CFRAME_BAD_FEELING  -150
#define CFRAME_CLOSE_BLDG   -200
#define CFRAME_SUMMON_GUARD -250
#define CFRAME_LOWER_LIMIT  -300

/*
 * Special blows
 */
#define MAX_SB        10
#define MAX_TEMPLE_SB  8

/*
 * Another weapon type flag set (Different from tval/sval)
 */
#define WT_NONE         0
#define WT_SMALL_SWORD  1
#define WT_KATANA       2
#define WT_SWORD        3
#define WT_GREAT_SWORD  4
#define WT_AXE          5
#define WT_SPEAR        6
#define WT_LANCE        7
#define WT_CLAW         8
#define WT_SCYTHE       9
#define WT_WHIP        10
#define WT_HAMMER      11
#define WT_STAFF       12
#define WT_FAN         13
#define WT_BOW         14
#define WT_GUN         15

#define WT_BIT_SMALL_SWORD 0x00000001
#define WT_BIT_KATANA      0x00000002
#define WT_BIT_SWORD       0x00000004
#define WT_BIT_GREAT_SWORD 0x00000008
#define WT_BIT_AXE         0x00000010
#define WT_BIT_SPEAR       0x00000020
#define WT_BIT_LANCE       0x00000040
#define WT_BIT_CLAW        0x00000080
#define WT_BIT_SCYTHE      0x00000100
#define WT_BIT_WHIP        0x00000200
#define WT_BIT_HAMMER      0x00000400
#define WT_BIT_STAFF       0x00000800
#define WT_BIT_FAN         0x00001000
#define WT_BIT_BOW         0x00002000
#define WT_BIT_GUN         0x00004000

#define weapon_type_bit(wt) (0x00000001L << ((wt) - 1))

#define MAX_WT 16

/*
 * Divider for "skills"
 */
#define SKILL_DIV_XTHN 12
#define SKILL_DIV_XTHB 12
#define SKILL_DIV_XSAV  7
#define SKILL_DIV_XSTL  1
#define SKILL_DIV_XFOS  6
#define SKILL_DIV_XSRH  6
#define SKILL_DIV_XDIS  8
#define SKILL_DIV_XDEV  6

#define SKILL_LIKERT_HEROIC_MAX    17
#define SKILL_LIKERT_LEGENDARY_MAX (SKILL_LIKERT_HEROIC_MAX + 99)
#define SKILL_LIKERT_MYTHICAL_MAX  (SKILL_LIKERT_LEGENDARY_MAX + 99)

/*
 * Status of effect of tarot card "The Fool"
 */
#define FOOL_STATUS_NONE     0x00
#define FOOL_STATUS_PLAYER   0x01
#define FOOL_STATUS_MONSTERS 0x02

/*
 * Stock limit of the monster stock
 */
#define MAX_STOCK_MON 10

#define MAX_SCRATCH_CARD_INFO 20

/*
 * Wraith form checker
 */
#define WRAITH_FORM() (p_ptr->wraith_form || p_ptr->wraith_form_perm)

/*
 * Activate multi-shadow
 */
#define ACTIVATE_MULTISHADOW() (p_ptr->multishadow_active |= \
	(!p_ptr->is_dead && p_ptr->multishadow && one_in_(2)) ? 0x00000001 : 0x00000000)
#define STOP_MULTISHADOW() (p_ptr->multishadow_active <<= 1)
#define IS_MULTISHADOW(BACK) (p_ptr->multishadow && (p_ptr->multishadow_active & (0x00000001 << (BACK))))

/*
 * Bit flags for apply_magic() (etc)
 */
#define AMF_OKAY    0x00000001
#define AMF_GOOD    0x00000002
#define AMF_GREAT   0x00000004
#define AMF_SPECIAL 0x00000008
#define AMF_CURSED  0x00000010

#define EMPTY_HAND_RARM 0x02
#define EMPTY_HAND_LARM 0x01

/*
 * Bit flags of misc. events
 */
#define EVENT_CLOSE_BARMAMUTHA           0x00000001
#define EVENT_CANNOT_BE_TEMPLEKNIGHT     0x00000002
#define EVENT_CANNOT_BE_WHITEKNIGHT      0x00000004
#define EVENT_INC_SKILL_MELEE_REGISTERED 0x00000008
#define EVENT_INC_SKILL_BOW_REGISTERED   0x00000010

#define IN_HEAVEN_GATE() ((dungeon_type == DUNGEON_HEAVEN_WAY) && (dun_level == d_info[dungeon_type].maxdepth))

#define IS_MERMAID_IN_WATER() \
	(character_dungeon && (p_ptr->prace == RACE_MERMAID) && \
	 !p_ptr->ffall && !p_ptr->riding && \
	 ((cave[py][px].feat == FEAT_DEEP_WATER) || \
	  (cave[py][px].feat == FEAT_SHAL_WATER) || \
	  (cave[py][px].feat == FEAT_SWAMP) || \
	  (cave[py][px].feat == FEAT_DEEP_SEA)))
