﻿Imports System.IO
Imports System.Xml.XPath
Imports System.Xml
Imports System.Text
Imports Iplugins

Public Class Form1
    Inherits System.Windows.Forms.Form
    Implements Plugin.IPluginHost
    Dim dt As New DataTable
    Dim svdir As XElement
    Public DialogShow As Boolean
    Public Sub Application_ThreadException(ByVal sender As Object, _
            ByVal e As System.Threading.ThreadExceptionEventArgs)
        Try
            Dim f As New ErrorForm(e.Exception.ToString)
            f.Show()
        Finally
        End Try
    End Sub

    'IPluginの配列
    Dim plugins() As Plugin.IPlugin

    'IPluginHostの実装
    Public ReadOnly Property MainForm() As Form _
        Implements Plugin.IPluginHost.MainForm
        Get
            Return Me
        End Get
    End Property
    Public ReadOnly Property MyPath As String _
    Implements Plugin.IPluginHost.MyPath
        Get
            Return Application.StartupPath
        End Get
    End Property
    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        If (Debugger.IsAttached = False) Then 'デバッガーにアタッチしていない場合
            ''ThreadExceptionイベントハンドラを追加()
            AddHandler Application.ThreadException, _
                AddressOf Application_ThreadException
        End If
        If File.Exists(Application.StartupPath & "\\Settings.xml") = False Then '設定ファイルの存在確認
            Dim fm As New StartedSettings
            fm.ShowDialog(Me)
            fm.Dispose()
            Exit Sub
        End If
        If File.Exists((Application.StartupPath & "\\p.t0d0dat")) = True Then
            Dim passsr As New StreamReader((Application.StartupPath & "\\p.t0d0dat"))
            Dim readingdpass As String = passsr.ReadToEnd
            Dim src As Byte() = Convert.FromBase64String(readingdpass)
            Dim passData As String = Encoding.UTF8.GetString(src)
            Dim src2 As Byte() = Convert.FromBase64String(passData)
            Dim pass As String = Encoding.UTF8.GetString(src2)
            Dim passinput As String = InputBox("パスワードを入力して下さい。", "ToDoo0 366")
            If passinput = pass Then
                MessageBox.Show("認証しました。", "ToDoo0 366")
            Else
                MessageBox.Show("入力されたパスワードは間違っています。", "ToDoo0 366")
                End
            End If
        End If
        Dim sr As New StreamReader(Application.StartupPath & "\\Settings.xml") '設定ファイルを開く
        Dim docs As XDocument = XDocument.Parse(sr.ReadToEnd) 'Xdocumentに取り込む
        sr.Close()
        sr.Dispose()
        svdir = docs.XPathSelectElement("SetClass/SaveFolder") '保存先ディレクトリの読み込み
        DialogShow = docs.XPathSelectElement("SetClass/DialogShow") '確認ダイアログの表示可否
        '記録用フォルダを作る
        If Directory.Exists(svdir.Value & "\\Files\") = False Then
            Directory.CreateDirectory(svdir.Value & "\\Files\")
        End If
        CSVDataSet.CSVDataTable.Clear()

        Dim Dates As String = MonthCalendar1.SelectionRange.Start.Date
        Dates.Replace("/", "-")
        Dim nowstr As Date = Now
        Dim ThisMonth = nowstr.Month
        If File.Exists((svdir.Value & "\\Files\" & ThisMonth & ".txt")) = True Then
            Dim sr3 As New StreamReader((svdir.Value & "\\Files\" & ThisMonth & ".txt"))
            ThisMonthMemoRichTextBox.Text = sr3.ReadToEnd
            sr.Close()
            sr3.Dispose()
        End If
        If File.Exists(svdir.Value & "\\Files\" & Dates.Replace("/", "-") & ".csv") = False Then
            Pluginset()
            Exit Sub
        Else
            Dim delimStr As String = "," ' 区切り文字
            Dim delimiter() As Char = delimStr.ToCharArray ' 区切り文字をまとめる
            Dim strData() As String ' 分解後の文字の入れ物
            Dim strLine As String ' 1行分のデータ
            Dim sr2 As New StreamReader(svdir.Value & "\\Files\" & Dates.Replace("/", "-") & ".csv")
            While (sr2.Peek() >= 0)
                strLine = sr2.ReadLine()
                strData = strLine.Split(delimiter)
                CSVDataSet.CSVDataTable.AddCSVDataTableRow( _
                        strData(0), strData(1), strData(2), strData(3), strData(4))
            End While
            sr2.Close()
            sr2.Dispose()
            Pluginset()
            Exit Sub
        End If

    End Sub

    Private Sub Pluginset()
        'インストールされているプラグインを探す
        Dim pis As PluginInfo() = PluginInfo.FindPlugins()

        'プラグインのインスタンスを取得する
        Me.plugins = New Plugin.IPlugin(pis.Length - 1) {}
        Dim i As Integer
        For i = 0 To (Me.plugins.Length) - 1
            Me.plugins(i) = pis(i).CreateInstance(Me)
        Next i

        'プラグインを実行するメニューを追加する
        Dim plugin As Plugin.IPlugin
        For Each plugin In Me.plugins
            Dim mi As New ToolStripMenuItem(plugin.Name, My.Resources._Plugins, AddressOf menuPlugin_Click)
            プラグインPToolStripMenuItem.DropDownItems.Add(mi)
        Next plugin
    End Sub

    'プラグインのメニューがクリックされた時
    Private Sub menuPlugin_Click(ByVal sender As Object, _
        ByVal e As System.EventArgs)
        Dim mi As ToolStripMenuItem = CType(sender, ToolStripMenuItem)
        'クリックされたプラグインを探す
        '（同じ名前のプラグインが複数あると困ったことに...）
        Dim plugin As Plugin.IPlugin
        For Each plugin In Me.plugins
            If mi.Text = plugin.Name Then
                'クリックされたプラグインを実行する
                plugin.Run()
                Return
            End If
        Next plugin
    End Sub

    'プラグインのバージョンを表示する
    Private Sub menuAbout_Click(ByVal sender As Object, _
        ByVal e As System.EventArgs)
        Dim msg As String = "インストールされているプラグイン" & vbCrLf _
            & "（名前 : 説明 : バージョン）" & vbCrLf & vbCrLf
        Dim plugin As Plugin.IPlugin
        For Each plugin In Me.plugins
            msg += String.Format("{0} : {1} : {2}" + vbLf, _
                plugin.Name, plugin.Description, plugin.Version)
        Next plugin
        MessageBox.Show(msg)
    End Sub
    Private Sub ListBox1_SelectedIndexChanged(sender As System.Object, e As System.EventArgs)
    End Sub

    Private Sub MonthCalendar1_DateSelected(sender As System.Object, e As System.Windows.Forms.DateRangeEventArgs) Handles MonthCalendar1.DateSelected
        CSVDataSet.CSVDataTable.Clear()

        Dim Dates As String = MonthCalendar1.SelectionRange.Start.Date
        Dates.Replace("/", "-")
        If File.Exists(svdir.Value & "\\Files\" & Dates.Replace("/", "-") & ".csv") = False Then
            Exit Sub
        Else
            Dim delimStr As String = "," ' 区切り文字
            Dim delimiter() As Char = delimStr.ToCharArray ' 区切り文字をまとめる
            Dim strData() As String ' 分解後の文字の入れ物
            Dim strLine As String ' 1行分のデータ
            Dim sr As New StreamReader(svdir.Value & "\\Files\" & Dates.Replace("/", "-") & ".csv")
            While (sr.Peek() >= 0)
                strLine = sr.ReadLine()
                strData = strLine.Split(delimiter)
                CSVDataSet.CSVDataTable.AddCSVDataTableRow( _
                        strData(0), strData(1), strData(2), strData(3), strData(4))
            End While
            sr.Close()
            sr.Dispose()
        End If

    End Sub
    ''' <summary>
    ''' このSub(ToDoWrite)は、DataTableに書き込む作業をします。
    ''' </summary>
    ''' <param name="Title">タイトルを指定</param>
    ''' <param name="Text">内容を指定</param>
    ''' <param name="bikou">備考を指定</param>
    ''' <param name="Category">カテゴリを指定</param>
    ''' <remarks></remarks>
    Public Sub ToDoWrite(ByVal Title As String, ByVal Text As String, ByVal Bikou As String, ByVal Category As String)
        CSVDataSet.CSVDataTable.AddCSVDataTableRow( _
Title, Text.Replace(vbCrLf, vbNullString), Bikou, Category, "未完了")
        Save() '保存
    End Sub
    Public Sub PluginToDoWrite(ByVal plugin As Plugin.IPlugin, ByVal Title As String, ByVal Text As String, ByVal Bikou As String, ByVal Category As String, ByVal dates As String) Implements Plugin.IPluginHost.Add
        CSVDataSet.CSVDataTable.AddCSVDataTableRow( _
Title, Text.Replace(vbCrLf, vbNullString), Bikou, Category, "未完了")
        Dim strData As String ' 1行分のデータ
        Dim sw As New StreamWriter((svdir.Value & "\\Files\" & Dates.Replace("/", "-") & ".csv"), False)
        For Each Datas As CSVDataSet.CSVDataTableRow _
                         In CSVDataSet.CSVDataTable
            strData = Datas.タイトル _
                    & "," & Datas.内容 _
                    & "," & Datas.備考 _
                    & "," & Datas.カテゴリ _
                    & "," & Datas.進行状況
            sw.WriteLine(strData)
        Next
        sw.Close()
        sw.Dispose()

    End Sub
    Private Sub AddButton_Click(sender As System.Object, e As System.EventArgs) Handles AddButton.Click
        Dim fm As New WriteForm
        fm.ShowDialog(Me)
        fm.Dispose()
    End Sub

    Private Sub DelButton_Click(sender As System.Object, e As System.EventArgs) Handles DelButton.Click
        Try
            If DialogShow = True Then
                Dim msg As MsgBoxResult = MessageBox.Show("現在の行を削除します。本当によろしいですか？", "ToDoo0 366", MessageBoxButtons.YesNo)
                If msg = MsgBoxResult.Yes Then
                    DataGridView1.Rows.RemoveAt(DataGridView1.CurrentRow.Index)
                End If
            Else
                DataGridView1.Rows.RemoveAt(DataGridView1.CurrentRow.Index)
            End If
            Save() '保存
        Catch ex As NullReferenceException
            MessageBox.Show("この行は削除できません。")

        End Try
    End Sub
    Private Sub 終了EToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles 終了EToolStripMenuItem.Click
        End
    End Sub

    Private Sub 追加AToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles 追加AToolStripMenuItem.Click
        Dim fm As New WriteForm
        fm.ShowDialog(Me)
        fm.Dispose()
    End Sub

    Private Sub 削除DToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles 削除DToolStripMenuItem.Click
        If DialogShow = True Then
            Dim msg As MsgBoxResult = MessageBox.Show("現在の行を削除します。本当によろしいですか？", "ToDoo0 366", MessageBoxButtons.YesNo)
            If msg = MsgBoxResult.Yes Then
                DataGridView1.Rows.RemoveAt(DataGridView1.CurrentRow.Index)
            End If
        Else
            DataGridView1.Rows.RemoveAt(DataGridView1.CurrentRow.Index)
        End If

    End Sub
    ''' <summary>
    ''' 保存します
    ''' </summary>
    ''' <remarks></remarks>
    Sub Save()
        Dim Dates As String = MonthCalendar1.SelectionRange.Start.Date
        Dates.Replace("/", "-")
        Dim strData As String ' 1行分のデータ
        Dim sw As New StreamWriter((svdir.Value & "\\Files\" & Dates.Replace("/", "-") & ".csv"), False)
        For Each Datas As CSVDataSet.CSVDataTableRow _
                         In CSVDataSet.CSVDataTable
            strData = Datas.タイトル _
                    & "," & Datas.内容 _
                    & "," & Datas.備考 _
                    & "," & Datas.カテゴリ _
                    & "," & Datas.進行状況
            sw.WriteLine(strData)
        Next
        sw.Close()
        sw.Dispose()
    End Sub

    Private Sub データフォルダを開くOToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles データフォルダを開くOToolStripMenuItem.Click
        Process.Start((svdir.Value & "\\Files\"))
    End Sub

    Private Sub パスワード設定PToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles パスワード設定PToolStripMenuItem.Click
        Dim msg As MsgBoxResult = MessageBox.Show("パスワードを設定できます。" _
        & "ただし、解析できる可能性十分にあります。" & vbCrLf _
        & "本当に設定しますか?" & vbCrLf _
        & "(安全のために、確認ダイアログの表示をしないとされた方にも、" & vbCrLf _
        & "表示させていただいております。)", "ToDoo0 366", MessageBoxButtons.YesNo)
        If msg = MsgBoxResult.Yes Then
            Dim pass As String = InputBox("設定するパスワードを入力して下さい。", "ToDoo0 366")
            If pass = vbNullString Then
                MessageBox.Show("パスワードを空にする事はできません!")
                Exit Sub
            End If
            Dim passcheck As String = InputBox("確認用のために、再度入力してください。", "ToDoo0 366")
            If pass = passcheck Then
                MessageBox.Show("入力されたパスワードは同じものと判断されました。")
                msg = Nothing
                msg = MessageBox.Show("本当にこのパスワードに設定しますか?", "ToDoo0 366", MessageBoxButtons.YesNo)
                If msg = MsgBoxResult.Yes Then
                    Dim src1 As Byte() = Encoding.UTF8.GetBytes(pass)
                    Dim passdata1 As String = Convert.ToBase64String(src1)
                    Dim src2 As Byte() = Encoding.UTF8.GetBytes(passdata1)
                    Dim passdata As String = Convert.ToBase64String(src2)
                    Dim sw As New StreamWriter(Application.StartupPath & "\\p.t0d0dat")
                    sw.Write(passdata)
                    sw.Close()
                    sw.Dispose()
                    MessageBox.Show("パスワードの作成が完了しました。", "ToDoo0 366")
                    MessageBox.Show("「p.t0d0dat」は、削除・変更等は行わないで下さい。", "ToDoo0 366")
                    Exit Sub
                Else
                    Exit Sub
                End If
            Else
                MessageBox.Show("入力されたパスワードは等しいものではありませんでした。" & vbCrLf _
                & "再度ご確認の上、設定を実施下さい。", "ToDoo0 366")
                Exit Sub
            End If
        End If
    End Sub
    Private Sub バージョン情報AToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles バージョン情報AToolStripMenuItem.Click
        Dim fm As New AboutBox1
        fm.ShowDialog(Me)
        fm.Dispose()
    End Sub
    Private Sub DataGridView1_CellDoubleClick(sender As System.Object, e As System.Windows.Forms.DataGridViewCellEventArgs) Handles DataGridView1.CellDoubleClick
        Try
            ContentRichTextBox.Text = DataGridView1.CurrentRow.Cells(1).Value.ToString
            If DataGridView1.CurrentRow.Cells(4).Value = "完了!" Then
                DataGridView1.CurrentRow.Cells(4).Value = "未完了"
            Else
                DataGridView1.CurrentRow.Cells(4).Value = "完了!"
            End If
            Save()
        Catch ex As InvalidCastException 'できない場合のパス
            Exit Sub
        End Try

    End Sub

    Private Sub ContentRichTextBox_LinkClicked(sender As System.Object, e As System.Windows.Forms.LinkClickedEventArgs) Handles ContentRichTextBox.LinkClicked
        Process.Start(e.LinkText)
    End Sub

    Private Sub ThisMonthMemoRichTextBox_LinkClicked(sender As System.Object, e As System.Windows.Forms.LinkClickedEventArgs) Handles ThisMonthMemoRichTextBox.LinkClicked
        Process.Start(e.LinkText)
    End Sub

    Private Sub MonthMemoAddButton_Click(sender As System.Object, e As System.EventArgs) Handles MonthMemoAddButton.Click
        Dim fm As New ThisMonthMemoAdd
        fm.ShowDialog()
        fm.Dispose()
    End Sub
    ''' <summary>
    ''' 今月のメモを追加する部分です。
    ''' </summary>
    ''' <param name="Content">内容を入れる!</param>
    ''' <remarks></remarks>
    Public Sub Monthmemoadd2(ByVal Content As String)
        Dim nowstr As Date = Now
        Dim ThisMonth = nowstr.Month
        Dim sw As New StreamWriter(svdir.Value & "\\Files\" & ThisMonth & ".txt")
        sw.Write(Content)
        sw.Close()
        sw.Dispose()
        MessageBox.Show("メモの追加が完了しました!", "ToDoo0 366")
        Application.Restart()
    End Sub

    Public Sub ShowMessage(ByVal plugin As Plugin.IPlugin, _
        ByVal msg As String) _
        Implements Plugin.IPluginHost.ShowMessage
        '表示する
        MessageBox.Show(msg)
    End Sub

    Private Sub プラグインの追加AToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles プラグインの追加AToolStripMenuItem.Click
        Process.Start(Application.StartupPath & "\plugins")
    End Sub

    Private Sub 作者サイトSToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles 作者サイトSToolStripMenuItem.Click
        Process.Start("http://www.s-szr.com")
    End Sub
End Class

''' <summary>
''' プラグインに関する情報
''' </summary>
Public Class PluginInfo
    Private _location As String
    Private _className As String

    ''' <summary>
    ''' PluginInfoクラスのコンストラクタ
    ''' </summary>
    ''' <param name="path">アセンブリファイルのパス</param>
    ''' <param name="cls">クラスの名前</param>
    Private Sub New(ByVal path As String, ByVal cls As String)
        Me._location = path
        Me._className = cls
    End Sub

    ''' <summary>
    ''' アセンブリファイルのパス
    ''' </summary>
    Public ReadOnly Property Location() As String
        Get
            Return _location
        End Get
    End Property

    ''' <summary>
    ''' クラスの名前
    ''' </summary>
    Public ReadOnly Property ClassName() As String
        Get
            Return _className
        End Get
    End Property

    ''' <summary>
    ''' 有効なプラグインを探す
    ''' </summary>
    ''' <returns>有効なプラグインのPluginInfo配列</returns>
    Public Shared Function FindPlugins() As PluginInfo()
        Dim plugins As New System.Collections.ArrayList
        'IPlugin型の名前
        Dim ipluginName As String = _
            GetType(Plugin.IPlugin).FullName

        'プラグインフォルダ
        Dim folder As String = _
            System.IO.Path.GetDirectoryName( _
            System.Reflection.Assembly. _
            GetExecutingAssembly().Location)
        folder += "\plugins"
        If Not System.IO.Directory.Exists(folder) Then
            Throw New ApplicationException( _
                "プラグインフォルダ""" + folder + _
                """が見つかりませんでした。")
        End If

        '.dllファイルを探す
        Dim dlls As String() = _
            System.IO.Directory.GetFiles(folder, "*.dll")

        Dim dll As String
        For Each dll In dlls
            Try
                'アセンブリとして読み込む
                Dim asm As System.Reflection.Assembly = _
                    System.Reflection.Assembly.LoadFrom(dll)
                Dim t As Type
                For Each t In asm.GetTypes()
                    'アセンブリ内のすべての型について、
                    'プラグインとして有効か調べる
                    If t.IsClass And t.IsPublic And _
                        Not t.IsAbstract And _
                        Not (t.GetInterface(ipluginName) Is Nothing _
                        ) Then
                        'PluginInfoをコレクションに追加する
                        plugins.Add(New PluginInfo(dll, t.FullName))
                    End If
                Next t
            Catch
            End Try
        Next dll

        'コレクションを配列にして返す
        Return CType(plugins.ToArray( _
            GetType(PluginInfo)), PluginInfo())
    End Function 'FindPlugins

    ''' <summary>
    ''' プラグインクラスのインスタンスを作成する
    ''' </summary>
    ''' <returns>プラグインクラスのインスタンス</returns>
    Public Function CreateInstance( _
        ByVal host As Plugin.IPluginHost) As Plugin.IPlugin
            'アセンブリを読み込む
            Dim asm As System.Reflection.Assembly = _
                System.Reflection.Assembly.LoadFrom(Me.Location)
            'クラス名からインスタンスを作成する
            Dim plugin As Plugin.IPlugin = _
                CType(asm.CreateInstance(Me.ClassName),  _
                    Plugin.IPlugin)
            'IPluginHostの設定
            plugin.Host = host
            Return plugin
    End Function

End Class

