<?php
require_once(TODOTASK_DIR.'/app/controllers/login.class.php');
define("TASK_CLASS_MODE_EDIT" ,"edit");
define("TASK_CLASS_MODE_EDIT_ACT" ,"edit_act");
define("TASK_CLASS_MODE_NEW" ,"new");
define("TASK_CLASS_MODE_ADD" ,"add");
define("TASK_CLASS_MODE_APP" ,"app");


define("TASK_CLASS_MODE_GAINUP" ,"1");
define("TASK_CLASS_MODE_STATUSUP" ,"2");
define("TASK_CLASS_MODE_PRIORITYUP" ,"3");
define("TASK_CLASS_AJAK_NG" ,"");

define("TASK_CLASS_MODE_CMNTINS" ,"1");
define("TASK_CLASS_MODE_CMNTDEL" ,"2");



class Task extends Login {
	public $last_task_no = "";
	public $last_cmnt_no = "";

	function __construct( ){
		parent::__construct();
	}

	function __destruct(){

	}

	// タスクの取得
	public function GetTask($group_no,$taskboxid,$pageno,$aryViewMode,$gmode) {
		$aryRes = array();
	
//		$sSQL = "";
//		$sSQL = $sSQL."Select ";
//		$sSQL = $sSQL."	task_no, ";
//		$sSQL = $sSQL."	taskbox_id, ";
//		$sSQL = $sSQL."	status, ";
//		$sSQL = $sSQL."	ifnull(timelimit,'') timelimit, ";
//		$sSQL = $sSQL."	priority, ";
//		$sSQL = $sSQL."	note, ";
//		$sSQL = $sSQL."	detail, ";
//		$sSQL = $sSQL."	gains, ";
//		$sSQL = $sSQL."	volume, ";
//		$sSQL = $sSQL."	volunit, ";
//		$sSQL = $sSQL."	do_user_id, ";
//		$sSQL = $sSQL."	add_user_id, ";
//		$sSQL = $sSQL."	(to_days(now()) - to_days(upddate)) datedif, ";
//		$sSQL = $sSQL."	get_cmnt_cnt(task_no,group_no) cmnt_cnt, ";	// コメント表示
//		$sSQL = $sSQL."	get_approval(task_no,group_no) min_approval, ";	// 承認
//		$sSQL = $sSQL."	get_name(do_user_id) do_user_name, ";
//		$sSQL = $sSQL."	get_name(add_user_id) add_user_name ";
//		$sSQL = $sSQL."From task_tbl tt ";
//		$sSQL = $sSQL."Where ";
//		$sSQL = $sSQL."	 group_no=".gfQt($group_no);
//		$sSQL = $sSQL."	 and if(".gfQt($taskboxid)."='',1,taskbox_id=".gfQt($taskboxid).") ";
//		if ($gmode==TASK_MODE_PAGE){
//			if ($aryViewMode["fintask_flg"]==VIEW_OFF){
//				$sSQL = $sSQL."	 and status <> ".TASK_STATUS_FIN;
//			}
//			if ($aryViewMode["staytask_flg"]==VIEW_OFF){
//				$sSQL = $sSQL."	 and status <> ".TASK_STATUS_PEN;
//			}
//		}
//		$sSQL = $sSQL." Order By ";
//		$sSQL = $sSQL."	priority desc,task_no desc,timelimit ";
//		$sSQL = $sSQL."LIMIT ".($pageno-1)*$aryViewMode["listcnt"]." , ".$aryViewMode["listcnt"];


		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	tt.task_no, ";
		$sSQL = $sSQL."	tt.taskbox_id, ";
		$sSQL = $sSQL."	tt.status, ";
		$sSQL = $sSQL."	ifnull(tt.timelimit,'') timelimit, ";
		$sSQL = $sSQL."	tt.priority, ";
		$sSQL = $sSQL."	tt.note, ";
		$sSQL = $sSQL."	tt.detail, ";
		$sSQL = $sSQL."	tt.gains, ";
		$sSQL = $sSQL."	tt.volume, ";
		$sSQL = $sSQL."	tt.volunit, ";
		$sSQL = $sSQL."	tt.do_user_id, ";
		$sSQL = $sSQL."	tt.add_user_id, ";
		$sSQL = $sSQL."	(to_days(now()) - to_days(tt.upddate)) datedif, ";
//		$sSQL = $sSQL."	get_cmnt_cnt(task_no,group_no) cmnt_cnt, ";	// コメント表示
		$sSQL = $sSQL."	(select count(cmnt_no) from cmnt_tbl ct where ct.task_no = tt.task_no and ct.group_no = tt.group_no) cmnt_cnt, ";	// コメント表示
//		$sSQL = $sSQL."	get_approval(task_no,group_no) min_approval, ";	// 承認
		$sSQL = $sSQL."	(select ifnull(min(approval_no),0) from approval_tbl at where at.task_no = tt.task_no and at.group_no = tt.group_no) min_approval, ";	// 承認
		$sSQL = $sSQL."	um1.user_name do_user_name, ";
		$sSQL = $sSQL."	um2.user_name add_user_name ";
		$sSQL = $sSQL."From task_tbl tt ";
		$sSQL = $sSQL."	left outer join user_mst um1 ";
		$sSQL = $sSQL."	on tt.do_user_id = um1.user_id  ";
		$sSQL = $sSQL."	left outer join user_mst um2 ";
		$sSQL = $sSQL."	on tt.add_user_id = um2.user_id  ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	tt.group_no=".gfQt($group_no);
		$sSQL = $sSQL."	and if(".gfQt($taskboxid)."='',1,tt.taskbox_id=".gfQt($taskboxid).") ";
		if ($gmode==TASK_MODE_PAGE){
			if ($aryViewMode["fintask_flg"]==VIEW_OFF){
				$sSQL = $sSQL."	 and tt.status <> ".TASK_STATUS_FIN;
			}
			if ($aryViewMode["staytask_flg"]==VIEW_OFF){
				$sSQL = $sSQL."	 and tt.status <> ".TASK_STATUS_PEN;
			}
		}
		$sSQL = $sSQL." Order By ";
		$sSQL = $sSQL."	tt.priority desc,tt.task_no desc,tt.timelimit ";
		$sSQL = $sSQL."LIMIT ".($pageno-1)*$aryViewMode["listcnt"]." , ".$aryViewMode["listcnt"];


		$rs = parent::get_rs($sSQL);
		if($rs) {
			$i = 0;
			while( $row = parent::get_row($rs)){
				$tmpDate = "";
				$tmpDate = gfGetDBFields($row,"timelimit");
				if ($tmpDate!="") {
					$tmpDate = date("Y/m/d",strtotime($tmpDate));
				}
				//タスクラインの表示
				$aryRes[$i]["group_no"] = $group_no; 
				$aryRes[$i]["task_no"] = gfGetDBFields($row,"task_no"); 
				$aryRes[$i]["taskbox_id"] = gfGetDBFields($row,"taskbox_id"); 
				$aryRes[$i]["status"] = gfGetDBFields($row,"status"); 
				$aryRes[$i]["timelimit"] = $tmpDate; 
				$aryRes[$i]["priority"] = gfGetDBFields($row,"priority"); 
				$aryRes[$i]["note"] = gfGetDBFields($row,"note"); 
				$aryRes[$i]["detail"] = gfGetDBFields($row,"detail"); 
				$aryRes[$i]["gains"] = gfGetDBFields($row,"gains"); 
				$aryRes[$i]["volume"] = gfGetDBFields($row,"volume"); 
				$aryRes[$i]["volunit"] = gfGetDBFields($row,"volunit"); 
				$aryRes[$i]["do_user_id"] = gfGetDBFields($row,"do_user_id"); 
				$aryRes[$i]["add_user_id"] = gfGetDBFields($row,"add_user_id"); 
				$aryRes[$i]["do_user_name"] = gfGetDBFields($row,"do_user_name"); 
				$aryRes[$i]["add_user_name"] = gfGetDBFields($row,"add_user_name"); 
				$aryRes[$i]["datedif"] = gfGetDBFields($row,"datedif"); 
				$aryRes[$i]["cmnt_cnt"] = gfGetDBFields($row,"cmnt_cnt"); 
				$aryRes[$i]["min_approval"] = gfGetDBFields($row,"min_approval"); 

				$i++;
			}
			parent::free_rs($rs);
		}
		return $aryRes;
	
	}
	
	// タスクの取得
	public function GetTaskForEdit($group_no,$taskboxid,$taskno) {
		$aryRes = array();
	
		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	taskbox_id, ";
		$sSQL = $sSQL."	gains, ";
		$sSQL = $sSQL."	volume, ";
		$sSQL = $sSQL."	volunit, ";
		$sSQL = $sSQL."	status, ";
		$sSQL = $sSQL."	timelimit, ";
		$sSQL = $sSQL."	priority, ";
		$sSQL = $sSQL."	note, ";
		$sSQL = $sSQL."	detail, ";
		$sSQL = $sSQL."	do_user_id, ";
		$sSQL = $sSQL."	add_user_id, ";
		$sSQL = $sSQL."	add_date, ";
		$sSQL = $sSQL."	edit_user_id, ";
		$sSQL = $sSQL."	upddate ";
		$sSQL = $sSQL."From task_tbl ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	 group_no=".gfQt($group_no);
		$sSQL = $sSQL."	 and if(".gfQt($taskboxid)."='',1,taskbox_id=".gfQt($taskboxid).") ";
		$sSQL = $sSQL."	 and task_no=".gfQt($taskno);

		$rs = parent::get_rs($sSQL);

		if($rs) {
			while( $row = parent::get_row($rs)){
				$aryRes["group_no"] = $group_no; 
				$aryRes["task_no"] = $taskno; 
				$aryRes["taskbox_id"] = gfGetDBFields($row,"taskbox_id"); 
				$aryRes["gains"] = gfGetDBFields($row,"gains"); 
				$aryRes["volume"] = gfGetDBFields($row,"volume"); 
				$aryRes["volunit"] = gfGetDBFields($row,"volunit"); 
				$aryRes["status"] = gfGetDBFields($row,"status"); 
				$aryRes["timelimit"] = gfGetDBFields($row,"timelimit"); 
				if ($aryRes["timelimit"]!="") {
					$aryRes["timelimit"] = date("Y/m/d",strtotime($aryRes["timelimit"]));
				}
				$aryRes["priority"] = gfGetDBFields($row,"priority"); 
				$aryRes["note"] = gfGetDBFields($row,"note"); 
				$aryRes["detail"] = gfGetDBFields($row,"detail"); 
				$aryRes["do_user_id"] = gfGetDBFields($row,"do_user_id"); 
				$aryRes["add_user_id"] = gfGetDBFields($row,"add_user_id"); 
				$aryRes["add_date"] = gfGetDBFields($row,"add_date"); 
				$aryRes["edit_user_id"] = gfGetDBFields($row,"edit_user_id"); 
				$aryRes["upddate"] = gfGetDBFields($row,"upddate"); 
			}
			parent::free_rs($rs);
		}
		return $aryRes;
	}


	// タスク付属のイメージリストの取得
	public function GetTaskDataFile($group_no,$taskno) {
		$aryRes = array();
	
//		$sSQL = "";
//		$sSQL = $sSQL."Select ";
//		$sSQL = $sSQL."	data_no, ";
//		$sSQL = $sSQL."	task_no, ";
//		$sSQL = $sSQL."	group_no, ";
//		$sSQL = $sSQL."	data_name, ";
//		$sSQL = $sSQL."	data_ext, ";
//		$sSQL = $sSQL."	data_size, ";
//		$sSQL = $sSQL."	get_name(add_user_id) add_user_name ";
//		$sSQL = $sSQL."From data_tbl ";
//		$sSQL = $sSQL."Where ";
//		$sSQL = $sSQL."	 group_no=".gfQt($group_no);
//		$sSQL = $sSQL."	 and task_no=".gfQt($taskno);
//		$sSQL = $sSQL."order by data_no ";

		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	dt.data_no, ";
		$sSQL = $sSQL."	dt.task_no, ";
		$sSQL = $sSQL."	dt.group_no, ";
		$sSQL = $sSQL."	dt.data_name, ";
		$sSQL = $sSQL."	dt.data_ext, ";
		$sSQL = $sSQL."	dt.data_size, ";
		$sSQL = $sSQL."	um.user_name add_user_name ";
		$sSQL = $sSQL."From data_tbl dt ";
		$sSQL = $sSQL."	left outer join user_mst um ";
		$sSQL = $sSQL."	on dt.add_user_id=um.user_id ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	 dt.group_no=".gfQt($group_no);
		$sSQL = $sSQL."	 and dt.task_no=".gfQt($taskno);
		$sSQL = $sSQL."order by dt.data_no ";

		$rs = parent::get_rs($sSQL);

		$i = 0;
		if($rs) {
			while( $row = parent::get_row($rs)){
				$aryRes[$i]["data_no"] = gfGetDBFields($row,"data_no"); 
				$aryRes[$i]["task_no"] = $taskno; 
				$aryRes[$i]["group_no"] = $group_no; 
				$aryRes[$i]["data_name"] = gfGetDBFields($row,"data_name"); 
				$aryRes[$i]["data_ext"] = gfGetDBFields($row,"data_ext"); 
				$aryRes[$i]["data_size"] = gfGetDBFields($row,"data_size"); 
				$aryRes[$i]["add_user_name"] = gfGetDBFields($row,"add_user_name"); 
				$i++;
			}
			parent::free_rs($rs);
		}
		return $aryRes;
	}


	// 登録処理
	public function InsTask($group_no,$newtaskboxid,$status,
			$note,$priority,$timelimit,$detail,$gains,$volume,$volunit,$douser,$id) {
	
		// タスクを追加する。
		$sSQL = "";
		$sSQL = $sSQL."insert into task_tbl (";
		$sSQL = $sSQL."	group_no,";
		$sSQL = $sSQL."	taskbox_id,";
		$sSQL = $sSQL."	status,";
		$sSQL = $sSQL."	note,";
		$sSQL = $sSQL."	priority,";
		$sSQL = $sSQL."	timelimit,";
		$sSQL = $sSQL."	detail,";
		$sSQL = $sSQL."	gains,";
		$sSQL = $sSQL."	volume,";
		$sSQL = $sSQL."	volunit,";
		$sSQL = $sSQL."	do_user_id,";
		$sSQL = $sSQL."	add_user_id,";
		$sSQL = $sSQL."	add_date,";
		$sSQL = $sSQL."	remotehost,";
		$sSQL = $sSQL."	upddate,";
		$sSQL = $sSQL."	insdate";
		$sSQL = $sSQL.") values (";
		$sSQL = $sSQL.gfQt($group_no).",";
		$sSQL = $sSQL.gfQt($newtaskboxid).",";
		$sSQL = $sSQL.gfQt($status).",";
		$sSQL = $sSQL.gfQt($note).",";
		$sSQL = $sSQL.gfQt($priority).",";
		$sSQL = $sSQL."if(".gfQt($timelimit)."='',null,".gfQt($timelimit)."),";
		$sSQL = $sSQL.gfQt($detail,1).",";	// 改行を認める
		$sSQL = $sSQL.gfQt($gains).",";
		$sSQL = $sSQL.gfQt($volume).",";
		$sSQL = $sSQL.gfQt($volunit).",";
		$sSQL = $sSQL.gfQt($douser).",";
		$sSQL = $sSQL.gfQt($id).",";
		$sSQL = $sSQL."now(),";
		$sSQL = $sSQL.gfQt($_SERVER['REMOTE_ADDR']).",";
		$sSQL = $sSQL."now(),";
		$sSQL = $sSQL."now()";
		$sSQL = $sSQL.") ";

		$res = parent::exec_sql($sSQL);
		if (parent::affected_rows() > 0 ) {
			// ログの書き込み
			$task_no = parent::get_lastid();
			$this->last_task_no = $task_no; 
			parent::InsLog($group_no, $task_no, $newtaskboxid ,gfPageStr($note) ,TASK_STATUS_MAKE,"");
			return true;
		} else {
			return false;
		}
	}
	
	
	// 更新処理
	public function UpdTask($group_no,$newtaskboxid,$taskboxid,$taskno,$status,
			$note,$priority,$timelimit,$detail,$gains,$volume,$volunit,$douser,$id) {
	
		// タスクを更新する。
		$sSQL = "";
		$sSQL = $sSQL."Update task_tbl set ";
		$sSQL = $sSQL."	 taskbox_id= ".gfQt($newtaskboxid);
		$sSQL = $sSQL."	 ,note = ".gfQt($note);	
		$sSQL = $sSQL."	 ,priority = ".gfQt($priority);
		$sSQL = $sSQL."	 ,gains= ".gfQt($gains);
		$sSQL = $sSQL."	 ,volume= ".gfQt($volume);
		$sSQL = $sSQL."	 ,volunit= ".gfQt($volunit);
		$sSQL = $sSQL."	 ,status= ".gfQt($status);
		$sSQL = $sSQL."	 ,timelimit = if(".gfQt($timelimit)."='',null,".gfQt($timelimit).") ";
		$sSQL = $sSQL."	 ,detail= ".gfQt($detail,1);	// 改行を認める
		$sSQL = $sSQL."	 ,do_user_id= ".gfQt($douser);
		$sSQL = $sSQL."	 ,edit_user_id= ".gfQt($id);
		$sSQL = $sSQL."	 ,upddate = now() ";
		$sSQL = $sSQL."where ";
		$sSQL = $sSQL."	 group_no= ".gfQt($group_no);
//		$sSQL = $sSQL."	 and if(".gfQt($taskboxid)."='',1,taskbox_id=".gfQt($taskboxid).") ";
		$sSQL = $sSQL."	 and task_no= ".gfQt($taskno);

		$res = parent::exec_sql($sSQL);
		if (parent::affected_rows() > 0 ) {
			// ログの書き込み
			parent::InsLog($group_no,$taskno,$newtaskboxid,gfPageStr($note) ,$status,"");
			return true;
		} else {
			return false;
		}
	}
	
	
	// 破棄処理
	public function DelTask($group_no ,$taskboxid ,$taskno ,$status ,$note ) {
//		// タスクの現在の状況の取得
//		$sSQL = "";
//		$sSQL = $sSQL."Select ";
//		$sSQL = $sSQL."	status, ";
//		$sSQL = $sSQL."	note ";
//		$sSQL = $sSQL."From task_tbl ";
//		$sSQL = $sSQL."Where ";
//		$sSQL = $sSQL."	 group_no=".gfQt($group_no);
//		$sSQL = $sSQL."	 and task_no=".gfQt($taskno);
//
//		$rs = parent::get_rs($sSQL);
//
//		if($rs) {
//			while( $row = parent::get_row($rs)){
//				$status = gfGetDBFields($row,"status"); 
//				$note = gfGetDBFields($row,"note"); 
//			}
//			parent::free_rs($rs);
//		} else {
//			return false;
//		}
	
		// タスクを破棄する。
		$sSQL = "";
		$sSQL = $sSQL."DELETE FROM task_tbl ";
		$sSQL = $sSQL."where ";
		$sSQL = $sSQL."	 group_no= ".gfQt($group_no);
//		$sSQL = $sSQL."	 and taskbox_id= ".gfQt($taskboxid);
		$sSQL = $sSQL."	 and task_no= ".gfQt($taskno);
	
		$res = parent::exec_sql($sSQL);
		if (parent::affected_rows() > 0 ) {
			// ログの書き込み
			parent::InsLog($group_no,$taskno,$taskboxid , gfPageStr($note),$status,"");
			return true;
		} else {
			return false;
		}
	}

	// ページ番号計算処理
	public function GetTaskPageCnt($aryViewMode ,$group_no ,$taskboxid){
		// ページ数の計算
		$iPageAll = 0; // 全ページ数
	
		// ページ数の取得
		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	count(group_no) cnt ";
		$sSQL = $sSQL."From task_tbl ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	 group_no=".gfQt($group_no);
		$sSQL = $sSQL."	 and if(".gfQt($taskboxid)."='',1,taskbox_id=".gfQt($taskboxid).") ";
		if ($aryViewMode["fintask_flg"]==VIEW_OFF){
			$sSQL = $sSQL."	 and status <> ".TASK_STATUS_FIN;
		}
		if ($aryViewMode["staytask_flg"]==VIEW_OFF){
			$sSQL = $sSQL."	 and status <> ".TASK_STATUS_PEN;
		}

		$rs = parent::get_rs($sSQL);
		if($rs) {
			while( $row = parent::get_row($rs)){
				$iPageAll  = ceil((gfGetDBFields($row,"cnt")/$aryViewMode["listcnt"]));
			}
			parent::free_rs($rs);
		}
	
		return $iPageAll;
	}


	// 更新処理
	public function UpdTaskAjax($id ,$group_no ,$taskboxid ,$taskno ,$mode ,$gains ,$status ,$priority, $note) {
	
		$sResEnd = ""; 	// 更新失敗
		// タスクを更新する。
		$sSQL = "";
		$sSQL = $sSQL."Update task_tbl set ";
		$sSQL = $sSQL."	 edit_user_id= ".gfQt($id);
		if ($mode == TASK_CLASS_MODE_GAINUP ) {
			$sSQL = $sSQL."	 ,gains= ".gfQt($gains);
		} else if ($mode == TASK_CLASS_MODE_STATUSUP){
			$sSQL = $sSQL."	 ,status= ".gfQt($status);
		} else if ($mode == TASK_CLASS_MODE_PRIORITYUP){
			$sSQL = $sSQL."	 ,priority= ".gfQt($priority);
		}
		$sSQL = $sSQL."	 ,upddate = now() ";
		$sSQL = $sSQL."where ";
		$sSQL = $sSQL."	 group_no= ".gfQt($group_no);
		$sSQL = $sSQL."	 and taskbox_id= ".gfQt($taskboxid);
		$sSQL = $sSQL."	 and task_no= ".gfQt($taskno);

		$res = parent::exec_sql($sSQL);
		if (parent::affected_rows() > 0 ) {
			if ($mode == TASK_CLASS_MODE_GAINUP ) {
				$sResEnd = $gains;
			} else if ($mode == TASK_CLASS_MODE_STATUSUP){
				$sResEnd = $status;
			} else if ($mode == TASK_CLASS_MODE_PRIORITYUP){
				$sResEnd = $priority;
			}
			// ログの書き込み
			parent::InsLog($group_no,$taskno,$taskboxid , $note ,$status,"");
		}
		return 	$sResEnd;
	}


	// コメント記入
	public function InsCmntAjax($id ,$task_no ,$group_no, $cmnt ,$taskboxid ) {

		$sSQL = "";
		$sSQL = $sSQL."insert into cmnt_tbl (";
		$sSQL = $sSQL."	task_no,";
		$sSQL = $sSQL."	group_no,";
		$sSQL = $sSQL."	cmnt,";
		$sSQL = $sSQL."	add_user_id,";
		$sSQL = $sSQL."	add_date,";
		$sSQL = $sSQL."	remotehost,";
		$sSQL = $sSQL."	upddate,";
		$sSQL = $sSQL."	insdate";
		$sSQL = $sSQL.") values (";
		$sSQL = $sSQL.gfQt($task_no).",";
		$sSQL = $sSQL.gfQt($group_no).",";
		$sSQL = $sSQL.gfQt($cmnt).",";
		$sSQL = $sSQL.gfQt($id).",";
		$sSQL = $sSQL."now(),";
		$sSQL = $sSQL.gfQt($_SERVER['REMOTE_ADDR']).",";
		$sSQL = $sSQL."now(),";
		$sSQL = $sSQL."now()";
		$sSQL = $sSQL.") ";


		$res = parent::exec_sql($sSQL);
		if (parent::affected_rows() > 0 ) {
			$cmnt_no = parent::get_lastid();
			$this->last_cmnt_no = $cmnt_no; 
			// ログの書き込み
			parent::InsLog($group_no, $task_no, $taskboxid ,gfPageStr($cmnt) ,TASK_STATUS_CMNTINS,"");
			return true;
		} else {
			return false;
		}

	}

	// コメント削除
	public function DelCmntAjax($id ,$taskno ,$group_no ,$cmnt,$taskboxid, $cmnt_no ) {

		$sSQL = "";
		$sSQL = $sSQL."DELETE FROM cmnt_tbl ";
		$sSQL = $sSQL."where ";
		$sSQL = $sSQL."	 group_no=".gfQt($group_no);
		$sSQL = $sSQL."	 and task_no=".gfQt($taskno);
		$sSQL = $sSQL."	 and cmnt_no=".gfQt($cmnt_no);

		$res = parent::exec_sql($sSQL);
		if (parent::affected_rows() > 0 ) {
			$cmnt_no = parent::get_lastid();
			$this->last_cmnt_no = $cmnt_no; 
			// ログの書き込み
			parent::InsLog($group_no,$taskno,$taskboxid , gfPageStr($cmnt),TASK_STATUS_CMNTDEL,"");
			return true;
		} else {
			return false;
		}
	}

	// コメント取得
	public function GetCmnt($group_no,$taskno) {

		$aryRes = array();
	
//		$sSQL = "";
//		$sSQL = $sSQL."Select ";
//		$sSQL = $sSQL."	cmnt_no, ";
//		$sSQL = $sSQL."	task_no, ";
//		$sSQL = $sSQL."	group_no, ";
//		$sSQL = $sSQL."	cmnt, ";
//		$sSQL = $sSQL."	get_name(add_user_id) add_user_name,";
//		$sSQL = $sSQL."	add_date ";
//		$sSQL = $sSQL."From cmnt_tbl ";
//		$sSQL = $sSQL."Where ";
//		$sSQL = $sSQL."	 group_no=".gfQt($group_no);
//		$sSQL = $sSQL."	 and task_no=".gfQt($taskno);
//		$sSQL = $sSQL." order by cmnt_no desc";

		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	ct.cmnt_no, ";
		$sSQL = $sSQL."	ct.task_no, ";
		$sSQL = $sSQL."	ct.group_no, ";
		$sSQL = $sSQL."	ct.cmnt, ";
		$sSQL = $sSQL."	um.user_name add_user_name,";
		$sSQL = $sSQL."	ct.add_date ";
		$sSQL = $sSQL."From cmnt_tbl ct ";
		$sSQL = $sSQL."	left outer join user_mst um ";
		$sSQL = $sSQL."	on ct.add_user_id = um.user_id ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	 ct.group_no=".gfQt($group_no);
		$sSQL = $sSQL."	 and ct.task_no=".gfQt($taskno);
		$sSQL = $sSQL." order by ct.cmnt_no desc";


		$rs = parent::get_rs($sSQL);

		$i = 0;
		if($rs) {
			while( $row = parent::get_row($rs)){
				$aryRes[$i]["cmnt_no"] = gfGetDBFields($row,"cmnt_no"); 
				$aryRes[$i]["task_no"] = $taskno; 
				$aryRes[$i]["group_no"] = $group_no; 
				$aryRes[$i]["cmnt"] = gfGetDBFields($row,"cmnt"); 
				$aryRes[$i]["add_user_name"] = gfGetDBFields($row,"add_user_name"); 
				$aryRes[$i]["add_date"] = gfGetDBFields($row,"add_date");
				if ($aryRes[$i]["add_date"]!="") {
					$aryRes[$i]["add_date"] = date("Y/m/d H:i:s",strtotime($aryRes[$i]["add_date"]));
				}
				$i++;
			}
			parent::free_rs($rs);
		}
		return $aryRes;

	}

	// コメント取得
	public function GetApproval($group_no,$taskno) {

		$aryRes = array();
	
//		$sSQL = "";
//		$sSQL = $sSQL."Select ";
//		$sSQL = $sSQL."	task_no, ";
//		$sSQL = $sSQL."	group_no, ";
//		$sSQL = $sSQL."	approval_no, ";
//		$sSQL = $sSQL."	user_id, ";
//		$sSQL = $sSQL."	get_name(user_id) user_name,";
//		$sSQL = $sSQL."	add_date ";
//		$sSQL = $sSQL."From approval_tbl ";
//		$sSQL = $sSQL."Where ";
//		$sSQL = $sSQL."	 group_no=".gfQt($group_no);
//		$sSQL = $sSQL."	 and task_no=".gfQt($taskno);
//		$sSQL = $sSQL." order by approval_no desc";

		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	at.task_no, ";
		$sSQL = $sSQL."	at.group_no, ";
		$sSQL = $sSQL."	at.approval_no, ";
		$sSQL = $sSQL."	at.user_id, ";
		$sSQL = $sSQL."	um.user_name user_name,";
		$sSQL = $sSQL."	at.add_date ";
		$sSQL = $sSQL."From approval_tbl at ";
		$sSQL = $sSQL."	left outer join user_mst um ";
		$sSQL = $sSQL."	on at.user_id=um.user_id ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	 at.group_no=".gfQt($group_no);
		$sSQL = $sSQL."	 and at.task_no=".gfQt($taskno);
		$sSQL = $sSQL." order by approval_no desc";


		$rs = parent::get_rs($sSQL);

		$i = 0;
		if($rs) {
			while( $row = parent::get_row($rs)){
				$aryRes[$i]["task_no"] = $taskno; 
				$aryRes[$i]["group_no"] = $group_no; 
				$aryRes[$i]["approval_no"] = gfGetDBFields($row,"approval_no"); 
				$aryRes[$i]["user_id"] = gfGetDBFields($row,"user_id"); 
				$aryRes[$i]["user_name"] = gfGetDBFields($row,"user_name"); 
				$aryRes[$i]["add_date"] = gfGetDBFields($row,"add_date");
				if ($aryRes[$i]["add_date"]!="") {
					$aryRes[$i]["add_date"] = date("Y/m/d H:i:s",strtotime($aryRes[$i]["add_date"]));
				}
				$i++;
			}
			parent::free_rs($rs);
		}
		return $aryRes;

	}

	// 担当者にメールを送るか確認する
	public function GetBoxDouser($group_no,$taskboxid,$douser) {
		// 担当者へメールを送る必要がある場合送信処理
		if ($douser == "") {
			return false;
		}

		$aryRes = array();
		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	user_mail, ";
		$sSQL = $sSQL."	user_name, ";
		$sSQL = $sSQL."	(Select mailsend_flg from taskbox_mst";
		$sSQL = $sSQL."	 where  ";
		$sSQL = $sSQL."	 group_no=".gfQt($group_no);
		$sSQL = $sSQL."	 and taskbox_id=".gfQt($taskboxid);
		$sSQL = $sSQL."	) mailsend_flg ";
		$sSQL = $sSQL."From user_mst um ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	 user_id=".gfQt($douser);

		$rs = parent::get_rs($sSQL);

		if($rs) {
			while( $row = parent::get_row($rs)){
				$aryRes["user_mail"] = gfGetDBFields($row,"user_mail"); 
				$aryRes["user_name"] = gfGetDBFields($row,"user_name"); 
				$aryRes["mailsend_flg"] = gfGetDBFields($row,"mailsend_flg"); 
			}
			parent::free_rs($rs);
		}

		return $aryRes;
	}

	// 承認スタンプ登録処理
	public function InsApprovel($group_no, $task_no, $taskboxid, $approval_no, $id,$page) {
	
		// タスクを追加する。
		$sSQL = "";
		$sSQL = $sSQL."insert into approval_tbl (";
		$sSQL = $sSQL."	group_no,";
		$sSQL = $sSQL."	task_no,";
		$sSQL = $sSQL."	user_id,";
		$sSQL = $sSQL."	approval_no,";
		$sSQL = $sSQL."	add_date,";
		$sSQL = $sSQL."	upddate,";
		$sSQL = $sSQL."	insdate";
		$sSQL = $sSQL.") values (";
		$sSQL = $sSQL.gfQt($group_no).",";
		$sSQL = $sSQL.gfQt($task_no).",";
		$sSQL = $sSQL.gfQt($id).",";
		$sSQL = $sSQL.gfQt($approval_no).",";
		$sSQL = $sSQL."now(),";
		$sSQL = $sSQL."now(),";
		$sSQL = $sSQL."now()";
		$sSQL = $sSQL.") ";
		$sSQL = $sSQL."on duplicate key update ";
		$sSQL = $sSQL."	approval_no = ".gfQt($approval_no).",";
		$sSQL = $sSQL."	add_date = now() ";

		$res = parent::exec_sql($sSQL);
		if (parent::affected_rows() > 0 ) {
			// ログの書き込み
			parent::InsLog($group_no, $task_no, $taskboxid ,gfPageStr($page->GetApprovalName($approval_no)) ,TASK_STATUS_APPROVAL,"");
			return true;
		} else {
			return false;
		}
	}

}
?>