
var mEditID = "";
var editUrl = "taskajax.php";

function createChild(parent, tagName, options) {
	var element = document.createElement(tagName);
	if(options) {
		for(var key in options) {
			if(options.hasOwnProperty(key)) element[key] = options[key];
		}
	}
	if(parent) parent.appendChild(element);
	return element;
}

var clsEditVal = Class.create();
clsEditVal.instance = {};
clsEditVal.prototype = 
{
	initialize: function(mode,element,gid,tid,tno,csrf,delauth) 
	{
		this.element = $(element);
		this.mode = mode;
		this.gid = gid;
		this.tid = tid;
		this.tno = tno;
		this.csrf = csrf;
		this.delauth = delauth;
		this.startEdit();
	},
	startEdit: function() 
	{
		mEditID = this.element.id;
		this.orgVal = this.element.innerHTML;
		// gains
		if (this.mode=='1') {
			this.editVal = this.orgVal.replace(/%<BR>/, '');
			this.element.innerHTML = '';
			this.editForm = createChild(this.element, 'form');
			this.input = createChild(this.editForm, 'input', { 
							type: 'text', 
							name: 'gains', 
							size: 3, 
							maxlength: 3, 
							autocomplete: 'off', 
							value: this.editVal });
			this.br = createChild(this.editForm, 'br');
			this.cancelButton = createChild(this.editForm, 'input', { type: 'reset', value: 'cancel'});
			this.submitButton = createChild(this.editForm, 'input', { type: 'submit', value: '更新'});
			Event.observe(this.editForm, 'submit', this.gainsact.bindAsEventListener(this), false);
			Event.observe(this.editForm, 'reset', this.cancelEdit.bindAsEventListener(this), false);
			Field.activate(this.input);
		// status
		} else if(this.mode=='2') {
			this.element.innerHTML = '';
			this.select = createChild(this.element, 'select', { name: 'status', width : '100%'});

			this.select.options[0] = createChild(this.select, 'option', { value: '0'});
			this.select.options[0].innerHTML = "未処理";
			this.select.options[1] = createChild(this.select, 'option', { value: '1'});
			this.select.options[1].innerHTML = "処理中";
			this.select.options[2] = createChild(this.select, 'option', { value: '2'});
			this.select.options[2].innerHTML = "終了";
			this.select.options[3] = createChild(this.select, 'option', { value: '3'});
			this.select.options[3].innerHTML = "延期";
			if (this.delauth=='1') { 
				this.select.options[4] = createChild(this.select, 'option', { value: '4'});
				this.select.options[4].innerHTML = "破棄";
			}

			for(var i=0;i<this.select.length;i++){
				if (this.select.options[i].innerHTML == this.orgVal) {
					this.select.selectedIndex=i;
				}
			}

			Event.observe(this.select, 'blur', this.cancelSelect.bindAsEventListener(this), false);
			Event.observe(this.select, 'change', this.selectact.bindAsEventListener(this), false);
			Field.activate(this.select);
		} else if(this.mode=='3') {
			this.element.innerHTML = '';
			this.select = createChild(this.element, 'select', { name: 'priority', width : '100%'});

			this.select.options[0] = createChild(this.select, 'option', { value: '1'});
			this.select.options[0].innerHTML = "☆";
			this.select.options[1] = createChild(this.select, 'option', { value: '2'});
			this.select.options[1].innerHTML = "☆☆";
			this.select.options[2] = createChild(this.select, 'option', { value: '3'});
			this.select.options[2].innerHTML = "☆☆☆";
			this.select.options[3] = createChild(this.select, 'option', { value: '4'});
			this.select.options[3].innerHTML = "☆☆☆☆";
			this.select.options[4] = createChild(this.select, 'option', { value: '5'});
			this.select.options[4].innerHTML = "☆☆☆☆☆";
			for(var i=0;i<this.select.length;i++){
				if (this.select.options[i].innerHTML+'<BR>' == this.orgVal) {
					this.select.selectedIndex=i;
				}
			}

			Event.observe(this.select, 'blur', this.cancelSelect.bindAsEventListener(this), false);
			Event.observe(this.select, 'change', this.priorityact.bindAsEventListener(this), false);
			Field.activate(this.select);
		}

 	},
	cancelEdit: function(event) 
	{
		mEditID = "";
		this.editForm = null;
		this.element.innerHTML = this.orgVal;
	},
	cancelSelect: function(event) 
	{
		mEditID = "";
		this.select = null;
		this.element.innerHTML = this.orgVal;
	},
	gainsact: function(event) 
	{
		var param = 'gains=' + this.input.value +
				'&mode=1' +
				'&group_no=' + this.gid +
				'&taskboxid=' + this.tid +
				'&taskno=' + this.tno +
				'&csrf=' + this.csrf;
		this.update(param);
	},
	selectact: function(event) 
	{
		var param = 'status=' + this.select.value +
				'&mode=2' +
				'&group_no=' + this.gid +
				'&taskboxid=' + this.tid +
				'&taskno=' + this.tno +
				'&csrf=' + this.csrf;
		this.update(param);
	},
	priorityact: function(event) 
	{
		var param = 'priority=' + this.select.value +
				'&mode=3' +
				'&group_no=' + this.gid +
				'&taskboxid=' + this.tid +
				'&taskno=' + this.tno +
				'&csrf=' + this.csrf;
		this.update(param);
	},
	update: function(param) 
	{
		var url = editUrl;
		new Ajax.Request(
			url,
			{
				method: 'post',
				parameters: param,
				onSuccess : this.onSuccess.bind(this),
				onFailure: this.onFailure.bind(this)
			}
		);
		this.editForm = null;
		Event.stop(event);
	},
	onSuccess: function(req) 
	{
		if(!req.responseText || req.responseText == "") {
			return this.onFailure(req);
		}
		if(this.mode=="1") {
			this.element.innerHTML = req.responseText + "%<BR>";
		} else if (this.mode=="2") {
			if (req.responseText == 0) {
				this.element.innerHTML = "未処理";
			} else if (req.responseText == 1) {
				this.element.innerHTML = "処理中";
			} else if (req.responseText == 2) {
				this.element.innerHTML = "終了";
			} else if (req.responseText == 3) {
				this.element.innerHTML = "延期";
			} else if (req.responseText == 4) {
				this.element.innerHTML = "破棄";
			} else {
				this.element.innerHTML = req.responseText;
			}
		} else if (this.mode=="3") {
			if (req.responseText == 0) {
				this.element.innerHTML = "";
			} else if (req.responseText == 1) {
				this.element.innerHTML = "☆";
			} else if (req.responseText == 2) {
				this.element.innerHTML = "☆☆";
			} else if (req.responseText == 3) {
				this.element.innerHTML = "☆☆☆";
			} else if (req.responseText == 4) {
				this.element.innerHTML = "☆☆☆☆";
			} else if (req.responseText == 5) {
				this.element.innerHTML = "☆☆☆☆☆";
			} else {
				this.element.innerHTML = req.responseText;
			}
		}
		mEditID = "";
		this.editForm = null;

	},
	onFailure: function(transport) 
	{
		this.element.innerHTML = '失敗しました';
		setTimeout((function() {
			this.cancelEdit();
			this.startEdit();
		}).bind(this), 1200);
	}

};

function fEdit(mode,id,gid,tid,tno,csrf,delauth) {
	if (mEditID!="" && $(id).id != mEditID) {
		if (clsEditVal.instance[mEditID].mode == '1') {
			clsEditVal.instance[mEditID].cancelEdit();
		} else if (clsEditVal.instance[mEditID].mode == '2') {
			clsEditVal.instance[mEditID].cancelSelect();
		} else if (clsEditVal.instance[mEditID].mode == '3') {
			clsEditVal.instance[mEditID].cancelSelect();
		}	
	}
	if (mEditID=="") {
		clsEditVal.instance[id] = new clsEditVal(mode,$(id),gid,tid,tno,csrf,delauth);
	}
}
