<?php
	require_once('./config.inc.php');
	require_once(TODOTASK_CTRL_DIR.'/logview.class.php');
	// ページロード
	$page = gfPageLoad();
	$page->title = TITLE_LOGLIST;
	$page->group_no = gfIssetGET('group_no',""); 
	$page->taskbox_id = gfIssetGET('taskboxid',"");	// タスクボックスID 
	$page->task_no = gfIssetGET('taskno',"");	// タスクNO 
	$page->pageno = gfIssetGET('pageno',"");	// ページ番号 

	// check page parameter
	$page->chkPage();

	// ログイン確認
	$objLog = new Logview();
	$page->user_name = $objLog->get_loginname(); 
	$page->user_id = $objLog->get_loginid(); 
	$page->backurl = "";

	// 取得したグループが存在するか確認
	if (!$objLog->ChkGroupMst($page->group_no)) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_001_1 , TASK_ART_001_2 ,$page->backurl ,MSG_NOR);
	}
	$page->group_name = $objLog->get_group_name($page->group_no); 

	// メンバーチェック(参照しようとしているタスクのメンバーに登録されているか)
	$page->memLv = $objLog->ChkMember($page->group_no,$page->user_id);
	// メンバーに所属していなくてメンバーモードの場合
	if ($page->memLv == GRPAUTH_NOMEM) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , AUTH_ERR_001 ,$page->backurl ,MSG_NOR);
	}

	$page->aryLogList = $objLog->GetLogList($page->group_no,$page->pageno ,$page->taskbox_id, $page->task_no);

	// ページの一覧を表示する
	$page->page_cnt = $objLog->GetLogPageCnt($page->group_no, $page->taskbox_id, $page->task_no); 
	// ページめくりのリンク追加
	$page->pagelink = $objLog->make_page($page->page_cnt,$page->pageno,MAX_LOGPV,"loglist.php?group_no=".$page->group_no);

	$page->title = $page->group_name.$page->title;

	$page->display('/log/list.php');

	// ページ終了処理
	gfPageUnLoad();


?>