/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007 by KURUSUGAWA Electronics Industry Inc, JAPAN
 *  Copyright (C) 2008 by Takahisa Yokota
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_support.S,v 1.16 2005/11/12 14:58:46 hiro Exp $
 */

/*
 *	ץå¸⥸塼 ֥MCF52235ѡ
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 *  ǥѥå
 *
 *  dispatch ϡޥ⡼ɡ߶ػ߾֤ǸƤӽФʤФʤ
 *  exit_and_dispatch ⡤ޥ⡼ɡ߶ػ߾֤ǸƤӽФ
 *  §Ǥ뤬ͥ뵯ưб뤿ᡤߥ⡼ɤǸƤӽ
 *  ˤбƤ롥
 */
	.text
	.globl dispatch
	.globl exit_and_dispatch
dispatch:
	lea  -11 * 4(%sp), %sp
	movem.l %d2-%d7/%a2-%a6, (%sp)	/* 쥸¸ */
	move.l runtsk, %a0		/* A0  runtsk  */
	move.l %sp, TCB_msp(%a0)	/* å¸ */
	move.l #dispatch_r, %d2
	move.l %d2, TCB_pc(%a0)	/* ¹ԺƳϤ¸ */
	jbra dispatcher

dispatch_r:
	movem.l (%sp), %d2-%d7/%a2-%a6	/* 쥸 */
	lea 11 * 4(%sp), %sp
	btst.b #TCB_enatex_bit, TCB_enatex(%a0)
	jbeq dispatch_r_1		/* enatex  FALSE ʤ꥿ */
	tst.l TCB_texptn(%a0)		/* texptn  0 Ǥʤ           */
	jbne call_texrtn		/*   㳰롼θƽФ */
dispatch_r_1:
	rts

exit_and_dispatch:
	move.w	%sr, %d0
	ori.l #0x00001000, %d0		/* ޥ⡼ */
	move.w	%d0, %sr
dispatcher:
	/*
	 *  Ǥϥޥ⡼ɡ߶ػ߾֤ǤʤФʤʤ
	 */
	move.l schedtsk, %a0
	move.l %a0, runtsk		/* schedtsk  runtsk  */
	jbeq   dispatcher_1		/* runtsk 뤫 */
	move.l TCB_msp(%a0), %sp	/* å */
	move.l TCB_pc(%a0),  %a1	/* ¹ԺƳϤ */
	jmp (%a1)
dispatcher_1:
	stop #0x2000			/* Ԥʳߥ⡼ɡ */
	/*
	 *  ǳߥ⡼ɤڤ괹Τϡȯ߽
	 *  ˤɤΥåȤȤβȡߥϥɥ
	 *  ΥǥѥåɻߤȤ2Ĥΰ̣롥
	 *
	 *   stop̿ϡIPM  0 ˤ뤬 task_intmask 
	 *  ꤹ٤Ǥ롥M68040 Ǥϡstop ̿Υѥ᡼
	 *  Ȥʤᡤ򤨤 0 ˤƤstop ̿ 8
	 *  ¤٤ơtask_intmask ͤʬϤ뤬ޤ
	 *  յϤʤȹͤˡ
	 *
	 *  ץåԤ⡼ɤ˰ܹԤȡߵĤȤϡ
	 *  Բʬ˹ԤʤɬפM68040 Ǥ stop̿ξԤʤ
	 *  ΤʤˡԲʬ˹Ԥʤʤ硤ߤ
	 *  ľ˳ߤꡤǥ¹Բǽ֤ˤʤ
	 *  ȡ¹Ԥ٤ˤ⤫餺ץåԤ⡼
	 *  ɤˤʤäƤޤ
	 *
	 *  ߤԤĴ֤ϡruntsk  NULL=0ˤꤷʤФʤ
	 *  ʤΤ褦ꤷʤȡߥϥɥ餫 iget_tid 
	 *  ƤӽФݤưͤ˹פʤʤ롥
	 */
	move.w #0x3700, %sr		/* ޥ⡼ɡ߶ػ */
	
	tst.l reqflg			/* reqflg  FALSE ʤ */
	jbeq dispatcher_1		/*      dispatcher_1  */
	clr.l reqflg			/* reqflg  FALSE  */
	jbra dispatcher

/*
 *  no_reg_exception()
 *  CPU㳰ȤϿƤʤ㳰ȯȸƤӽФ
 *  㳰ȯpc,sr,pr,r015Ϥƥͥ
 *  ߤ롣
 */
	.text
	.align 2
	.globl no_reg_exception
no_reg_exception:
	move.l  %a7, %sp@-
	move.l  %a6, %sp@-
	move.l  %a5, %sp@-
	move.l  %a4, %sp@-
	move.l  %a3, %sp@-
	move.l  %a2, %sp@-
	move.l  %a1, %sp@-
	move.l  %a0, %sp@-
	move.l  %d7, %sp@-
	move.l  %d6, %sp@-
	move.l  %d5, %sp@-
	move.l  %d4, %sp@-
	move.l  %d3, %sp@-
	move.l  %d2, %sp@-
	move.l  %d1, %sp@-
	move.l  %d0, %sp@-
	move.l %sp, %sp@-
	jbsr  cpu_experr

/*
 *  ư
 */
	.text
	.globl activate_r
activate_r:
	/*
	 *  ưľϥ㳰ػߤƤ뤿ᡤǥ
	 *  㳰롼ƤӽФΩʤ
	 */
#ifdef SUPPORT_CHG_IPM			/* t_unlock_cpu ν */
	move.w %sr, %d0			/* ߥޥ task_intmask  */
	and.l  #~0x00000700, %d0
	clr.l	%d1
	move.w task_intmask, %d1
	or.l   %d1, %d0
	move.w %d0, %sr
#else /* SUPPORT_CHG_IPM */
	and.w #~0x0700, %sr		/* ߵ */
#endif /* SUPPORT_CHG_IPM */
	move.l (%sp)+, %a0		/* εưϤ a0  */
	jmp (%a0)

/*
 *  ߥϥɥ顿CPU㳰ϥɥи
 *
 *  ret_int ϳߥ⡼ɡ߶ػ߾֤ǡret_exc ϥޥ⡼ɡ
 *  ߶ػ߾֤ǸƤӽФʤФʤʤޤ ret_exc ϡ
 *  쥸¸֤ǸƤӽФȡ
 */
	.text
	.globl ret_int
	.globl ret_exc
ret_int:
	move.w	#0x3700, %sr
	lea	-4* 4(%sp), %sp
	movem.l %d0-%d1/%a0-%a1, (%sp)	/* å쥸¸ */
ret_exc:
	clr.l reqflg			/* reqflg  FALSE  */
	move.l runtsk, %a0		/* A0  runtsk */
	tst.l enadsp			/* enadsp  FALSE ʤ */
	jbeq  ret_int_1			/*         ret_int_1  */
	cmp.l schedtsk, %a0		/* runtsk  schedtsk Ʊʤ */
	jbeq ret_int_1			/*                  ret_int_1  */
	lea	-4 * 11(%sp), %sp
	movem.l %d2-%d7/%a2-%a6, (%sp)	/* ĤΥ쥸¸ */
	move.l %sp, TCB_msp(%a0)	/* å¸ */
	move.l #ret_int_r, %d2
	move.l %d2, TCB_pc(%a0)	/* ¹ԺƳϤ¸ */
	jbra dispatcher

ret_int_r:
	movem.l (%sp), %d2-%d7/%a2-%a6	/* 쥸 */
	lea  4 * 11(%sp), %sp
ret_int_1:
	btst.b #TCB_enatex_bit, TCB_enatex(%a0)
	jbeq ret_int_2			/* enatex  FALSE ʤ꥿ */
	tst.l TCB_texptn(%a0)		/* texptn  0 ʤ꥿ */
	jbeq ret_int_2
	jsr call_texrtn			/* 㳰롼θƽФ */
ret_int_2:
#ifdef SUPPORT_CHG_IPM
	move.l  16(%sp),  %d0	               /* γߥޥ */
	and.l   #~0x00000700, %d0		/*        task_intmask  */
	clr.l	%d1
	move.w	task_intmask, %d1
	or.l	%d1, %d0
	move.l  %d0, 16(%sp)
#endif /* SUPPORT_CHG_IPM */
	movem.l (%sp), %d0-%d1/%a0-%a1	/* å쥸 */
	lea	4 * 4(%sp), %sp
	rte

/*
 *  Ԥ
 */
	.globl _sil_dly_nse
_sil_dly_nse:
	subi.l #SIL_DLY_TIM1, %d0	/* D0  SIL_DLY_TIM1  */
	jbhi _sil_dly_nse_1		/* ̤ 0 ʲʤ꥿ */
	rts
_sil_dly_nse_1:
	subi.l #SIL_DLY_TIM2, %d0	/* D0  SIL_DLY_TIM2  */
	jbhi _sil_dly_nse_1		/* ̤ 0 礭Х롼 */
	rts
