/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007 by KURUSUGAWA Electronics Industry Inc, JAPAN
 *  Copyright (C) 2008 by Takahisa Yokota
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.c,v 1.7 2003/07/08 14:57:15 hiro Exp $
 */

/*
 *	åȥƥ¸⥸塼MCF52235EVBѡ
 */

#include "jsp_kernel.h"
#include <sil.h>
#include "mcfuart.h"

/*
 *  åȥƥ¸ν
 */
void
sys_initialize()
{
    SIOPCB *siopcb;

    sil_wrb_mem (MCF_GPIO_PUAPAR, (MCF_GPIO_PUAPAR_RXD0_RXD0|MCF_GPIO_PUAPAR_TXD0_TXD0));
    sil_wrb_mem (MCF_GPIO_PUBPAR, (MCF_GPIO_PUBPAR_RXD1_RXD1|MCF_GPIO_PUBPAR_TXD1_TXD1));
    mcfuart_initialize ();
    siopcb = mcfuart_opn_por (LOGTASK_PORTID, 0);
}

/*
 *  åȥƥνλ
 */
void
sys_exit()
{
	cfv2_exit();
}

/*
 *  åȥƥʸ
 */
void
sys_putc(char c)
{
	if (c == '\n') {
		cfv2_putc(LOGTASK_PORTID, '\r');
	}
	cfv2_putc(LOGTASK_PORTID, c);
}

/********************************************************************/
/* 
 * PLL min/max specifications
 */
#define MAX_FVCO    60000   /* KHz */
#define MAX_FSYS    60000   /* KHz */
#define MAX_FREF    48000   /* KHz */
#define MIN_FREF    1000    /* KHz */
#define MAX_MFD     18      /* Multiplier (not encoded) */
#define MIN_MFD     4       /* Multiplier (not encoded) */
#define MAX_RFD     128     /* Divider (not encoded) */
#define MIN_RFD     1       /* Divider (not encoded) */

/*
 * Low Power Divider specifications
 */
#define MIN_LPD     (1 << 0)    /* Divider (not encoded) */
#define MAX_LPD     (1 << 15)   /* Divider (not encoded) */

/* 
 * Operating Parameters
 * Pass to clock_pll() the 'flags' argument
 */
#define PLL_DISABLE   (0x0001)
#define PLL_CLKSRC    (0x0004)
#define PLL_FWKUP     (0x0020)
#define PLL_DISCLK    (0x0040)
#define PLL_LOCEN     (0x0080)
#define PLL_LOCRE     (0x0800)
#define PLL_LOLRE     (0x8000)
#define PLL_ALLFLAGS  (0x88E4)


/* Register read/write macros */
#define MCF_CLOCK_SYNCR           (*(volatile unsigned short*)(IPSBAR + 0x120000))
#define MCF_CLOCK_SYNSR           (*(volatile unsigned char *)(IPSBAR + 0x120002))
#define MCF_CLOCK_LPCR            (*(volatile unsigned char *)(IPSBAR + 0x120007))
#define MCF_CLOCK_CCHR            (*(volatile unsigned char *)(IPSBAR + 0x120008))
#define MCF_CLOCK_RTCDR           (*(volatile unsigned char *)(IPSBAR + 0x12000C))

/* Bit definitions and macros for MCF_CLOCK_SYNCR */
#define MCF_CLOCK_SYNCR_PLLEN     (0x0001)
#define MCF_CLOCK_SYNCR_PLLMODE   (0x0002)
#define MCF_CLOCK_SYNCR_CLKSRC    (0x0004)
#define MCF_CLOCK_SYNCR_FWKUP     (0x0020)
#define MCF_CLOCK_SYNCR_DISCLK    (0x0040)
#define MCF_CLOCK_SYNCR_LOCEN     (0x0080)
#define MCF_CLOCK_SYNCR_RFD(x)    (((x)&0x0007)<<8)
#define MCF_CLOCK_SYNCR_LOCRE     (0x0800)
#define MCF_CLOCK_SYNCR_MFD(x)    (((x)&0x0007)<<12)
#define MCF_CLOCK_SYNCR_LOLRE     (0x8000)

/* Bit definitions and macros for MCF_CLOCK_SYNSR */
#define MCF_CLOCK_SYNSR_LOCS      (0x04)
#define MCF_CLOCK_SYNSR_LOCK      (0x08)
#define MCF_CLOCK_SYNSR_LOCKS     (0x10)
#define MCF_CLOCK_SYNSR_CRYOSC    (0x20)
#define MCF_CLOCK_SYNSR_OCOSC     (0x40)
#define MCF_CLOCK_SYNSR_EXTOSC    (0x80)

/* Bit definitions and macros for MCF_CLOCK_LPCR */
#define MCF_CLOCK_LPCR_LPD(x)     (((x)&0x0F)<<0)

/* Bit definitions and macros for MCF_CLOCK_CCHR */
#define MCF_CLOCK_CCHR_PFD(x)     (((x)&0x07)<<0)

/* Bit definitions and macros for MCF_CLOCK_RTCDR */
#define MCF_CLOCK_RTCDR_RTCDF(x)  (((x)&0xFFFFFFFF)<<0)


/********************************************************************/
/* Initialize the PLL
 * 
 * Parameters:
 *  fref    PLL reference clock frequency in KHz
 *  fsys    Desired PLL output frequency in KHz
 *  flags   Operating parameters
 *
 * Return Value:
 *  The resulting output system frequency
 */
int
clock_pll (int fref, int fsys, int flags)
{
    int syncr, mfd_max, mfd_min, rfd_max;
    int i, temp, fout, mfd, rfd, done;
    
    /* Check for the disable flag */
    if (flags & PLL_DISABLE)
    {
        MCF_CLOCK_SYNCR &= ~MCF_CLOCK_SYNCR_PLLEN;
        return fref;
    }
    
    /* Check bounds of reference clock */
    if((fref > MAX_FREF) || (fref < MIN_FREF))
        return fref;
        
    if (fsys == 0)
    {
        /* Return current PLL output */
        if ((MCF_CLOCK_SYNCR & MCF_CLOCK_SYNCR_CLKSRC) &&
            (MCF_CLOCK_SYNCR & MCF_CLOCK_SYNCR_PLLEN))
        {
            mfd = (MCF_CLOCK_SYNCR & 0x7000) >> 12;
            mfd = MIN_MFD + (mfd * 2);
            rfd = (MCF_CLOCK_SYNCR & 0x0700) >> 8;
            rfd = 1 << rfd;
            return (fref * mfd / rfd);
        }
        else
            return fref;            
    }
    
    /* Check bounds of requested system clock */
    if (fsys > MAX_FSYS)
        fsys = MAX_FSYS;

    /* Determine maximum possible multiplier (must be even) */
    mfd_max = MAX_FVCO / fref;
    mfd_max &= ~1;
    if (mfd_max > MAX_MFD)
        mfd_max = MAX_MFD;
    
    /* Determine maximum possible output based on max multiplier */
    fout = fref * mfd_max;

    /* Determine target output based on fsys and max possible */ 
    if (fout > fsys)
        fout = fsys;
    
    /* Determine the minimum multiplier */
    for (mfd_min = mfd_max; 
         mfd_min > MIN_MFD && fout < (fref * mfd_min); 
         mfd_min-=2);
         
    /* Set preliminary divider maximum */         
    rfd_max = MAX_RFD;

    /*
     * Loop across the valid MFD and RFD settings starting with
     * the max MFD and min RFD and find the closest match less-than
     * or equal-to the desired output frequency
     */
    done = 0;
    for (mfd = mfd_max; mfd >= mfd_min; mfd-=2)
    {
        for (rfd = MIN_RFD; rfd < rfd_max; rfd <<= 1)
        {
            temp = fref * mfd / rfd;
            
            if (fout == temp)
            {
                /* exact match */
                done = 1;
                break;
            }
            if (fout > temp)
            {
                /* new upper bound for the rfd */
                rfd_max = rfd;
                /* is this the nearest match? */
                if ((rfd != 1) && ((fout - temp) < (fref / (rfd>>1))))
                    done = 1;
                break;
            }
        }
        if (done)
            break;
     }
    if (!done)
    {
        /* 
         * Fell out of loop before finding an exact match or getting 
         * as close as possible. Adjust mfd to nearest match.
         */
        mfd += 2;
    }
    
    fout = fref * mfd / rfd;

    /* Encode MFD and RFD settings */
    mfd = (mfd - MIN_MFD) / 2;
    for (i = 0; rfd > MIN_RFD; rfd >>= 1, i++) {};
    rfd = i;

    /*
     * Temp fix for PLL bug
     */
    (*(unsigned char *)(IPSBAR + 0x120006)) |= 0x04;

    /* 
     * Initialize the PLL to generate the new system clock frequency 
     * A higher divider is used first with the desired MFD.  Once 
     * locked, the desired RFD is applied
     */
    syncr = MCF_CLOCK_SYNCR & ~(0x7700);
    temp = (MCF_CLOCK_SYNCR & 0x7000) >> 12;
    MCF_CLOCK_SYNCR = syncr 
        | MCF_CLOCK_SYNCR_RFD(rfd + 1)
        | MCF_CLOCK_SYNCR_MFD(temp)
        | MCF_CLOCK_SYNCR_PLLEN;
    MCF_CLOCK_SYNCR = syncr 
        | MCF_CLOCK_SYNCR_RFD(rfd + 1)
        | MCF_CLOCK_SYNCR_MFD(mfd)
        | MCF_CLOCK_SYNCR_PLLEN;
        
   	/* Wait for the PLL to lock */	
	while (!(MCF_CLOCK_SYNSR & MCF_CLOCK_SYNSR_LOCK)) {};

    /* Finish off the initialization */
    MCF_CLOCK_SYNCR = syncr
        | MCF_CLOCK_SYNCR_RFD(rfd)
        | MCF_CLOCK_SYNCR_MFD(mfd)
        | MCF_CLOCK_SYNCR_CLKSRC
        | MCF_CLOCK_SYNCR_PLLEN;

    return fout;
}


/* ϡɥ */
#ifndef GDB_STUB
void
hardware_init_hook (void)
{
  sil_wrw_mem ((VP) MCF_INTC_IMRH(MCF_INTC0), 0xFFFFFFFF);
  sil_wrw_mem ((VP) MCF_INTC_IMRL(MCF_INTC0), ~MCF_INTC_IMRL_ALL);
  sil_wrw_mem ((VP) MCF_INTC_IMRH(MCF_INTC1), 0xFFFFFFFF);
  sil_wrw_mem ((VP) MCF_INTC_IMRL(MCF_INTC1), ~MCF_INTC_IMRL_ALL);
  clock_pll((REF_CLK_KHZ / 5), SYS_CLK_KHZ, 0);  
}
#else
void
hardware_init_hook (void)
{
}
#endif
